/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.connector.ipc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.buffermgmt.impl.WsByteBufferPoolManagerImpl;
import com.ibm.ws.management.connector.ipc.Arrayster;
import com.ibm.ws.management.connector.ipc.IPCProtocol;
import com.ibm.ws.util.WsObjectInputStream;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.tcp.channel.TCPConnectionContext;
import com.ibm.wsspi.tcp.channel.TCPReadRequestContext;
import com.ibm.wsspi.tcp.channel.TCPWriteRequestContext;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;

public class ClientAccessor {
    private static TraceComponent tc = Tr.register(ClientAccessor.class, "Admin", "com.ibm.ws.management.resources.connector");
    private static final int READ_TIMEOUT = -1;
    private static final int WRITE_TIMEOUT = -1;
    private int timeoutInSec = 181;
    private static final int bufferSize = 8192;
    private static final boolean privateDebug = false;
    private static final boolean shortCircuit = false;
    private TCPWriteRequestContext wtsc;
    private TCPReadRequestContext rtsc;
    private WsByteBuffer readBuffer;
    private WsByteBuffer headerBuffer;
    private WsByteBuffer[] outputBuffers = new WsByteBuffer[2];
    private WsByteBuffer bb = null;
    private boolean isReadingHeader;
    private int headerOffset;

    protected ClientAccessor(TCPConnectionContext tcc, VirtualConnection vc) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ClientAccessor<init>");
        }
        this.wtsc = tcc.getWriteInterface();
        this.rtsc = tcc.getReadInterface();
        this.readBuffer = WsByteBufferPoolManagerImpl.getRef().allocate(8192);
        this.outputBuffers[0] = this.headerBuffer = IPCProtocol.allocateHeaderBuffer();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "readBuffer=" + this.readBuffer);
        }
        this.rtsc.setBuffer(this.readBuffer);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ClientAccessor<init>");
        }
    }

    public void releaseBuffer() {
        this.readBuffer.release();
    }

    public void setReadTimeout(int timeout) {
        this.timeoutInSec = timeout;
    }

    public Object request(Object req_object) throws Exception {
        byte[] received;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "request");
        }
        byte[] req_bytes = null;
        Object result_object = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(req_object);
        oos.flush();
        req_bytes = baos.toByteArray();
        baos.close();
        oos.close();
        try {
            IPCProtocol.setDataLength(this.headerBuffer, req_bytes.length);
            this.outputBuffers[1] = WsByteBufferPoolManagerImpl.getRef().wrap(req_bytes);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Writing out request; length of body is " + req_bytes.length);
            }
            this.wtsc.setBuffers(this.outputBuffers);
            this.wtsc.write(-1L, -1);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (this.outputBuffers[1] != null) {
                this.outputBuffers[1].release();
            }
            this.headerBuffer.rewind();
            this.wtsc.setBuffers(null);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "**** Request sent; receiving response ****");
        }
        long totalRead = 0L;
        IPCProtocol.IPCCHeader header = null;
        this.bb = this.rtsc.getBuffer();
        this.bb.clear();
        this.clientReadMoreData();
        int bytesRemaining = this.bb.remaining();
        totalRead = bytesRemaining;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, totalRead + " bytes in the 1st buffer of response; bb=" + this.bb);
        }
        header = IPCProtocol.readMessageHeader(this.bb);
        while (totalRead < 12L) {
            this.bb.clear();
            this.clientReadMoreData();
            bytesRemaining = this.bb.remaining();
            totalRead += (long)bytesRemaining;
            IPCProtocol.readMessageHeader(header, this.bb);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Response header parsing complete; header=" + header);
        }
        Arrayster yster = new Arrayster();
        yster.resetMerge(header.dataLength);
        int objDataRead = bytesRemaining = this.bb.remaining();
        if (bytesRemaining > 0) {
            received = new byte[bytesRemaining];
            this.bb.get(received);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, bytesRemaining + " bytes to be merged into total length");
            }
            yster.merge(received);
        }
        while (objDataRead < header.dataLength) {
            this.bb.clear();
            this.clientReadMoreData();
            bytesRemaining = this.bb.remaining();
            objDataRead += bytesRemaining;
            received = new byte[bytesRemaining];
            this.bb.get(received);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, bytesRemaining + " bytes to be merged into total length");
            }
            yster.merge(received);
        }
        received = yster.getByteArray();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Response complete; length of body is " + objDataRead);
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(received);
        WsObjectInputStream ois = new WsObjectInputStream(bais);
        result_object = ois.readObject();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "request", result_object);
        }
        return result_object;
    }

    private long clientReadMoreData() throws Exception {
        long nn = 0L;
        try {
            nn = this.rtsc.read(1L, this.timeoutInSec * 1000);
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "clientReadMoreData; bytes read=" + nn);
            }
            this.bb.flip();
        }
        catch (IOException ex) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "clientReadMoreData; the server socket is probably closed; " + ex);
            }
            throw ex;
        }
        return nn;
    }
}

