/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.task;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.EJBJarFile;
import com.ibm.etools.commonarchive.ModuleFile;
import com.ibm.etools.commonarchive.ModuleRef;
import com.ibm.etools.commonarchive.WARFile;
import com.ibm.websphere.management.application.EditScheduler;
import com.ibm.websphere.management.application.InstallScheduler;
import com.ibm.websphere.management.application.UpdateScheduler;
import com.ibm.websphere.management.application.task.AbstractTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.models.extensions.appprofilecommonext.AppProfileComponentExtension;
import com.ibm.websphere.models.extensions.appprofileejbext.AppProfileEJBJarExtension;
import com.ibm.websphere.models.extensions.appprofileejbext.EJBModuleProfile;
import com.ibm.websphere.models.extensions.appprofilewebappext.AppProfileWebAppExtension;
import com.ibm.websphere.models.extensions.helpers.ApplicationDataHelper;
import com.ibm.websphere.models.extensions.helpers.PMEEJBJarExtensionHelper;
import com.ibm.websphere.models.extensions.helpers.PMEExtensionHelperFactory;
import com.ibm.websphere.models.extensions.helpers.PMEWebAppExtensionHelper;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.client.util;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.management.application.task.DeltaDataTask;
import com.ibm.ws.management.util.RasUtils;
import com.ibm.ws.sm.workspace.RepositoryContext;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.WebApp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivationPlan
extends AbstractTask {
    private static TraceComponent tc = Tr.register(ActivationPlan.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String CLASS_NAME;
    private static final String DOMAIN = "WebSphere";
    public static final String ADD_SUFFIX = ".ibmadd";
    public static final String REMOVE_SUFFIX = ".ibmremove";
    private static final String COMP_EJB = "WS_EJBContainer";
    private static final String COMP_WEB = "WS_WebContainer";
    private static final String COMP_PORTLET = "WS_PortletContainer";
    private static final String COMP_JSF = "WS_JSF";
    private static final String COMP_SIP = "WS_SipContainer";
    private static final String COMP_COMP = "WS_Compensation";
    private static final String COMP_APPPROFILE = "WS_AppProfile";
    private static final String COMP_ACTSESSION = "WS_ActivitySession";
    private static final String COMP_I18N = "WS_I18N";
    private static final String COMP_STARTUPBEANS = "WS_StartupService";
    private RepositoryContext appContext = null;
    private static final String thisClassName = "com.ibm.ws.management.task.ActivationPlan.";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean performTask() throws AdminException {
        boolean bl;
        block30: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "performTask");
            }
            Archive localear = null;
            try {
                this.appContext = AppUtils.findAppContextFromConfig(this.scheduler.getAppName(), this.scheduler.getWorkSpace(), this.scheduler.getProperties());
                Hashtable addPlan = (Hashtable)this.scheduler.getProperties().get("activation.plan.add");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "add plan from user: " + addPlan);
                }
                Hashtable removePlan = (Hashtable)this.scheduler.getProperties().get("activation.plan.remove");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "remove plan from user: " + removePlan);
                }
                Hashtable<String, List<ObjectName>> plan = (Hashtable<String, List<ObjectName>>)this.scheduler.getProperties().get("activation.plan.default");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "plan from extensions: " + plan);
                }
                if (plan == null) {
                    plan = new Hashtable<String, List<ObjectName>>();
                }
                if (this.scheduler instanceof InstallScheduler) {
                    InstallScheduler ish = (InstallScheduler)this.scheduler;
                    EARFile ear = ish.getEarFile(false, true);
                    Properties savedProps = null;
                    if (!Boolean.FALSE.equals(this.scheduler.getProperties().get("processEmbeddedConfig"))) {
                        savedProps = this.getSavedPropsFromEar(ear);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "enhEarProps props: " + savedProps);
                    }
                    if (savedProps == null) {
                        savedProps = (Properties)this.scheduler.getProperties().get("runtime.props.saved");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "saved props: " + savedProps);
                        }
                    }
                    EList mRefs = ear.getModuleRefs();
                    for (ModuleRef mRef : mRefs) {
                        this.handleSingleModule(mRef, plan, addPlan, removePlan, true);
                    }
                    this.savePlan(this.convertToProps(plan), this.appContext);
                } else if (this.scheduler instanceof UpdateScheduler) {
                    UpdateScheduler ush = (UpdateScheduler)this.scheduler;
                    Properties propPlan = ActivationPlan.loadPlan(this.appContext);
                    String uri = ush.getContentURI();
                    if (ush.getContentType().equals("modulefile") && ush.getOperation().equals("delete")) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "module delete case: " + uri);
                        }
                        uri = "com.ibm.ws.runtime.components." + uri;
                        propPlan.remove(uri);
                        propPlan.remove(uri + ADD_SUFFIX);
                        propPlan.remove(uri + REMOVE_SUFFIX);
                        this.savePlan(propPlan, this.appContext);
                    } else {
                        List[] allChanges = DeltaDataTask.getChangedLists(ush);
                        Archive ear = null;
                        ear = localear = ConfigRepoHelper.getEarFileFromBinaries(this.appContext, this.scheduler.getWorkSpace(), this.getResourceBundle(), true);
                        List<String> mUris = this.findAffectedModules((EARFile)ear, allChanges);
                        EList mRefs = ear.getModuleRefs();
                        for (ModuleRef mRef : mRefs) {
                            if (!mUris.contains(mRef.getUri())) continue;
                            this.handleSingleModule(mRef, plan, addPlan, removePlan, ush.getContentType().equals("modulefile"));
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "plan during update: " + plan);
                        }
                        propPlan.putAll((Map<?, ?>)this.convertToProps(plan));
                        this.savePlan(propPlan, this.appContext);
                    }
                    if (ConfigRepoHelper.getAppDeploymentForApp(this.appContext).isZeroEarCopy()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Removing saved ear for zeroEarCopy case");
                        }
                        this.appContext.getParent().notifyChanged(2, this.appContext.getParent().getName());
                    }
                } else if (this.scheduler instanceof EditScheduler) {
                    Properties propPlan = ActivationPlan.loadPlan(this.appContext);
                    EARFile ear = ((EditScheduler)this.scheduler).getEarFile();
                    EList mRefs = ear.getModuleRefs();
                    for (ModuleRef mRef : mRefs) {
                        this.handleUserInput(mRef, plan, addPlan, removePlan);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "plan during edit: " + plan);
                    }
                    propPlan.putAll((Map<?, ?>)this.convertToProps(plan));
                    this.savePlan(propPlan, this.appContext);
                }
                this.scheduler.propagateTaskEvent(this.createNotification("Completed", "ADMA5113I", null));
                bl = true;
                Object var15_26 = null;
                if (localear == null) break block30;
            }
            catch (Throwable th) {
                boolean bl2;
                block31: {
                    try {
                        RasUtils.logException(th, tc, CLASS_NAME, "performTask", "236", this);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "exception creating activation plan - " + th);
                        }
                        this.scheduler.propagateTaskEvent(this.createNotification("Failed", "ADMA5112E", new String[]{th.toString()}));
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "performTask");
                        }
                        bl2 = true;
                        Object var15_27 = null;
                        if (localear == null) break block31;
                    }
                    catch (Throwable throwable) {
                        block32: {
                            Object var15_28 = null;
                            if (localear == null) break block32;
                            localear.close();
                        }
                        throw throwable;
                    }
                    localear.close();
                }
                return bl2;
            }
            localear.close();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Properties getSavedPropsFromEar(EARFile earFile) throws Exception {
        if (earFile.containsFile("META-INF/ibm-application-runtime.props")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ear contains act plan");
            }
            InputStream io = null;
            io = earFile.getInputStream("META-INF/ibm-application-runtime.props");
            Properties props = new Properties();
            props.load(io);
            Properties properties = props;
            Object var6_7 = null;
            if (io == null) return properties;
            try {
                io.close();
                return properties;
            }
            catch (Throwable th2) {
                if (!tc.isDebugEnabled()) return properties;
                Tr.debug(tc, "error closing act plan file: " + th2);
            }
            return properties;
            catch (Throwable th) {
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "exception opening props file: " + th);
                    }
                    Object var6_8 = null;
                    if (io == null) return null;
                }
                catch (Throwable throwable) {
                    Object var6_9 = null;
                    if (io == null) throw throwable;
                    try {
                        io.close();
                        throw throwable;
                    }
                    catch (Throwable th2) {
                        if (!tc.isDebugEnabled()) throw throwable;
                        Tr.debug(tc, "error closing act plan file: " + th2);
                    }
                    throw throwable;
                }
                try {
                    io.close();
                    return null;
                }
                catch (Throwable th2) {
                    if (!tc.isDebugEnabled()) return null;
                    Tr.debug(tc, "error closing act plan file: " + th2);
                }
                return null;
            }
        }
        if (this.scheduler.getProperties().get("runtime.props.saved") == null) return null;
        if (!tc.isDebugEnabled()) return (Properties)this.scheduler.getProperties().get("runtime.props.saved");
        Tr.debug(tc, "full update - props file in scheduler");
        return (Properties)this.scheduler.getProperties().get("runtime.props.saved");
    }

    private void handleSingleModule(ModuleRef mRef, Hashtable<String, List<ObjectName>> plan, Hashtable<String, List<ObjectName>> addPlan, Hashtable<String, List<ObjectName>> removePlan, boolean handleUserInput) throws Exception {
        if (mRef.isClient() || mRef.isConnector()) {
            return;
        }
        List<ObjectName> comps = plan.get(mRef.getUri());
        if (comps == null) {
            comps = new ArrayList<ObjectName>();
            plan.put(mRef.getUri(), comps);
        }
        this.getDefaultComps(mRef, comps);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Default comps for " + mRef.getUri() + " = " + comps);
        }
        if (handleUserInput) {
            this.handleUserInput(mRef, plan, addPlan, removePlan);
        }
    }

    private void handleUserInput(ModuleRef mRef, Hashtable<String, List<ObjectName>> plan, Hashtable<String, List<ObjectName>> addPlan, Hashtable<String, List<ObjectName>> removePlan) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleUserInput: " + addPlan + ", removePlan=" + removePlan);
        }
        if (addPlan != null) {
            List<ObjectName> adds = addPlan.get(util.createUniqueModuleName(ConfigRepoHelper.getDDUri(mRef), mRef.getUri()));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "add comps for " + mRef.getUri() + " = " + adds);
            }
            if (adds != null) {
                plan.put(mRef.getUri() + ADD_SUFFIX, adds);
            }
        }
        if (removePlan != null) {
            List<ObjectName> removes = removePlan.get(util.createUniqueModuleName(ConfigRepoHelper.getDDUri(mRef), mRef.getUri()));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "remove comps for " + mRef.getUri() + " = " + removes);
            }
            if (removes != null) {
                plan.put(mRef.getUri() + REMOVE_SUFFIX, removes);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleUserInput");
        }
    }

    private List<String> findAffectedModules(EARFile ear, List<String>[] allChanges) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "findAffectedModules");
        }
        ArrayList<String> retVal = new ArrayList<String>();
        ArrayList<String> allUris = new ArrayList<String>();
        allUris.addAll(allChanges[0]);
        allUris.addAll(allChanges[1]);
        allUris.addAll(allChanges[2]);
        EList mRefs = ear.getModuleRefs();
        block0: for (int i = 0; i < mRefs.size(); ++i) {
            ModuleRef mRef = (ModuleRef)mRefs.get(i);
            if (allUris.contains(mRef.getUri())) {
                if (retVal.contains(mRef.getUri())) continue;
                retVal.add(mRef.getUri());
                continue;
            }
            for (String uri : allUris) {
                if (!uri.startsWith(mRef.getUri() + "/")) continue;
                if (retVal.contains(mRef.getUri())) continue block0;
                retVal.add(mRef.getUri());
                continue block0;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findAffectedModules " + retVal);
        }
        return retVal;
    }

    private void getDefaultComps(ModuleRef mRef, List<ObjectName> comps) throws Exception {
        String methodName;
        block21: {
            ApplicationDataHelper helper;
            methodName = "getDefaultComps";
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, methodName);
            }
            ModuleFile moduleFile = (ModuleFile)mRef.getModuleFile();
            if (mRef.isEJB()) {
                comps.add(this.createON(COMP_EJB));
                try {
                    helper = PMEExtensionHelperFactory.createPMEEJBJarExtensionHelper((EJBJarFile)moduleFile, false);
                    if (this.containsCScopeDependency(mRef, helper)) {
                        comps.add(this.createON(COMP_COMP));
                    }
                    if (this.containsActivitySessionDependency(mRef, helper)) {
                        comps.add(this.createON(COMP_ACTSESSION));
                    }
                    if (this.containsAppProfileDependency(mRef, (PMEEJBJarExtensionHelper)helper)) {
                        comps.add(this.createON(COMP_APPPROFILE));
                    }
                    if (this.containsI18NDependency(mRef, helper)) {
                        comps.add(this.createON(COMP_I18N));
                    }
                    if (this.containsStartupBeansDependency((EJBJarFile)moduleFile)) {
                        comps.add(this.createON(COMP_STARTUPBEANS));
                    }
                    break block21;
                }
                catch (Throwable th) {
                    RasUtils.logException(th, tc, CLASS_NAME, methodName, "420", this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception occurred while checking dependency on PME components for EJB module " + moduleFile.getName());
                    }
                    break block21;
                }
            }
            if (mRef.isWeb()) {
                comps.add(this.createON(COMP_WEB));
                if (moduleFile.containsFile("WEB-INF/portlet.xml")) {
                    comps.add(this.createON(COMP_PORTLET));
                }
                if (moduleFile.containsFile("WEB-INF/sip.xml")) {
                    comps.add(this.createON(COMP_SIP));
                }
                if (this.containsJSFDependency(mRef)) {
                    comps.add(this.createON(COMP_JSF));
                }
                try {
                    helper = PMEExtensionHelperFactory.createPMEWebAppExtensionHelper((WARFile)moduleFile, false);
                    if (this.containsActivitySessionDependency(mRef, helper)) {
                        comps.add(this.createON(COMP_ACTSESSION));
                    }
                    if (this.containsAppProfileDependency(mRef, (PMEWebAppExtensionHelper)helper)) {
                        comps.add(this.createON(COMP_APPPROFILE));
                    }
                    if (this.containsI18NDependency(mRef, helper)) {
                        comps.add(this.createON(COMP_I18N));
                    }
                }
                catch (Throwable th) {
                    RasUtils.logException(th, tc, CLASS_NAME, methodName, "464", this);
                    if (!tc.isDebugEnabled()) break block21;
                    Tr.debug(tc, "Exception occurred while checking dependency on PME components for web module " + moduleFile.getName());
                }
            }
        }
        ArrayList<ObjectName> temp = new ArrayList<ObjectName>();
        for (ObjectName on : comps) {
            if (temp.contains(on)) continue;
            temp.add(on);
        }
        comps.clear();
        comps.addAll(temp);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, methodName, comps);
        }
    }

    private ObjectName createON(String compName) throws MalformedObjectNameException {
        ObjectName on = new ObjectName(DOMAIN, "specname", compName);
        return on;
    }

    private List<ObjectName> convertPropsToList(String s) {
        String[] comps;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "converPropsToList: " + s);
        }
        if (AppUtils.isEmpty(s)) {
            return null;
        }
        ArrayList<ObjectName> retVal = new ArrayList<ObjectName>();
        for (String comp : comps = s.split("\\+")) {
            try {
                ObjectName on = new ObjectName(comp);
                if (!on.getDomain().equals(DOMAIN)) {
                    throw new MalformedObjectNameException("Invalid comp bad domain: " + comp);
                }
                if (on.getKeyProperty("specname") == null) {
                    throw new MalformedObjectNameException("Invalid comp no spec name: " + comp);
                }
                retVal.add(on);
            }
            catch (Throwable th) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Ignored Bad ObjectName: " + th);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "converPropsToList: " + retVal);
        }
        return retVal.size() == 0 ? null : retVal;
    }

    private Properties convertToProps(Hashtable<String, List<ObjectName>> plan) throws Throwable {
        Properties retVal = new Properties();
        Enumeration<String> ee1 = plan.keys();
        while (ee1.hasMoreElements()) {
            String key = ee1.nextElement();
            List<ObjectName> value = plan.get(key);
            String s = "";
            for (ObjectName on : value) {
                s = s.equals("") ? on.toString() : s + "+" + on.toString();
            }
            retVal.put("com.ibm.ws.runtime.components." + key, s);
        }
        return retVal;
    }

    /*
     * Loose catch block
     */
    private void savePlan(Properties retVal, RepositoryContext appContext) throws Throwable {
        block22: {
            Exception ioex2;
            PrintWriter pw;
            FileOutputStream fos;
            block21: {
                block20: {
                    String path = appContext.getPath() + "/" + "META-INF/ibm-application-runtime.props";
                    path = path.replace('\\', '/');
                    fos = null;
                    pw = null;
                    File metaInfDir = new File(path.substring(0, path.lastIndexOf("/")));
                    if (!metaInfDir.exists()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "savePlan: Creating " + metaInfDir);
                        }
                        metaInfDir.mkdir();
                    }
                    fos = new FileOutputStream(path);
                    pw = new PrintWriter(fos);
                    Properties tempProps = new Properties();
                    Enumeration<Object> ee = retVal.keys();
                    while (ee.hasMoreElements()) {
                        String key = (String)ee.nextElement();
                        String val = retVal.getProperty(key);
                        if (AppUtils.isEmpty(val)) continue;
                        tempProps.put(key, val);
                    }
                    tempProps.store(pw, "Created by WebSphere.  Do not modify.");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "saving plan to : " + path);
                    }
                    if (appContext.getFile("META-INF/ibm-application-runtime.props") == null) {
                        appContext.notifyChanged(0, "META-INF/ibm-application-runtime.props");
                        break block20;
                    }
                    appContext.notifyChanged(1, "META-INF/ibm-application-runtime.props");
                }
                Object var12_12 = null;
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException ioex2) {
                    if (!tc.isDebugEnabled()) break block21;
                    Tr.debug(tc, "error closing fos: " + ioex2);
                }
            }
            try {
                if (pw != null) {
                    pw.close();
                }
                break block22;
            }
            catch (Exception ioex2) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "error closing pw: " + ioex2);
                }
                break block22;
            }
            {
                catch (Throwable th) {
                    throw th;
                }
            }
            catch (Throwable throwable) {
                block24: {
                    block23: {
                        Object var12_13 = null;
                        try {
                            if (fos != null) {
                                fos.close();
                            }
                        }
                        catch (IOException ioex2) {
                            if (!tc.isDebugEnabled()) break block23;
                            Tr.debug(tc, "error closing fos: " + ioex2);
                        }
                    }
                    try {
                        if (pw != null) {
                            pw.close();
                        }
                    }
                    catch (Exception ioex2) {
                        if (!tc.isDebugEnabled()) break block24;
                        Tr.debug(tc, "error closing pw: " + ioex2);
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Properties loadPlan(RepositoryContext appContext) throws Exception {
        Properties properties;
        Properties props = new Properties();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "loading prop file");
        }
        if (appContext.getFile("META-INF/ibm-application-runtime.props") == null) {
            if (!tc.isDebugEnabled()) return props;
            Tr.debug(tc, "error -- update case and no prop plan file in repository");
            return props;
        }
        InputStream is = null;
        try {
            try {
                is = appContext.getInputStream("META-INF/ibm-application-runtime.props");
                props.load(is);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "loaded props: " + props);
                }
                properties = props;
                Object var5_5 = null;
            }
            catch (Throwable ex) {
                throw new AdminException(ex);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            try {
                if (is == null) throw throwable;
                is.close();
                throw throwable;
            }
            catch (IOException ioex) {
                if (!tc.isDebugEnabled()) throw throwable;
                Tr.debug(tc, "error closing is for plan: " + ioex);
            }
            throw throwable;
        }
        try {}
        catch (IOException ioex) {
            if (!tc.isDebugEnabled()) return properties;
            Tr.debug(tc, "error closing is for plan: " + ioex);
            return properties;
        }
        if (is == null) return properties;
        is.close();
        return properties;
    }

    private boolean containsCScopeDependency(ModuleRef mRef, ApplicationDataHelper helper) {
        boolean containsDependency;
        String methodName;
        block5: {
            methodName = "containsCScopeDependency";
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, methodName);
            }
            containsDependency = false;
            try {
                if (((PMEEJBJarExtensionHelper)helper).getCompensationEJBJarExtension() != null) {
                    containsDependency = true;
                }
            }
            catch (Throwable th) {
                RasUtils.logException(th, tc, CLASS_NAME, methodName, "633", this);
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "Failure checking dependency on PME CScope component for module " + mRef.getModuleFile().getName(), th);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, methodName, containsDependency);
        }
        return containsDependency;
    }

    private boolean containsActivitySessionDependency(ModuleRef mRef, ApplicationDataHelper helper) {
        boolean containsDependency;
        String methodName;
        block5: {
            methodName = "containsActivitySessionDependency";
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, methodName);
            }
            containsDependency = false;
            try {
                if (helper instanceof PMEWebAppExtensionHelper && ((PMEWebAppExtensionHelper)helper).getActivitySessionWebAppExtension() != null || helper instanceof PMEEJBJarExtensionHelper && ((PMEEJBJarExtensionHelper)helper).getActivitySessionEJBJarExtension() != null) {
                    containsDependency = true;
                }
            }
            catch (Throwable th) {
                RasUtils.logException(th, tc, CLASS_NAME, methodName, "655", this);
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "Failure checking dependency on PME ActivitySession component for module " + mRef.getModuleFile().getName(), th);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, methodName, containsDependency);
        }
        return containsDependency;
    }

    private boolean containsAppProfileDependency(ModuleRef mRef, PMEEJBJarExtensionHelper helper) {
        boolean containsDependency;
        String methodName;
        block8: {
            methodName = "containsAppProfileDependency";
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, methodName);
            }
            containsDependency = false;
            try {
                AppProfileEJBJarExtension appProfileExt = helper.getAppProfileEJBJarExtension();
                if (appProfileExt != null) {
                    EJBModuleProfile ejbProfile;
                    EList appProfiles;
                    AppProfileComponentExtension appProfileComponentExt;
                    EList appProfileComponentExts;
                    if (appProfileExt.getRunAsTasks().size() > 0) {
                        containsDependency = true;
                    }
                    if (!containsDependency && (appProfileComponentExts = appProfileExt.getAppProfileComponentExtensions()) != null && appProfileComponentExts.iterator().hasNext() && (appProfileComponentExt = (AppProfileComponentExtension)appProfileComponentExts.iterator().next()).getTaskRefs() != null && appProfileComponentExt.getTaskRefs().size() > 0) {
                        containsDependency = true;
                    }
                    if (!containsDependency && (appProfiles = appProfileExt.getApplicationProfiles()) != null && appProfiles.iterator().hasNext() && (ejbProfile = (EJBModuleProfile)appProfiles.iterator().next()).getTasks().size() > 0) {
                        containsDependency = true;
                    }
                }
            }
            catch (Throwable th) {
                RasUtils.logException(th, tc, CLASS_NAME, methodName, "697", this);
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug(tc, "Failure checking dependency on PME ApplicationProfile component for module " + mRef.getModuleFile().getName(), th);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, methodName, containsDependency);
        }
        return containsDependency;
    }

    private boolean containsAppProfileDependency(ModuleRef mRef, PMEWebAppExtensionHelper helper) {
        boolean containsDependency;
        String methodName;
        block7: {
            methodName = "containsAppProfileDependency";
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, methodName);
            }
            containsDependency = false;
            try {
                EList appProfileComponentExts;
                AppProfileWebAppExtension appProfileWebAppExt = helper.getAppProfileWebAppExtension();
                if (appProfileWebAppExt != null && (appProfileComponentExts = appProfileWebAppExt.getAppProfileComponentExtensions()) != null && appProfileComponentExts.iterator().hasNext()) {
                    AppProfileComponentExtension appProfileComponentExt = (AppProfileComponentExtension)appProfileComponentExts.iterator().next();
                    if (appProfileComponentExt != null && appProfileComponentExt.getTask() != null) {
                        containsDependency = true;
                    }
                    if (!containsDependency && appProfileComponentExt.getTaskRefs() != null && appProfileComponentExt.getTaskRefs().size() > 0) {
                        containsDependency = true;
                    }
                }
            }
            catch (Throwable th) {
                RasUtils.logException(th, tc, CLASS_NAME, methodName, "731", this);
                if (!tc.isDebugEnabled()) break block7;
                Tr.debug(tc, "Failure checking PME ApplicationProfile component dependency for module " + mRef.getModuleFile().getName(), th);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, methodName, containsDependency);
        }
        return containsDependency;
    }

    private boolean containsJSFDependency(ModuleRef mRef) {
        boolean containsDependency;
        String methodName;
        block5: {
            methodName = "containsJSFDependency";
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, methodName);
            }
            containsDependency = false;
            try {
                WebApp dd = (WebApp)mRef.getDeploymentDescriptor();
                EList servlets = dd.getServlets();
                for (int i = 0; i < servlets.size(); ++i) {
                    JavaClass sClass;
                    Servlet servlet = (Servlet)servlets.get(i);
                    if (!servlet.getWebType().isServletType() || (sClass = servlet.getServletClass()) == null || !sClass.getName().equals("javax.faces.webapp.FacesServlet")) continue;
                    containsDependency = true;
                }
            }
            catch (Throwable th) {
                RasUtils.logException(th, tc, CLASS_NAME, methodName, "760", this);
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "Failure checking JSF dependency for module " + mRef.getModuleFile().getName(), th);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, methodName, containsDependency);
        }
        return containsDependency;
    }

    private boolean containsI18NDependency(ModuleRef mRef, ApplicationDataHelper helper) {
        boolean containsDependency;
        String methodName;
        block5: {
            methodName = "containsi18NDependency";
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, methodName);
            }
            containsDependency = false;
            try {
                if (helper instanceof PMEWebAppExtensionHelper && ((PMEWebAppExtensionHelper)helper).getI18NWebAppExtension() != null || helper instanceof PMEEJBJarExtensionHelper && ((PMEEJBJarExtensionHelper)helper).getI18NEJBJarExtension() != null) {
                    containsDependency = true;
                }
            }
            catch (Throwable th) {
                RasUtils.logException(th, tc, CLASS_NAME, methodName, "782", this);
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "Failure checking dependency on PME I18N component for module " + mRef.getModuleFile().getName(), th);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, methodName, containsDependency);
        }
        return containsDependency;
    }

    private boolean containsStartupBeansDependency(EJBJarFile moduleFile) {
        boolean containsDependency;
        String methodName;
        block8: {
            methodName = "containsStartupBeansDependency";
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, methodName);
            }
            String startupBeansAppInterface = "com.ibm.websphere.startupservice.AppStartUpHome";
            String startupBeansModInterface = "com.ibm.websphere.startupservice.ModStartUpHome";
            containsDependency = false;
            try {
                EJBJar ejbDD = moduleFile.getDeploymentDescriptor();
                EList enterpriseBeans = ejbDD.getEnterpriseBeans();
                for (EnterpriseBean bean : enterpriseBeans) {
                    String homeInterfaceName = bean.getHomeInterfaceName();
                    String remoteInterfaceName = bean.getRemoteInterfaceName();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "bean " + bean.getName() + ": home/remote " + homeInterfaceName + "/" + remoteInterfaceName);
                    }
                    if (null != remoteInterfaceName && startupBeansAppInterface.equals(remoteInterfaceName) || startupBeansModInterface.equals(remoteInterfaceName)) {
                        containsDependency = true;
                    } else {
                        if (null == homeInterfaceName || !startupBeansAppInterface.equals(homeInterfaceName) && !startupBeansModInterface.equals(homeInterfaceName)) continue;
                        containsDependency = true;
                    }
                    break;
                }
            }
            catch (Throwable th) {
                RasUtils.logException(th, tc, CLASS_NAME, methodName, "830", this);
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug(tc, "Failure checking dependency on PME Startup Beans for module " + moduleFile.getName(), th);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, methodName, containsDependency);
        }
        return containsDependency;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/ws/management/application/task/ActivationPlan.java, WAS.admin.installapp.server, WAS70.SERV1, q0834.18, ver. 1.15");
        }
        CLASS_NAME = ActivationPlan.class.getName();
    }
}

