/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.sync;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.application.EditionHelper;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.DocumentContentSource;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.models.config.topology.cell.Cell;
import com.ibm.websphere.models.config.topology.node.Node;
import com.ibm.websphere.resource.WASResourceSetImpl;
import com.ibm.ws.config.ModelMgr;
import com.ibm.ws.management.util.RasUtils;
import com.ibm.ws.runtime.service.VariableMap;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class AppSyncUtils {
    private static TraceComponent tc = Tr.register(AppSyncUtils.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String CLASS_NAME;
    private static final String CELLS_CONTEXT = "cells/";
    private static final String NODES_CONTEXT = "nodes/";
    public static final String APPSYNC_STATUS_KEY = "syncstatus";
    public static final String APPSYNC_DELTA_FILESTBL_KEY = "filestbl";
    public static final String APPSYNC_STOPPEDDEPLOYLIST_KEY = "stoppedlist";
    public static final String APPSYNC_APPNAME = "appname";
    public static final int NULLEVENT = -1;
    public static final String APPSYNC_RECYLEAPPASV5 = "com.ibm.websphere.management.application.sync.recycleappasv5";
    private static int _cellType;
    private static String _cellName;

    public static int shouldProcess(String uri, String cellname, String nodename, boolean isInNodeSync, boolean isLocal) throws Exception {
        if (uri.indexOf(CELLS_CONTEXT) == -1) {
            return 0;
        }
        if (uri.endsWith("/workclass.xml")) {
            return 0;
        }
        if (uri.endsWith("META-INF/ibm-application-runtime.props")) {
            return 0;
        }
        if (uri.startsWith(CELLS_CONTEXT + cellname + "/applications/") && (AppSyncUtils.isPathToEar(uri, cellname) || AppSyncUtils.isPathToDeployments(uri, cellname) || AppSyncUtils.isPathToDeltaxml(uri))) {
            return 1;
        }
        if (AppSyncUtils.isPathToVariablesxml(uri, cellname)) {
            return 2;
        }
        if (AppSyncUtils.isPathToServerindexxml(uri, cellname, nodename, isInNodeSync, isLocal)) {
            return 3;
        }
        return 0;
    }

    public static Resource getResource(ConfigRepository repo, String uri, String fileName) {
        try {
            ModelMgr.initialize("ws-server");
            String[] uris = repo.listResourceNames(uri, 1, 0);
            if (uris == null || uris.length == 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, uri + " not in config repository");
                }
                return null;
            }
            DocumentContentSource dcs = repo.extract(uri);
            WASResourceSetImpl resourceSet = new WASResourceSetImpl();
            URI fileURI = URI.createURI(fileName);
            Resource res = resourceSet.createResource(fileURI);
            HashMap options = new HashMap();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "fileURI: " + fileURI + "\nuri: " + uri + "\nResource:" + res.getClass().getName());
            }
            if (res != null) {
                res.load(dcs.getSource(), options);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "res for: " + uri + " is: " + res);
            }
            return res;
        }
        catch (Throwable th) {
            if (AdminServiceFactory.getAdminService() == null) {
                th.printStackTrace();
            } else {
                RasUtils.logException(th, tc, CLASS_NAME, "getResource", "152");
            }
            Tr.error(tc, "ADMA7005E", new Object[]{uri});
            return null;
        }
    }

    public static String normalizeBinaryPath(VariableMap v, String path) {
        String ret = v.expand(path);
        ret = ret.replace('/', File.separatorChar);
        ret = ret.replace('\\', File.separatorChar);
        return ret;
    }

    public static String getMaxFilePermissionForApps(String cellname, String nodename, ConfigRepository repo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMaxFilePermissionForApps");
        }
        String perm = null;
        perm = AppSyncUtils.getNode(cellname, nodename, repo).getMaxFilePermissionForApps();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMaxFilePermissionForApps");
        }
        return perm;
    }

    public static Node getNode(String cellname, String nodename, ConfigRepository repo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNode");
        }
        Resource res = AppSyncUtils.getResource(repo, CELLS_CONTEXT + cellname + "/" + NODES_CONTEXT + nodename + "/node.xml", "node.xml");
        Node node = (Node)res.getContents().get(0);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNode", new Object[]{node});
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hashtable buildSIMap(String cellname, String nodename, ConfigRepository repo) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "buildSIMap");
        }
        Resource res = AppSyncUtils.getResource(repo, CELLS_CONTEXT + cellname + "/" + NODES_CONTEXT + nodename + "/serverindex.xml", "serverindex.xml");
        Hashtable siMap = new Hashtable();
        if (res == null) {
            return siMap;
        }
        try {
            try {
                ServerIndex top = (ServerIndex)res.getContents().get(0);
                EList entries = top.getServerEntries();
                Vector<String> serverList = null;
                for (int i = 0; i < entries.size(); ++i) {
                    ServerEntry entry = (ServerEntry)entries.get(i);
                    EList depls = entry.getDeployedApplications();
                    for (int lcv = 0; lcv < depls.size(); ++lcv) {
                        String s;
                        String siEntry = (String)depls.get(lcv);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "buildSIMap: siEntry = " + siEntry);
                        }
                        int index = siEntry.indexOf(47);
                        int lastIndex = siEntry.lastIndexOf(47);
                        if (lastIndex <= index) {
                            Tr.warning(tc, "ADMA7003E", new Object[]{siEntry});
                            throw new Exception("ERROR building SIMap");
                        }
                        String appName = siEntry.substring(lastIndex + 1);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Entry :  appName: " + appName);
                        }
                        if ((serverList = (Vector<String>)siMap.get(appName)) == null) {
                            serverList = new Vector<String>();
                        }
                        if (!serverList.contains(s = entry.getServerName())) {
                            serverList.addElement(entry.getServerName());
                        }
                        siMap.put(appName, serverList);
                    }
                }
                Object var18_18 = null;
                if (res != null) {
                    res.unload();
                }
            }
            catch (Throwable th) {
                Tr.warning(tc, "ADMA7002E", new Object[]{th});
                Object var18_19 = null;
                if (res != null) {
                    res.unload();
                }
            }
        }
        catch (Throwable throwable) {
            Object var18_20 = null;
            if (res != null) {
                res.unload();
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "buildSIMap");
        }
        return siMap;
    }

    public static boolean isPathToVariablesxml(String uri, String cellname) {
        Tr.entry(tc, "isPathToVariablesxml: uri=" + uri + ", cellname=" + cellname);
        try {
            if (uri.indexOf(CELLS_CONTEXT + cellname) == -1) {
                Tr.exit(tc, "isPathToVariablesxml, false");
                return false;
            }
            if (uri.endsWith("variables.xml")) {
                Tr.exit(tc, "isPathToVariablesxml, true");
                return true;
            }
        }
        catch (Throwable th) {
            Tr.debug(tc, "Error parsing url " + uri + " for isPathToVariablesxml : " + th);
        }
        Tr.exit(tc, "isPathToVariablesxml, false");
        return false;
    }

    public static boolean isPathToServerindexxml(String uri, String cellname, String nodename, boolean isInNodeSync, boolean isLocal) {
        Tr.entry(tc, "isPathToServerindexxml");
        try {
            if (uri.indexOf(CELLS_CONTEXT + cellname) == -1) {
                Tr.exit(tc, "isPathToServerindexxml, false");
                return false;
            }
            String str = CELLS_CONTEXT + cellname + "/" + NODES_CONTEXT + nodename + "/serverindex.xml";
            return uri.equals(str);
        }
        catch (Throwable th) {
            Tr.debug(tc, "Error parsing url " + uri + " for isPathToServerindexxml : " + th);
            Tr.exit(tc, "isPathToServerindexxml, false");
            return false;
        }
    }

    public static String getAppNameFromAppDoc(String ouri, String cellName) {
        int endIndex;
        String tempStr;
        String appName = null;
        String start = CELLS_CONTEXT + cellName + "/applications/";
        String uri = ouri.substring(start.length() + 1);
        int startIndex = uri.indexOf("/");
        if (startIndex != -1) {
            uri = uri.substring(startIndex + 1);
        }
        if (uri.startsWith("deployments/")) {
            tempStr = uri.substring("deployments".length() + 1);
            endIndex = tempStr.indexOf("/");
            if (endIndex != -1) {
                appName = tempStr.substring(0, endIndex);
            }
        } else if (uri.startsWith("deltas") && (endIndex = (tempStr = uri.substring(7)).indexOf("/")) != -1) {
            appName = tempStr.substring(0, endIndex);
        }
        if (appName == null) {
            String temp = uri;
            int index = temp.indexOf("/");
            if (index != -1 && index != 0) {
                temp = temp.substring(0, index);
            }
            if ((index = temp.lastIndexOf(".ear")) != -1) {
                appName = temp.substring(0, index);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "return appname =" + appName);
        }
        return appName;
    }

    public static String getBinName(String mappName, String cellName) {
        Tr.entry(tc, "getBinName: " + mappName);
        String binName = CELLS_CONTEXT + cellName + "/" + "applications" + "/" + EditionHelper.getAppAndEdition(mappName)[0] + ".ear/" + EditionHelper.getAppEarName(mappName, "");
        Tr.exit(tc, "getBinName: " + binName);
        return binName;
    }

    public static String getDeplURI(String mappName, String cellName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDeplURI:" + mappName);
        }
        String deplURI = CELLS_CONTEXT + cellName + "/" + "applications" + "/" + EditionHelper.getAppAndEdition(mappName)[0] + ".ear/" + "deployments" + "/" + mappName + "/deployment.xml";
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDeplURI: deplURI = " + deplURI);
        }
        return deplURI;
    }

    public static String getAppNameFromDepURI(String deploymentURI) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAppNameFromDepURI: " + deploymentURI);
        }
        String appName = "";
        try {
            int startIndex = deploymentURI.indexOf("applications") + "applications".length() + 1;
            int endIndex = deploymentURI.indexOf("deployments") - 1;
            appName = deploymentURI.substring(startIndex, endIndex);
            appName = appName.substring(0, appName.lastIndexOf(".ear"));
        }
        catch (Throwable e) {
            Tr.debug(tc, "getAppNameFromDepURI error in parsing URI " + deploymentURI + ": " + e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAppNameFromDepURI: appName = " + appName);
        }
        return appName;
    }

    public static String getAppNameFromEARURI(String earURI) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAppNameFromEARURI: " + earURI);
        }
        String appName = "";
        try {
            appName = earURI.substring(earURI.lastIndexOf(47) + 1);
            appName = appName.substring(0, appName.lastIndexOf(".ear"));
        }
        catch (Throwable e) {
            Tr.debug(tc, "getAppNameFromEARURI error in parsing URI " + earURI + ": " + e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAppNameFromEARURI: appName = " + appName);
        }
        return appName;
    }

    public static String getAppNameFromDeltaURI(String dURI) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAppNameFromDeltaURI: " + dURI);
        }
        String appName = "";
        try {
            String[] str = dURI.split("/");
            appName = str[str.length - 3];
            appName = appName.substring(0, appName.lastIndexOf(".ear"));
        }
        catch (Throwable e) {
            Tr.debug(tc, "getAppNameFromDeltaURI error in parsing URI " + dURI + ": " + e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAppNameFromDeltaURI: appName = " + appName);
        }
        return appName;
    }

    public static boolean isPathToDeltaxml(String uri) {
        Tr.entry(tc, "isPathToDeltaxml: " + uri);
        try {
            if (uri.indexOf("delta") != -1) {
                Tr.exit(tc, "isPathToDeltaxml, true");
                return true;
            }
        }
        catch (Throwable th) {
            Tr.debug(tc, "Error parsing uri " + uri + " for isPathToDeltaxml.");
        }
        Tr.exit(tc, "isPathToDeltaxml: " + uri + " =  false");
        return false;
    }

    public static boolean isPathToDeploymentxml(String uri, String cellname) {
        Tr.entry(tc, "isPathToDeploymentxml: uri=" + uri + ", cellname=" + cellname);
        try {
            if (uri.indexOf(CELLS_CONTEXT + cellname) == -1) {
                Tr.exit(tc, "isPathToDeploymentxml, false");
                return false;
            }
            if (uri.indexOf("applications") != -1 && uri.indexOf("deployments") != -1 && uri.endsWith("deployment.xml")) {
                Tr.exit(tc, "isPathToDeploymentxml, true");
                return true;
            }
        }
        catch (Throwable th) {
            Tr.debug(tc, "Error parsing url " + uri + " for isPathToDeploymentxml : " + th);
        }
        Tr.exit(tc, "isPathToDeploymentxml, false");
        return false;
    }

    public static boolean isPathToDeployments(String uri, String cellname) {
        Tr.entry(tc, "isPathToDeployments: uri=" + uri + ", cellname=" + cellname);
        try {
            if (uri.indexOf(CELLS_CONTEXT + cellname) == -1) {
                Tr.exit(tc, "isPathToDeployments, false");
                return false;
            }
            if (uri.indexOf("applications") != -1 && uri.indexOf("deployments") != -1) {
                Tr.exit(tc, "isPathToDeployments, true");
                return true;
            }
        }
        catch (Throwable th) {
            Tr.debug(tc, "Error parsing url " + uri + " for isPathToDeployments : " + th);
        }
        Tr.exit(tc, "isPathToDeployments, false");
        return false;
    }

    public static boolean isPathToEar(String uri, String cellname) {
        Tr.entry(tc, "isPathToEar: uri=" + uri + ", cellname=" + cellname);
        try {
            String last;
            String s;
            int index;
            if (uri.indexOf(CELLS_CONTEXT + cellname) == -1) {
                Tr.exit(tc, "isPathToEar, false");
                return false;
            }
            if (uri.indexOf("applications") != -1 && uri.indexOf("deployments") == -1 && (index = (s = uri.substring(uri.indexOf("applications") + "applications".length() + 1)).indexOf("/")) != -1 && s.startsWith(last = s.substring(index + 1))) {
                Tr.exit(tc, "isPathToEar, true");
                return true;
            }
        }
        catch (Throwable th) {
            Tr.debug(tc, "Error parsing url " + uri + " for isPathToEAR : " + th);
        }
        Tr.exit(tc, "isPathToEar, false");
        return false;
    }

    public static String getDmgrNodeName(ConfigRepository repo, String cellname) {
        try {
            return AppSyncUtils.getNodeNameFromServer("DEPLOYMENT_MANAGER", repo, cellname);
        }
        catch (Throwable e) {
            Tr.debug(tc, "Problem getting the node name for the dmgr: " + e.getMessage());
            return null;
        }
    }

    public static String getNodeNameFromBaseServer(ConfigRepository repo, String cellname) {
        try {
            return AppSyncUtils.getNodeNameFromServer("APPLICATION_SERVER", repo, cellname);
        }
        catch (Throwable e) {
            Tr.debug(tc, "Problem getting the node name for the base server: " + e.getMessage());
            return null;
        }
    }

    private static String getNodeNameFromServer(String serverType, ConfigRepository repo, String cellname) {
        String servName = null;
        try {
            Vector nodeNames = AppSyncUtils.getNodes(repo, cellname);
            for (int i = 0; i < nodeNames.size(); ++i) {
                Resource res = AppSyncUtils.getResource(repo, CELLS_CONTEXT + cellname + "/" + NODES_CONTEXT + nodeNames.elementAt(i) + "/serverindex.xml", "serverindex.xml");
                if (res == null) continue;
                servName = AppSyncUtils.findServerName(res, serverType);
                res.unload();
                res = null;
                if (servName == null) continue;
                return (String)nodeNames.elementAt(i);
            }
        }
        catch (Throwable e) {
            Tr.debug(tc, "Problem getting the node name for the server: " + e.getMessage());
        }
        return null;
    }

    private static String findServerName(Resource res, String serverType) throws Exception {
        if (!(serverType.equals("APPLICATION_SERVER") || serverType.equals("DEPLOYMENT_MANAGER") || serverType.equals("NODE_AGENT") || serverType.equals("GENERIC_SERVER") || serverType.equals("WEB_SERVER") || serverType.equals("MESSAGE_BROKER"))) {
            throw new Exception("ERROR: Invalid server type!");
        }
        EList serverindexExtent = res.getContents();
        ServerIndex doc = null;
        for (int i = 0; i < serverindexExtent.size(); ++i) {
            doc = (ServerIndex)serverindexExtent.get(i);
            EList servers = doc.getServerEntries();
            for (int j = 0; j < servers.size(); ++j) {
                ServerEntry s = (ServerEntry)servers.get(j);
                String type = s.getServerType();
                if (!type.equals(serverType)) continue;
                return s.getServerName();
            }
        }
        return null;
    }

    public static Vector getNodes(ConfigRepository repo, String cellname) throws Exception {
        Vector<String> v = new Vector<String>();
        String cRoot = (String)repo.getConfig().get("was.repository.root");
        String sdir = cRoot + "/cells/" + cellname + "/nodes";
        File nodeContexts = new File(sdir);
        File[] nodes = nodeContexts.listFiles();
        String nodeName = null;
        for (int i = 0; i < nodes.length; ++i) {
            if (!nodes[i].isDirectory()) continue;
            nodeName = nodes[i].getName();
            v.add(nodeName);
        }
        return v;
    }

    public static void setCellInfo(String cellname, int celltype) {
        _cellName = cellname;
        _cellType = celltype;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Set to cell : " + cellname + " cell type : " + _cellType);
        }
    }

    public static boolean isCellDistributed(String cellname, ConfigRepository repo) {
        if (_cellType == -1 || !_cellName.equals(cellname)) {
            Resource res = AppSyncUtils.getResource(repo, CELLS_CONTEXT + cellname + "/" + "cell.xml", "cell.xml");
            Cell cell = (Cell)res.getContents().get(0);
            res.unload();
            _cellName = cellname;
            _cellType = cell.getCellType().getValue();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Changed to cell : " + cellname + " cell type : " + _cellType);
            }
        }
        return _cellType == 1;
    }

    public static String getSyncEventFromRepoEvent(int repositoryEventType) {
        String event2 = "";
        switch (repositoryEventType) {
            case 0: {
                event2 = "DOCSADDED_KEY";
                break;
            }
            case 1: {
                event2 = "DOCSREMOVED_KEY";
                break;
            }
            case 2: {
                event2 = "DOCSMODIFIED_KEY";
            }
        }
        return event2;
    }

    public static boolean isRecycleAppAsV5(ConfigRepository repo, String cellname) {
        String ret = null;
        if (System.getProperty(APPSYNC_RECYLEAPPASV5) != null) {
            ret = System.getProperty(APPSYNC_RECYLEAPPASV5);
        } else {
            Resource res = AppSyncUtils.getResource(repo, CELLS_CONTEXT + cellname + "/" + "cell.xml", "cell.xml");
            if (res != null && res.getContents().get(0) instanceof Cell) {
                Cell cell = (Cell)res.getContents().get(0);
                ArrayList customProps = new ArrayList(cell.getProperties());
                for (int i = 0; i < customProps.size(); ++i) {
                    Property prop = (Property)customProps.get(i);
                    if (!prop.getName().equals(APPSYNC_RECYLEAPPASV5)) continue;
                    ret = prop.getValue();
                    break;
                }
            }
            if (res != null) {
                res.unload();
            }
        }
        if (ret != null && tc.isDebugEnabled()) {
            Tr.debug(tc, "\"RecyclingAppAsV5\" property is set to " + ret);
        }
        return Boolean.valueOf(ret);
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/ws/management/application/sync/AppSyncUtils.java, WAS.admin.installapp.sync, WAS70.SERV1, q0834.18, ver. 1.12.1.14");
        }
        CLASS_NAME = AppSyncUtils.class.getName();
        _cellType = -1;
        _cellName = null;
    }
}

