/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.j2ee.deploy.spi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.CommonarchiveFactory;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.impl.CommonarchiveFactoryImpl;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminClientFactory;
import com.ibm.websphere.management.AdminContext;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.websphere.management.application.AppManagementFactory;
import com.ibm.websphere.management.application.AppManagementProxy;
import com.ibm.websphere.management.application.AppNotification;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.configservice.ConfigServiceProxy;
import com.ibm.websphere.management.configservice.tasks.InstallRARTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.filetransfer.client.TransferFailedException;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.J2EEAppDeploymentImpl;
import com.ibm.ws.management.application.client.AppInstallHelper;
import com.ibm.ws.management.application.j2ee.deploy.spi.DeploymentConfigurationImpl;
import com.ibm.ws.management.application.j2ee.deploy.spi.J2EEDeploymentController;
import com.ibm.ws.management.application.j2ee.deploy.spi.TargetImpl;
import com.ibm.ws.management.application.j2ee.deploy.spi.TargetModuleIDImpl;
import com.ibm.ws.management.application.j2ee.deploy.spi.exceptions.J2EEDeployIllegalStateException;
import com.ibm.ws.management.application.j2ee.deploy.spi.status.ProgressObjectImpl;
import com.ibm.ws.management.util.RasUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.DConfigBeanVersionType;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.DeploymentConfiguration;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.DConfigBeanVersionUnsupportedException;
import javax.enterprise.deploy.spi.exceptions.InvalidModuleException;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import javax.enterprise.deploy.spi.status.ProgressObject;
import javax.management.MBeanException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleRef;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;

public class DeploymentManagerImpl
implements DeploymentManager,
NotificationListener {
    private static final TraceComponent tc = Tr.register(DeploymentManagerImpl.class, "Admin", "com.ibm.ws.management.resources.J2eeDeploymentMessages");
    private static final String CLASS_NAME;
    private static final String DEFAULT_CONTEXT_ROOT = "/";
    public static final String EAR_MODULE = "Application";
    public static final String WAR_MODULE = "WebModule";
    public static final String EJB_MODULE = "EJBModule";
    public static final String RAR_MODULE = "RARModule";
    public static final String CAR_MODULE = "CARModule";
    public static final String EAR_EXT = ".ear";
    public static final String JAR_EXT = ".jar";
    public static final String WAR_EXT = ".war";
    public static final String RAR_EXT = ".rar";
    public static final String CAR_EXT = ".car";
    private static Hashtable localePrefs;
    private boolean connected = false;
    private AdminClient client = null;
    private ObjectName j2eeAppDeploymentON = null;
    private ObjectName appManagementON = null;
    private Locale userLocale = null;
    private DConfigBeanVersionType configBeanVersion = DConfigBeanVersionType.V5;
    private AppManagement appM = null;
    private Hashtable commandpoAssociation = new Hashtable();
    private Boolean distributed = null;
    private String processType = "unknown";

    public DeploymentManagerImpl() {
        localePrefs.put("app.client.locale", this.getCurrentLocale());
    }

    public void connect(String host, String port, String connectorType, String user, String password) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "connect");
        }
        try {
            Properties connectionProps = new Properties();
            connectionProps.setProperty("host", host);
            connectionProps.setProperty("port", port);
            connectionProps.setProperty("type", connectorType == null ? "SOAP" : connectorType);
            if (user != null && password != null && !user.equals("") && !password.equals("")) {
                connectionProps.setProperty("securityEnabled", Boolean.toString(true));
                connectionProps.setProperty("username", user);
                connectionProps.setProperty("password", password);
            }
            this.client = AdminClientFactory.createAdminClient(connectionProps);
            ObjectName connectedServer = this.client.getServerMBean();
            this.processType = (String)this.client.invoke(connectedServer, "getProcessType", null, null);
        }
        catch (Exception e) {
            RasUtils.logException((Throwable)e, tc, CLASS_NAME, "connect", "192", this);
            throw new ConnectorException(e);
        }
        this.connected = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "connect");
        }
    }

    public Target[] getTargets() throws IllegalStateException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTargets");
        }
        this.validateConnection();
        Hashtable<String, Locale> tbl = new Hashtable<String, Locale>();
        tbl.put("app.client.locale", this.getCurrentLocale());
        Target[] targets = null;
        try {
            targets = (Target[])this.invokeJ2EEAppDeploymentMBean("getTargets", new Object[]{tbl, null}, new String[]{Hashtable.class.getName(), String.class.getName()});
        }
        catch (TargetException e) {
            RasUtils.logException((Throwable)e, tc, CLASS_NAME, "getTargets", "234", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTargets");
        }
        return targets;
    }

    public TargetModuleID[] getRunningModules(ModuleType moduleType, Target[] targetList) throws TargetException, IllegalStateException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRunningModules");
        }
        this.validateConnection();
        String type = DeploymentManagerImpl.convertModuleType(moduleType);
        Hashtable<String, Locale> tbl = new Hashtable<String, Locale>();
        tbl.put("app.client.locale", this.getCurrentLocale());
        TargetModuleID[] targetMods = (TargetModuleID[])this.invokeJ2EEAppDeploymentMBean("getRunningModules", new Object[]{type, targetList, tbl, null}, new String[]{"java.lang.String", "[Ljavax.enterprise.deploy.spi.Target;", "java.util.Hashtable", "java.lang.String"});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRunningModules");
        }
        return targetMods;
    }

    public TargetModuleID[] getNonRunningModules(ModuleType moduleType, Target[] targetList) throws TargetException, IllegalStateException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNonRunningModules");
        }
        this.validateConnection();
        String type = DeploymentManagerImpl.convertModuleType(moduleType);
        Hashtable<String, Locale> tbl = new Hashtable<String, Locale>();
        tbl.put("app.client.locale", this.getCurrentLocale());
        TargetModuleID[] targetMods = (TargetModuleID[])this.invokeJ2EEAppDeploymentMBean("getNonRunningModules", new Object[]{type, targetList, tbl, null}, new String[]{"java.lang.String", "[Ljavax.enterprise.deploy.spi.Target;", "java.util.Hashtable", "java.lang.String"});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNonRunningModules");
        }
        return targetMods;
    }

    public TargetModuleID[] getAvailableModules(ModuleType moduleType, Target[] targetList) throws TargetException, IllegalStateException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAvailableModules");
        }
        this.validateConnection();
        String type = DeploymentManagerImpl.convertModuleType(moduleType);
        TargetModuleID[] targetMods = null;
        if (moduleType.equals(ModuleType.RAR)) {
            return this.getAvailableRarModules(targetList);
        }
        Hashtable<String, Locale> tbl = new Hashtable<String, Locale>();
        tbl.put("app.client.locale", this.getCurrentLocale());
        targetMods = (TargetModuleID[])this.invokeJ2EEAppDeploymentMBean("getAvailableModules", new Object[]{type, targetList, tbl, null}, new String[]{"java.lang.String", "[Ljavax.enterprise.deploy.spi.Target;", "java.util.Hashtable", "java.lang.String"});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAvailableModules");
        }
        return targetMods;
    }

    public TargetModuleID[] getAvailableRarModules(Target[] targetList) throws TargetException, IllegalStateException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAvailableRarModules");
        }
        TargetModuleID[] targetMods = null;
        Session session = null;
        ConfigServiceProxy configService = null;
        try {
            int i;
            session = new Session();
            configService = new ConfigServiceProxy(this.client);
            TargetImpl target = null;
            ObjectName nodeOn = null;
            Vector<TargetModuleIDImpl> resourceAdapters = new Vector<TargetModuleIDImpl>();
            for (i = 0; i < targetList.length; ++i) {
                target = (TargetImpl)targetList[i];
                nodeOn = ConfigServiceHelper.createObjectName(null, "Node", target.getNode());
                ObjectName[] ra = configService.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(null, "J2CResourceAdapter"), null);
                for (int j = 0; j < ra.length; ++j) {
                    if (ra[j].getKeyPropertyListString().indexOf("builtin_rra") >= 0) continue;
                    resourceAdapters.add(this.createRARTargetModule(target, ra[j]));
                }
            }
            configService.discard(session);
            targetMods = new TargetModuleID[resourceAdapters.size()];
            for (i = 0; i < resourceAdapters.size(); ++i) {
                targetMods[i] = (TargetModuleID)resourceAdapters.elementAt(i);
            }
        }
        catch (Exception e) {
            RasUtils.logException((Throwable)e, tc, CLASS_NAME, "getAvailableRarModules", "432", this);
            this.cleanUpSession(configService, session);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAvailableRarModules");
        }
        return targetMods;
    }

    public DeploymentConfiguration createConfiguration(DeployableObject deployObject) throws InvalidModuleException {
        return new DeploymentConfigurationImpl(deployObject, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ProgressObject distribute(Target[] targetList, File moduleArchive, File deploymentPlan) throws IllegalStateException {
        ProgressObject progressObject;
        block11: {
            ProgressObjectImpl progressObjectImpl;
            block10: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "distribute", "moduleArchive=" + moduleArchive);
                }
                this.validateConnection();
                try {
                    try {
                        if (moduleArchive == null) {
                            throw new J2EEDeployIllegalStateException(AppUtils.getMessage(this.getResourceBundle(), "ADMJ1010E"));
                        }
                        if (targetList == null) {
                            ProgressObjectImpl po = new ProgressObjectImpl(CommandType.DISTRIBUTE, StateType.COMPLETED);
                            po.setMessage("ADMJ1031I", null);
                            progressObjectImpl = po;
                            Object var8_12 = null;
                            break block10;
                        }
                        File moduleArchiveTempFile = null;
                        ModuleType mt = this.getModuleType(moduleArchive);
                        moduleArchiveTempFile = mt.equals(ModuleType.EAR) ? this.createTempFile(new FileInputStream(moduleArchive), "app", EAR_EXT) : moduleArchive;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "moduleArchiveTempFile: " + moduleArchiveTempFile);
                        }
                        progressObject = this.distributeInternal(targetList, moduleArchiveTempFile, deploymentPlan, mt);
                        break block11;
                    }
                    catch (FileNotFoundException fnfe) {
                        RasUtils.logException((Throwable)fnfe, tc, CLASS_NAME, "distribute", "512", this);
                        ProgressObjectImpl po = new ProgressObjectImpl(CommandType.DISTRIBUTE, StateType.FAILED);
                        po.setMessage("ADMJ1022E", new Object[]{fnfe.toString()});
                        ProgressObjectImpl progressObjectImpl2 = po;
                        Object var8_14 = null;
                        if (!tc.isEntryEnabled()) return progressObjectImpl2;
                        Tr.exit(tc, "distribute");
                        return progressObjectImpl2;
                    }
                    catch (Exception e) {
                        RasUtils.logException((Throwable)e, tc, CLASS_NAME, "distribute", "518", this);
                        ProgressObjectImpl po = new ProgressObjectImpl(CommandType.DISTRIBUTE, StateType.FAILED);
                        po.setMessage("ADMJ1024E", new Object[]{e.toString()});
                        ProgressObjectImpl progressObjectImpl3 = po;
                        Object var8_15 = null;
                        if (!tc.isEntryEnabled()) return progressObjectImpl3;
                        Tr.exit(tc, "distribute");
                        return progressObjectImpl3;
                    }
                }
                catch (Throwable throwable) {
                    Object var8_16 = null;
                    if (!tc.isEntryEnabled()) throw throwable;
                    Tr.exit(tc, "distribute");
                    throw throwable;
                }
            }
            if (!tc.isEntryEnabled()) return progressObjectImpl;
            Tr.exit(tc, "distribute");
            return progressObjectImpl;
        }
        Object var8_13 = null;
        if (!tc.isEntryEnabled()) return progressObject;
        Tr.exit(tc, "distribute");
        return progressObject;
    }

    public ProgressObject distributeInternal(Target[] targetList, File moduleArchive, File deploymentPlan, ModuleType mt) throws IllegalStateException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "distributeInternal: " + moduleArchive + " plan: " + deploymentPlan);
        }
        ProgressObjectImpl po = new ProgressObjectImpl(CommandType.DISTRIBUTE);
        String earToInstall = moduleArchive.getAbsolutePath();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "earToInstall: " + earToInstall);
        }
        try {
            if (mt == null) {
                mt = this.getModuleType(moduleArchive);
            }
            if (mt.equals(ModuleType.RAR)) {
                this.distributeRARFile(targetList, moduleArchive, deploymentPlan, po);
            } else {
                if (!mt.equals(ModuleType.EAR)) {
                    String earFileName = moduleArchive.getName().replace('.', '_') + EAR_EXT;
                    earFileName = AppUtils.getTempDir() + earFileName;
                    earToInstall = AppInstallHelper.createEarWrapper(earToInstall, earFileName, DEFAULT_CONTEXT_ROOT);
                }
                Hashtable props = new Hashtable();
                props.put("app.client.locale", this.getCurrentLocale());
                props.put("jsr88", Boolean.toString(true));
                J2EEDeploymentController controller = (J2EEDeploymentController)AppManagementFactory.readArchive(earToInstall, props);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Created controller: " + controller);
                }
                if (deploymentPlan != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Reading plan..");
                    }
                    controller.readDeploymentPlan(deploymentPlan);
                }
                controller.saveAndClose();
                props = controller.getAppDeploymentSavedResults();
                String appName = (String)props.get("appname");
                AppManagement appM = this.getAppManagementProxy(this.client);
                props.put("app.client.locale", this.getCurrentLocale());
                props.put("DeleteSourceEar", Boolean.TRUE);
                Hashtable<String, String> module2server = new Hashtable<String, String>();
                String mapping = this.createModule2ServerValue(targetList);
                if (mapping != null && !mapping.equals("")) {
                    module2server.put("*", mapping);
                    props.put("moduleToServer", module2server);
                }
                String ts = Long.toHexString(System.currentTimeMillis());
                props.put("HandBackForClient", ts);
                boolean clientOnly = this.isClientOnlyEarFile(earToInstall);
                TargetModuleIDImpl[] targetModList = this.createTargetModules(targetList, appName, !clientOnly, mt);
                this.commandpoAssociation.put(ts, new DataHolder(po, null, targetModList));
                earToInstall = this.prepareOnServer(earToInstall, props);
                appM.installApplication(earToInstall, null, props, null);
            }
        }
        catch (Exception e) {
            RasUtils.logException((Throwable)e, tc, CLASS_NAME, "distributeInternal", "636", this);
            Tr.warning(tc, "ADMJ1016E", new Object[]{e});
            throw new J2EEDeployIllegalStateException(e.getMessage(), e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "distributeInternal");
        }
        return po;
    }

    private ProgressObject distributeRARFile(Target[] targetList, File moduleArchive, File deploymentPlan, ProgressObject po) throws IllegalStateException {
        Hashtable tbl = new Hashtable();
        String rarInstall = moduleArchive.getPath().replace('\\', '/');
        Session session = null;
        ConfigServiceProxy configService = null;
        try {
            Vector<String> nodeList = new Vector<String>();
            session = new Session();
            configService = new ConfigServiceProxy(this.client);
            for (int i = 0; i < targetList.length; ++i) {
                String nodeName = ((TargetImpl)targetList[i]).getNode();
                if (nodeName != null) {
                    if (nodeList.contains(nodeName)) continue;
                    nodeList.add(nodeName);
                    InstallRARTask task = new InstallRARTask(configService);
                    ObjectName ra = task.installResourceAdapter(session, nodeName, rarInstall, tbl);
                    TargetModuleIDImpl targetMod = this.createRARTargetModule(targetList[i], ra);
                    ((ProgressObjectImpl)po).addSuccessfulResult(targetMod);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Rar installed=" + ra.getCanonicalKeyPropertyListString());
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Rar not installed. Cluster target is not supported.");
                }
                throw new J2EEDeployIllegalStateException(AppUtils.getMessage(this.getResourceBundle(), "ADMJ1028E"));
            }
            configService.save(session, false);
            configService.discard(session);
            ((ProgressObjectImpl)po).setFinalStateAndNotify(StateType.COMPLETED);
        }
        catch (Exception e) {
            RasUtils.logException((Throwable)e, tc, CLASS_NAME, "distributeRARFile", "701", this);
            this.cleanUpSession(configService, session);
            if (e instanceof IllegalStateException) {
                throw (IllegalStateException)e;
            }
            throw new J2EEDeployIllegalStateException(e.getMessage(), e);
        }
        return po;
    }

    private void cleanUpSession(ConfigService configService, Session session) {
        try {
            if (configService != null && session != null) {
                configService.discard(session);
            }
        }
        catch (Exception e) {
            RasUtils.logException((Throwable)e, tc, CLASS_NAME, "cleanUpSession", "721", this);
        }
    }

    private TargetModuleIDImpl[] createTargetModules(Target[] targets, String appName, boolean isStartable, ModuleType mt) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTargetModules");
        }
        TargetModuleIDImpl[] targetMods = null;
        if (targets != null) {
            targetMods = new TargetModuleIDImpl[targets.length];
            TargetModuleIDImpl tm = null;
            TargetImpl target = null;
            for (int i = 0; i < targets.length; ++i) {
                target = (TargetImpl)targets[i];
                tm = J2EEAppDeploymentImpl.createTargetMod(appName, DeploymentManagerImpl.convertModuleType(mt), target, null);
                tm.setStartable(isStartable);
                targetMods[i] = tm;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createTargetModules");
        }
        return targetMods;
    }

    private TargetModuleIDImpl createRARTargetModule(Target target, ObjectName rarOn) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createRARTargetModule");
        }
        TargetModuleIDImpl targetMod = null;
        if (target != null) {
            targetMod = new TargetModuleIDImpl();
            targetMod.setModuleID(rarOn.getKeyProperty("_Websphere_Config_Data_Id"));
            targetMod.setObjectName(rarOn);
            targetMod.setParentTargetModuleID(null);
            targetMod.setChildTargetModuleID(null);
            targetMod.setTarget(target);
            targetMod.setWebURL(null);
            targetMod.setModuleType(RAR_MODULE);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createRARTargetModules");
        }
        return targetMod;
    }

    private String createModule2ServerValue(Target[] targets) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createModule2ServerValue");
        }
        StringBuffer module2ServerMapping = new StringBuffer();
        TargetImpl target = null;
        for (int i = 0; i < targets.length; ++i) {
            target = (TargetImpl)targets[i];
            if (module2ServerMapping.length() > 0) {
                module2ServerMapping.append("+");
            }
            module2ServerMapping.append("WebSphere:cell=");
            module2ServerMapping.append(target.getCell());
            if (target.isCluster()) {
                module2ServerMapping.append(",cluster=");
                module2ServerMapping.append(target.getServerName());
                continue;
            }
            module2ServerMapping.append(",node=");
            module2ServerMapping.append(target.getNode());
            module2ServerMapping.append(",server=");
            module2ServerMapping.append(target.getServerName());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createModule2ServerValue");
        }
        return module2ServerMapping.toString();
    }

    private boolean isEarFile(File moduleFile) throws FileNotFoundException {
        boolean bl;
        boolean isEar;
        block7: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "isEarFile");
            }
            Archive archive = null;
            isEar = false;
            try {
                CommonarchiveFactory factory = CommonarchiveFactoryImpl.getActiveFactory();
                archive = factory.openArchive(moduleFile.getAbsolutePath());
                bl = isEar = archive.isEARFile();
                Object var7_7 = null;
                if (archive == null) break block7;
                archive.close();
            }
            catch (OpenFailureException ofe) {
                try {
                    RasUtils.logException((Throwable)ofe, tc, CLASS_NAME, "isEarFile", "842", this);
                    throw new FileNotFoundException(moduleFile.getAbsolutePath());
                }
                catch (Throwable throwable) {
                    block8: {
                        Object var7_8 = null;
                        if (archive != null) {
                            archive.close();
                        }
                        if (!tc.isEntryEnabled()) break block8;
                        Tr.exit(tc, "isEarFile", Boolean.toString(isEar));
                    }
                    throw throwable;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isEarFile", Boolean.toString(isEar));
        }
        return bl;
    }

    private boolean isClientOnlyEarFile(String earToInstall) throws FileNotFoundException {
        boolean bl;
        boolean clientOnly;
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "isClientOnlyEarFile");
            }
            clientOnly = true;
            EARFile archive = null;
            try {
                archive = AppInstallHelper.getEarFile(earToInstall, false, true, null);
                Iterator allArchiveFiles = archive.getModuleRefs().iterator();
                ModuleRef module = null;
                while (allArchiveFiles.hasNext() && clientOnly) {
                    module = (ModuleRef)allArchiveFiles.next();
                    if (module.isClient()) continue;
                    clientOnly = false;
                }
                bl = clientOnly;
                Object var8_8 = null;
                if (archive == null) break block8;
            }
            catch (AppDeploymentException ade) {
                try {
                    RasUtils.logException((Throwable)ade, tc, CLASS_NAME, "isClientOnlyEarFile", "876", this);
                    throw new FileNotFoundException(earToInstall);
                }
                catch (Throwable throwable) {
                    block9: {
                        Object var8_9 = null;
                        if (archive != null) {
                            archive.close();
                        }
                        if (!tc.isEntryEnabled()) break block9;
                        Tr.exit(tc, "isClientOnlyEarFile", Boolean.toString(clientOnly));
                    }
                    throw throwable;
                }
            }
            archive.close();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isClientOnlyEarFile", Boolean.toString(clientOnly));
        }
        return bl;
    }

    private ModuleType getModuleType(File moduleFile) throws FileNotFoundException {
        ModuleType moduleType;
        ModuleType mt;
        block16: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getModuleType");
            }
            mt = null;
            Archive archive = null;
            try {
                CommonarchiveFactory factory = CommonarchiveFactoryImpl.getActiveFactory();
                archive = factory.openArchive(moduleFile.getAbsolutePath());
                if (archive.isEARFile()) {
                    mt = ModuleType.EAR;
                } else if (archive.isEJBJarFile()) {
                    mt = ModuleType.EJB;
                } else if (archive.isRARFile()) {
                    mt = ModuleType.RAR;
                } else if (archive.isWARFile()) {
                    mt = ModuleType.WAR;
                } else if (archive.isApplicationClientFile()) {
                    mt = ModuleType.CAR;
                }
                moduleType = mt;
                Object var7_7 = null;
                if (archive == null) break block16;
                archive.close();
            }
            catch (OpenFailureException ofe) {
                try {
                    RasUtils.logException((Throwable)ofe, tc, CLASS_NAME, "getModuleType", "914", this);
                    throw new FileNotFoundException(moduleFile.getAbsolutePath());
                }
                catch (Throwable throwable) {
                    block17: {
                        Object var7_8 = null;
                        if (archive != null) {
                            archive.close();
                        }
                        if (!tc.isEntryEnabled()) break block17;
                        Tr.exit(tc, "getModuleType", mt.toString());
                    }
                    throw throwable;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getModuleType", mt.toString());
        }
        return moduleType;
    }

    private String getModuleFileExtension(ModuleType mt) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getModuleFileExtension", new Object[]{mt});
        }
        String fileExt = EAR_EXT;
        if (mt.equals(ModuleType.EJB)) {
            fileExt = JAR_EXT;
        } else if (mt.equals(ModuleType.WAR)) {
            fileExt = WAR_EXT;
        } else if (mt.equals(ModuleType.RAR)) {
            fileExt = RAR_EXT;
        } else if (mt.equals(ModuleType.CAR)) {
            fileExt = CAR_EXT;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getModuleFileExtension", new Object[]{fileExt});
        }
        return fileExt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgressObject distribute(Target[] targetList, ModuleType type, InputStream moduleArchive, InputStream deploymentPlan) throws IllegalStateException {
        ProgressObject progressObject;
        block12: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "distribute");
            }
            this.validateConnection();
            if (moduleArchive == null) {
                throw new J2EEDeployIllegalStateException(AppUtils.getMessage(this.getResourceBundle(), "ADMJ1010E"));
            }
            if (targetList != null) break block12;
            ProgressObjectImpl po = new ProgressObjectImpl(CommandType.DISTRIBUTE, StateType.COMPLETED);
            po.setMessage("ADMJ1031I", null);
            ProgressObjectImpl progressObjectImpl = po;
            Object var11_11 = null;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "distribute(Target[], ModuleType, InputStream, InputStream)");
            }
            return progressObjectImpl;
        }
        try {
            ProgressObject po;
            String fileExt = this.getModuleFileExtension(type);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "file extension is set to " + fileExt);
            }
            File moduleArchiveFile = this.createTempFile(moduleArchive, "app", fileExt);
            File deploymentPlanFile = null;
            if (deploymentPlan != null) {
                deploymentPlanFile = this.createTempFile(deploymentPlan, "deploymentPlan", "xml");
            }
            progressObject = po = this.distributeInternal(targetList, moduleArchiveFile, deploymentPlanFile, type);
            Object var11_12 = null;
        }
        catch (Exception e) {
            ProgressObjectImpl progressObjectImpl;
            try {
                RasUtils.logException((Throwable)e, tc, CLASS_NAME, "distribute", "991", this);
                ProgressObjectImpl po = new ProgressObjectImpl(CommandType.DISTRIBUTE, StateType.FAILED);
                po.setMessage("ADMJ1024E", new Object[]{e.toString()});
                progressObjectImpl = po;
                Object var11_13 = null;
            }
            catch (Throwable throwable) {
                block13: {
                    Object var11_14 = null;
                    if (!tc.isEntryEnabled()) break block13;
                    Tr.exit(tc, "distribute(Target[], ModuleType, InputStream, InputStream)");
                }
                throw throwable;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "distribute(Target[], ModuleType, InputStream, InputStream)");
            }
            return progressObjectImpl;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "distribute(Target[], ModuleType, InputStream, InputStream)");
        }
        return progressObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgressObject distribute(Target[] targetList, InputStream moduleArchive, InputStream deploymentPlan) throws IllegalStateException {
        ProgressObject progressObject;
        block13: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "distribute");
            }
            this.validateConnection();
            if (moduleArchive == null) {
                throw new J2EEDeployIllegalStateException(AppUtils.getMessage(this.getResourceBundle(), "ADMJ1010E"));
            }
            if (targetList != null) break block13;
            ProgressObjectImpl po = new ProgressObjectImpl(CommandType.DISTRIBUTE, StateType.COMPLETED);
            po.setMessage("ADMJ1031I", null);
            ProgressObjectImpl progressObjectImpl = po;
            Object var10_10 = null;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "distribute");
            }
            return progressObjectImpl;
        }
        try {
            ProgressObject po;
            File deploymentPlanFile = null;
            if (deploymentPlan != null) {
                deploymentPlanFile = this.createTempFile(deploymentPlan, "deploymentPlan", "xml");
            }
            File moduleArchiveFile = this.createTempFile(moduleArchive, "app", EAR_EXT);
            String fileExt = this.getModuleFileExtension(this.getModuleType(moduleArchiveFile));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "file extension is set to " + fileExt);
            }
            if (!EAR_EXT.equals(fileExt)) {
                moduleArchiveFile = this.createTempFile(new FileInputStream(moduleArchiveFile), "app", fileExt);
            }
            progressObject = po = this.distributeInternal(targetList, moduleArchiveFile, deploymentPlanFile, null);
            Object var10_11 = null;
        }
        catch (Exception e) {
            ProgressObjectImpl progressObjectImpl;
            try {
                RasUtils.logException((Throwable)e, tc, CLASS_NAME, "distribute", "1051", this);
                ProgressObjectImpl po = new ProgressObjectImpl(CommandType.DISTRIBUTE, StateType.FAILED);
                po.setMessage("ADMJ1024E", new Object[]{e.toString()});
                progressObjectImpl = po;
                Object var10_12 = null;
            }
            catch (Throwable throwable) {
                block14: {
                    Object var10_13 = null;
                    if (!tc.isEntryEnabled()) break block14;
                    Tr.exit(tc, "distribute");
                }
                throw throwable;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "distribute");
            }
            return progressObjectImpl;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "distribute");
        }
        return progressObject;
    }

    public ProgressObject start(TargetModuleID[] moduleIDList) throws IllegalStateException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "start", "moduleIDList=" + Arrays.toString(moduleIDList));
        }
        this.validateConnection();
        if (moduleIDList == null) {
            moduleIDList = new TargetModuleIDImpl[]{};
        }
        ProgressObjectImpl po = new ProgressObjectImpl(CommandType.START);
        try {
            this.validateRootRequest(moduleIDList);
            if (moduleIDList.length > 0) {
                CommandProcessor cp = new CommandProcessor(this, po, CommandType.START, moduleIDList);
                String pKey = AdminContext.peek();
                if (pKey != null) {
                    cp.setProfileKey(pKey);
                }
                Thread t = new Thread(cp);
                t.setDaemon(true);
                t.start();
            } else {
                po.setFinalStateAndNotify(StateType.COMPLETED);
                po.setMessage("ADMJ1027I", null);
            }
        }
        catch (Exception e) {
            RasUtils.logException((Throwable)e, tc, CLASS_NAME, "start", "1100", this);
            po.setState(StateType.FAILED);
            po.setMessage("ADMJ1024E", new Object[]{e.toString()});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "start");
        }
        return po;
    }

    public ProgressObject stop(TargetModuleID[] moduleIDList) throws IllegalStateException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stop");
        }
        this.validateConnection();
        if (moduleIDList == null) {
            moduleIDList = new TargetModuleIDImpl[]{};
        }
        ProgressObjectImpl po = new ProgressObjectImpl(CommandType.STOP);
        try {
            this.validateRootRequest(moduleIDList);
            if (moduleIDList.length > 0) {
                CommandProcessor cp = new CommandProcessor(this, po, CommandType.STOP, moduleIDList);
                String pKey = AdminContext.peek();
                if (pKey != null) {
                    cp.setProfileKey(pKey);
                }
                Thread t = new Thread(cp);
                t.setDaemon(true);
                t.start();
            } else {
                po.setFinalStateAndNotify(StateType.COMPLETED);
                po.setMessage("ADMJ1027I", null);
            }
        }
        catch (Exception e) {
            RasUtils.logException((Throwable)e, tc, CLASS_NAME, "stop", "1151", this);
            po.setState(StateType.FAILED);
            po.setMessage("ADMJ1024E", new Object[]{e.toString()});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stop");
        }
        return po;
    }

    private void startCommand(TargetModuleID[] moduleIDList, ProgressObject po) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "startCommand");
        }
        Object on = null;
        Object applicationManagementON = null;
        TargetModuleIDImpl mod = null;
        String server = "";
        Object newServer = null;
        String node = "";
        Object newNode = null;
        boolean success = true;
        boolean allSuccess = true;
        String message = null;
        Object[] params = null;
        try {
            for (int i = 0; i < moduleIDList.length; ++i) {
                success = true;
                message = null;
                params = null;
                mod = (TargetModuleIDImpl)moduleIDList[i];
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Starting module:" + mod.getObjectName().toString());
                    Tr.debug(tc, "TargetModuleID: " + mod.toString());
                }
                if (!mod.isStartable() || mod.isRar()) {
                    ((ProgressObjectImpl)po).addSuccessfulResult(mod);
                    continue;
                }
                try {
                    Hashtable<String, Locale> tbl = new Hashtable<String, Locale>();
                    tbl.put("app.client.locale", this.getCurrentLocale());
                    AppManagement appM = this.getAppManagementProxy(this.client);
                    appM.startApplication(mod.getObjectName().getKeyProperty("name"), mod.getTarget().getName(), tbl, null);
                    success = true;
                }
                catch (MBeanException mbe) {
                    RasUtils.logException((Throwable)mbe, tc, CLASS_NAME, "startCommand", "1212", this);
                    if (mbe.getTargetException() instanceof ConfigurationWarning && mbe.getTargetException().getMessage() != null && mbe.getTargetException().getMessage().startsWith("Duplicate application")) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Application " + mod.getObjectName().getKeyProperty("name") + " was already started.");
                        }
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception starting " + mod.getObjectName().getKeyProperty("name") + ".", mbe);
                        }
                        message = "ADMJ1014E";
                        params = new Object[]{mbe};
                        success = false;
                    }
                }
                catch (Throwable t) {
                    RasUtils.logException(t, tc, CLASS_NAME, "startCommand", "1241", this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception starting " + mod.getObjectName().getKeyProperty("name") + ".", t);
                    }
                    message = "ADMJ1014E";
                    params = new Object[]{t};
                    success = false;
                }
                if (success) {
                    message = "ADMJ1018I";
                    params = new Object[]{mod.getApplicationName()};
                    ((ProgressObjectImpl)po).addSuccessfulResult(mod);
                } else {
                    ((ProgressObjectImpl)po).addFailedResult(mod);
                }
                ((ProgressObjectImpl)po).sendModuleEvent(mod, success ? StateType.COMPLETED : StateType.FAILED, message, params);
                allSuccess &= success;
            }
            ((ProgressObjectImpl)po).setFinalStateAndNotify(allSuccess ? StateType.COMPLETED : StateType.FAILED);
        }
        catch (Exception e) {
            RasUtils.logException((Throwable)e, tc, CLASS_NAME, "startCommand", "1275", this);
            Tr.warning(tc, "ADMJ1014E", new Object[]{e});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "startCommand");
        }
    }

    public void stopCommand(TargetModuleID[] moduleIDList, ProgressObject po) throws IllegalStateException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stopCommand");
        }
        Object on = null;
        Object applicationManagementON = null;
        TargetModuleIDImpl mod = null;
        String server = "";
        Object newServer = null;
        String node = "";
        Object newNode = null;
        boolean success = true;
        boolean allSuccess = true;
        String message = null;
        Object[] params = null;
        try {
            for (int i = 0; i < moduleIDList.length; ++i) {
                mod = (TargetModuleIDImpl)moduleIDList[i];
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Stopping module:" + mod.getObjectName().toString());
                    Tr.debug(tc, "TargetModuleID: " + mod.toString());
                }
                success = true;
                message = null;
                params = null;
                Hashtable<String, Locale> tbl = new Hashtable<String, Locale>();
                tbl.put("app.client.locale", this.getCurrentLocale());
                try {
                    AppManagement appM = this.getAppManagementProxy(this.client);
                    appM.stopApplication(mod.getObjectName().getKeyProperty("name"), mod.getTarget().getName().toString(), tbl, null);
                    success = true;
                }
                catch (Throwable t) {
                    RasUtils.logException(t, tc, CLASS_NAME, "stopCommand", "1331", this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception stopping " + mod.getObjectName().toString(), t);
                        Tr.debug(tc, "TargetModuleID: " + mod.toString());
                    }
                    success = false;
                    message = "ADMJ1015E";
                    params = new Object[]{t};
                }
                if (success) {
                    message = "ADMJ1019I";
                    params = new Object[]{mod.getApplicationName()};
                    ((ProgressObjectImpl)po).addSuccessfulResult(mod);
                } else {
                    ((ProgressObjectImpl)po).addFailedResult(mod);
                }
                ((ProgressObjectImpl)po).sendModuleEvent(mod, success ? StateType.COMPLETED : StateType.FAILED, message, params);
                allSuccess &= success;
            }
            ((ProgressObjectImpl)po).setFinalStateAndNotify(allSuccess ? StateType.COMPLETED : StateType.FAILED);
        }
        catch (Exception e) {
            RasUtils.logException((Throwable)e, tc, CLASS_NAME, "stopCommand", "1367", this);
            Tr.warning(tc, "ADMJ1015E", new Object[]{e});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stopCommand");
        }
    }

    public ProgressObject undeploy(TargetModuleID[] moduleIDList) throws IllegalStateException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "undeploy");
        }
        this.validateConnection();
        if (moduleIDList == null) {
            moduleIDList = new TargetModuleIDImpl[]{};
        }
        ProgressObjectImpl po = new ProgressObjectImpl(CommandType.UNDEPLOY);
        if (moduleIDList.length > 0) {
            try {
                this.validateRootRequest(moduleIDList);
                Hashtable<String, Object> props = new Hashtable<String, Object>();
                props.put("app.client.locale", this.getCurrentLocale());
                AppManagement appM = this.getAppManagementProxy(this.client);
                props.put("app.client.locale", this.getCurrentLocale());
                Hashtable<String, Boolean> appNames = new Hashtable<String, Boolean>();
                boolean rarOnly = true;
                TargetModuleIDImpl targetMod = null;
                for (int i = 0; i < moduleIDList.length; ++i) {
                    targetMod = (TargetModuleIDImpl)moduleIDList[i];
                    if (targetMod.isRar()) {
                        this.undeployRar(targetMod, po);
                        continue;
                    }
                    rarOnly = false;
                    String appName = targetMod.getApplicationName();
                    String ts = Long.toHexString(System.currentTimeMillis());
                    props.put("HandBackForClient", ts);
                    this.commandpoAssociation.put(ts, new DataHolder(po, targetMod, null));
                    if (!appNames.containsKey(appName)) {
                        appNames.put(appName, Boolean.TRUE);
                        appM.uninstallApplication(appName, props, null);
                        po.increaseEventCount();
                        continue;
                    }
                    po.addSuccessfulResult(targetMod);
                }
                if (rarOnly) {
                    po.setFinalStateAndNotify(StateType.COMPLETED);
                }
            }
            catch (Exception e) {
                RasUtils.logException((Throwable)e, tc, CLASS_NAME, "undeploy", "1451", this);
                po.setState(StateType.FAILED);
                po.setMessage("ADMJ1024E", new Object[]{e.toString()});
            }
        } else {
            po.setFinalStateAndNotify(StateType.COMPLETED);
            po.setMessage("ADMJ1027I", null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "undeploy");
        }
        return po;
    }

    private ProgressObject undeployRar(TargetModuleIDImpl targetMod, ProgressObjectImpl po) throws IllegalStateException {
        Session session = null;
        ConfigServiceProxy configService = null;
        try {
            session = new Session();
            configService = new ConfigServiceProxy(this.client);
            if (targetMod != null && targetMod.getObjectName() != null) {
                configService.deleteConfigData(session, targetMod.getObjectName());
                configService.save(session, false);
                configService.discard(session);
                po.addSuccessfulResult(targetMod);
            } else {
                po.addFailedResult(targetMod);
            }
        }
        catch (Exception e) {
            RasUtils.logException((Throwable)e, tc, CLASS_NAME, "undeployRar", "1491", this);
            po.addFailedResult(targetMod);
            this.cleanUpSession(configService, session);
        }
        return po;
    }

    private AppManagement getAppManagementProxy(AdminClient client) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAppManagementProxy");
        }
        if (this.appM == null) {
            this.appM = AppManagementProxy.getJMXProxyForClient(client);
            NotificationFilterSupport myFilter = new NotificationFilterSupport();
            myFilter.enableType("websphere.admin.appmgmt");
            ObjectName on = this.getAppManagementObjectName();
            client.addNotificationListener(on, this, (NotificationFilter)myFilter, null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAppManagementProxy");
        }
        return this.appM;
    }

    private void releaseAppManagementProxy() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "releaseAppManagementProxy");
        }
        if (this.appM != null && this.client != null) {
            try {
                this.client.removeNotificationListener(this.getAppManagementObjectName(), this);
            }
            catch (Exception e) {
                RasUtils.logException((Throwable)e, tc, CLASS_NAME, "releaseAppManagementProxy", "1539", this);
            }
            this.appM = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "releaseAppManagementProxy");
        }
    }

    public void handleNotification(Notification notf, Object handback) {
        String key;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleNotification", new String[]{"notf=" + notf, "handback=" + handback});
        }
        AppNotification ev = (AppNotification)notf.getUserData();
        if ((ev.taskName.equals("InstallApplication") && ev.subtaskName.equals("ConfigureTask") || ev.taskName.equals("UninstallApplication") && ev.subtaskName.equals("DeleteSIEntryTask")) && ev.subtaskStatus.equals("Completed")) {
            key = (String)ev.props.get("HandBackForClient");
            String nodes = (String)ev.props.get("nodes");
            if (key != null && nodes != null) {
                DataHolder assocData = (DataHolder)this.commandpoAssociation.get(key);
                assocData.setNodes(nodes.split("\\+"));
            }
        }
        if ((ev.taskName.equals("InstallApplication") || ev.taskName.equals("UninstallApplication")) && (ev.taskStatus.equals("Completed") || ev.taskStatus.equals("Failed")) && (key = (String)ev.props.get("HandBackForClient")) != null) {
            DataHolder assocData = (DataHolder)this.commandpoAssociation.get(key);
            StateType state = null;
            if (assocData.po != null) {
                boolean notified;
                state = this.getStateFromEventStatus(ev);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "assocData.tm " + assocData.tm);
                    Tr.debug(tc, "assocData.tms " + assocData.tms);
                }
                if (assocData.tm != null) {
                    if (ev.taskStatus.equals("Completed")) {
                        TargetModuleID[] childModuleID;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "moduleType: " + assocData.tm.getModuleType());
                        }
                        if (assocData.tm.getModuleType().equals(EAR_MODULE) && (childModuleID = this.getAvailableChildren(assocData.tm, ev.props.getProperty("appname"))) != null) {
                            assocData.tm.setChildTargetModuleID(childModuleID);
                        }
                        assocData.po.addSuccessfulResult(assocData.tm);
                    } else if (ev.taskStatus.equals("Failed")) {
                        assocData.po.addFailedResult(assocData.tm);
                    }
                    assocData.po.sendTranslatedModuleEvent(assocData.tm, state, ev.message);
                } else if (assocData.tms != null) {
                    for (int i = 0; i < assocData.tms.length; ++i) {
                        if (ev.taskStatus.equals("Completed")) {
                            TargetModuleID[] childModuleID;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "moduleType: " + assocData.tms[i].getModuleType());
                            }
                            if (assocData.tms[i].getModuleType().equals(EAR_MODULE) && (childModuleID = this.getAvailableChildren(assocData.tms[i], ev.props.getProperty("appname"))) != null) {
                                assocData.tms[i].setChildTargetModuleID(childModuleID);
                            }
                            assocData.po.addSuccessfulResult(assocData.tms[i]);
                        } else if (ev.taskStatus.equals("Failed")) {
                            assocData.po.addFailedResult(assocData.tms[i]);
                        }
                        assocData.po.sendTranslatedModuleEvent(assocData.tms[i], state, ev.message);
                    }
                }
                if (assocData.po.isLast()) {
                    this.synchronizeNodes(assocData);
                }
                if (notified = assocData.po.setFinalStateAndNotify(state)) {
                    this.commandpoAssociation.remove(key);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleNotification");
        }
    }

    private void synchronizeNodes(DataHolder assocData) {
        if (this.isDistributed() && assocData != null && assocData.nodes != null) {
            Enumeration<Object> vEnum = assocData.nodes.keys();
            String node = null;
            while (vEnum.hasMoreElements()) {
                try {
                    node = (String)vEnum.nextElement();
                    ObjectName on = new ObjectName("WebSphere:*,type=NodeSync,process=nodeagent,node=" + node);
                    Set s = this.client.queryNames(on, null);
                    if (s != null && !s.isEmpty()) {
                        Object[] o = s.toArray();
                        ObjectName nodeSyncON = (ObjectName)o[0];
                        this.client.invoke(nodeSyncON, "sync", null, null);
                        continue;
                    }
                    Tr.warning(tc, "ADMJ1029W", new Object[]{node});
                }
                catch (Exception e) {
                    RasUtils.logException((Throwable)e, tc, CLASS_NAME, "synchronizeNodes", "1679", this);
                    Tr.error(tc, "ADMJ1030E", e);
                }
            }
        }
    }

    private boolean isDistributed() {
        if (this.distributed == null) {
            try {
                ObjectName on = this.client.getServerMBean();
                this.distributed = on.getKeyProperty("process").equals("dmgr") ? Boolean.TRUE : Boolean.FALSE;
            }
            catch (Exception e) {
                RasUtils.logException((Throwable)e, tc, CLASS_NAME, "isDistributed", "1699", this);
                this.distributed = Boolean.TRUE;
            }
        }
        return this.distributed;
    }

    private StateType getStateFromEventStatus(AppNotification ev) {
        StateType state = null;
        state = ev.taskStatus.equals("Completed") ? StateType.COMPLETED : (ev.taskStatus.equals("Failed") ? StateType.FAILED : StateType.RUNNING);
        return state;
    }

    public boolean isRedeploySupported() {
        return false;
    }

    public ProgressObject redeploy(TargetModuleID[] moduleIDList, File moduleArchive, File deploymentPlan) throws UnsupportedOperationException, IllegalStateException {
        ResourceBundle resBundle = AppUtils.getBundle("com.ibm.ws.management.resources.J2eeDeploymentMessages", this.getCurrentLocale());
        throw new UnsupportedOperationException(AppUtils.getMessage(resBundle, "ADMJ1007E"));
    }

    public ProgressObject redeploy(TargetModuleID[] moduleIDList, InputStream moduleArchive, InputStream deploymentPlan) throws UnsupportedOperationException, IllegalStateException {
        ResourceBundle resBundle = AppUtils.getBundle(DeploymentManagerImpl.getLocalePrefs());
        throw new UnsupportedOperationException(AppUtils.getMessage(resBundle, "ADMJ1007E"));
    }

    public void release() {
        this.releaseAppManagementProxy();
        this.client = null;
        this.connected = false;
    }

    public Locale getDefaultLocale() {
        return Locale.getDefault();
    }

    public Locale getCurrentLocale() {
        Locale l = null;
        l = this.userLocale != null ? this.userLocale : this.getDefaultLocale();
        return l;
    }

    public void setLocale(Locale locale) throws UnsupportedOperationException {
        this.userLocale = locale;
        localePrefs.put("app.client.locale", locale);
    }

    public static Hashtable getLocalePrefs() {
        return localePrefs;
    }

    public Locale[] getSupportedLocales() {
        return Locale.getAvailableLocales();
    }

    public boolean isLocaleSupported(Locale locale) {
        boolean supported = false;
        Locale[] locales = this.getSupportedLocales();
        for (int i = 0; i < locales.length; ++i) {
            if (!locales[i].equals(locale)) continue;
            supported = true;
            break;
        }
        return supported;
    }

    public DConfigBeanVersionType getDConfigBeanVersion() {
        return this.configBeanVersion;
    }

    public boolean isDConfigBeanVersionSupported(DConfigBeanVersionType type) {
        return DConfigBeanVersionType.V5.equals(type) || DConfigBeanVersionType.V1_4.equals(type) || DConfigBeanVersionType.V1_3.equals(type);
    }

    public void setDConfigBeanVersion(DConfigBeanVersionType type) throws DConfigBeanVersionUnsupportedException {
        if (!this.isDConfigBeanVersionSupported(type)) {
            throw new DConfigBeanVersionUnsupportedException(type + " is unsupported");
        }
        this.configBeanVersion = type;
    }

    private Object invokeGetTarget() {
        Object o = null;
        try {
            o = this.invokeJ2EEAppDeploymentMBean("getTarget", null, null);
        }
        catch (TargetException te) {
            RasUtils.logException((Throwable)te, tc, CLASS_NAME, "invokeGetTarget", "1881", this);
            Tr.warning(tc, "ADMJ1023E", new Object[]{te});
        }
        return o;
    }

    private Object invokeJ2EEAppDeploymentMBean(String method2, Object[] params, String[] signature) throws TargetException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invokeAppManagementMBean");
        }
        Object config = null;
        try {
            ObjectName j2eeDepON = this.getJ2EEAppDeploymentObjectName();
            config = this.client.invoke(j2eeDepON, method2, params, signature);
        }
        catch (MBeanException mbe) {
            RasUtils.logException((Throwable)mbe, tc, CLASS_NAME, "invokeJ2EEAppDeploymentMBean", "1905", this);
            Tr.warning(tc, "ADMJ1023E", new Object[]{mbe});
            if (mbe.getTargetException() != null) {
                if (mbe.getTargetException() instanceof TargetException) {
                    throw (TargetException)mbe.getTargetException();
                }
                throw new J2EEDeployIllegalStateException(mbe.getTargetException().getMessage(), mbe.getTargetException());
            }
            throw new J2EEDeployIllegalStateException(mbe.getMessage(), mbe);
        }
        catch (Exception e) {
            RasUtils.logException((Throwable)e, tc, CLASS_NAME, "invokeJ2EEAppDeploymentMBean", "1920", this);
            Tr.warning(tc, "ADMJ1023E", new Object[]{e});
            throw new J2EEDeployIllegalStateException(e.getMessage(), e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invokeAppManagementMBean");
        }
        return config;
    }

    private ObjectName getJ2EEAppDeploymentObjectName() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getJ2EEAppDeploymentObjectName");
        }
        if (this.j2eeAppDeploymentON == null) {
            this.j2eeAppDeploymentON = this.getObjectName("J2EEAppDeployment");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getJ2EEAppDeploymentObjectName");
        }
        return this.j2eeAppDeploymentON;
    }

    private ObjectName getAppManagementObjectName() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAppManagementObjectName");
        }
        if (this.appManagementON == null) {
            this.appManagementON = this.getObjectName("AppManagement");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAppManagementObjectName");
        }
        return this.appManagementON;
    }

    private ObjectName getObjectName(String type) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAppMgmtObjectName");
        }
        ObjectName appMgmtON = null;
        String process = null;
        ObjectName serverON = this.client.getServerMBean();
        process = serverON.getKeyProperty("process");
        ObjectName queryName = new ObjectName("WebSphere:*,type=" + type + ",process=" + process);
        Set s = this.client.queryNames(queryName, null);
        if (s != null && !s.isEmpty()) {
            if (s.size() != 1 && tc.isDebugEnabled()) {
                Tr.debug(tc, "There are " + s.size() + type + " objects.");
            }
            Object[] o = s.toArray();
            appMgmtON = (ObjectName)o[0];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ObjectName is " + appMgmtON.getCanonicalName());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAppMgmtObjectName");
        }
        return appMgmtON;
    }

    public static String convertModuleType(ModuleType moduleType) {
        String type = EAR_MODULE;
        if (moduleType.equals(ModuleType.EAR)) {
            type = EAR_MODULE;
        } else if (moduleType.equals(ModuleType.WAR)) {
            type = WAR_MODULE;
        } else if (moduleType.equals(ModuleType.EJB)) {
            type = EJB_MODULE;
        } else if (moduleType.equals(ModuleType.CAR)) {
            type = CAR_MODULE;
        } else if (moduleType.equals(ModuleType.RAR)) {
            type = RAR_MODULE;
        }
        return type;
    }

    private File createTempFile(InputStream is, String prefix, String suffix) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTempFile");
        }
        File tempFile = null;
        try {
            String userInstallRoot = System.getProperty("user.install.root");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "userInstallRoot: " + userInstallRoot);
            }
            File tmpDir = null;
            if (userInstallRoot != null && !userInstallRoot.trim().equals("")) {
                tmpDir = new File(userInstallRoot + "/temp");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "tmpDir: " + tmpDir.getAbsolutePath());
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "createTempFile: prefix " + prefix + " suffix " + suffix + " tmpDir " + tmpDir);
            }
            tempFile = File.createTempFile(prefix, suffix, tmpDir);
            FileOutputStream out = new FileOutputStream(tempFile);
            byte[] buf = new byte[8192];
            int numRead = is.read(buf);
            while (numRead != -1) {
                ((OutputStream)out).write(buf, 0, numRead);
                numRead = is.read(buf);
            }
            out.flush();
            ((OutputStream)out).close();
        }
        catch (IOException ioe) {
            RasUtils.logException((Throwable)ioe, tc, CLASS_NAME, "createTempFile", "2048", this);
            Tr.warning(tc, "ADMJ1016E", ioe);
            throw new J2EEDeployIllegalStateException(ioe.getMessage(), ioe);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "file exists? " + tempFile.exists());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "can write? " + tempFile.canWrite());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createTempFile");
        }
        return tempFile;
    }

    private void validateConnection() throws IllegalStateException {
        if (!this.connected) {
            throw new J2EEDeployIllegalStateException(AppUtils.getMessage(this.getResourceBundle(), "ADMJ1009E"));
        }
    }

    private void validateRootRequest(TargetModuleID[] moduleIDList) {
        TargetModuleID mod = null;
        for (int i = 0; i < moduleIDList.length; ++i) {
            mod = moduleIDList[i];
            if (mod.getParentTargetModuleID() == null) continue;
            throw new J2EEDeployIllegalStateException(AppUtils.getMessage(this.getResourceBundle(), "ADMJ1021E"));
        }
    }

    private ResourceBundle getResourceBundle() {
        return AppUtils.getBundle("com.ibm.ws.management.resources.J2eeDeploymentMessages", this.getCurrentLocale());
    }

    private String prepareOnServer(String filename, Hashtable props) throws ConnectorException, AdminException, TransferFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepareOnServer", new Object[]{filename});
        }
        String ret = filename;
        if ("DeploymentManager".equals(this.processType)) {
            Properties transferProps = this.client.getConnectorProperties();
            ret = AppInstallHelper.copyToServer(this.client, filename);
            props.put("DeleteSourceEar", Boolean.TRUE);
        } else {
            ret = filename;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "copyToServer", new Object[]{ret});
        }
        return ret;
    }

    private TargetModuleID[] getAvailableChildren(TargetModuleIDImpl m, String appName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAvailableChildren", new Object[]{m, appName});
        }
        TargetModuleID[] childModuleID = null;
        try {
            AppManagement appM = this.getAppManagementProxy(this.client);
            Hashtable tbl = new Hashtable();
            J2EEAppDeploymentImpl j2ee = new J2EEAppDeploymentImpl(tbl);
            childModuleID = j2ee.getAvailableChildren(appM, appName, m, tbl, null);
        }
        catch (Exception ex) {
            RasUtils.logException((Throwable)ex, tc, CLASS_NAME, "getAvailableChildren", "2127", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAvailableChildren", new Object[]{childModuleID});
        }
        return childModuleID;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append('@');
        stringBuilder.append(Integer.toHexString(this.hashCode()));
        stringBuilder.append("[connected=");
        stringBuilder.append(this.connected);
        stringBuilder.append(", client=");
        stringBuilder.append(this.client);
        stringBuilder.append(", j2eeAppDeploymentON=");
        stringBuilder.append(this.j2eeAppDeploymentON);
        stringBuilder.append(", appManagementON=");
        stringBuilder.append(this.appManagementON);
        stringBuilder.append(", userLocale=");
        stringBuilder.append(this.userLocale);
        stringBuilder.append(", configBeanVersion=");
        stringBuilder.append(this.configBeanVersion);
        stringBuilder.append(", appM=");
        stringBuilder.append(this.appM);
        stringBuilder.append(", commandpoAssociation=");
        stringBuilder.append(this.commandpoAssociation);
        stringBuilder.append(", distributed=");
        stringBuilder.append(this.distributed);
        stringBuilder.append(", processType=");
        stringBuilder.append(this.processType);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/ws/management/application/j2ee/deploy/spi/DeploymentManagerImpl.java, WAS.admin.installapp, WAS70.SERV1, q0834.18, ver. 1.34");
        }
        CLASS_NAME = DeploymentManagerImpl.class.getName();
        localePrefs = new Hashtable();
    }

    private class DataHolder {
        ProgressObjectImpl po = null;
        TargetModuleIDImpl tm = null;
        TargetModuleIDImpl[] tms = null;
        Properties nodes = new Properties();

        DataHolder(ProgressObjectImpl po, TargetModuleIDImpl tm, TargetModuleIDImpl[] tms) {
            this.po = po;
            this.tm = tm;
            this.tms = tms;
        }

        void setNodes(String[] nodesArray) {
            if (this.nodes != null) {
                for (int i = 0; i < nodesArray.length; ++i) {
                    this.nodes.setProperty(nodesArray[i], "1");
                }
            }
        }
    }

    private class CommandProcessor
    implements Runnable {
        private CommandType command = null;
        private TargetModuleID[] targetMods = null;
        private DeploymentManagerImpl dm = null;
        private ProgressObject po = null;
        private String profileKey = null;

        CommandProcessor(DeploymentManagerImpl dm, ProgressObject po, CommandType command, TargetModuleID[] targetMods) {
            this.command = command;
            this.targetMods = targetMods;
            this.dm = dm;
            this.po = po;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block13: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "CommandProcessor.run");
                }
                boolean isPushedProfile = false;
                try {
                    block12: {
                        try {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Profile Key", this.profileKey);
                            }
                            if (this.profileKey != null) {
                                isPushedProfile = AdminContext.push(this.profileKey);
                            }
                            if (this.command.equals(CommandType.START)) {
                                this.dm.startCommand(this.targetMods, this.po);
                                break block12;
                            }
                            if (this.command.equals(CommandType.STOP)) {
                                this.dm.stopCommand(this.targetMods, this.po);
                            }
                        }
                        catch (Exception ce) {
                            RasUtils.logException((Throwable)ce, tc, CLASS_NAME, "CommandProcessor.run", "2218", this);
                            Object var4_3 = null;
                            if (isPushedProfile) {
                                AdminContext.pop();
                            }
                            if (!tc.isEntryEnabled()) return;
                            Tr.exit(tc, "CommandProcessor.run");
                            return;
                        }
                    }
                    Object var4_2 = null;
                    if (!isPushedProfile) break block13;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    if (isPushedProfile) {
                        AdminContext.pop();
                    }
                    if (!tc.isEntryEnabled()) throw throwable;
                    Tr.exit(tc, "CommandProcessor.run");
                    throw throwable;
                }
                AdminContext.pop();
            }
            if (!tc.isEntryEnabled()) return;
            Tr.exit(tc, "CommandProcessor.run");
        }

        public void setProfileKey(String key) {
            this.profileKey = key;
        }
    }
}

