/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.exts;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.application.AppDeploymentUtil;
import com.ibm.websphere.management.application.AppManagementExtensions;
import com.ibm.websphere.management.application.EditScheduler;
import com.ibm.websphere.management.application.InstallScheduler;
import com.ibm.websphere.management.application.Scheduler;
import com.ibm.websphere.management.application.UpdateScheduler;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessor;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessorFactory;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.appdeployment.ModuleDeployment;
import com.ibm.websphere.models.config.classloader.Classloader;
import com.ibm.websphere.models.config.classloader.LibraryRef;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.UpdateSchedulerImpl;
import com.ibm.ws.management.application.client.AppInstallHelper;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.management.tools.UnmanagedNode;
import com.ibm.ws.management.util.RasUtils;
import com.ibm.ws.sm.workspace.RepositoryContext;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;

public class ValidateAppExt
implements AppManagementExtensions.AppValidationHelper,
AppManagementExtensions.AppValidationHelper2 {
    private static TraceComponent tc = Tr.register(ValidateAppExt.class, null, null);
    private static final String CLASS_NAME;

    public void validateOperation_Required(Scheduler scheduler, List results) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ValidateAppExt.validateOperation_Required())");
        }
        try {
            EARFile ear = this.getEar(scheduler);
            boolean earHasWeb25Modules = AppDeploymentUtil.checkWeb25Modules(ear);
            boolean earHasEJB30Modules = AppDeploymentUtil.checkEJB3Modules(ear);
            if (earHasWeb25Modules) {
                this.validate(ear, scheduler, results, false);
            } else if (earHasEJB30Modules) {
                this.validate(ear, scheduler, results, true);
            }
        }
        catch (Throwable th) {
            RasUtils.logException(th, tc, CLASS_NAME, "validateOperation_Required", "94", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ValidateAppExt.validateOperation_Required())");
        }
    }

    public void validateOperation_Optional(Scheduler arg0, List arg1) {
    }

    private void validate(EARFile ear, Scheduler scheduler, List results, boolean bEJB3FeP) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ValidateAppExt.validate(EARFile)", new Object[]{ear, scheduler, results, bEJB3FeP});
        }
        Hashtable servertbl = (Hashtable)scheduler.getProperties().get("moduleToServer");
        Hashtable nodeVersionTable = AppDeploymentUtil.getNodeVersionForAppTargets(servertbl, scheduler.getCellContext(), scheduler.getWorkSpace());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "\nNodeVersionTable: " + nodeVersionTable + "\nHere is the  table:  " + nodeVersionTable.size());
        }
        Enumeration keys = nodeVersionTable.keys();
        while (keys.hasMoreElements()) {
            List lstData = (List)nodeVersionTable.get(keys.nextElement());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "lstData =", lstData);
            }
            if (lstData == null) continue;
            List lstUnNode = new ArrayList();
            lstUnNode = UnmanagedNode.listManagedNodes((Session)new Session(scheduler.getWorkSpace().getUserName(), true));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "List of unmanaged node: ", lstUnNode);
            }
            for (int i = 0; i < lstData.size(); i += 4) {
                String nodeName = (String)lstData.get(i);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "found nodeName =" + nodeName);
                }
                try {
                    if (lstUnNode == null || !lstUnNode.contains(nodeName)) {
                        int nodeVersion = Integer.parseInt((String)lstData.get(i + 1));
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "nodeVersion: " + nodeVersion);
                        }
                        if (nodeVersion == 7) continue;
                        String msg = AppUtils.getMessage(AppUtils.getBundle(null), "ADMA0110E", new String[]{"6.0", nodeName, (String)lstData.get(i)});
                        if (bEJB3FeP) {
                            String prodName = (String)lstData.get(i + 3);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "prodName: " + prodName);
                            }
                            if (prodName != null && "EJB 3.0".equals(prodName) || results.contains(msg)) continue;
                            results.add(msg);
                            continue;
                        }
                        if (results.contains(msg)) continue;
                        results.add(msg);
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Skipping Unmanaged Node: " + nodeName);
                    continue;
                }
                catch (Throwable th) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Error in getting listUnmanagedNode: " + th);
                    }
                    RasUtils.logException(th, tc, CLASS_NAME, "validate", "157", this);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ValidateAppExt.validate(EARFile)", results);
        }
    }

    private EARFile getEar(Scheduler scheduler) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ValidateAppExt.getEar()", scheduler);
        }
        EARFile ear = null;
        if (scheduler instanceof InstallScheduler) {
            ear = ((InstallScheduler)scheduler).getEarFile(true, false);
        } else if (scheduler instanceof UpdateScheduler) {
            RepositoryContext rc = AppUtils.findAppContextFromConfig(scheduler.getAppName(), scheduler.getWorkSpace(), scheduler.getProperties());
            if (!ConfigRepoHelper.getAppDeploymentForApp(rc).isZeroBinaryCopy()) {
                String bundleName = "com.ibm.ws.management.resources.AppDeploymentMessages";
                ear = ConfigRepoHelper.getEarFileFromBinaries(rc, scheduler.getWorkSpace(), AppUtils.getBundle(bundleName, Locale.getDefault()), true);
            } else {
                ear = (EARFile)((UpdateSchedulerImpl)scheduler).getContentAsArchive(false, true);
            }
        } else if (scheduler instanceof EditScheduler && (ear = ((EditScheduler)scheduler).getEarFile()) == null) {
            RepositoryContext rc = AppUtils.findAppContextFromConfig(scheduler.getAppName(), scheduler.getWorkSpace(), scheduler.getProperties());
            ear = ConfigRepoHelper.getEarFileFromDeployment(scheduler.getWorkSpace(), rc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ValidateAppExt.getEar()", ear);
        }
        return ear;
    }

    public void isApplicationDeployable(String nodeName, String clusterName, String appName, EARFile ear, String workspaceID, Locale locale, List errors) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ValidateAppExt.isApplicationDeployable()");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "nodName = " + nodeName + ", clusterName = " + clusterName + ", appName = " + appName + ", workspaceID = " + workspaceID);
        }
        try {
            AppDeploymentInfo info = AppInstallHelper.getAppDeploymentInfo(ear);
            Vector ejbJars = info.getModuleConfig("EJB3JAR_DD");
            if (ejbJars != null && ejbJars.size() > 0) {
                if (ear != null) {
                    ear.getOptions().setUseJavaReflection(true);
                    this.validate(nodeName, clusterName, appName, ear, workspaceID, locale, errors, true);
                    ear.close();
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "EARFile is null");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, info.getAppDisplayName() + " doesn't have any EJB 3.0 modules!!!!");
            }
            Vector web25Wars = info.getModuleConfig("WEB25WAR_DD");
            if (web25Wars != null && web25Wars.size() > 0) {
                this.validate(nodeName, clusterName, appName, ear, workspaceID, locale, errors, false);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, info.getAppDisplayName() + " doesn't have any WEB2.5 modules!!!!");
            }
            this.validateBLASharedLib(nodeName, clusterName, appName, workspaceID, locale, errors);
        }
        catch (Throwable th) {
            Tr.error(tc, "Received Exception in method isApplicationDeployable(): " + th.getMessage());
            RasUtils.logException(th, tc, CLASS_NAME, "isApplicationDeployable", "235", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ValidateAppExt.isApplicationDeployable()");
        }
    }

    private void validate(String nodeName, String clusterName, String appName, EARFile ear, String workspaceID, Locale locale, List errors, boolean bEJB3FEP) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ValidateAppExt.validate(nodeName)", new Object[]{nodeName, clusterName, appName, ear, workspaceID, locale, errors});
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "validating " + ear.getName() + " for node " + nodeName + " and/or cluster " + clusterName);
        }
        this.validate(nodeName, clusterName, appName, workspaceID, locale, errors, bEJB3FEP);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ValidateAppExt.validate(nodeName)");
        }
    }

    private void validate(String nodeName, String clusterName, String appName, String workspaceID, Locale locale, List results, boolean bEJB3FEP) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ValidateAppExt.validate()", new Object[]{nodeName, clusterName, appName, workspaceID, results});
        }
        ManagedObjectMetadataAccessor moma = ManagedObjectMetadataAccessorFactory.createAccessor(null);
        String managedNode2 = null;
        List managedNodes = this.getManagedNodes();
        for (String managedNode2 : managedNodes) {
            if (!managedNode2.equals(nodeName)) continue;
            int nodeVersion = Integer.parseInt(AppUtils.getNodeMajorVersion(null, nodeName));
            if (nodeVersion == 7) break;
            String msg = AppUtils.getMessage(AppUtils.getBundle(null), "ADMA0110E", new String[]{"5.0", nodeName, String.valueOf(nodeVersion)});
            if (bEJB3FEP) {
                String prodName = moma.getMetadataProperty(nodeName, "com.ibm.websphere.EJB3FeaturePackProductShortName");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "prodName: " + prodName);
                }
                if (prodName != null && "EJB 3.0".equals(prodName)) break;
                if (!results.contains(msg)) {
                    results.add(msg);
                }
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "Node, " + nodeName + ", doesn't contain EJB 3.0");
                break;
            }
            if (results.contains(msg)) break;
            results.add(msg);
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ValidateAppExt.validate()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List getManagedNodes() throws Exception {
        List managedNodes;
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "ValidateAppExt.getManagedNodes()");
            }
            managedNodes = null;
            CommandMgr cmdMgr = CommandMgr.getCommandMgr();
            if (cmdMgr != null) {
                ConfigService configService = ConfigServiceFactory.getConfigService();
                Session session = new Session();
                try {
                    try {
                        AdminCommand cmd = cmdMgr.createCommand("listManagedNodes");
                        cmd.setConfigSession(session);
                        cmd.execute();
                        CommandResult res = cmd.getCommandResult();
                        if (!res.isSuccessful()) {
                            throw new Exception("failure during");
                        }
                        managedNodes = (List)res.getResult();
                    }
                    catch (Throwable th) {
                        Tr.error(tc, "Exception in method getManagedNodes: " + th.getMessage());
                        RasUtils.logException(th, tc, CLASS_NAME, "getManagedNodes", "321", this);
                        Object var8_9 = null;
                        configService.discard(session);
                        break block8;
                    }
                    Object var8_8 = null;
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    configService.discard(session);
                    throw throwable;
                }
                configService.discard(session);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ValidateAppExt.getManagedNodes()", managedNodes);
        }
        return managedNodes;
    }

    private void validateBLASharedLib(String nodeName, String clusterName, String appName, String workspaceID, Locale locale, List results) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateBLASharedLib", new Object[]{nodeName, clusterName, appName, workspaceID, locale, results});
        }
        RepositoryContext apc = AppUtils.findAppContextFromConfig(appName, ConfigRepoHelper.getWorkSpace(workspaceID), new Hashtable());
        ApplicationDeployment appD = ConfigRepoHelper.getAppDeploymentForApp(apc);
        EList mds = appD.getModules();
        boolean hasBLASharedLib = false;
        block0: for (int i = 0; !hasBLASharedLib && i < mds.size(); ++i) {
            ModuleDeployment md2 = (ModuleDeployment)mds.get(i);
            Classloader cl = md2.getClassloader();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "classloader for module " + md2.getUri() + ": " + cl);
            }
            if (cl == null) continue;
            EList libs = cl.getLibraries();
            for (int j = 0; libs != null && j < libs.size(); ++j) {
                LibraryRef libRef = (LibraryRef)libs.get(j);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "parsing library name " + libRef.getLibraryName());
                }
                if (libRef.getLibraryName().indexOf("assetnname=") == -1 && libRef.getLibraryName().indexOf("cuname=") == -1) continue;
                hasBLASharedLib = true;
                if (!tc.isDebugEnabled()) continue block0;
                Tr.debug(tc, "found BLA shared lib");
                continue block0;
            }
        }
        if (hasBLASharedLib) {
            ManagedObjectMetadataAccessor moma = ManagedObjectMetadataAccessorFactory.createAccessor(null);
            List managedNodes = this.getManagedNodes();
            for (String managedNode : managedNodes) {
                int nodeVersion;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "processing managedNode " + managedNode);
                }
                if (!managedNode.equals(nodeName)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "found a match");
                }
                if ((nodeVersion = Integer.parseInt(AppUtils.getNodeMajorVersion(null, nodeName))) != 7) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "not a 7.x node");
                    }
                    results.add(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA0201E", new String[]{nodeName, Integer.toString(nodeVersion)}));
                    if (!tc.isDebugEnabled()) break;
                    Tr.debug(tc, "results: " + results);
                    break;
                }
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "a 7.x node");
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateBLASharedLib");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/ws/management/application/exts/ValidateAppExt.java, WAS.admin.installapp, WAS70.SERV1, q0834.18, ver. 1.8");
        }
        CLASS_NAME = ValidateAppExt.class.getName();
    }
}

