/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.client.AppDeploymentController;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.application.client.AppDeploymentTaskHelper;
import com.ibm.websphere.management.application.client.ArchiveDeploymentInfo;
import com.ibm.websphere.management.application.client.WASDeploymentTask;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.appdeployment.ModuleDeployment;
import com.ibm.websphere.models.config.classloader.Classloader;
import com.ibm.websphere.models.config.classloader.LibraryRef;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.client.util;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.webapplication.WebApp;

public class SharedLibRelationshipHelper
implements AppDeploymentTaskHelper {
    private static TraceComponent tc = Tr.register(SharedLibRelationshipHelper.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String APPLICATION_DD = "META-INF/application.xml";
    private static final String[] cols = new String[]{"module", "uri", "relationship", "compUnitName", "matchTarget", "origRelationship"};
    static final int moduleColumn = 0;
    static final int urlColumn = 1;
    static final int relationshipColumn = 2;
    static final int cuNameColumn = 3;
    static final int matchTargetColumn = 4;
    static final int origRelationshipColumn = 5;
    private String[] taskValidateErrorMessages;

    public AppDeploymentTask createTask(AppDeploymentController appController, String taskName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTask");
        }
        try {
            if ((appController.getDeploymentMode() & 0x10L) != 0L) {
                return new WASDeploymentTask(appController, "SharedLibRelationship", cols, new boolean[]{false, false, false, false, false, false}, new boolean[]{false, false, true, true, true, false}, new boolean[]{false, false, false, true, false, true}, true);
            }
            return new WASDeploymentTask(appController, "SharedLibRelationship", cols, new boolean[]{false, false, false, false, false, false}, new boolean[]{false, false, true, true, true, false}, new boolean[]{false, false, false, false, false, true}, true);
        }
        catch (Exception ex) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error instantiating task" + ex);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createTask");
            }
            return null;
        }
    }

    public void prepareTask(AppDeploymentInfo appInstallInfo, AppDeploymentTask t) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepareTask");
        }
        if (t.getTaskData() != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "prepareTask: task data already set.");
            }
            return;
        }
        Vector<String> data = new Vector<String>();
        String[] colNames = t.getColumnNames();
        for (int i = 0; i < colNames.length; ++i) {
            data.addElement(colNames[i]);
        }
        Vector wars = appInstallInfo.getModuleConfig("WAR_DD");
        boolean process = t.getAppDeploymentController().getSelectedOptions().contains("processEmbeddedConfig");
        ApplicationDeployment appDepl = ((ArchiveDeploymentInfo)appInstallInfo).getAppDeploymentObject(process);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "appDepl: " + appDepl);
        }
        Hashtable modToLibTbl = (Hashtable)appInstallInfo.getAppOptions().get("sharedLibRelationship");
        if ((t.getAppDeploymentController().getDeploymentMode() & 0x10L) != 0L || (t.getAppDeploymentController().getDeploymentMode() & 0x1000L) != 0L || (t.getAppDeploymentController().getDeploymentMode() & 1L) != 0L) {
            this.addData(data, appInstallInfo, appDepl, modToLibTbl, appInstallInfo.getApplication());
        }
        for (int i = 0; i < wars.size(); ++i) {
            this.addData(data, appInstallInfo, appDepl, modToLibTbl, (WebApp)wars.elementAt(i));
        }
        t.setTaskData(util.buildTaskData(data, colNames.length));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepareTask");
        }
    }

    private void addData(Vector data, AppDeploymentInfo appInstallInfo, ApplicationDeployment appDepl, Hashtable modToLibTbl, EObject obj) throws AppDeploymentException {
        String uri;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addData", new Object[]{data, obj});
        }
        if (obj instanceof Application) {
            data.addElement(appInstallInfo.getAppDisplayName());
            uri = obj.eResource().getURI().toString();
        } else {
            data.addElement(util.getModuleName(appInstallInfo, obj));
            uri = util.formUriString(appInstallInfo, obj);
        }
        data.addElement(uri);
        String appOrModuleUri = uri;
        if (!(obj instanceof Application)) {
            appOrModuleUri = util.getModuleUriFromUriString(uri);
        }
        String libs = new String();
        libs = appDepl == null ? this.getSharedLib(appOrModuleUri, modToLibTbl) : this.getSharedLibFromAppDep(appDepl, appOrModuleUri, modToLibTbl);
        data.addElement(libs);
        data.addElement("");
        data.addElement("AppDeploymentOption.Yes");
        data.addElement(libs);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addData", new Object[]{data});
        }
    }

    private String getSharedLibFromAppDep(ApplicationDeployment appDepl, String uri, Hashtable modToLibTbl) {
        String slib;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSharedLibFromAppDep", new Object[]{appDepl, uri, modToLibTbl});
        }
        if ((slib = this.getSharedLib(uri, modToLibTbl)) == null || slib.length() == 0) {
            Classloader cl = null;
            if (APPLICATION_DD.equals(uri)) {
                cl = appDepl.getClassloader();
            } else {
                ModuleDeployment md2 = this.getMDFromModuleRef(appDepl, uri);
                if (md2 != null) {
                    cl = md2.getClassloader();
                }
            }
            if (cl != null) {
                slib = this.getLibColumn(cl);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSharedLibFromAppDep", new Object[]{slib});
        }
        return slib;
    }

    private ModuleDeployment getMDFromModuleRef(ApplicationDeployment appDepl, String uri) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMDFromModuleRef", new Object[]{appDepl, uri});
        }
        EList mlist = appDepl.getModules();
        ModuleDeployment retVal = null;
        for (int i = 0; i < mlist.size(); ++i) {
            ModuleDeployment md2 = (ModuleDeployment)mlist.get(i);
            if (!md2.getUri().equals(uri)) continue;
            retVal = md2;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMDFromModuleRef", new Object[]{retVal});
        }
        return retVal;
    }

    private String getLibColumn(Classloader cl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLibColumn");
        }
        String slib = "";
        if (cl != null) {
            EList libs = cl.getLibraries();
            for (int i = 0; i < libs.size(); ++i) {
                LibraryRef sref = (LibraryRef)libs.get(i);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "lib name: " + sref.getLibraryName());
                }
                if (sref.getLibraryName().indexOf("assetname=") == -1 && sref.getLibraryName().indexOf("cuname=") == -1) continue;
                if (!AppUtils.isEmpty(slib)) {
                    slib = slib + "+";
                }
                slib = slib + sref.getLibraryName();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLibColumn", new Object[]{slib});
        }
        return slib;
    }

    private String getSharedLib(String uri, Hashtable modToLibTbl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSharedLib", new Object[]{uri, modToLibTbl});
        }
        String libName = new String();
        if (modToLibTbl != null) {
            libName = (String)modToLibTbl.get(uri);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSharedLib", new Object[]{libName});
        }
        return libName;
    }

    public void completeTask(AppDeploymentInfo appInstallInfo, AppDeploymentTask t) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "completeTask");
        }
        if (!t.isTaskEmpty()) {
            String[][] data = t.getTaskData();
            Hashtable slibTbl = new Hashtable();
            String key = null;
            for (int indx = 1; indx < data.length; ++indx) {
                key = data[indx][1];
                String uri = util.getModuleUriFromUriString(key);
                if (uri == null) {
                    uri = key;
                }
                Hashtable<String, String> assetSharedLibInfo = new Hashtable<String, String>();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "uri: " + uri);
                }
                String relationship = data[indx][2];
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "relationshipColumn: 2");
                }
                assetSharedLibInfo.put("relationship", relationship);
                if (!AppUtils.isEmpty(data[indx][3])) {
                    assetSharedLibInfo.put("compUnitName", data[indx][3]);
                }
                assetSharedLibInfo.put("matchTarget", data[indx][4]);
                assetSharedLibInfo.put("origRelationship", data[indx][5]);
                slibTbl.put(uri, assetSharedLibInfo);
            }
            appInstallInfo.getAppOptions().put("sharedLibRelationship", slibTbl);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "sharedLibRelationship: " + appInstallInfo.getAppOptions().get("sharedLibRelationship"));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "completeTask");
        }
    }
}

