/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.client;

import com.ibm.ejs.models.base.bindings.commonbnd.CommonbndPackage;
import com.ibm.ejs.models.base.bindings.commonbnd.EjbRefBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.EJBJarBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.EnterpriseBeanBinding;
import com.ibm.ejs.models.base.bindings.webappbnd.WebAppBinding;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.client.AppDeploymentController;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.application.client.AppDeploymentTaskHelper;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.client.MapEJBRefToEJB;
import com.ibm.ws.management.application.client.util;
import com.ibm.ws.management.application.j2ee.deploy.spi.DConfigBeanImpl;
import com.ibm.ws.management.application.j2ee.deploy.spi.J2EEDeployUtil;
import com.ibm.ws.management.application.j2ee.deploy.spi.J2EEDeploymentHelper;
import java.lang.reflect.Constructor;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.enterprise.deploy.shared.ModuleType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jst.j2ee.common.EjbRef;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.webapplication.WebApp;

public class MapEJBRefToEJBHelper
implements AppDeploymentTaskHelper,
J2EEDeploymentHelper {
    private static TraceComponent tc = Tr.register(MapEJBRefToEJBHelper.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");

    public AppDeploymentTask createTask(AppDeploymentController appController, String taskName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTask");
        }
        try {
            String helperClass = this.getClass().getName();
            int index = helperClass.lastIndexOf("Helper");
            Class<?> taskClass = Class.forName(helperClass.substring(0, index));
            Constructor<?> constructor = taskClass.getDeclaredConstructor(AppDeploymentController.class);
            return (AppDeploymentTask)constructor.newInstance(appController);
        }
        catch (Exception ex) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error instantiating task" + ex);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createTask");
            }
            return null;
        }
    }

    public void prepareTask(AppDeploymentInfo appInstallInfo, AppDeploymentTask t) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepareTask");
        }
        if (t.getTaskData() != null) {
            return;
        }
        Vector<String> data = new Vector<String>();
        String[] colNames = t.getColumnNames();
        for (int i = 0; i < colNames.length; ++i) {
            data.addElement(colNames[i]);
        }
        this.prepareTaskForEJB(appInstallInfo, t, data);
        this.prepareTaskForWAR(appInstallInfo, t, data);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "data in ejb ref task: " + data);
        }
        t.setTaskData(util.buildTaskData(data, colNames.length));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepareTask");
        }
    }

    private void prepareTaskForEJB(AppDeploymentInfo appInstallInfo, AppDeploymentTask t, Vector data) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepareTaskForEJB");
        }
        Vector ejbJars = appInstallInfo.getModuleConfig("JAR_DD");
        Vector ejbJarBindings = appInstallInfo.getModuleConfig("JAR_BND");
        for (int i = 0; i < ejbJarBindings.size(); ++i) {
            EJBJarBinding ejbJarBinding = (EJBJarBinding)ejbJarBindings.elementAt(i);
            EJBJar jar = (EJBJar)ejbJars.elementAt(i);
            for (EnterpriseBean ejb : jar.getEnterpriseBeans()) {
                EnterpriseBeanBinding ejbBindings = ejbJarBinding.getEJBBinding(ejb);
                this.addTaskData(appInstallInfo, jar, ejb.getName(), ejb.getEjbRefs(), ejbBindings.getEjbRefBindings(), data, t);
                this.addTaskData(appInstallInfo, jar, ejb.getName(), ejb.getEjbLocalRefs(), ejbBindings.getEjbRefBindings(), data, t);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepareTaskForEJB");
        }
    }

    private void prepareTaskForWAR(AppDeploymentInfo appInstallInfo, AppDeploymentTask t, Vector data) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepareTaskForWAR");
        }
        Vector wars = appInstallInfo.getModuleConfig("WAR_DD");
        Vector warBindings = appInstallInfo.getModuleConfig("WAR_BND");
        for (int i = 0; i < warBindings.size(); ++i) {
            WebAppBinding warBinding = (WebAppBinding)warBindings.elementAt(i);
            WebApp war = (WebApp)wars.elementAt(i);
            this.addTaskData(appInstallInfo, war, "", war.getEjbRefs(), warBinding.getEjbRefBindings(), data, t);
            this.addTaskData(appInstallInfo, war, "", war.getEjbLocalRefs(), warBinding.getEjbRefBindings(), data, t);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepareTaskForEJB");
        }
    }

    private void addTaskData(AppDeploymentInfo appInstallInfo, EObject refObject, String ejbName, List refs, List ejbRefBnds, Vector data, AppDeploymentTask task) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addTaskData");
        }
        int numColumns = task.getColumnNames().length;
        for (EjbRef ref : refs) {
            Iterator l = ejbRefBnds.iterator();
            boolean found = false;
            EjbRefBinding erb = null;
            while (l.hasNext() && !found) {
                erb = (EjbRefBinding)l.next();
                if (erb.getBindingEjbRef() == null || !erb.getBindingEjbRef().equals(ref)) continue;
                found = true;
            }
            data.addElement(util.getModuleName(appInstallInfo, refObject));
            data.addElement(ejbName);
            data.addElement(util.formUriString(appInstallInfo, refObject));
            data.addElement(ref.getName());
            data.addElement(ref.getRemote());
            if (found) {
                data.addElement(erb.getJndiName());
            } else {
                data.addElement(null);
            }
            if (numColumns <= 6) continue;
            if (refObject instanceof EJBJar) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "module version is " + ((EJBJar)refObject).getVersionID());
                }
                data.addElement(Integer.toString(((EJBJar)refObject).getVersionID()));
                continue;
            }
            if (!(refObject instanceof WebApp)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "module version is " + ((WebApp)refObject).getVersionID());
            }
            data.addElement(Integer.toString(((WebApp)refObject).getVersionID()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addTaskData");
        }
    }

    public void completeTask(AppDeploymentInfo appInstallInfo, AppDeploymentTask t) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "completeTask");
        }
        if (!t.isTaskEmpty()) {
            this.completeTaskForEJB(appInstallInfo, t);
            this.completeTaskForWAR(appInstallInfo, t);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "completeTask");
        }
    }

    private void completeTaskForEJB(AppDeploymentInfo appInstallInfo, AppDeploymentTask t) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "completeTaskForEJB");
        }
        Vector ejbJars = appInstallInfo.getModuleConfig("JAR_DD");
        Vector ejbJarBindings = appInstallInfo.getModuleConfig("JAR_BND");
        for (int i = 0; i < ejbJarBindings.size(); ++i) {
            EJBJarBinding ejbJarBinding = (EJBJarBinding)ejbJarBindings.elementAt(i);
            EJBJar jar = (EJBJar)ejbJars.elementAt(i);
            for (EnterpriseBean ejb : jar.getEnterpriseBeans()) {
                EnterpriseBeanBinding ejbBindings = ejbJarBinding.getEJBBinding(ejb);
                Iterator k = ejb.getEjbRefs().iterator();
                while (k.hasNext()) {
                    this.updateEJBRefBinding(t, (EjbRef)k.next(), ejbBindings.getEjbRefBindings(), util.formUriString(appInstallInfo, jar), ejb.getName(), util.getModuleName(appInstallInfo, jar));
                }
                k = ejb.getEjbLocalRefs().iterator();
                while (k.hasNext()) {
                    this.updateEJBRefBinding(t, (EjbRef)k.next(), ejbBindings.getEjbRefBindings(), util.formUriString(appInstallInfo, jar), ejb.getName(), util.getModuleName(appInstallInfo, jar));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "completeTaskForEJB");
        }
    }

    private void completeTaskForWAR(AppDeploymentInfo appInstallInfo, AppDeploymentTask t) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "completeTaskForWAR");
        }
        Vector wars = appInstallInfo.getModuleConfig("WAR_DD");
        Vector warBindings = appInstallInfo.getModuleConfig("WAR_BND");
        for (int i = 0; i < warBindings.size(); ++i) {
            WebAppBinding warBinding = (WebAppBinding)warBindings.elementAt(i);
            WebApp war = (WebApp)wars.elementAt(i);
            Iterator k = war.getEjbRefs().iterator();
            while (k.hasNext()) {
                this.updateEJBRefBinding(t, (EjbRef)k.next(), warBinding.getEjbRefBindings(), util.formUriString(appInstallInfo, war), "", util.getModuleName(appInstallInfo, war));
            }
            k = war.getEjbLocalRefs().iterator();
            while (k.hasNext()) {
                this.updateEJBRefBinding(t, (EjbRef)k.next(), warBinding.getEjbRefBindings(), util.formUriString(appInstallInfo, war), "", util.getModuleName(appInstallInfo, war));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "completeTaskForWAR");
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private void updateEJBRefBinding(AppDeploymentTask t, EjbRef ref, List ejbRefBnds, String uri, String ejbName, String moduleName) throws AppDeploymentException {
        block33: {
            block32: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "updateEJBRefBinding");
                }
                String[] matchingTaskData = null;
                String[][] taskData = t.getTaskData();
                for (int j = 0; j < taskData.length; ++j) {
                    block31: {
                        block30: {
                            MapEJBRefToEJB cfr_ignored_0 = (MapEJBRefToEJB)t;
                            if (taskData[j].length <= 3) continue;
                            MapEJBRefToEJB cfr_ignored_1 = (MapEJBRefToEJB)t;
                            if (!ref.getName().equals(taskData[j][3])) continue;
                            MapEJBRefToEJB cfr_ignored_2 = (MapEJBRefToEJB)t;
                            if (!uri.equals(taskData[j][2])) continue;
                            if (ejbName == null) break block30;
                            MapEJBRefToEJB cfr_ignored_3 = (MapEJBRefToEJB)t;
                            if (ejbName.equals(taskData[j][1])) break block31;
                        }
                        if (ejbName != null) continue;
                        MapEJBRefToEJB cfr_ignored_4 = (MapEJBRefToEJB)t;
                        if (taskData[j][1] != null) {
                            MapEJBRefToEJB cfr_ignored_5 = (MapEJBRefToEJB)t;
                            if (!taskData[j][1].trim().equals("")) continue;
                        }
                    }
                    MapEJBRefToEJB cfr_ignored_6 = (MapEJBRefToEJB)t;
                    if (!moduleName.equals(taskData[j][0])) continue;
                    matchingTaskData = taskData[j];
                    break;
                }
                if (matchingTaskData == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "No matching task data for reference binding " + ref.getName() + " for module " + moduleName);
                    }
                    return;
                }
                Iterator l = ejbRefBnds.iterator();
                boolean found = false;
                EjbRefBinding erb = null;
                while (l.hasNext()) {
                    erb = (EjbRefBinding)l.next();
                    if (erb.getBindingEjbRef() == null || !erb.getBindingEjbRef().equals(ref)) continue;
                    found = true;
                    break;
                }
                if (tc.isDebugEnabled()) {
                    MapEJBRefToEJB cfr_ignored_7 = (MapEJBRefToEJB)t;
                    Tr.debug(tc, "matchingTaskData[jndiColumn]: " + (String)matchingTaskData[5] + "ending");
                }
                String jndi = null;
                if (matchingTaskData.length > 5) {
                    jndi = matchingTaskData[5];
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "found matching ejb ref binding: " + found);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "jndi: " + jndi);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "matchingTaskdata.length: " + matchingTaskData.length);
                }
                if (!found && !AppUtils.isEmpty(jndi) && matchingTaskData.length > 6) {
                    void uriColumn;
                    int moduleVersion = Integer.valueOf((String)matchingTaskData[6]);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "moduleVersion: " + moduleVersion);
                    }
                    if ((uriColumn = matchingTaskData[2]).matches(".*.jar.*") && moduleVersion >= 30 || uriColumn.matches(".*.war.*") && moduleVersion >= 24) {
                        erb = ((CommonbndPackage)EPackage.Registry.INSTANCE.getEPackage("commonbnd.xmi")).getCommonbndFactory().createEjbRefBinding();
                        erb.setBindingEjbRef(ref);
                        ejbRefBnds.add(erb);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "adding ejb ref binding for ee5 module");
                        }
                        found = true;
                    }
                }
                if (!found) break block32;
                MapEJBRefToEJB cfr_ignored_8 = (MapEJBRefToEJB)t;
                if (matchingTaskData.length <= 5) break block32;
                if (AppUtils.isEmpty(jndi)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "an empty or null jndi entry");
                    }
                    if (erb.getJndiName() != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "resetting value to blank");
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.debug(tc, "removing ejb ref for null jndi");
                        }
                        ejbRefBnds.remove(erb);
                    }
                    break block33;
                } else if (!jndi.equals(erb.getJndiName())) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "setting value to " + jndi);
                    }
                    erb.setJndiName(jndi);
                }
                break block33;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No matching reference binding " + ref.getName() + " for module " + moduleName);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateEJBRefBinding");
        }
    }

    public Hashtable getXPathInfo(Vector allTypes) {
        if (!allTypes.contains(ModuleType.EJB) && !allTypes.contains(ModuleType.WAR)) {
            return null;
        }
        Hashtable<String, Object> tbl = new Hashtable<String, Object>();
        tbl.put(ModuleType.WAR.toString(), "/web-app/ejb-ref/ejb-ref-name");
        Vector<String> v = new Vector<String>();
        v.addElement("/ejb-jar/enterprise-beans/entity");
        v.addElement("/ejb-jar/enterprise-beans/session");
        v.addElement("/ejb-jar/enterprise-beans/message-driven");
        tbl.put(ModuleType.EJB.toString(), v);
        return tbl;
    }

    public void taskData2DCBean(AppDeploymentTask task, DConfigBeanImpl dcImpl, String uri) {
        ModuleType type = dcImpl.getDDBean().getRoot().getDeployableObject().getType();
        if (type.equals(ModuleType.WAR)) {
            J2EEDeployUtil.task2DC(task, dcImpl, new String[]{uri, dcImpl.getDDBean().getText()}, new int[]{2, 3});
        } else if (type.equals(ModuleType.EJB)) {
            J2EEDeployUtil.ejbTask2DC(task, dcImpl, uri, "ejb-ref/ejb-ref-name", new int[]{2, 1, 3});
        }
    }

    public void dcBean2TaskData(AppDeploymentTask task, Hashtable keys, Hashtable props) {
        J2EEDeployUtil.dcBean2TaskData(task, keys, props);
    }
}

