/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.client;

import com.ibm.ejs.models.base.bindings.ejbbnd.EJBJarBinding;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.AppDeploymentUtil;
import com.ibm.websphere.management.application.client.AppDeploymentController;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.application.client.AppDeploymentTaskHelper;
import com.ibm.ws.management.application.PartialDeploymentInfo;
import com.ibm.ws.management.application.client.EnsureMethodProtectionFor20EJB;
import com.ibm.ws.management.application.client.util;
import java.lang.reflect.Constructor;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jem.java.Method;
import org.eclipse.jst.j2ee.common.CommonFactory;
import org.eclipse.jst.j2ee.common.CommonPackage;
import org.eclipse.jst.j2ee.common.SecurityRole;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EJBJarFile;
import org.eclipse.jst.j2ee.ejb.AssemblyDescriptor;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EjbFactory;
import org.eclipse.jst.j2ee.ejb.EjbPackage;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.ExcludeList;
import org.eclipse.jst.j2ee.ejb.MethodElement;
import org.eclipse.jst.j2ee.ejb.MethodPermission;
import org.eclipse.jst.j2ee.internal.common.XMLResource;

public class EnsureMethodProtectionFor20EJBHelper
implements AppDeploymentTaskHelper {
    private static TraceComponent tc = Tr.register(EnsureMethodProtectionFor20EJBHelper.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");

    public AppDeploymentTask createTask(AppDeploymentController appController, String taskName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTask");
        }
        try {
            String helperClass = this.getClass().getName();
            int index = helperClass.lastIndexOf("Helper");
            Class<?> taskClass = Class.forName(helperClass.substring(0, index));
            Constructor<?> constructor = taskClass.getDeclaredConstructor(AppDeploymentController.class);
            return (AppDeploymentTask)constructor.newInstance(appController);
        }
        catch (Exception ex) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error instantiating task" + ex);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createTask");
            }
            return null;
        }
    }

    public void prepareTask(AppDeploymentInfo appInstallInfo, AppDeploymentTask t) throws AppDeploymentException {
        int i;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepareTask");
        }
        if (t.getTaskData() != null) {
            return;
        }
        Vector ejbJars = appInstallInfo.getModuleConfig("JAR_DD");
        Vector ejbJarBindings = appInstallInfo.getModuleConfig("JAR_BND");
        Vector<String> data = new Vector<String>();
        String[] colNames = t.getColumnNames();
        for (i = 0; i < colNames.length; ++i) {
            data.addElement(colNames[i]);
        }
        if (appInstallInfo instanceof PartialDeploymentInfo) {
            t.setTaskData(util.buildTaskData(data, colNames.length));
            return;
        }
        for (i = 0; i < ejbJarBindings.size(); ++i) {
            EJBJar jar = (EJBJar)ejbJars.elementAt(i);
            if (((XMLResource)jar.eResource()).getVersionID() < 13) continue;
            boolean jarAdded = false;
            EJBJarFile jFile = (EJBJarFile)appInstallInfo.getModuleFileForDD(jar);
            if (AppDeploymentUtil.isEE5SchemaDD(jFile)) {
                if (!tc.isEntryEnabled()) continue;
                Tr.exit(tc, "performTask: Not applicable for EJB3 modules");
                continue;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "jar: " + jar);
            }
            EJBJarBinding ejbJarBinding = (EJBJarBinding)ejbJarBindings.elementAt(i);
            EList ejbBindings = ejbJarBinding.getEjbBindings();
            for (EnterpriseBean ejb : jar.getEnterpriseBeans()) {
                Hashtable allMethods = util.getMethods(t, jar, ejb, jFile);
                Vector localUnprotectedMethods = (Vector)allMethods.get("unprotectedMethod");
                if (localUnprotectedMethods.size() == 0 || jarAdded) continue;
                data.addElement(util.getModuleName(appInstallInfo, jar));
                data.addElement(util.formUriString(appInstallInfo, jar));
                data.addElement("methodProtection.uncheck");
                jarAdded = true;
            }
        }
        t.setTaskData(util.buildTaskData(data, colNames.length));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepareTask");
        }
    }

    private MethodPermission createPermission(AppDeploymentTask t, boolean unchecked, Vector roles) {
        EjbFactory factory = ((EjbPackage)EPackage.Registry.INSTANCE.getEPackage("ejb.xmi")).getEjbFactory();
        MethodPermission permission = factory.createMethodPermission();
        if (unchecked) {
            permission.setDescription(util.getMessage(t, "method.permission.unchecked.permission.description"));
            permission.setUnchecked(true);
        } else {
            permission.setDescription(util.getMessage(t, "method.permission.permission.description"));
            permission.setUnchecked(false);
            EList permissionRoles = permission.getRoles();
            int numRoles = roles.size();
            for (int roleNo = 0; roleNo < numRoles; ++roleNo) {
                SecurityRole nextRole = (SecurityRole)roles.elementAt(roleNo);
                permissionRoles.add(nextRole);
            }
        }
        return permission;
    }

    private MethodPermission locatePermission(AppDeploymentTask t, AssemblyDescriptor assemblyDescriptor, Vector permissions, boolean doUncheck, Vector roles) {
        MethodPermission locatedPermission = null;
        int numPermissions = permissions.size();
        for (int permissionNo = 0; locatedPermission == null && permissionNo < numPermissions; ++permissionNo) {
            MethodPermission nextPermission = (MethodPermission)permissions.elementAt(permissionNo);
            boolean nextIsUnchecked = nextPermission.isUnchecked();
            if ((!doUncheck || !nextIsUnchecked) && (doUncheck || !this.rolesMatch(nextPermission, roles))) continue;
            locatedPermission = nextPermission;
        }
        if (locatedPermission == null) {
            locatedPermission = this.createPermission(t, doUncheck, roles);
            util.addMethodPermission(assemblyDescriptor, locatedPermission);
            permissions.add(locatedPermission);
        }
        return locatedPermission;
    }

    private boolean rolesMatch(MethodPermission permission, Vector roles) {
        EList permissionRoles = permission.getRoles();
        int numRoles = roles.size();
        if (permissionRoles.size() != numRoles) {
            return false;
        }
        Iterator permissionRoleIterator = permissionRoles.iterator();
        boolean foundAll = true;
        while (foundAll && permissionRoleIterator.hasNext()) {
            SecurityRole soughtRole = (SecurityRole)permissionRoleIterator.next();
            foundAll = false;
            for (int roleNo = 0; !foundAll && roleNo < numRoles; ++roleNo) {
                SecurityRole candidateRole = (SecurityRole)roles.elementAt(roleNo);
                foundAll = soughtRole == candidateRole;
            }
        }
        return foundAll;
    }

    private void addExcludeMethod(AssemblyDescriptor assemblyDescriptor, AppDeploymentTask t, EnterpriseBean ejb, Method method2, int methodType) {
        MethodElement element = util.createElement(ejb, method2, methodType);
        this.ensureExcludeList(t, assemblyDescriptor).getMethodElements().add(element);
    }

    private ExcludeList ensureExcludeList(AppDeploymentTask t, AssemblyDescriptor assemblyDescriptor) {
        ExcludeList excludeList = assemblyDescriptor.getExcludeList();
        if (excludeList == null) {
            excludeList = this.createExcludeList(t, assemblyDescriptor);
        }
        return excludeList;
    }

    private ExcludeList createExcludeList(AppDeploymentTask t, AssemblyDescriptor assemblyDescriptor) {
        EjbFactory factory = ((EjbPackage)EPackage.Registry.INSTANCE.getEPackage("ejb.xmi")).getEjbFactory();
        ExcludeList excludeList = factory.createExcludeList();
        excludeList.setDescription(util.getMessage(t, "method.permission.exclude.list.description"));
        assemblyDescriptor.setExcludeList(excludeList);
        return excludeList;
    }

    private void assignSecurityRolesToMethod(AppDeploymentTask t, AppDeploymentInfo appInstallInfo, AssemblyDescriptor assemblyDescriptor, EnterpriseBean ejb, Vector assignedPermissions, Method method2, String securityRoleNames, int methodType) throws AppDeploymentException {
        Vector securityRoles = EnsureMethodProtectionFor20EJBHelper.findMatchingSecurityRoles(appInstallInfo, t, assemblyDescriptor, securityRoleNames);
        if (securityRoles.size() > 0) {
            util.addMethod(this.locatePermission(t, assemblyDescriptor, assignedPermissions, false, securityRoles), ejb, method2, methodType);
        }
    }

    public static Vector findMatchingSecurityRoles(AppDeploymentInfo appInstallInfo, AppDeploymentTask t, AssemblyDescriptor assemblyDescriptor, String securityRoleNames) throws AppDeploymentException {
        EList appSecurityRoles = null;
        EList securityRoles = assemblyDescriptor.getSecurityRoles();
        Iterator roleIterator = securityRoles.iterator();
        Vector<SecurityRole> roles = new Vector<SecurityRole>();
        StringTokenizer roleNameTokens = new StringTokenizer(securityRoleNames, ",");
        while (roleNameTokens.hasMoreTokens()) {
            String roleName = roleNameTokens.nextToken();
            boolean found = false;
            while (roleIterator.hasNext()) {
                SecurityRole nextRole = (SecurityRole)roleIterator.next();
                if (nextRole.getRoleName() == null || !nextRole.getRoleName().equals(roleName)) continue;
                roles.addElement(nextRole);
                found = true;
                break;
            }
            if (found) continue;
            if (appInstallInfo.getApplication() != null) {
                if (appSecurityRoles == null) {
                    appSecurityRoles = appInstallInfo.getApplication().getSecurityRoles();
                }
                for (int i = 0; i < appSecurityRoles.size() && !found; ++i) {
                    SecurityRole nextRole = (SecurityRole)appSecurityRoles.get(i);
                    if (nextRole.getRoleName() == null || !nextRole.getRoleName().equals(roleName)) continue;
                    roles.addElement(nextRole);
                    found = true;
                    CommonFactory factory = ((CommonPackage)EPackage.Registry.INSTANCE.getEPackage("common.xmi")).getCommonFactory();
                    SecurityRole role = factory.createSecurityRole();
                    role.setRoleName(nextRole.getRoleName());
                    role.setDescription(nextRole.getDescription());
                    securityRoles.add(role);
                }
            }
            if (found) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Not able to find matching security role for role name " + roleName);
            }
            throw new AppDeploymentException(MessageFormat.format(util.getMessage(t, "ADMA0031E"), roleName), null);
        }
        return roles;
    }

    public void completeTask(AppDeploymentInfo appInstallInfo, AppDeploymentTask t) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "completeTask");
        }
        if (appInstallInfo instanceof PartialDeploymentInfo) {
            return;
        }
        if (!t.isTaskEmpty()) {
            Hashtable<String, EJBJarBinding> uriForDD = new Hashtable<String, EJBJarBinding>();
            Vector ejbJarBindings = appInstallInfo.getModuleConfig("JAR_BND");
            for (int i = 0; i < ejbJarBindings.size(); ++i) {
                EJBJarBinding ejbJarBinding = (EJBJarBinding)ejbJarBindings.elementAt(i);
                EJBJar jar = ejbJarBinding.getEjbJar();
                if (jar == null || ((XMLResource)jar.eResource()).getVersionID() < 13) continue;
                uriForDD.put(util.formUriString(appInstallInfo, jar), ejbJarBinding);
            }
            String[][] taskData = t.getTaskData();
            for (int j = 0; j < taskData.length; ++j) {
                Method matchingUnprotectedMethod = null;
                Vector assignedPermissions = new Vector();
                EnsureMethodProtectionFor20EJB cfr_ignored_0 = (EnsureMethodProtectionFor20EJB)t;
                EJBJarBinding ejbJarBinding = (EJBJarBinding)uriForDD.get(taskData[j][1]);
                if (ejbJarBinding == null) {
                    if (!tc.isDebugEnabled()) continue;
                    EnsureMethodProtectionFor20EJB cfr_ignored_1 = (EnsureMethodProtectionFor20EJB)t;
                    Tr.debug(tc, "Not able to find binding for uri " + taskData[j][1]);
                    continue;
                }
                String[] matchingTaskData = taskData[j];
                EJBJar jar = ejbJarBinding.getEjbJar();
                EJBJarFile jFile = (EJBJarFile)appInstallInfo.getModuleFileForDD(jar);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "jar: " + jar);
                }
                EList ejbBindings = ejbJarBinding.getEjbBindings();
                for (EnterpriseBean ejb : jar.getEnterpriseBeans()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "ejb: " + ejb);
                    }
                    Hashtable allMethods = util.getMethods(t, jar, ejb, jFile);
                    Vector unprotectedMethods = (Vector)allMethods.get("unprotectedMethod");
                    for (int k = 0; k < unprotectedMethods.size(); ++k) {
                        Vector unprotectedMethod = (Vector)unprotectedMethods.elementAt(k);
                        if (unprotectedMethod.size() <= 0) continue;
                        matchingUnprotectedMethod = (Method)unprotectedMethod.elementAt(0);
                        int methodType = unprotectedMethod.size() > 1 ? (Integer)unprotectedMethod.elementAt(1) : 0;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "unprotected method: " + matchingUnprotectedMethod);
                        }
                        EnsureMethodProtectionFor20EJB cfr_ignored_2 = (EnsureMethodProtectionFor20EJB)t;
                        String protectionType = matchingTaskData[2];
                        if (protectionType == null) continue;
                        if (protectionType.equals("methodProtection.exclude")) {
                            this.addExcludeMethod(jar.getAssemblyDescriptor(), t, ejb, matchingUnprotectedMethod, methodType);
                            continue;
                        }
                        if (protectionType.equals("methodProtection.uncheck")) {
                            util.addMethod(this.locatePermission(t, jar.getAssemblyDescriptor(), assignedPermissions, true, null), ejb, matchingUnprotectedMethod, methodType);
                            continue;
                        }
                        this.assignSecurityRolesToMethod(t, appInstallInfo, jar.getAssemblyDescriptor(), ejb, assignedPermissions, matchingUnprotectedMethod, protectionType, methodType);
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "completeTask");
        }
    }
}

