/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.client.AppDeploymentController;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.application.client.AppDeploymentTaskHelper;
import com.ibm.ws.management.application.client.AppInstallHelper;
import com.ibm.ws.management.application.client.DefaultBinding;
import com.ibm.ws.management.application.client.util;
import com.ibm.ws.management.application.dfltbndngs.Preferences;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;

public class DefaultBindingHelper
implements AppDeploymentTaskHelper {
    private static TraceComponent tc = Tr.register(DefaultBindingHelper.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    Hashtable initPrefs = null;

    public DefaultBindingHelper() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DefaultBindingHelper");
        }
        this.initPrefs = new Hashtable();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DefaultBindingHelper");
        }
    }

    public DefaultBindingHelper(Hashtable tbl) {
        this();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DefaultBindingHelper");
        }
        if (tbl != null) {
            Enumeration keys = tbl.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                this.initPrefs.put(key, tbl.get(key));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DefaultBindingHelper");
        }
    }

    public AppDeploymentTask createTask(AppDeploymentController appController) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTask");
        }
        AppDeploymentTask t = this.createTask(appController, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createTask");
        }
        return t;
    }

    public AppDeploymentTask createTask(AppDeploymentController appController, String taskName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTask");
        }
        DefaultBinding db = new DefaultBinding(appController);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createTask");
        }
        return db;
    }

    public static Vector getDefaultBindingInfo(String earFile) throws AppDeploymentException {
        return DefaultBindingHelper.getDefaultBindingInfo(earFile, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector getDefaultBindingInfo(String earPath, Hashtable prefs) throws AppDeploymentException {
        Vector vector;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getDefaultBindingInfo");
            }
            AppDeploymentInfo info = null;
            try {
                info = AppInstallHelper.getAppDeploymentInfoGenericRead(earPath, null, prefs);
                Vector ret = DefaultBindingHelper.getDefaultBindingInfo(info);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getDefaultBindingInfo");
                }
                vector = ret;
                Object var6_5 = null;
                if (info == null) break block4;
            }
            catch (Throwable throwable) {
                block5: {
                    Object var6_6 = null;
                    if (info == null) break block5;
                    info.close(false);
                }
                throw throwable;
            }
            info.close(false);
        }
        return vector;
    }

    protected static Vector getDefaultBindingInfo(AppDeploymentInfo appInstallInfo) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefaultBindingInfo");
        }
        Vector<String> bindingInfo = new Vector<String>();
        Vector ejbs = appInstallInfo.getModuleConfig("JAR_DD");
        Vector ejbBindings = appInstallInfo.getModuleConfig("JAR_BND");
        for (int i = 0; !(i >= ejbs.size() || bindingInfo.contains("defaultbinding.datasource.jndi") && bindingInfo.contains("defaultbinding.cf.jndi") && bindingInfo.contains("defaultbinding.ejbjndi.prefix")); ++i) {
            EJBJar jar = (EJBJar)ejbs.elementAt(i);
            Iterator iterator = jar.getEnterpriseBeans().iterator();
            while (!(!iterator.hasNext() || bindingInfo.contains("defaultbinding.datasource.jndi") && bindingInfo.contains("defaultbinding.cf.jndi") && bindingInfo.contains("defaultbinding.ejbjndi.prefix"))) {
                EnterpriseBean ejb = (EnterpriseBean)iterator.next();
                if (!ejb.isMessageDriven() && !bindingInfo.contains("defaultbinding.ejbjndi.prefix")) {
                    bindingInfo.addElement("defaultbinding.ejbjndi.prefix");
                }
                if (ejb.getVersionID() == 11 && ejb.isContainerManagedEntity() && !bindingInfo.contains("defaultbinding.datasource.jndi")) {
                    bindingInfo.addElement("defaultbinding.datasource.jndi");
                    bindingInfo.addElement("defaultbinding.datasource.username");
                    bindingInfo.addElement("defaultbinding.datasource.password");
                }
                if (ejb.getVersionID() == 11 && !jar.isVersion2_0Descriptor() || !ejb.isContainerManagedEntity()) continue;
                if (!bindingInfo.contains("defaultbinding.datasource.jndi")) {
                    bindingInfo.addElement("defaultbinding.datasource.jndi");
                    bindingInfo.addElement("defaultbinding.datasource.username");
                    bindingInfo.addElement("defaultbinding.datasource.password");
                }
                if (bindingInfo.contains("defaultbinding.cf.jndi")) continue;
                bindingInfo.addElement("defaultbinding.cf.jndi");
                bindingInfo.addElement("defaultbinding.cf.resauth");
            }
        }
        if (appInstallInfo.getModuleConfig("WAR_BND").size() > 0) {
            bindingInfo.addElement("defaultbinding.virtual.host");
        }
        bindingInfo.addElement("defaultbinding.force");
        bindingInfo.addElement("defaultbinding.strategy.file");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDefaultBindingInfo");
        }
        return bindingInfo;
    }

    public void prepareTask(String assetId, String workspaceId, AppDeploymentTask t) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepareTask", new Object[]{assetId, workspaceId, t});
        }
        this.prepareTask(AppInstallHelper.getAssetPath(assetId, workspaceId), t);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepareTask");
        }
    }

    public void prepareTask(String earFile, AppDeploymentTask t) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepareTask");
        }
        AppDeploymentInfo info = AppInstallHelper.getAppDeploymentInfoGenericRead(earFile, null, this.initPrefs);
        this.prepareTask(info, t);
        info.close(false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepareTask");
        }
    }

    public void prepareTask(AppDeploymentInfo appInstallInfo, AppDeploymentTask t) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepareTask");
        }
        if (t.getTaskData() != null) {
            return;
        }
        Vector<String> data = new Vector<String>();
        Vector bindingInfo = null;
        if (appInstallInfo != null) {
            bindingInfo = DefaultBindingHelper.getDefaultBindingInfo(appInstallInfo);
        }
        String[] colNames = t.getColumnNames();
        for (int i = 0; i < colNames.length; ++i) {
            if (bindingInfo == null) {
                data.addElement(colNames[i]);
                continue;
            }
            if (!bindingInfo.contains(colNames[i])) continue;
            data.addElement(colNames[i]);
        }
        if (bindingInfo != null && bindingInfo.size() != colNames.length) {
            String[] resetColNames = new String[bindingInfo.size()];
            for (int i = 0; i < data.size(); ++i) {
                resetColNames[i] = (String)data.elementAt(i);
            }
            ((DefaultBinding)t).setColumnNames(resetColNames);
            colNames = resetColNames;
        }
        Preferences prefs = new Preferences();
        int columnSize = data.size();
        for (int i = 0; i < columnSize; ++i) {
            String val;
            if (colNames[i].equals("defaultbinding.datasource.jndi")) {
                val = (String)this.initPrefs.get("defaultbinding.datasource.jndi");
                if (val == null) {
                    val = prefs.getDefaultDataSourceJndiName();
                }
                data.addElement(val);
                continue;
            }
            if (colNames[i].equals("defaultbinding.datasource.username")) {
                val = (String)this.initPrefs.get("defaultbinding.datasource.username");
                if (val == null) {
                    val = prefs.getDefaultDataSourceUser();
                }
                data.addElement(val);
                continue;
            }
            if (colNames[i].equals("defaultbinding.datasource.password")) {
                val = (String)this.initPrefs.get("defaultbinding.datasource.password");
                if (val == null) {
                    val = prefs.getDefaultDataSourcePassword();
                }
                data.addElement(val);
                continue;
            }
            if (colNames[i].equals("defaultbinding.cf.jndi")) {
                val = (String)this.initPrefs.get("defaultbinding.cf.jndi");
                if (val == null) {
                    val = prefs.getDefaultConnectionFactoryJndiName();
                }
                data.addElement(val);
                continue;
            }
            if (colNames[i].equals("defaultbinding.cf.resauth")) {
                val = (String)this.initPrefs.get("defaultbinding.cf.resauth");
                if (val == null) {
                    val = Preferences.RES_AUTH[prefs.getDefaultConnectionFactoryResAuth()];
                }
                data.addElement(val);
                continue;
            }
            if (colNames[i].equals("defaultbinding.strategy.file")) {
                val = (String)this.initPrefs.get("defaultbinding.strategy.file");
                if (val == null) {
                    val = prefs.getStrategyFile();
                }
                data.addElement(val);
                continue;
            }
            if (colNames[i].equals("defaultbinding.virtual.host")) {
                val = (String)this.initPrefs.get("defaultbinding.virtual.host");
                if (val == null) {
                    val = prefs.getVirtualHost();
                }
                data.addElement(val);
                continue;
            }
            if (colNames[i].equals("defaultbinding.ejbjndi.prefix")) {
                val = (String)this.initPrefs.get("defaultbinding.ejbjndi.prefix");
                if (val == null) {
                    val = prefs.getEjbJndiPrefix();
                }
                data.addElement(val);
                continue;
            }
            if (!colNames[i].equals("defaultbinding.force")) continue;
            val = (String)this.initPrefs.get("defaultbinding.force");
            if (val == null) {
                val = prefs.getForceBindings() ? "AppDeploymentOption.Yes" : "AppDeploymentOption.No";
            }
            data.addElement(val);
        }
        t.setTaskData(util.buildTaskData(data, columnSize));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepareTask");
        }
    }

    public void completeTask(AppDeploymentInfo appInstallInfo, AppDeploymentTask t) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "completeTask");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "completeTask");
        }
    }

    public static Preferences getPreferences(DefaultBinding db) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPreferences");
        }
        Preferences p = new Preferences();
        String[][] data = db.getTaskData();
        int num = data[0].length;
        for (int i = 0; i < num; ++i) {
            if (data[0][i].equals("defaultbinding.datasource.jndi")) {
                p.setDefaultDataSourceJndiName(data[1][i]);
                continue;
            }
            if (data[0][i].equals("defaultbinding.datasource.username")) {
                p.setDefaultDataSourceUser(data[1][i]);
                continue;
            }
            if (data[0][i].equals("defaultbinding.datasource.password")) {
                p.setDefaultDataSourcePassword(data[1][i]);
                continue;
            }
            if (data[0][i].equals("defaultbinding.cf.jndi")) {
                p.setDefaultConnectionFactoryJndiName(data[1][i]);
                continue;
            }
            if (data[0][i].equals("defaultbinding.cf.resauth")) {
                p.setDefaultConnectionFactoryResAuth(data[1][i]);
                continue;
            }
            if (data[0][i].equals("defaultbinding.strategy.file")) {
                p.setStrategyFile(data[1][i]);
                continue;
            }
            if (data[0][i].equals("defaultbinding.virtual.host")) {
                p.setVirtualHost(data[1][i]);
                continue;
            }
            if (data[0][i].equals("defaultbinding.ejbjndi.prefix")) {
                p.setEjbJndiPrefix(data[1][i]);
                continue;
            }
            if (!data[0][i].equals("defaultbinding.force")) continue;
            p.setForceBindings(data[1][i].equals("AppDeploymentOption.Yes"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPreferences");
        }
        return p;
    }

    public static Preferences getPreferencesFromHashtable(Properties tbl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPreferences");
        }
        Preferences p = new Preferences();
        String val = tbl.getProperty("defaultbinding.datasource.jndi");
        if (val != null) {
            p.setDefaultDataSourceJndiName(val);
        }
        if ((val = tbl.getProperty("defaultbinding.datasource.username")) != null) {
            p.setDefaultDataSourceUser(val);
        }
        if ((val = tbl.getProperty("defaultbinding.datasource.password")) != null) {
            p.setDefaultDataSourcePassword(val);
        }
        if ((val = tbl.getProperty("defaultbinding.cf.jndi")) != null) {
            p.setDefaultConnectionFactoryJndiName(val);
        }
        if ((val = tbl.getProperty("defaultbinding.cf.resauth")) != null) {
            p.setDefaultConnectionFactoryResAuth(val);
        }
        if ((val = tbl.getProperty("defaultbinding.strategy.file")) != null) {
            p.setStrategyFile(val);
        }
        if ((val = tbl.getProperty("defaultbinding.virtual.host")) != null) {
            p.setVirtualHost(val);
        }
        if ((val = tbl.getProperty("defaultbinding.ejbjndi.prefix")) != null) {
            p.setEjbJndiPrefix(val);
        }
        boolean force = (val = tbl.getProperty("defaultbinding.force")) != null && (val.toUpperCase().equals("YES") || val.equals("AppDeploymentOption.Yes"));
        p.setForceBindings(force);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPreferences");
        }
        return p;
    }
}

