/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.client;

import com.ibm.ejs.models.base.bindings.applicationbnd.ApplicationbndFactory;
import com.ibm.ejs.models.base.bindings.applicationbnd.ApplicationbndPackage;
import com.ibm.ejs.models.base.bindings.applicationbnd.RunAsBinding;
import com.ibm.ejs.models.base.bindings.applicationbnd.RunAsMap;
import com.ibm.ejs.models.base.bindings.commonbnd.AbstractAuthData;
import com.ibm.ejs.models.base.bindings.commonbnd.BasicAuthData;
import com.ibm.ejs.models.base.bindings.commonbnd.CommonbndFactory;
import com.ibm.ejs.models.base.bindings.commonbnd.CommonbndPackage;
import com.ibm.ejs.models.base.extensions.ejbext.EJBJarExtension;
import com.ibm.ejs.models.base.extensions.ejbext.EjbextFactory;
import com.ibm.ejs.models.base.extensions.ejbext.EjbextPackage;
import com.ibm.ejs.models.base.extensions.ejbext.EnterpriseBeanExtension;
import com.ibm.ejs.models.base.extensions.ejbext.Identity;
import com.ibm.ejs.models.base.extensions.ejbext.RunAsMode;
import com.ibm.ejs.models.base.extensions.ejbext.RunAsSpecifiedIdentity;
import com.ibm.ejs.models.base.extensions.ejbext.SecurityIdentity;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.client.AppDeploymentController;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.application.client.AppDeploymentTaskHelper;
import com.ibm.ws.management.application.client.CorrectUseSystemIdentity;
import com.ibm.ws.management.application.client.util;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.common.CommonFactory;
import org.eclipse.jst.j2ee.common.CommonPackage;
import org.eclipse.jst.j2ee.common.SecurityRole;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.MethodElement;

public class CorrectUseSystemIdentityHelper
implements AppDeploymentTaskHelper {
    private static TraceComponent tc = Tr.register(CorrectUseSystemIdentityHelper.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");

    public AppDeploymentTask createTask(AppDeploymentController appController, String taskName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTask");
        }
        CorrectUseSystemIdentity si = new CorrectUseSystemIdentity(appController);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createTask");
        }
        return si;
    }

    public void prepareTask(AppDeploymentInfo appInstallInfo, AppDeploymentTask t) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepareTask");
        }
        Vector<String> data = new Vector<String>();
        String[] colNames = t.getColumnNames();
        for (int i = 0; i < colNames.length; ++i) {
            data.addElement(colNames[i]);
        }
        if (appInstallInfo.getApplication() == null) {
            t.setTaskData(util.buildTaskData(data, colNames.length));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "prepareTask");
            }
            return;
        }
        Vector ejbJars = appInstallInfo.getModuleConfig("JAR_DD");
        Vector ejbExtensions = appInstallInfo.getModuleConfig("JAR_EXT");
        for (int i = 0; i < ejbJars.size(); ++i) {
            EJBJar jar = (EJBJar)ejbJars.elementAt(i);
            if (((EJBJarExtension)ejbExtensions.elementAt(i)).getEjbExtensions().size() <= 0) continue;
            this.prepareTaskForEJB11(appInstallInfo, t, (EJBJarExtension)ejbExtensions.elementAt(i), data);
        }
        t.setTaskData(util.buildTaskData(data, colNames.length));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepareTaskForEJB");
        }
    }

    private void prepareTaskForEJB11(AppDeploymentInfo appInstallInfo, AppDeploymentTask t, EJBJarExtension jarExt, Vector data) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepareTaskForEJB11");
        }
        for (EnterpriseBeanExtension ejbext : jarExt.getEjbExtensions()) {
            EnterpriseBean ejb = ejbext.getEnterpriseBean();
            if (ejb == null || ejb.getEjbJar() == null) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "ejb is not set for ejb extension: " + ejbext + ", skipping this extension");
                continue;
            }
            for (SecurityIdentity si : ejbext.getRunAsSettings()) {
                RunAsMode mode = si.getRunAsMode();
                if (!mode.isSystemIdentity()) continue;
                Iterator methods = si.getMethodElements().iterator();
                if (methods.hasNext()) {
                    while (methods.hasNext()) {
                        MethodElement methodElement = (MethodElement)methods.next();
                        this.addData(appInstallInfo, ejb, methodElement.getSignature(), data);
                    }
                    continue;
                }
                this.addData(appInstallInfo, ejb, "", data);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepareTaskForEJB11");
        }
    }

    private void addData(AppDeploymentInfo appInstallInfo, EnterpriseBean ejb, String signature, Vector data) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addData");
        }
        data.addElement(ejb.getName());
        data.addElement(util.getModuleName(appInstallInfo, ejb.getEjbJar()));
        data.addElement(util.formUriString(appInstallInfo, ejb.getEjbJar()));
        data.addElement(signature);
        data.addElement("");
        data.addElement("");
        data.addElement("");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addData");
        }
    }

    private SecurityRole createSecurityRole(CorrectUseSystemIdentity task, String roleName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSecurityRole");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "role name: " + roleName);
        }
        CommonPackage commonPkg = (CommonPackage)EPackage.Registry.INSTANCE.getEPackage("common.xmi");
        CommonFactory commonFact = commonPkg.getCommonFactory();
        SecurityRole role = commonFact.createSecurityRole();
        role.setRoleName(roleName);
        role.setDescription(util.getMessage(task, "runAsSpecified.role.description"));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSecurityRole");
        }
        return role;
    }

    private SecurityRole getSecurityRole(AppDeploymentInfo appInstallInfo, CorrectUseSystemIdentity task, String roleName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSecurityRole");
        }
        SecurityRole secRole = null;
        Application dd = appInstallInfo.getApplication();
        if (dd != null) {
            if (!dd.containsSecurityRole(roleName)) {
                secRole = this.createSecurityRole(task, roleName);
                dd.getSecurityRoles().add(secRole);
            } else {
                secRole = dd.getSecurityRoleNamed(roleName);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSecurityRole");
        }
        return secRole;
    }

    private RunAsBinding getRunAsBindingForRole(AppDeploymentInfo appInstallInfo, CorrectUseSystemIdentity task, String[] taskData, SecurityRole secRole) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRunAsBindingForRole");
        }
        RunAsMap ram = appInstallInfo.getApplicationBindings().getRunAsMap();
        EList rabs = null;
        RunAsBinding rab = null;
        boolean found = false;
        if (ram != null) {
            rabs = ram.getRunAsBindings();
            Iterator rabsi = rabs.iterator();
            while (rabsi.hasNext() && !found) {
                rab = (RunAsBinding)rabsi.next();
                if (taskData.length <= 4) continue;
                if (!taskData[4].equals(rab.getSecurityRole().getRoleName())) continue;
                found = true;
            }
        }
        BasicAuthData authData = null;
        if (!found) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "create new runAsBinding for role: " + taskData[4]);
            }
            ApplicationbndPackage appbndPkg = (ApplicationbndPackage)EPackage.Registry.INSTANCE.getEPackage("applicationbnd.xmi");
            ApplicationbndFactory appbndfact = appbndPkg.getApplicationbndFactory();
            CommonbndPackage commonbndPkg = (CommonbndPackage)EPackage.Registry.INSTANCE.getEPackage("commonbnd.xmi");
            CommonbndFactory combndfact = commonbndPkg.getCommonbndFactory();
            if (ram == null) {
                ram = appbndfact.createRunAsMap();
                rabs = ram.getRunAsBindings();
                appInstallInfo.getApplicationBindings().setRunAsMap(ram);
            }
            rab = appbndfact.createRunAsBinding();
            rab.setSecurityRole(secRole);
            authData = combndfact.createBasicAuthData();
            rab.setAuthData(authData);
            rabs.add(rab);
        } else {
            AbstractAuthData aaData = rab.getAuthData();
            if (aaData instanceof BasicAuthData) {
                authData = (BasicAuthData)aaData;
            }
        }
        if (authData != null) {
            if (taskData.length > 5) {
                if (taskData[5] != null) {
                    if (!taskData[5].trim().equals("")) {
                        authData.setUserId(taskData[5]);
                        if (taskData.length > 6) {
                            if (taskData[6] != null) {
                                if (!taskData[6].trim().equals("")) {
                                    authData.setPassword(taskData[6]);
                                }
                            }
                        }
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRunAsBindingForRole");
        }
        return rab;
    }

    private void correctRunAsRole(AppDeploymentInfo appInstallInfo, CorrectUseSystemIdentity task, String[] taskData) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "correctRunAsRole");
        }
        Vector ejbJars = appInstallInfo.getModuleConfig("JAR_DD");
        Vector ejbExtensions = appInstallInfo.getModuleConfig("JAR_EXT");
        block0: for (int i = 0; i < ejbJars.size(); ++i) {
            EJBJar jar = (EJBJar)ejbJars.elementAt(i);
            if (!util.formUriString(appInstallInfo, jar).equals(taskData[2])) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "find matching ejb module: " + taskData[2]);
            }
            if (((EJBJarExtension)ejbExtensions.elementAt(i)).getEjbExtensions().size() <= 0) break;
            for (EnterpriseBeanExtension ejbext : ((EJBJarExtension)ejbExtensions.elementAt(i)).getEjbExtensions()) {
                if (taskData[0] == null || ejbext.getEnterpriseBean() == null) continue;
                if (!taskData[0].equals(ejbext.getEnterpriseBean().getName())) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "find matching ejb: " + taskData[0]);
                }
                this.fixIdentity(task, ejbext, taskData);
                break block0;
            }
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "correctRunAsRole");
        }
    }

    private void fixIdentity(CorrectUseSystemIdentity task, EnterpriseBeanExtension ejbext, String[] taskData) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fixIdentity");
        }
        Iterator runassettings = ejbext.getRunAsSettings().iterator();
        boolean found = false;
        while (runassettings.hasNext() && !found) {
            SecurityIdentity si = (SecurityIdentity)runassettings.next();
            RunAsMode mode = si.getRunAsMode();
            if (!mode.isSystemIdentity()) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "find UseSystemIdentity, security identity: " + si);
            }
            if (taskData.length > 3) {
                if (taskData[3] != null) {
                    if (!taskData[3].trim().equals("")) {
                        found = this.fixIdentityForMethod(task, taskData, si);
                        continue;
                    }
                }
            }
            if (si.getMethodElements().iterator().hasNext()) continue;
            if (taskData.length <= 3) continue;
            found = true;
            this.fixIdentityToRunAsSpecified(task, taskData, si);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fixIdentity");
        }
    }

    private boolean fixIdentityForMethod(CorrectUseSystemIdentity task, String[] taskData, SecurityIdentity si) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fixIdentityForMethod");
        }
        boolean found = false;
        Iterator methods = si.getMethodElements().iterator();
        while (methods.hasNext() && !found) {
            MethodElement methodE = (MethodElement)methods.next();
            if (methodE.getSignature() == null) continue;
            if (!methodE.getSignature().equals(taskData[3])) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "find matching method, signature: " + methodE.getSignature());
            }
            this.fixIdentityToRunAsSpecified(task, taskData, si);
            found = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fixIdentityForMethod");
        }
        return found;
    }

    private void fixIdentityToRunAsSpecified(CorrectUseSystemIdentity task, String[] taskData, SecurityIdentity si) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fixIdentityToRunAsSpecified");
        }
        EjbextPackage ejbextPkg = (EjbextPackage)EPackage.Registry.INSTANCE.getEPackage("ejbext.xmi");
        EjbextFactory ejbextFact = ejbextPkg.getEjbextFactory();
        RunAsSpecifiedIdentity addIdentity = ejbextFact.createRunAsSpecifiedIdentity();
        Identity id = ejbextFact.createIdentity();
        id.setRoleName(taskData[4]);
        id.setDescription(util.getMessage(task, "runAsSpecified.identity.description"));
        addIdentity.setRunAsSpecifiedIdentity(id);
        si.setRunAsMode(addIdentity);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fixIdentityToRunAsSpecified");
        }
    }

    public void completeTask(AppDeploymentInfo appInstallInfo, AppDeploymentTask t) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "completeTask");
        }
        if (!t.isTaskEmpty()) {
            CorrectUseSystemIdentity task = (CorrectUseSystemIdentity)t;
            Object matchingTaskData = null;
            String[][] taskData = t.getTaskData();
            for (int j = 1; j < taskData.length; ++j) {
                String roleName = null;
                if (taskData[j].length > 4) {
                    roleName = taskData[j][4];
                }
                if (roleName == null || roleName.trim().equals("")) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "No role name specified, skipping task data: " + j + ", data: " + taskData[j]);
                    continue;
                }
                SecurityRole secRole = this.getSecurityRole(appInstallInfo, task, roleName);
                RunAsBinding rab = this.getRunAsBindingForRole(appInstallInfo, task, taskData[j], secRole);
                this.correctRunAsRole(appInstallInfo, task, taskData[j]);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "completeTask");
        }
    }
}

