/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.websphere.management.application.AppNotification;
import com.ibm.websphere.management.application.EditionHelper;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.ws.management.application.AppManagementImpl;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.management.util.RasUtils;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Properties;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;

public class RedeploymentManager
implements AppNotification.Listener,
NotificationListener {
    private static TraceComponent tc = Tr.register(RedeploymentManager.class, null, "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String CLASS_NAME;
    String earPath;
    String appName;
    Hashtable properties;
    String workspaceID;
    String origWID;
    WorkSpace ws = null;
    AppNotification.Listener localListener;
    AppManagementImpl appM;
    Object handback = null;
    boolean isLocal;
    public static final String APPDEPL_RUNTIME_PROPS_SAVED = "runtime.props.saved";

    public RedeploymentManager(String earP, String appN, Hashtable props, String wID, AppNotification.Listener notf, boolean isL, AppManagement man) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "RedeploymentManager: " + appN);
        }
        this.earPath = earP;
        this.appName = appN;
        this.properties = props;
        if (this.properties == null) {
            this.properties = new Hashtable();
        }
        this.properties.put("contenttype", "app");
        this.appM = (AppManagementImpl)man;
        this.workspaceID = wID;
        this.origWID = wID;
        if (this.workspaceID == null) {
            this.workspaceID = Long.toHexString(System.currentTimeMillis());
        }
        this.localListener = notf;
        this.isLocal = isL;
        if (!this.isLocal) {
            this.handback = Long.toHexString(System.currentTimeMillis());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "RedeploymentManager: " + appN);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void performTask() throws AdminException {
        try {
            block34: {
                RepositoryContext appC;
                block32: {
                    if (tc.isEntryEnabled()) {
                        Tr.entry(tc, "performTask");
                    }
                    this.ws = ConfigRepoHelper.getWorkSpace(this.workspaceID);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Workspace: " + this.workspaceID);
                    }
                    appC = null;
                    try {
                        appC = AppUtils.findAppContextFromConfig(this.appName, this.ws, this.properties);
                        if (appC != null) {
                            ApplicationDeployment appDepl = ConfigRepoHelper.getAppDeploymentForApp(appC);
                            this.properties.put("AppDeplObj", appDepl);
                            if (appDepl.isZeroBinaryCopy() && this.properties.get("zeroBinaryCopy") == null) {
                                this.properties.put("zeroBinaryCopy", Boolean.TRUE);
                            }
                            if (appDepl.isZeroEarCopy() && this.properties.get("zeroEarCopy") == null) {
                                this.properties.put("zeroEarCopy", Boolean.TRUE);
                            }
                        }
                    }
                    catch (Throwable th) {
                        RasUtils.logException(th, tc, CLASS_NAME, "doCleanup", "129", this);
                        if (!tc.isDebugEnabled()) break block32;
                        Tr.debug(tc, "Error in loading old deployment.xml : " + th);
                    }
                }
                if (appC != null) {
                    InputStream is;
                    block33: {
                        is = null;
                        if (appC.getFile("META-INF/ibm-application-runtime.props") == null) break block33;
                        is = appC.getInputStream("META-INF/ibm-application-runtime.props");
                        Properties props = new Properties();
                        props.load(is);
                        this.properties.put(APPDEPL_RUNTIME_PROPS_SAVED, props);
                    }
                    Object var5_7 = null;
                    try {
                        if (is != null) {
                            is.close();
                        }
                        break block34;
                    }
                    catch (IOException ioex) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "error closing is: " + ioex);
                        }
                        break block34;
                    }
                    {
                        catch (Throwable th) {
                            RasUtils.logException(th, tc, CLASS_NAME, "doCleanup", "146", this);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Error in loading old act plan: " + th);
                            }
                            Object var5_8 = null;
                            try {
                                if (is != null) {
                                    is.close();
                                }
                                break block34;
                            }
                            catch (IOException ioex) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "error closing is: " + ioex);
                                }
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        block35: {
                            Object var5_9 = null;
                            try {
                                if (is != null) {
                                    is.close();
                                }
                            }
                            catch (IOException ioex) {
                                if (!tc.isDebugEnabled()) break block35;
                                Tr.debug(tc, "error closing is: " + ioex);
                            }
                        }
                        throw throwable;
                    }
                }
            }
            if (!this.isLocal) {
                NotificationFilterSupport filter = new NotificationFilterSupport();
                filter.enableType("websphere.admin.appmgmt");
                AdminServiceFactory.getAdminService().addNotificationListener(this.appM.getObjectName(), this, (NotificationFilter)filter, this.handback);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Added listener for JMX");
                }
            }
            if (this.isLocal) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Calling local uninstall");
                }
                this.appM.uninstallApplicationLocal(this.appName, this.properties, this, this.workspaceID);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Calling JMX uninstall");
                }
                this.appM.uninstallApplication(this.appName, this.properties, this.workspaceID);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "performTask");
            }
        }
        catch (Throwable th) {
            if (th instanceof AdminException) {
                throw (AdminException)th;
            }
            throw new AdminException(th, "");
        }
    }

    public void appEventReceived(AppNotification ev) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "appEventReceived: " + ev);
        }
        if (ev.taskName.equals("UninstallApplication")) {
            if (ev.taskStatus.equals("Completed")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Uninstall ended .. start install..");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "the appname from event is " + ev.props.get("appname"));
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "the appname from class is " + this.appName);
                }
                if (ev.props.get("appname").equals(this.appName)) {
                    try {
                        if (EditionHelper.isEditionSupportEnabled()) {
                            String[] names = EditionHelper.getAppAndEdition(this.appName);
                            if (!AppUtils.isEmpty(names[1])) {
                                this.properties.put("edition", names[1]);
                            }
                            this.appName = names[0];
                        }
                        if (this.isLocal) {
                            this.appM.installApplicationLocal(this.earPath, this.appName, this.properties, this, this.workspaceID);
                        } else {
                            this.appM.installApplication(this.earPath, this.appName, this.properties, this.workspaceID);
                        }
                    }
                    catch (AdminException ex) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception in invoking install: " + ex);
                        }
                        this.doCleanup(ev);
                    }
                }
            }
            if (ev.taskStatus.equals("Failed")) {
                this.doCleanup(ev);
            }
        } else if (ev.taskName.equals("InstallApplication") && (ev.taskStatus.equals("Completed") || ev.taskStatus.equals("Failed"))) {
            this.doCleanup(ev);
        }
        if (this.isLocal && this.localListener != null) {
            this.localListener.appEventReceived(ev);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "appEventReceived");
        }
    }

    public void handleNotification(Notification notf, Object hback) {
        if (hback == null || !hback.equals(this.handback)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "not my event: " + hback + ", handback=" + this.handback);
            }
            return;
        }
        Object ud = notf.getUserData();
        if (ud instanceof AppNotification) {
            this.appEventReceived((AppNotification)ud);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "unknown ud: " + ud);
        }
    }

    public void doCleanup(AppNotification ev) {
        block9: {
            block8: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "doCleanup");
                }
                try {
                    if (!this.isLocal) {
                        AdminServiceFactory.getAdminService().removeNotificationListener(this.appM.getObjectName(), this);
                    }
                }
                catch (Exception ex) {
                    if (!tc.isDebugEnabled()) break block8;
                    Tr.debug(tc, "!!!Error removing the listener: " + this);
                }
            }
            if (this.origWID == null) {
                try {
                    ConfigRepoHelper.removeWorkSpace(ev.taskStatus.equals("Completed") && ev.taskName.equals("InstallApplication"), this.ws);
                }
                catch (Throwable th) {
                    RasUtils.logException(th, tc, CLASS_NAME, "doCleanup", "306", this);
                    if (!tc.isDebugEnabled()) break block9;
                    Tr.debug(tc, "Error in removing workspace: " + th);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doCleanup");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/ws/management/application/RedeploymentManager.java, WAS.admin.installapp, WAS70.SERV1, q0834.18, ver. 1.12");
        }
        CLASS_NAME = RedeploymentManager.class.getName();
    }
}

