/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.logging.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.buffermgmt.impl.WsByteBufferPoolManagerImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.genericbnf.impl.GenericUtils;
import com.ibm.ws.http.channel.impl.HttpDateFormat;
import com.ibm.ws.http.logging.AccessLog;
import com.ibm.ws.http.logging.impl.LoggerOffThread;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.http.channel.HttpChannelUtils;
import com.ibm.wsspi.http.channel.HttpRequestMessage;
import com.ibm.wsspi.http.channel.HttpResponseMessage;
import com.ibm.wsspi.http.channel.values.HttpHeaderKeys;
import java.io.FileNotFoundException;

public class AccessLogger
extends LoggerOffThread
implements AccessLog {
    private static final TraceComponent tc = Tr.register(AccessLogger.class, "HTTPChannel", "com.ibm.ws.http.channel.resources.httpchannelmessages");
    private AccessLog.Format myFormat = AccessLog.Format.COMMON;

    public AccessLogger(String filename) throws FileNotFoundException {
        super(filename);
    }

    public AccessLog.Format getFormat() {
        return this.myFormat;
    }

    public void setFormat(AccessLog.Format format) {
        this.myFormat = format;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Set access format to " + (Object)((Object)format));
        }
    }

    public void log(HttpRequestMessage request, HttpResponseMessage response, String version, String userId, String remoteAddr, long numBytes) {
        block16: {
            if (!this.isStarted()) {
                return;
            }
            try {
                StringBuilder sb = new StringBuilder(128);
                sb.append(remoteAddr);
                if (null == userId) {
                    sb.append(" - - [");
                } else {
                    sb.append(" - ");
                    sb.append(userId);
                    sb.append(" [");
                }
                sb.append(HttpDateFormat.getRef().getNCSATime());
                sb.append("] \"");
                sb.append(request.getMethodValue().getName());
                sb.append(' ');
                sb.append(request.getRequestURI());
                String query = request.getQueryString();
                if (null != query) {
                    sb.append('?');
                    sb.append(GenericUtils.nullOutPasswords(query, (byte)38));
                }
                sb.append(' ');
                sb.append(version);
                sb.append("\" ");
                sb.append(response.getStatusCodeAsInt());
                sb.append(' ');
                if (-1 != response.getContentLength()) {
                    sb.append(response.getContentLength());
                } else {
                    sb.append(numBytes);
                }
                if (AccessLog.Format.COMBINED.equals((Object)this.getFormat())) {
                    String val = request.getHeaderAsString(HttpHeaderKeys.HDR_REFERER);
                    if (null == val) {
                        sb.append(" -");
                    } else {
                        sb.append(" \"");
                        sb.append(val);
                        sb.append("\"");
                    }
                    val = request.getHeaderAsString(HttpHeaderKeys.HDR_USER_AGENT);
                    if (null == val) {
                        sb.append(" -");
                    } else {
                        sb.append(" \"");
                        sb.append(val);
                        sb.append('\"');
                    }
                    int count = request.getNumberOfHeaderInstances(HttpHeaderKeys.HDR_COOKIE);
                    if (0 == count) {
                        sb.append(" -");
                    } else {
                        sb.append(" \"");
                        sb.append(request.getHeaderAsString(HttpHeaderKeys.HDR_COOKIE, 0));
                        for (int i = 1; i < count; ++i) {
                            sb.append(", ");
                            sb.append(request.getHeaderAsString(HttpHeaderKeys.HDR_COOKIE, i));
                        }
                        sb.append('\"');
                    }
                }
                sb.append("\r\n");
                WsByteBuffer wsbb = WsByteBufferPoolManagerImpl.getRef().allocate(sb.length());
                wsbb.put(HttpChannelUtils.getBytes(sb));
                wsbb.flip();
                super.log(wsbb);
            }
            catch (Throwable t) {
                FFDCFilter.processException(t, this.getClass().getName() + ".log", "136", this);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block16;
                Tr.event(tc, "Exception while writing log msg; " + t);
            }
        }
    }

    public void log(byte[] message) {
        block3: {
            if (!this.isStarted()) {
                return;
            }
            try {
                WsByteBuffer wsbb = WsByteBufferPoolManagerImpl.getRef().allocate(message.length + 2);
                wsbb.put(message);
                wsbb.flip();
                super.log(wsbb);
            }
            catch (Throwable t) {
                FFDCFilter.processException(t, this.getClass().getName() + ".log", "156", this);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block3;
                Tr.event(tc, "Error writing to log; " + t);
            }
        }
    }

    public void log(String message) {
        if (this.isStarted()) {
            this.log(GenericUtils.getEnglishBytes(message));
        }
    }

    public String toString() {
        return super.toString() + "\n  NCSA Format: " + (Object)((Object)this.getFormat());
    }
}

