/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.genericbnf.impl;

import com.ibm.ws.genericbnf.impl.BinaryHeaderNode;
import com.ibm.ws.genericbnf.impl.GenericConstants;
import com.ibm.ws.genericbnf.impl.QuickCaseInsensitiveMatcher;
import com.ibm.wsspi.genericbnf.HeaderKeys;

public class QuickHeaderMatcher
extends QuickCaseInsensitiveMatcher {
    private static final boolean MAKE_LOWER = true;
    private BinaryHeaderNode dollarNode = new BinaryHeaderNode('$', true);
    private BinaryHeaderNode underscoreNode = new BinaryHeaderNode('_', true);

    public QuickHeaderMatcher() {
        super(true);
    }

    public void init() {
        super.init();
        this.dollarNode.init();
        this.underscoreNode.init();
    }

    protected BinaryHeaderNode getNode(int c, boolean createNew) {
        BinaryHeaderNode node = super.getNode(c, createNew);
        if (null == node) {
            if (36 == c) {
                node = this.dollarNode;
            } else if (95 == c) {
                node = this.underscoreNode;
            }
        }
        return node;
    }

    public HeaderKeys matchHeader(String headerKey) {
        HeaderKeys key = (HeaderKeys)this.match(headerKey);
        if (null == key) {
            int size = headerKey.length();
            for (int i = 0; i < size; ++i) {
                char c = headerKey.charAt(i);
                if ('\r' != c && '\n' != c) continue;
                throw new IllegalArgumentException("Invalid CRLF in name: " + i);
            }
            return GenericConstants.NO_MATCH;
        }
        return key;
    }

    public HeaderKeys matchHeader(StringBuffer headerKey) {
        HeaderKeys key = (HeaderKeys)this.match(headerKey);
        if (null == key) {
            int size = headerKey.length();
            for (int i = 0; i < size; ++i) {
                char c = headerKey.charAt(i);
                if ('\r' != c && '\n' != c) continue;
                throw new IllegalArgumentException("Invalid CRLF in name: " + i);
            }
            return GenericConstants.NO_MATCH;
        }
        return key;
    }

    public HeaderKeys matchHeader(byte[] headerKey) {
        HeaderKeys key = (HeaderKeys)this.match(headerKey);
        if (null == key) {
            int size = headerKey.length;
            for (int i = 0; i < size; ++i) {
                byte c = headerKey[i];
                if (13 != c && 10 != c) continue;
                throw new IllegalArgumentException("Invalid CRLF in name: " + i);
            }
            return GenericConstants.NO_MATCH;
        }
        return key;
    }
}

