/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ffdc.impl;

import com.ibm.ws.ffdc.impl.FFDCHelper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class Configure {
    public static final int NO_PROCESSING = 0;
    public static final int EXCEPTION_PATH_ONLY = 1;
    public static final int CALL_STACK_DUMP = 2;
    public static final int DIAGNOSE_CURRENT_LEVEL = 3;
    public static final int DIAGNOSE_USE_DM_CURRENT_LEVEL = 4;
    public static final int DIAGNOSE_CURRENT_TO_TOP = 5;
    public static final int DIAGNOSE_ENTIRE_STACK = 6;
    public static final int ADVANCED_PROCESSING = 7;
    private static final String LEVEL = "Level";
    private static final String INCLUDE = "IncludeList";
    private static final String EXCLUDE = "ExcludeList";
    private static final String NUMBERTODUMP = "TimesToDump";
    private static final String TIMEBETWEEN = "TimeBetween";
    private static final String FFDC = "FFDC";
    private static final String LAE = "LAE";
    private static final String INCIDENTSTREAMPOOLSIZE = "IncidentStreamPoolSize";
    private static final String INTROSPECTDEPTH = "IntrospectDepth";
    private static final String INTROSPECTSIZE = "IntrospectMaxSize";
    private static final String INTROSPECTOBJECTSIZE = "IntrospectMaxObjectSize";
    private static final String INTROSPECTARRAYSIZE = "IntrospectMaxArraySize";
    private static final String EXCEPTIONFILESIZE = "ExceptionFileSize";
    private static final String EXCEPTIONFILEBACKUP = "ExceptionBackUpFiles";
    private static final String REFRESHINTERVAL = "RefreshInterval";
    private static final String ALLOWDEBUG = "Debug";
    private static final String EXCEPTIONFILEMAXIMUMAGE = "ExceptionFileMaximumAge";
    private static final String DAYSBETWEENEXCEPTIONFILESCLEANUP = "DaysBetweenExceptionFilesCleanup";
    private static final String TIMEOFTHEDAYFORCLEANUP = "TimeOfTheDayForCleanup";
    public boolean theSwitch = false;
    public int processLevel = 1;
    public boolean useLogAnalysisEngine = false;
    public String[] inclusionList = null;
    public String[] exclusionList = null;
    public long timeBetweenProcessing = 0L;
    public int numberOfTimesToProcess = 1;
    public int incidentStreamPoolSize = 30;
    public int introspectDepth = 1;
    public int introspectMaxSize = 1024;
    public int introspectMaxObjectSize = 1024;
    public int introspectMaxArraySize = 512;
    public int exceptionFileSize = 1024;
    public int exceptionFileBackup = 1;
    public int refreshInterval = 0;
    public boolean debugMode = false;
    public long exceptionFileMaximumAge = 604800000L;
    public int daysBetweenExceptionFilesCleanup = 1;
    public long timeOfTheDayForCleanup = -1L;
    public String propertyFile = null;
    public int currentState = 0;
    private static String serverName = null;

    public static Configure newConfiguration(int serverState) {
        boolean completedConfig = false;
        Configure config = new Configure();
        completedConfig = config.processPropertyFile(serverState);
        if (!completedConfig) {
            config = null;
        }
        return config;
    }

    private static boolean convertBoolean(String inBoolean, boolean defaultValue) {
        if (inBoolean == null) {
            return defaultValue;
        }
        if (inBoolean.equalsIgnoreCase("true")) {
            return true;
        }
        if (inBoolean.equalsIgnoreCase("false")) {
            return false;
        }
        return defaultValue;
    }

    private static int convertInt(String inInt, int defaultValue) {
        int integerValue = defaultValue;
        if (inInt == null) {
            return defaultValue;
        }
        try {
            integerValue = Integer.parseInt(inInt);
        }
        catch (NumberFormatException nfe) {
            integerValue = defaultValue;
        }
        return integerValue;
    }

    private static int convertInt(String inInt, int defaultValue, int minValue) {
        int returnVal = 0;
        returnVal = Configure.convertInt(inInt, defaultValue);
        if (returnVal < minValue) {
            returnVal = defaultValue;
        }
        return returnVal;
    }

    private boolean processPropertyFile(int serverState) {
        String[] propertyFileName = new String[]{"", "ffdcStart.properties", "ffdcRun.properties", "ffdcStop.properties"};
        Properties properties = null;
        String level = null;
        String includeString = null;
        String excludeString = null;
        String LAEValue = null;
        String ffdcSwitch = null;
        String numberToDump = null;
        String timeToDump = null;
        String incidentStream = null;
        String introspectMSize = null;
        String introspectMObjectSize = null;
        String introspectMArraySize = null;
        String introspectMDepth = null;
        String exFileSize = null;
        String exFileBackup = null;
        String debugString = null;
        String refresh = null;
        String maxFileAge = null;
        String daysBetweenCleanups = null;
        String timeForCleanup = null;
        InputStream inputStream = null;
        if (serverState < 1 || serverState > 3) {
            serverState = 1;
        }
        if (serverName == null) {
            serverName = FFDCHelper.getServerName();
        }
        this.currentState = serverState;
        try {
            properties = new Properties();
            this.propertyFile = serverName + '_' + propertyFileName[serverState];
            inputStream = FFDCHelper.getResourceAsStream(this.propertyFile);
            if (inputStream == null) {
                this.propertyFile = propertyFileName[serverState];
                inputStream = FFDCHelper.getResourceAsStream(this.propertyFile);
            }
            properties.load(inputStream);
            inputStream.close();
        }
        catch (IOException io) {
            this.propertyFile = this.propertyFile + " (Default values)";
        }
        catch (Throwable th) {
            this.propertyFile = this.propertyFile + " (Default values)";
        }
        try {
            level = properties.getProperty(LEVEL);
            this.processLevel = Configure.convertInt(level, 0);
            includeString = properties.getProperty(INCLUDE);
            this.inclusionList = FFDCHelper.split(includeString, 124);
            excludeString = properties.getProperty(EXCLUDE);
            this.exclusionList = FFDCHelper.split(excludeString, 124);
            LAEValue = properties.getProperty(LAE);
            this.useLogAnalysisEngine = Configure.convertBoolean(LAEValue, false);
            ffdcSwitch = properties.getProperty(FFDC);
            this.theSwitch = Configure.convertBoolean(ffdcSwitch, false);
            numberToDump = properties.getProperty(NUMBERTODUMP);
            this.numberOfTimesToProcess = Configure.convertInt(numberToDump, 1);
            timeToDump = properties.getProperty(TIMEBETWEEN);
            this.timeBetweenProcessing = Configure.convertInt(timeToDump, 0);
            incidentStream = properties.getProperty(INCIDENTSTREAMPOOLSIZE);
            this.incidentStreamPoolSize = Configure.convertInt(incidentStream, 30);
            introspectMDepth = properties.getProperty(INTROSPECTDEPTH);
            this.introspectDepth = Configure.convertInt(introspectMDepth, 1);
            introspectMSize = properties.getProperty(INTROSPECTSIZE);
            this.introspectMaxSize = Configure.convertInt(introspectMSize, 1024);
            introspectMObjectSize = properties.getProperty(INTROSPECTOBJECTSIZE);
            this.introspectMaxObjectSize = Configure.convertInt(introspectMObjectSize, 1024);
            introspectMArraySize = properties.getProperty(INTROSPECTARRAYSIZE);
            this.introspectMaxObjectSize = Configure.convertInt(introspectMArraySize, 512);
            exFileSize = properties.getProperty(EXCEPTIONFILESIZE);
            this.exceptionFileSize = Configure.convertInt(exFileSize, 1024, 10);
            exFileBackup = properties.getProperty(EXCEPTIONFILEBACKUP);
            this.exceptionFileBackup = Configure.convertInt(exFileBackup, 1, 1);
            refresh = properties.getProperty(REFRESHINTERVAL);
            this.refreshInterval = Configure.convertInt(refresh, 0, 0);
            debugString = properties.getProperty(ALLOWDEBUG);
            this.debugMode = Configure.convertBoolean(debugString, false);
            maxFileAge = properties.getProperty(EXCEPTIONFILEMAXIMUMAGE);
            this.exceptionFileMaximumAge = (long)Configure.convertInt(maxFileAge, 7, 0) * 24L * 60L * 60L * 1000L;
            daysBetweenCleanups = properties.getProperty(DAYSBETWEENEXCEPTIONFILESCLEANUP);
            this.daysBetweenExceptionFilesCleanup = Configure.convertInt(daysBetweenCleanups, 1, 0);
            timeForCleanup = properties.getProperty(TIMEOFTHEDAYFORCLEANUP);
            this.timeOfTheDayForCleanup = Configure.convertInt(timeForCleanup, -1, -1);
        }
        catch (Throwable th) {
            // empty catch block
        }
        if (this.debugMode) {
            this.printObject();
        }
        return true;
    }

    public void printObject() {
        int x;
        System.out.println("*************** Start of dump *********************");
        System.out.println("Properties for : " + this.propertyFile);
        System.out.println("The Switch : " + this.theSwitch);
        System.out.println("The Level : " + this.processLevel);
        System.out.println("number : " + this.numberOfTimesToProcess);
        System.out.println("time : " + this.timeBetweenProcessing);
        System.out.println("LAE : " + this.useLogAnalysisEngine);
        System.out.println("Incident Stream pool : " + this.incidentStreamPoolSize);
        System.out.println("introspection depth : " + this.introspectDepth);
        System.out.println("introspection size : " + this.introspectMaxSize);
        System.out.println("Exception file size : " + this.exceptionFileSize);
        System.out.println("Exception backup files : " + this.exceptionFileBackup);
        System.out.println("Refresh interval : " + this.refreshInterval);
        System.out.println("Allow for debug : " + this.debugMode);
        if (this.inclusionList != null) {
            for (x = 0; x < this.inclusionList.length; ++x) {
                System.out.println("inclusionList[" + x + "] : " + this.inclusionList[x]);
            }
        } else {
            System.out.println("inclusionList is null");
        }
        if (this.exclusionList != null) {
            for (x = 0; x < this.exclusionList.length; ++x) {
                System.out.println("exclusionList[" + x + "] : " + this.exclusionList[x]);
            }
        } else {
            System.out.println("exclusionList is null");
        }
        System.out.println("*************** End of dump *********************");
    }
}

