/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ffdc.impl;

import com.ibm.ffdc.util.provider.FfdcProviderDependent;
import com.ibm.websphere.runtime.ServerName;
import com.ibm.ws.bootstrap.WSLauncher;
import com.ibm.ws.exception.WsException;
import com.ibm.ws.ffdc.FFDC;
import com.ibm.ws.ffdc.impl.Configure;
import com.ibm.ws.ffdc.impl.FFDCHelper;
import com.ibm.ws.ffdc.impl.FfdcProvider;
import com.ibm.ws.ffdc.impl.WrappingFileOutputStream;
import com.ibm.ws.runtime.service.Server;
import com.ibm.ws.runtime.service.ThreadPoolMgr;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.util.ThreadPool;
import com.ibm.ws.util.ThreadPoolListener;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationHelper
extends FfdcProviderDependent<FfdcProvider>
implements PropertyChangeListener,
ThreadPoolListener {
    private static final Logger LOGGER = Logger.getLogger(ConfigurationHelper.class.getName(), "com.ibm.ws.ffdc.resources.FFDCMessages");
    public static boolean isLegacyFFDCInitialized = false;

    protected ConfigurationHelper(FfdcProvider provider) {
        super(provider);
        this.initialize();
    }

    public synchronized void initialize() {
        if (isLegacyFFDCInitialized) {
            return;
        }
        isLegacyFFDCInitialized = true;
        try {
            Server server = this.getService(Server.class);
            server.addPropertyChangeListener("state", this);
            String serverName = server.getName();
            String fullServerName = server.getCellName() + '_' + server.getNodeName() + '_' + serverName;
            FFDC.setServerName(serverName, fullServerName);
            FFDC.setServer();
        }
        catch (SvcException ex) {
            ex.report();
        }
        catch (Throwable th) {
            this.ffdcerror(th);
        }
        try {
            ThreadPoolMgr tpm = this.getService(ThreadPoolMgr.class);
            if (tpm != null) {
                tpm.addThreadPoolListener(this);
            }
        }
        catch (SvcException ex) {
            ex.report();
        }
        catch (Throwable th) {
            this.ffdcerror(th);
        }
        try {
            VariableMap vMap = this.getService(VariableMap.class);
            if (vMap != null) {
                String serviceLogDir = vMap.expand("${LOG_ROOT}");
                FFDC.setLogRoot(serviceLogDir);
            }
        }
        catch (SvcException ex) {
            ex.report();
        }
        catch (Throwable th) {
            this.ffdcerror(th);
        }
        try {
            if (WSLauncher.isZOS()) {
                FFDC.setZos(true);
                FFDC.setzOSjobAttributes(ServerName.getjsabpref(), ServerName.getjsabjbnm().trim(), ServerName.getPrintableStoken());
            }
        }
        catch (Throwable th) {
            this.ffdcerror(th);
        }
    }

    private <T> T getService(final Class<T> cl) throws Exception {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<T>(){

            @Override
            public T run() throws Exception {
                return WsServiceRegistry.getService(this, cl);
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        if (pce.getNewValue().equals("STARTED")) {
            FFDC.setState(2);
        } else if (pce.getNewValue().equals("STOPPING")) {
            FFDC.setState(3);
        }
    }

    public void destroy() {
    }

    @Override
    public void threadPoolCreated(ThreadPool tp) {
    }

    @Override
    public void threadCreated(ThreadPool tp, int poolSize) {
    }

    @Override
    public void threadStarted(ThreadPool tp, int activeThreads, int maxThreads) {
    }

    @Override
    public void threadReturned(ThreadPool tp, int activeThreads, int maxThreads) {
        try {
            FFDC.resetThread();
        }
        catch (Throwable th) {
            this.ffdcerror(th);
        }
    }

    @Override
    public void threadDestroyed(ThreadPool tp, int poolSize) {
        try {
            FFDC.resetThread();
        }
        catch (Throwable th) {
            this.ffdcerror(th);
        }
    }

    protected Configure getConfiguration() {
        if (!isLegacyFFDCInitialized) {
            this.initialize();
        }
        return FFDC.getConfiguration();
    }

    protected boolean hasPermissionForLogging() {
        if (!isLegacyFFDCInitialized) {
            this.initialize();
        }
        return FFDC.hasPermissionForLogging();
    }

    public WrappingFileOutputStream getIncidentSummaryStream() throws WsException, IOException {
        int openFileSize;
        int filenum;
        int maxValue = 0x100000;
        Configure cfg = this.getConfiguration();
        int filesize = cfg == null ? 0 : cfg.exceptionFileSize;
        int n = filenum = cfg == null ? 0 : cfg.exceptionFileBackup;
        if (filesize > 0x100000) {
            filesize = 0x100000;
        }
        if ((openFileSize = filesize * 1024) < 0) {
            openFileSize = 0x100000;
        }
        String exceptionFileName = ConfigurationHelper.getIncidentSummaryFileName();
        return new WrappingFileOutputStream(exceptionFileName, openFileSize, filenum);
    }

    private static String getIncidentSummaryFileName() throws WsException {
        String fileName = "exception";
        String serverName = FFDCHelper.getServerName();
        if (serverName == null || serverName.length() == 0) {
            serverName = "serverName";
        }
        String baseDir = FFDCHelper.getDefaultLoggingDirectory();
        StringBuffer sb = new StringBuffer(64);
        sb.append(baseDir);
        sb.append(File.separatorChar);
        sb.append(serverName);
        sb.append('_');
        sb.append(fileName);
        if (FFDC.isZos()) {
            String jobName = FFDC.getzOSjobName();
            String startedTaskId = FFDC.getzOSjobNumber();
            if (jobName != null && !jobName.equals("")) {
                sb.append("_" + jobName);
            }
            if (startedTaskId != null && !startedTaskId.equals("")) {
                sb.append("_" + startedTaskId);
            }
        }
        sb.append(FFDC.getExceptionIndexFileNameExtension());
        return new String(sb);
    }

    private static class SvcException
    extends Exception {
        final Class cl;

        public SvcException(Throwable cause, Class cl) {
            super("Cannot locate service:" + cl == null ? null : cl.getName(), cause);
            this.cl = cl;
        }

        void report() {
            LOGGER.finer("Cannot locate service:" + this.cl.getName());
        }
    }
}

