/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ffdc;

import com.ibm.etools.analysis.engine.Directive;
import com.ibm.etools.analysis.engine.Incident;
import com.ibm.etools.analysis.engine.Solution;
import com.ibm.etools.analysis.engine.engines.FFDCAnalysisEngine;
import com.ibm.ws.ffdc.FFDC;
import com.ibm.ws.ffdc.impl.FFDCHelper;
import com.ibm.ws.ffdc.impl.WrappingFileOutputStream;
import java.io.File;
import java.io.PrintStream;

class AnalysisEngineWrapper {
    private static FFDCAnalysisEngine analysisEngine = null;
    private static boolean commandLineCall = false;
    private static String databaseName = "ffdcdb.xml";
    private static Object fileGuard = new Object();

    AnalysisEngineWrapper() {
    }

    private static synchronized FFDCAnalysisEngine getAnalysisEngine() {
        String qualifiedName = null;
        if (analysisEngine == null) {
            try {
                qualifiedName = commandLineCall ? databaseName : FFDCHelper.getQualifiedDatabaseName(databaseName);
            }
            catch (Throwable th) {
                return null;
            }
            analysisEngine = FFDCAnalysisEngine.getInstance((String)qualifiedName);
        }
        return analysisEngine;
    }

    static void setUpForCommandLineCall(String inDatabaseName) {
        commandLineCall = true;
        if (inDatabaseName != null) {
            databaseName = inDatabaseName;
        }
    }

    static String[] checkKnowledgeBase(String exceptionName, String[] callStack, String header, int filesize, int backupFiles) {
        return AnalysisEngineWrapper.checkKnowledgeBase(exceptionName, callStack, header, null, filesize, backupFiles);
    }

    static synchronized String[] checkKnowledgeBase(String exceptionName, String[] callStack, String header, String displayPrintStack, int filesize, int backupFiles) {
        Directive[] directive;
        FFDCAnalysisEngine analysisEngine = null;
        Object d = null;
        String[] stringDirectives = null;
        int directiveCounter = 0;
        String saveDirective = null;
        Incident incident = new Incident((String)null);
        analysisEngine = AnalysisEngineWrapper.getAnalysisEngine();
        if (analysisEngine == null) {
            return null;
        }
        incident.setMessageId(exceptionName);
        incident.setRawData(callStack);
        Solution[] solution = analysisEngine.analyzeForSolutions(incident);
        if (commandLineCall && solution.length == 0) {
            String msg = "NOT FOUND -- See attached call stack for more details about the problem.";
            msg = msg + header + '\n' + displayPrintStack;
            if (callStack.length == 0) {
                msg = msg + " -- Call Stack was not set to anything";
            }
            AnalysisEngineWrapper.printSolution("****** " + msg + " ******", exceptionName, header, 1, 1, filesize, backupFiles);
        }
        for (int counter = 0; counter < solution.length; ++counter) {
            directive = solution[counter].getDirectives();
            if (directive != null) {
                for (int innerloop = 0; innerloop < directive.length; ++innerloop) {
                    if (++directiveCounter != 1) continue;
                    saveDirective = directive[innerloop].getDirectiveString();
                }
            }
            if (solution[counter].getDescription() == null) continue;
            AnalysisEngineWrapper.printSolution(solution[counter].getDescription(), exceptionName, header, counter + 1, solution.length, filesize, backupFiles);
        }
        if (directiveCounter > 1) {
            stringDirectives = new String[directiveCounter];
            int directiveIndex = 0;
            for (int counter = 0; counter < solution.length; ++counter) {
                directive = solution[counter].getDirectives();
                if (directive == null) continue;
                for (int innerloop = 0; innerloop < directive.length; ++innerloop) {
                    stringDirectives[directiveIndex] = directive[innerloop].getDirectiveString();
                    ++directiveIndex;
                }
            }
        } else if (directiveCounter == 1) {
            stringDirectives = new String[]{saveDirective};
        }
        return stringDirectives;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printSolution(String solution, String exName, String header, int entry, int total, int filesize, int filenum) {
        PrintStream ps = null;
        if (commandLineCall) {
            System.out.println("----------------------------------------------------------------------");
            System.out.println("Key Value : " + header);
            if (total > 1) {
                System.out.println("Multiple entries found for symptom, entry " + entry + " of " + total);
            }
            System.out.println("Exception Name : " + exName);
            System.out.println("Solution : " + solution);
            System.out.println("----------------------------------------------------------------------");
            return;
        }
        Object object = fileGuard;
        synchronized (object) {
            try {
                ps = AnalysisEngineWrapper.openFile(filesize, filenum);
                if (ps == null) {
                    return;
                }
                ps.println("----------------------------------------------------------------------");
                ps.println("Key Value : " + header);
                ps.println("Exception Name : " + exName);
                ps.println("Solution : " + solution);
                ps.println("----------------------------------------------------------------------");
                ps.close();
            }
            catch (Throwable th) {
                return;
            }
        }
    }

    private static PrintStream openFile(int filesize, int filenum) {
        PrintStream ps = null;
        String exceptionFileName = null;
        int maxValue = 0x100000;
        int openFileSize = 0;
        if (filesize > 0x100000) {
            filesize = 0x100000;
        }
        if ((openFileSize = filesize * 1024) < 0) {
            openFileSize = 0x100000;
        }
        try {
            exceptionFileName = AnalysisEngineWrapper.getFileName();
            if (exceptionFileName == null) {
                return null;
            }
            WrappingFileOutputStream wfs = new WrappingFileOutputStream(exceptionFileName, openFileSize, filenum);
            ps = new PrintStream(wfs);
        }
        catch (Throwable th) {
            th.printStackTrace();
            return null;
        }
        return ps;
    }

    private static String getFileName() {
        String fileName = "solution";
        String serverName = null;
        serverName = FFDCHelper.getServerName();
        if (serverName == null || serverName.length() == 0) {
            serverName = "serverName";
        }
        try {
            String baseDir = FFDCHelper.getDefaultLoggingDirectory();
            StringBuffer sb = new StringBuffer(64);
            sb.append(baseDir);
            sb.append(File.separatorChar);
            sb.append(serverName);
            sb.append('_');
            sb.append(fileName);
            sb.append(FFDC.getExceptionIndexFileNameExtension());
            return new String(sb);
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

