/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.extension.thinregistry;

import com.ibm.ws.bootstrap.LoggingServices;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IPluginDescriptor;

public class ResourceHelper {
    private static final String srcClass = "ResourceHelper";
    private static HashMap s_resBundles = new HashMap();
    private static ResourceBundle s_logBundle = null;

    private ResourceHelper() {
    }

    static ResourceBundle getBundle(IPluginDescriptor plugin) {
        return ResourceHelper.getBundle(plugin, Locale.getDefault());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ResourceBundle getBundle(IPluginDescriptor plugin, Locale locale) {
        ResourceBundle bundle;
        block16: {
            String pluginId = plugin.getUniqueIdentifier();
            bundle = null;
            if (locale == null) {
                locale = Locale.getDefault();
            }
            StringBuffer cacheKeyBuf = new StringBuffer(pluginId);
            cacheKeyBuf.append("___");
            cacheKeyBuf.append(plugin.getVersionIdentifier().toString());
            cacheKeyBuf.append("___");
            cacheKeyBuf.append(locale.toString());
            String cacheKey = cacheKeyBuf.toString();
            if (s_resBundles.containsKey(cacheKey)) {
                bundle = (ResourceBundle)s_resBundles.get(cacheKey);
            } else {
                try {
                    int pos;
                    URL pluginxmlUrl = plugin.getInstallURL();
                    if (pluginxmlUrl == null) {
                        break block16;
                    }
                    String urlStr = pluginxmlUrl.toExternalForm();
                    if (!urlStr.endsWith("plugin.xml")) break block16;
                    if (!urlStr.endsWith("fragment.xml")) {
                        break block16;
                    }
                    StringBuffer buf = new StringBuffer(urlStr);
                    int len = urlStr.length();
                    buf.replace(len - 4, len, "_");
                    String PROP_EXT = ".properties";
                    buf.append(locale.toString());
                    buf.append(".properties");
                    bundle = ResourceHelper.findBundle(buf.toString());
                    if (bundle != null) {
                        break block16;
                    }
                    int startPos = urlStr.lastIndexOf("plugin.xml");
                    if (startPos == -1) {
                        startPos = urlStr.lastIndexOf("fragment.xml");
                    }
                    while ((pos = buf.toString().lastIndexOf("_")) != -1) {
                        if (pos < startPos) {
                        } else {
                            buf.replace(pos, buf.length(), ".properties");
                            bundle = ResourceHelper.findBundle(buf.toString());
                            if (bundle == null) continue;
                        }
                        break;
                    }
                }
                catch (RuntimeException e) {
                    if (LoggingServices.debugEnabled) {
                        LoggingServices.trace("Exception: ", e);
                        e.printStackTrace(LoggingServices.out);
                    }
                }
                finally {
                    s_resBundles.put(cacheKey, bundle);
                }
            }
        }
        return bundle;
    }

    private static ResourceBundle findBundle(String bundleUrl) {
        PropertyResourceBundle bundle;
        block3: {
            bundle = null;
            try {
                URL propFile = new URL(bundleUrl);
                InputStream in = propFile.openStream();
                if (in != null) {
                    bundle = new PropertyResourceBundle(in);
                }
            }
            catch (Exception e) {
                if (!LoggingServices.debugEnabled) break block3;
                LoggingServices.trace("find Bundle exception: ", e);
                e.printStackTrace(LoggingServices.out);
            }
        }
        return bundle;
    }

    public static String getString(ResourceBundle rb, String key, Object[] params) {
        String pattern = rb.getString(key);
        if (pattern != null) {
            return MessageFormat.format(pattern, params);
        }
        return null;
    }

    static ResourceBundle getResourceBundle() {
        if (s_logBundle == null) {
            s_logBundle = ResourceBundle.getBundle("com.ibm.ws.bootstrap.bootstrap");
        }
        return s_logBundle;
    }

    static String getString(String key, Object[] params) {
        try {
            String pattern = ResourceHelper.getResourceBundle().getString(key);
            if (pattern != null) {
                return MessageFormat.format(pattern, params);
            }
        }
        catch (MissingResourceException mre) {
            // empty catch block
        }
        StringBuffer sb = new StringBuffer();
        sb.append(key);
        for (int i = 0; i < params.length; ++i) {
            sb.append(params[i]);
        }
        return sb.toString();
    }
}

