/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.crypto.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.models.config.ipc.ssl.WSSchedule;
import com.ibm.ws.security.config.SecurityConfigObject;
import com.ibm.ws.ssl.config.AdminContextHelper;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;

public class WSScheduler
implements AlarmListener {
    private static final TraceComponent tc = Tr.register(WSScheduler.class, "SSL", "com.ibm.ws.ssl.resources.ssl");
    String name = null;
    int frequency = 90;
    int dayOfWeek = 7;
    int hour = 23;
    int minute = 0;
    long timeout = -1L;
    long nextStartLong = 0L;
    AlarmListener alarmListener = null;
    private static ConcurrentHashMap alarmMap = new ConcurrentHashMap();
    private static Object _lockObj = new Object();
    private static String _debug_interval = System.getProperty("com.ibm.ws.crypto.config.debugInterval");
    private static boolean isSecurityReady = false;
    private static boolean isSecurityEnabled = false;
    private static boolean isSecurityEnabledChecked = false;
    private static boolean isSecurityFailure = false;
    private static long lastAlarm = 0L;
    private String uuid = null;

    public WSScheduler(WSSchedule schedule, AlarmListener listener) {
        this.WSSchedulerInit(schedule, listener, (String)null);
    }

    public WSScheduler(WSSchedule schedule, AlarmListener listener, String key) {
        this.WSSchedulerInit(schedule, listener, key);
    }

    private void WSSchedulerInit(WSSchedule schedule, AlarmListener listener, String key) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSScheduler");
        }
        this.uuid = AdminContextHelper.peekAdminContext();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "uuid: " + this.uuid);
        }
        this.nextStartLong = schedule.getNextStartDate();
        long currentTime = System.currentTimeMillis();
        if (key != null) {
            AlarmObject alarmObject = (AlarmObject)alarmMap.get(key);
            if (tc.isDebugEnabled() && alarmObject != null) {
                Tr.debug(tc, "Time difference between current time and nextStart time: " + (this.nextStartLong - currentTime));
                Tr.debug(tc, "Time difference between nextStart in alarm and security.xml: " + (alarmObject.getNextStartLong() - this.nextStartLong));
                Tr.debug(tc, "nextStart in Alarm:" + alarmObject.getNextStartLong() + " nextStart in security.xml:" + this.nextStartLong + " CurrentTime:" + currentTime);
            }
            if (alarmObject != null && (this.nextStartLong < currentTime || this.nextStartLong == alarmObject.getNextStartLong())) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "WSScheduler; skip processing due to a duplicate call.");
                }
                return;
            }
        }
        this.name = schedule.getName();
        this.frequency = schedule.getFrequency();
        this.dayOfWeek = schedule.getDayOfWeek();
        this.hour = schedule.getHour();
        this.minute = schedule.getMinute();
        this.alarmListener = listener;
        try {
            long nextT = 0L;
            if (this.nextStartLong > 0L) {
                currentTime = System.currentTimeMillis();
                if (this.nextStartLong > currentTime) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Next alarm scheduled for: " + new Date(this.nextStartLong));
                    }
                    nextT = this.nextStartLong - currentTime;
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Alarm is past, Next alarm scheduled for: " + new Date(currentTime + 60000L));
                    }
                    nextT = 60000L;
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Time could not be read from the configuration.");
                }
                this.nextStartLong = -1L;
                nextT = 60000L;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Next alarm generated from today's date, scheduled for: " + new Date(currentTime + 60000L));
                }
            }
            Alarm alarmObj = AlarmManager.createDeferrable(nextT, this, key);
            this.setAlarm(key, this.nextStartLong, alarmObj);
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, this, "com.ibm.ws.crypto.config.WSScheduler.WSSchedulerInit", "151", this, new Object[]{e});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception generating schedule.", new Object[]{e});
            }
            Tr.error(tc, "ssl.schedule.init.error.CWPKI0034E", new Object[]{e.getMessage()});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSScheduler", new Object[]{this.toString()});
        }
    }

    public WSScheduler(SecurityConfigObject schedule, AlarmListener listener) {
        this.WSSchedulerInit(schedule, listener, (String)null);
    }

    public WSScheduler(SecurityConfigObject schedule, AlarmListener listener, String key) {
        this.WSSchedulerInit(schedule, listener, key);
    }

    private void WSSchedulerInit(SecurityConfigObject schedule, AlarmListener listener, String key) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSScheduler");
        }
        this.uuid = AdminContextHelper.peekAdminContext();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "uuid: " + this.uuid);
        }
        this.nextStartLong = schedule.getLong("nextStartDate");
        long currentTime = System.currentTimeMillis();
        if (key != null) {
            AlarmObject alarmObject = (AlarmObject)alarmMap.get(key);
            if (tc.isDebugEnabled() && alarmObject != null) {
                Tr.debug(tc, "Time difference between current time and nextStart time: " + (this.nextStartLong - currentTime));
                Tr.debug(tc, "Time difference between nextStart in alarm and security.xml: " + (alarmObject.getNextStartLong() - this.nextStartLong));
                Tr.debug(tc, "nextStart in Alarm:" + alarmObject.getNextStartLong() + " nextStart in security.xml:" + this.nextStartLong + " CurrentTime:" + currentTime);
            }
            if (alarmObject != null && (this.nextStartLong < currentTime || this.nextStartLong == alarmObject.getNextStartLong())) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "WSScheduler; skip processing due to a duplicate call.");
                }
                return;
            }
        }
        this.name = schedule.getString("name");
        this.frequency = schedule.getInteger("frequency");
        this.dayOfWeek = schedule.getInteger("dayOfWeek");
        this.hour = schedule.getInteger("hour");
        this.minute = schedule.getInteger("minute");
        this.alarmListener = listener;
        try {
            long nextT = 0L;
            if (this.nextStartLong > 0L) {
                currentTime = System.currentTimeMillis();
                if (this.nextStartLong > currentTime) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Next alarm scheduled for: " + new Date(this.nextStartLong));
                    }
                    nextT = this.nextStartLong - currentTime;
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Alarm is past, Next alarm scheduled for: " + new Date(currentTime + 60000L));
                    }
                    nextT = 60000L;
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Time could not be read from the configuration.");
                }
                this.nextStartLong = -1L;
                nextT = 60000L;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Next alarm generated from today's date, scheduled for: " + new Date(currentTime + 60000L));
                }
            }
            Alarm alarmObj = AlarmManager.createDeferrable(nextT, this, key);
            this.setAlarm(key, this.nextStartLong, alarmObj);
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, this, "com.ibm.ws.crypto.config.WSScheduler.WSSchedulerInit", "233", this, new Object[]{e});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception generating schedule.", new Object[]{e});
            }
            Tr.error(tc, "ssl.schedule.init.error.CWPKI0034E", new Object[]{e.getMessage()});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSScheduler", new Object[]{this.toString()});
        }
    }

    public WSScheduler(int freq, int day, int hr, int min) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSScheduler");
        }
        this.frequency = freq;
        this.dayOfWeek = day;
        this.hour = hr;
        this.minute = min;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSScheduler", new Object[]{this.toString()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alarm(Object alarmCtx) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "alarm", alarmCtx);
        }
        boolean pushed = false;
        try {
            if (this.uuid != null) {
                pushed = AdminContextHelper.pushAdminContext(this.uuid);
            }
            Object object = _lockObj;
            synchronized (object) {
                String key = null;
                long next = 0L;
                if (alarmCtx != null && alarmCtx instanceof String) {
                    key = (String)alarmCtx;
                    AlarmObject ao = (AlarmObject)alarmMap.get(key);
                    if (ao != null) {
                        next = ao.getNextStartLong();
                    }
                    alarmMap.remove(key);
                }
                boolean isReady = this.isSecurityReady();
                if ((this.isAlarmFired(120) || !isReady) && next != 0L) {
                    long delay = 120L;
                    if (!isReady) {
                        delay = 30L;
                    }
                    Alarm alarmObj = AlarmManager.createDeferrable(delay * 1000L, this, key);
                    this.setAlarm(key, next, alarmObj);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "An Alarm was fired within one minute, or Security Service is not ready, Retry is scheduled in " + delay + " seconds");
                    }
                } else if (this.isSecurityFailure() || next == 0L) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Security Service Failure, an alarm won't be fired.");
                    }
                } else {
                    Date nextDate = this.getNextEventDateFromNow();
                    this.nextStartLong = nextDate.getTime();
                    Alarm alarmObj = AlarmManager.createDeferrable(this.nextStartLong - System.currentTimeMillis(), this, key);
                    this.setAlarm(key, this.nextStartLong, alarmObj);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Next alarm generated by an alarm, scheduled for: " + nextDate);
                    }
                    try {
                        if (next != -1L) {
                            this.setAlarmFired();
                            this.alarmListener.alarm(alarmCtx);
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "First time setting the nextStartDate, do not fire alarm");
                        }
                        this.updateNextStartDate(this.name, new Long(nextDate.getTime()));
                    }
                    catch (Exception e) {
                        Manager.Ffdc.log(e, this, "com.ibm.ws.crypto.config.WSScheduler.alarm", "325", this, new Object[]{e});
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception generating schedule.", new Object[]{e});
                        }
                        Tr.error(tc, "ssl.schedule.init.error.CWPKI0034E", new Object[]{e.getMessage()});
                    }
                }
            }
        }
        finally {
            if (pushed) {
                AdminContextHelper.popAdminContext();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "alarm");
        }
    }

    public Date getNextEventDateFromNow() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNextEventDateFromNow");
        }
        Calendar rightNow = Calendar.getInstance();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNextEventDateFromNow", new Object[]{rightNow.getTime()});
        }
        return this.computeDate(rightNow);
    }

    public Date getNextEventDateFromDate(Date fromDate) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNextEventDateFromDate");
        }
        Calendar fromDateCal = Calendar.getInstance();
        fromDateCal.setTime(fromDate);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNextEventDateFromDate", new Object[]{fromDateCal.getTime()});
        }
        return this.computeDate(fromDateCal);
    }

    public Date computeDate(Calendar cal) {
        int nextDay;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "computeDate");
        }
        if (this.hour < 24) {
            cal.set(11, this.hour);
        }
        if (this.minute < 60) {
            cal.set(12, this.minute);
        }
        int currentDay = cal.get(6);
        int currentYear = cal.get(1);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "currentDay = " + currentDay);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "currentYear = " + currentYear);
        }
        if ((nextDay = currentDay + this.frequency) > 365) {
            cal.set(6, nextDay -= 365);
            cal.set(1, ++currentYear);
        } else {
            cal.set(6, nextDay);
        }
        if (this.dayOfWeek > 0 && this.dayOfWeek < 8) {
            int delta = 0;
            int currentDayOfWeek = cal.get(7);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "dayOfWeek (preferred) = " + this.dayOfWeek);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "currentDayOfWeek = " + currentDayOfWeek);
            }
            if (currentDayOfWeek != this.dayOfWeek) {
                delta = currentDayOfWeek - this.dayOfWeek;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "delta (dayOfWeek) = " + delta);
                }
                if (nextDay - delta <= 0) {
                    nextDay = nextDay - delta + 365;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "nextDay (w/delta) = " + nextDay);
                    }
                    cal.set(6, nextDay);
                    --currentYear;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "currentYear = " + currentYear);
                    }
                    cal.set(1, currentYear);
                } else if (nextDay - delta > 365) {
                    nextDay = nextDay - delta - 365;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "nextDay (w/delta) = " + nextDay);
                    }
                    cal.set(6, nextDay);
                    ++currentYear;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "currentYear = " + currentYear);
                    }
                    cal.set(1, currentYear);
                } else {
                    nextDay -= delta;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "nextDay (w/delta) = " + nextDay);
                    }
                    cal.set(6, nextDay);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "currentYear = " + currentYear);
                    }
                }
            }
        }
        Date nextDate = cal.getTime();
        if (_debug_interval != null && _debug_interval.length() > 0) {
            int val = Integer.parseInt(_debug_interval);
            Calendar rightNow = Calendar.getInstance();
            rightNow.set(14, 0);
            rightNow.set(13, 0);
            nextDate = new Date(rightNow.getTime().getTime() + (long)(val * 60000));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "computeDate-Debug code", new Object[]{new Integer(val), nextDate});
            }
        } else if (tc.isEntryEnabled()) {
            Tr.exit(tc, "computeDate", new Object[]{nextDate});
        }
        return nextDate;
    }

    public void updateNextStartDate(String scheduleName, Long newStartDate) {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "updateNextStartDate");
            }
            try {
                Class<?> cl1 = Class.forName("com.ibm.ws.ssl.utils.SchedulerCommandHelper");
                Method theMethod1 = cl1.getMethod("updateNextStartDate", String.class, Long.class);
                theMethod1.invoke(cl1.newInstance(), scheduleName, newStartDate);
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, this, "com.ibm.ws.crypto.config.WSScheduler.updateNextStartDate", "471", this);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Exception updating next start date.", new Object[]{e});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateNextStartDate");
        }
    }

    public String toString() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "toString");
        }
        StringBuffer buf = new StringBuffer();
        buf.append("WSScheduler.toString() {\n");
        buf.append("name = ");
        buf.append(this.name);
        buf.append("\n");
        buf.append("frequency = ");
        buf.append(this.frequency);
        buf.append("\n");
        buf.append("dayOfWeek = ");
        buf.append(this.dayOfWeek);
        buf.append("\n");
        buf.append("hour = ");
        buf.append(this.hour);
        buf.append("\n");
        buf.append("minute = ");
        buf.append(this.minute);
        buf.append("\n");
        buf.append("nextStartLong = ");
        buf.append(this.nextStartLong);
        buf.append("\n}");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "toString");
        }
        return buf.toString();
    }

    public void cancelAlarm(String key) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cancelAlarm  key:" + key);
        }
        if (key != null) {
            Alarm alarmObj = null;
            AlarmObject alarmObject = (AlarmObject)alarmMap.get(key);
            if (alarmObject != null) {
                alarmObj = alarmObject.getAlarm();
            }
            if (alarmObj != null) {
                boolean result = AlarmManager.disableAlarm(alarmObj);
                alarmMap.remove(key);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "disableAlarm:" + result + "  size:" + alarmMap.size());
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cancelAlarm");
        }
    }

    private void setAlarm(String key, long nextStartLong, Alarm alarmObj) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAlarm  key:" + key + "  Alarm:" + alarmObj + "Next Start:" + nextStartLong);
        }
        if (key != null && alarmObj != null) {
            this.cancelAlarm(key);
            alarmMap.put(key, new AlarmObject(nextStartLong, alarmObj));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "store Alarm.. size:" + alarmMap.size());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAlarm");
        }
    }

    private void setAlarmFired() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAlarmFired");
        }
        lastAlarm = System.currentTimeMillis();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAlarmFired " + lastAlarm);
        }
    }

    private boolean isAlarmFired(int range) {
        boolean fired = false;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isAlarmFired range:" + range);
        }
        if (System.currentTimeMillis() - lastAlarm < (long)(range * 1000)) {
            fired = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isAlarmFired " + fired);
        }
        return fired;
    }

    private boolean isSecurityFailure() {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isSecurityFailure" + isSecurityFailure);
        }
        return isSecurityFailure;
    }

    private boolean isSecurityEnabled() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isSecurityEnabled");
        }
        if (!isSecurityEnabledChecked) {
            try {
                Class<?> cl1 = Class.forName("com.ibm.ws.security.core.ContextManagerFactory");
                Method theMethod1 = cl1.getMethod("getInstance", null);
                Object ctxMgr = theMethod1.invoke(null, null);
                Class<?> cl2 = Class.forName("com.ibm.ws.security.core.ContextManager");
                Method theMethod2 = cl2.getMethod("isCellSecurityEnabled", null);
                Boolean isEnabledObj = (Boolean)theMethod2.invoke(ctxMgr, null);
                isSecurityEnabled = isEnabledObj;
                isSecurityEnabledChecked = true;
                isSecurityFailure = false;
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, this, "com.ibm.ws.crypto.config.WSScheduler.isSecurityEnabled", "624", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "isSecurityEnabled() call failed.", new Object[]{e});
                }
                isSecurityFailure = true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isSecurityEnabled" + isSecurityEnabled);
        }
        return isSecurityEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSecurityReady() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isSecurityReady");
        }
        if (!isSecurityReady) {
            if (!this.isSecurityEnabled() && !this.isSecurityFailure()) {
                isSecurityReady = true;
            } else {
                boolean pushed = false;
                try {
                    pushed = AdminContextHelper.pushAdminContext(null);
                    Class<?> cl1 = Class.forName("com.ibm.ws.security.core.ContextManagerFactory");
                    Method theMethod1 = cl1.getMethod("getInstance", null);
                    Object ctxMgr = theMethod1.invoke(null, null);
                    Class<?> cl2 = Class.forName("com.ibm.ws.security.core.ContextManager");
                    Method theMethod2 = cl2.getMethod("isSecurityServiceStarted", null);
                    Boolean isEnabledObj = (Boolean)theMethod2.invoke(ctxMgr, null);
                    isSecurityReady = isEnabledObj;
                    isSecurityFailure = false;
                }
                catch (Exception e) {
                    Manager.Ffdc.log(e, this, "com.ibm.ws.crypto.config.WSScheduler.isSecurityReady", "664", this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "isSecurityReady() call failed.", new Object[]{e});
                    }
                    isSecurityFailure = true;
                }
                finally {
                    if (pushed) {
                        AdminContextHelper.popAdminContext();
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isSecurityReady" + isSecurityReady);
        }
        return isSecurityReady;
    }

    class AlarmObject {
        Alarm _alarmObj = null;
        long _nextStartLong = 0L;

        AlarmObject() {
        }

        AlarmObject(long nextStartLong, Alarm alarmObj) {
            this._alarmObj = alarmObj;
            this._nextStartLong = nextStartLong;
        }

        Alarm getAlarm() {
            return this._alarmObj;
        }

        long getNextStartLong() {
            return this._nextStartLong;
        }
    }
}

