/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channel.framework.ctm;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.channel.framework.ctm.BaseChannelTypeManager;
import com.ibm.ws.channel.framework.impl.RCSUtil;
import com.ibm.ws.runtime.component.TransportChannelLoaderImpl;
import com.ibm.wsspi.runtime.config.ConfigObject;
import com.ibm.wsspi.runtime.config.ConfigService;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class RuntimeChannelTypeManager
extends BaseChannelTypeManager {
    private static TraceComponent tc = Tr.register(RuntimeChannelTypeManager.class, "ChannelFrameworkService", "com.ibm.ws.channel.resources.channelframeworkservice");
    private static String INSTALLED_CHANNELS = "installed-channels.xml";

    public RuntimeChannelTypeManager() {
    }

    public RuntimeChannelTypeManager(ConfigService service, String optionalChannelJarDir, TransportChannelLoaderImpl loader) throws Exception {
        File[] jarList;
        File dir;
        String channelJarDir = "installedChannels";
        if (optionalChannelJarDir != null) {
            channelJarDir = optionalChannelJarDir;
        }
        if (!(dir = new File(System.getProperty("was.install.root"), channelJarDir)).exists() || !dir.isDirectory()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, dir + " is missing or is not a directory.");
            }
            jarList = new File[]{};
        } else {
            List<File> programmaticChannels;
            if (tc.isDebugEnabled()) {
                StringBuffer message = new StringBuffer();
                String s = service.getScope(3).getAbsolutePath(INSTALLED_CHANNELS);
                message.append("RuntimeChannelTypeManager is loading channels from " + s);
                Tr.debug(tc, message.toString());
            }
            ArrayList<File> jars = new ArrayList<File>();
            List list = service.getDocumentObjects(service.getScope(3), INSTALLED_CHANNELS);
            for (ConfigObject o : list) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "looking at: " + o);
                }
                if (!RCSUtil.instanceOfInstalledChannelRef(o)) continue;
                String sJar = o.getString("jarFile", null);
                jars.add(new File(dir, sJar));
            }
            if (loader != null && (programmaticChannels = loader.unloadChannelList()) != null) {
                for (int i = programmaticChannels.size() - 1; i >= 0; --i) {
                    File f = programmaticChannels.remove(i);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding programmatically installed jar " + f.getName());
                    }
                    jars.add(f);
                }
            }
            jarList = jars.toArray(new File[jars.size()]);
        }
        if (!this.loadChannelDefinitions(jarList)) {
            Tr.audit(tc, "channel.load.problems");
        }
        if (tc.isDebugEnabled()) {
            Collection allTypes = this._typeMap.values();
            Tr.debug(tc, "loaded " + allTypes.size() + " channel types:", allTypes.toArray());
        }
    }
}

