/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.Transaction.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.Transaction.JTS.TxStatusHelper;
import com.ibm.ws.Transaction.UOWCoordinator;
import com.ibm.ws.Transaction.client.NonRecoverableTransactionImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.uow.UOWScopeCallbackManager;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;

public final class NonRecoverableTranManagerImpl
implements TransactionManager {
    private static final TraceComponent tc = Tr.register(NonRecoverableTranManagerImpl.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    private NonRecoverableTransactionImpl _tx = null;
    private UOWScopeCallbackManager _callbackManager;
    private static final int DEFAULT_TX_TIMEOUT = 60;
    private int _txTimeout = 60;

    NonRecoverableTranManagerImpl(UOWScopeCallbackManager callbackManager) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "NonRecoverableTranManagerImpl", this._callbackManager);
        }
        this._callbackManager = callbackManager;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "NonRecoverableTranManagerImpl", this);
        }
    }

    public void begin() throws NotSupportedException {
        if (this._tx != null) {
            Tr.error(tc, "WTRN0017_UNABLE_TO_BEGIN_NESTED_TRANSACTION");
            NotSupportedException nse = new NotSupportedException("Nested transactions are not supported.");
            FFDCFilter.processException((Throwable)nse, "com.ibm.ws.Transaction.NonRecoverableTranManagerImpl.begin", "33", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "begin");
            }
            throw nse;
        }
        this._tx = new NonRecoverableTransactionImpl(this._txTimeout);
        this._callbackManager.notifyCallbacks(1, this._tx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        block12: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "commit");
            }
            if (this._tx == null) {
                IllegalStateException ise = new IllegalStateException("There is no transaction associated with the calling thread.");
                FFDCFilter.processException((Throwable)ise, "com.ibm.ws.Transaction.NonRecoverableTranManagerImpl.commit", "48", this);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "commit");
                }
                throw ise;
            }
            NonRecoverableTransactionImpl before = this._tx;
            try {
                this._callbackManager.notifyCallbacks(2, before);
            }
            catch (IllegalStateException ise) {
                FFDCFilter.processException((Throwable)ise, "com.ibm.ws.Transaction.client.NonRecoverableTranManagerImpl.commit", "107", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "IllegalStateException caught notifying callbacks of tx PRE_END", ise);
                }
                try {
                    before.setRollbackOnly();
                }
                catch (IllegalStateException ise2) {
                    FFDCFilter.processException((Throwable)ise2, "com.ibm.ws.Transaction.client.NonRecoverableTranManagerImpl.commit", "117", this);
                    if (!tc.isEventEnabled()) break block12;
                    Tr.event(tc, "IllegalStateException caught setting tx rollback only", ise2);
                }
            }
        }
        try {
            this._tx.commit();
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "commit");
            }
        }
    }

    public int getStatus() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStatus");
        }
        int status = 6;
        if (this._tx != null) {
            status = this._tx.getStatus();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStatus", TxStatusHelper.getJavaxStatusAsString(status));
        }
        return status;
    }

    public Transaction getTransaction() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTransaction");
            Tr.exit(tc, "getTransaction", this._tx);
        }
        return this._tx;
    }

    public void resume(Transaction tran) throws IllegalStateException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resume");
        }
        if (this._tx != null) {
            IllegalStateException ise = new IllegalStateException("The current thread is already associated with another transaction.");
            FFDCFilter.processException((Throwable)ise, "com.ibm.ws.Transaction.NonRecoverableTranManagerImpl.resume", "98", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "resume");
            }
            throw ise;
        }
        this._tx = (NonRecoverableTransactionImpl)tran;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resume");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "rollback");
        }
        if (this._tx == null) {
            IllegalStateException ise = new IllegalStateException("There is no transaction associated with the calling thread.");
            FFDCFilter.processException((Throwable)ise, "com.ibm.ws.Transaction.NonRecoverableTranManagerImpl.rollback", "115", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "rollback");
            }
            throw ise;
        }
        try {
            this._callbackManager.notifyCallbacks(2, this._tx);
        }
        catch (IllegalStateException ise) {
            FFDCFilter.processException((Throwable)ise, "com.ibm.ws.Transaction.client.NonRecoverableTranManagerImpl.rollback", "187", this);
        }
        try {
            this._tx.rollback();
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "rollback");
            }
        }
    }

    public void setRollbackOnly() throws IllegalStateException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setRollbackOnly");
        }
        if (this._tx == null) {
            IllegalStateException ise = new IllegalStateException("There is no transaction associated with the calling thread.");
            FFDCFilter.processException((Throwable)ise, "com.ibm.ws.Transaction.NonRecoverableTranManagerImpl.setRollbackOnly", "139", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setRollbackOnly");
            }
            throw ise;
        }
        this._tx.setRollbackOnly();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setRollbackOnly");
        }
    }

    public void setTransactionTimeout(int timeout) throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTransactionTimeout", new Integer(timeout));
        }
        if (timeout < 0) {
            SystemException se = new SystemException("Transaction timeout value must be >= 0");
            FFDCFilter.processException((Throwable)se, "com.ibm.ws.Transaction.TranManagerImpl.setTransactionTimeout", "206", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setTransactionTimeout");
            }
            throw se;
        }
        if (timeout == Integer.MAX_VALUE) {
            this._txTimeout = 0;
        } else {
            int n = this._txTimeout = timeout == 0 ? 60 : timeout;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setTransactionTimeout");
        }
    }

    public Transaction suspend() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "suspend");
        }
        NonRecoverableTransactionImpl suspended = null;
        if (this._tx != null) {
            suspended = this._tx;
            this._tx = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "suspend", suspended);
        }
        return suspended;
    }

    public UOWCoordinator getUOWCoord() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUOWCoord");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUOWCoord", this._tx);
        }
        return this._tx;
    }
}

