/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.security.auth.callback;

import com.ibm.ISecurityL13SupportImpl.SecurityMessages;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.security.auth.callback.CcacheFileTextInputCallback;
import com.ibm.security.auth.callback.DefaultCcacheTextInputCallback;
import com.ibm.websphere.security.auth.callback.WSRealmNameCallbackImpl;
import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class WSCcacheCallBackHandlerImpl
implements CallbackHandler {
    private static final String realmNamePrompt = SecurityMessages.getMsgOrUseDefault("RealmName", "Realm (Cell) Name");
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static final TraceComponent tc = Tr.register(WSCcacheCallBackHandlerImpl.class, null, "com.ibm.ejs.resources.security");
    private String _username = "";
    private String _realmName = "";
    private String _defaultCcache = "";
    private String _ccacheFile = "";

    public WSCcacheCallBackHandlerImpl() {
    }

    public WSCcacheCallBackHandlerImpl(String userid, String realmName, String ccacheFile, String defaultCcache) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSCcacheCallBackHandlerImpl(userid, realmName, ccacheFile, defaultCcache)", new Object[]{"user: " + userid + " realmName: " + realmName + " ccacheFile: " + ccacheFile + " defaultCcache: " + defaultCcache});
        }
        this._username = userid;
        this._realmName = realmName;
        this._ccacheFile = ccacheFile;
        this._defaultCcache = defaultCcache;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSCcacheCallBackHandlerImpl(userid, realmName, ccacheFile, defaultCcache)");
        }
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handle(Callback[] callbacks)");
        }
        int len = 0;
        if (callbacks == null || (len = callbacks.length) == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "handle(callbacks = \"{ }\")");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "handle(Callback[] callbacks)");
            }
            return;
        }
        if (tc.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer();
            sb.append("{ ");
            for (int i = 0; i < len; ++i) {
                sb.append(callbacks[i].getClass().getName());
                if (i >= len - 1) continue;
                sb.append(", ");
            }
            sb.append(" }");
            Tr.debug(tc, "handle(callbacks = \"" + sb.toString() + "\")");
        }
        for (int i = 0; i < len; ++i) {
            Callback c = callbacks[i];
            if (c instanceof NameCallback) {
                ((NameCallback)c).setName(this._username);
                continue;
            }
            if (c instanceof WSRealmNameCallbackImpl) {
                ((WSRealmNameCallbackImpl)c).setRealmName(this._realmName);
                continue;
            }
            if (c instanceof CcacheFileTextInputCallback) {
                ((CcacheFileTextInputCallback)c).setText(this._ccacheFile);
                continue;
            }
            if (c instanceof DefaultCcacheTextInputCallback) {
                ((DefaultCcacheTextInputCallback)c).setText(this._defaultCcache);
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Un-use handle(callbacks = \"" + callbacks[i].getClass().getName() + "\")");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handle(Callback[] callbacks)");
        }
    }
}

