/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.security.auth;

import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import java.security.Principal;
import javax.resource.spi.ManagedConnectionFactory;

public final class IdentityPrincipal
implements Principal {
    private String _userName = null;
    private String _origUser = null;
    private String _realm = null;
    private String _token = null;
    private ManagedConnectionFactory _mcf = null;
    private ContextManager _cm = ContextManagerFactory.getInstance();

    public IdentityPrincipal(String userName, String realm, String origUser, byte[] token) {
        this._userName = userName;
        this._realm = realm;
        this._origUser = origUser;
        if (token != null) {
            this._token = new String(token);
        }
    }

    public String getName() {
        return this._userName;
    }

    public String getRealm() {
        return this._realm;
    }

    public String getOriginalUser() {
        return this._origUser;
    }

    public byte[] getToken() {
        if (this._token != null) {
            return this._token.getBytes();
        }
        return null;
    }

    public ManagedConnectionFactory getManagedConnectionFactory() {
        return this._mcf;
    }

    public void setManagedConnectionFactory(ManagedConnectionFactory mcf) {
        this._mcf = mcf;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof IdentityPrincipal)) {
            return false;
        }
        IdentityPrincipal that = (IdentityPrincipal)obj;
        if (!this._userName.equals(that._userName)) {
            return false;
        }
        if (!this._realm.equals(that._realm)) {
            return false;
        }
        if (!this._origUser.equals(that._origUser)) {
            return false;
        }
        return this._token.equals(that._token);
    }

    public int hashCode() {
        String s = this._userName;
        s = s + this._realm;
        s = s + this._origUser;
        s = s + this._token;
        return s.hashCode();
    }

    public String toString() {
        String s = this._userName;
        s = s + this._realm;
        s = s + this._origUser;
        s = s + this._token;
        return s;
    }
}

