/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.product.history;

import com.ibm.websphere.product.VersionInfo;
import com.ibm.websphere.product.WASDirectory;
import com.ibm.websphere.product.WASDirectoryException;
import com.ibm.websphere.product.WASProduct;
import com.ibm.websphere.product.formatters.HTMLPrintFormatter;
import com.ibm.websphere.product.formatters.PrintFormatter;
import com.ibm.websphere.product.formatters.TextPrintFormatter;
import com.ibm.websphere.product.history.WASHistory;
import com.ibm.websphere.product.history.xml.enumEventResult;
import com.ibm.websphere.product.history.xml.enumEventType;
import com.ibm.websphere.product.history.xml.enumUpdateAction;
import com.ibm.websphere.product.history.xml.enumUpdateType;
import com.ibm.websphere.product.history.xml.eventHistory;
import com.ibm.websphere.product.history.xml.updateEvent;
import com.ibm.websphere.product.logger.WASDirectoryLogger;
import com.ibm.websphere.product.metadata.WASComponentUpdate;
import com.ibm.websphere.product.metadata.WASMaintenancePackage;
import com.ibm.websphere.product.utils.WASDirectoryHelper;
import com.ibm.websphere.product.utils.WASDirectoryResourceBundleUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Vector;
import java.util.logging.Level;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class HistoryInfo {
    public static final String pgmVersion = "1.7.1.22";
    public static final String pgmUpdate = "8/9/08";
    public static final String TEXT_MODE = "text";
    public static final String HTML_MODE = "html";
    public static final String DEFAULT_REPORT_MODE = "text";
    protected boolean printStack;
    protected WASProduct wasProduct;
    protected WASHistory wasHistory;
    protected WASDirectory wasDirectory;
    protected boolean exceptionThrown = false;
    protected PrintFormatter formatter;
    String updateId;
    String componentName;
    protected static final int[] tableWidths = new int[]{25, 75};
    private static final String S_TIMESTAMP_FORMAT = "yyyy-MM-dd HH:mm:ssZ";
    private static final String S_BACKUP_FILENAME_NA = "not applicable";
    private static final String S_EMPTY_STRING = "";

    protected static String getDefaultedString(String msgCode, String defaultMsg) {
        String msgReturn = WASDirectoryResourceBundleUtils.getHistoryLocaleString(msgCode);
        if (msgReturn.equals(msgCode)) {
            return defaultMsg;
        }
        return msgReturn;
    }

    protected static String getDefaultedString(String msgCode, String defaultMsg, Object[] msgArgs) {
        String rawMessage = HistoryInfo.getDefaultedString(msgCode, defaultMsg);
        return MessageFormat.format(rawMessage, msgArgs);
    }

    protected static String getString(String msgCode) {
        return WASDirectoryResourceBundleUtils.getHistoryLocaleString(msgCode);
    }

    protected static String getString(String msgCode, Object msgArg) {
        return WASDirectoryResourceBundleUtils.getHistoryLocaleString(msgCode, msgArg);
    }

    protected static String getString(String msgCode, Object msgArg1, Object msgArg2) {
        Object[] objectList = new Object[]{msgArg1, msgArg2};
        return WASDirectoryResourceBundleUtils.getHistoryLocaleString(msgCode, objectList);
    }

    protected static String getString(String msgCode, Object[] msgArgs) {
        return WASDirectoryResourceBundleUtils.getHistoryLocaleString(msgCode, msgArgs);
    }

    public static void printCopyright() {
        System.out.println(HistoryInfo.getDefaultedString("WVER0210I", "WVER0210I: Copyright (c) IBM Corporation 2002, 2008; All rights reserved."));
        System.out.println(HistoryInfo.getDefaultedString("WVER0212I", "WVER0212I: HistoryInfo Reporter Version {0}, Dated {1}", new Object[]{pgmVersion, pgmUpdate}));
        System.out.println();
    }

    public static void main(String[] args) {
        HistoryInfo.main(args, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int main(String[] args, boolean allowExit) {
        HistoryInfo.printCopyright();
        boolean isComplete = false;
        String errorArg = null;
        String errorCode = null;
        boolean showHelp = false;
        boolean showUsage = false;
        String format = "text";
        String filename = null;
        boolean printStack = false;
        String updateId = null;
        String componentName = null;
        for (int argNo = 0; !isComplete && argNo < args.length; ++argNo) {
            String nextArg = args[argNo];
            if (nextArg.equalsIgnoreCase("-format")) {
                if (++argNo < args.length) {
                    nextArg = args[argNo];
                    if (nextArg.equalsIgnoreCase("text") || nextArg.equalsIgnoreCase(HTML_MODE)) {
                        format = nextArg;
                        continue;
                    }
                    isComplete = true;
                    errorArg = nextArg;
                    errorCode = "WVER0226E";
                    continue;
                }
                isComplete = true;
                errorArg = nextArg;
                errorCode = "WVER0225E";
                continue;
            }
            if (nextArg.equalsIgnoreCase("-file")) {
                if (++argNo < args.length) {
                    filename = args[argNo];
                    continue;
                }
                isComplete = true;
                errorArg = nextArg;
                errorCode = "WVER0225E";
                continue;
            }
            if (nextArg.equalsIgnoreCase("-maintenancePackageId")) {
                if (++argNo < args.length) {
                    updateId = args[argNo];
                    continue;
                }
                isComplete = true;
                errorArg = nextArg;
                errorCode = "WVER0225E";
                continue;
            }
            if (nextArg.equalsIgnoreCase("-component")) {
                if (++argNo < args.length) {
                    componentName = args[argNo];
                    continue;
                }
                isComplete = true;
                errorArg = nextArg;
                errorCode = "WVER0225E";
                continue;
            }
            if (nextArg.equalsIgnoreCase("-help") || nextArg.equalsIgnoreCase("-?") || nextArg.equalsIgnoreCase("/?") || nextArg.equalsIgnoreCase("/help")) {
                isComplete = true;
                showHelp = true;
                continue;
            }
            if (nextArg.equalsIgnoreCase("-usage")) {
                isComplete = true;
                showUsage = true;
                continue;
            }
            if (nextArg.equalsIgnoreCase("-printStack")) {
                printStack = true;
                continue;
            }
            isComplete = true;
            errorArg = nextArg;
            errorCode = "WVER0228E";
        }
        if (showUsage) {
            System.out.println(HistoryInfo.getString("WVER0230I"));
            if (!allowExit) return 0;
            System.exit(0);
            return -1;
        }
        if (showHelp) {
            System.out.println(HistoryInfo.getString("WVER0231I"));
            if (!allowExit) return 0;
            System.exit(0);
            return -1;
        }
        if (errorArg != null) {
            System.out.println(HistoryInfo.getString(errorCode, errorArg));
            if (!allowExit) return -1;
            System.exit(-1);
            return -1;
        }
        Throwable boundError = null;
        boolean hasErrorOccured = false;
        try {
            HistoryInfo hi = new HistoryInfo();
            hi.setPrintStack(printStack);
            hi.runReport(format, filename, updateId, componentName);
            hasErrorOccured = hi.hasExceptionThrown();
        }
        catch (FileNotFoundException e) {
            boundError = e;
        }
        catch (IOException e) {
            boundError = e;
        }
        catch (Throwable th) {
            boundError = th;
        }
        if (boundError != null) {
            String errorMessage;
            String useFilename = filename == null ? HistoryInfo.getString("label.standard.out") : filename;
            try {
                String exceptionText = boundError.getMessage();
                errorMessage = HistoryInfo.getString("WVER0240E", useFilename, exceptionText);
            }
            catch (Throwable th) {
                errorMessage = HistoryInfo.getString("WVER0241E", new Object[]{useFilename, boundError.getClass().getName(), th.getClass().getName()});
            }
            System.err.println(errorMessage);
            if (printStack) {
                boundError.printStackTrace();
            }
            if (!allowExit) return -1;
            System.exit(-1);
            return -1;
        }
        if (hasErrorOccured) {
            if (!allowExit) return -1;
            System.exit(-1);
            return -1;
        } else {
            if (!allowExit) return 0;
            System.exit(0);
        }
        return -1;
    }

    public HistoryInfo() {
        this.setPrintStack(false);
        this.clearSource();
        this.clearFormatter();
        this.clearUpdateId();
        this.clearComponentName();
    }

    protected void setPrintStack(boolean printStack) {
        this.printStack = printStack;
    }

    protected boolean getPrintStack() {
        return this.printStack;
    }

    protected boolean setSource() {
        this.wasProduct = new WASProduct();
        this.wasHistory = new WASHistory();
        return VersionInfo.handleErrors(this.wasProduct, this.wasHistory, System.err, this.getPrintStack());
    }

    protected WASProduct getProduct() {
        return this.wasProduct;
    }

    protected WASHistory getHistory() {
        return this.wasHistory;
    }

    protected void clearSource() {
        this.wasHistory = null;
        this.wasProduct = null;
        this.wasDirectory = null;
    }

    protected boolean setWASDirectory() throws FileNotFoundException, IOException, ParserConfigurationException, SAXException, WASDirectoryException {
        String installRoot = WASDirectoryHelper.getInstallRootPath();
        if (this.getPrintStack()) {
            WASDirectoryLogger.getWASDirectoryLogger(installRoot, Level.FINEST);
        }
        this.wasDirectory = new WASDirectory();
        return true;
    }

    protected void setFormatter(String format, PrintWriter out) {
        if (format == null || !format.equalsIgnoreCase("text") && !format.equalsIgnoreCase(HTML_MODE)) {
            format = "text";
        }
        this.formatter = format.equalsIgnoreCase(HTML_MODE) ? new HTMLPrintFormatter() : new TextPrintFormatter();
        this.formatter.setPrintWriter(out);
    }

    protected PrintFormatter getFormatter() {
        return this.formatter;
    }

    protected void clearFormatter() {
        this.formatter = null;
    }

    protected void setUpdateId(String updateId) {
        this.updateId = updateId;
    }

    protected String getUpdateId() {
        return this.updateId;
    }

    protected void clearUpdateId() {
        this.updateId = null;
    }

    protected void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    protected String getComponentName() {
        return this.componentName;
    }

    protected void clearComponentName() {
        this.componentName = null;
    }

    protected boolean eventIsOfInterest(updateEvent event2) {
        String useUpdateId = this.getUpdateId();
        String useComponentName = this.getComponentName();
        if (useUpdateId != null && !event2.getId().equals(useUpdateId)) {
            return false;
        }
        if (useComponentName != null) {
            boolean sawMatch = false;
            int numSubEvents = event2.getUpdateEventCount();
            for (int subEventNo = 0; !sawMatch && subEventNo < numSubEvents; ++subEventNo) {
                updateEvent nextSubEvent = event2.getUpdateEvent(subEventNo);
                sawMatch = this.componentEventIsOfInterest(nextSubEvent);
            }
            if (!sawMatch) {
                return false;
            }
        }
        return true;
    }

    protected boolean componentEventIsOfInterest(updateEvent event2) {
        String useComponentName = this.getComponentName();
        boolean result = useComponentName == null || event2.getId().equals(useComponentName);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runReport(String format, String filename, String updateId, String componentName) throws FileNotFoundException, IOException {
        if (filename == null) {
            this.runReport(format, System.out, updateId, componentName);
        } else {
            FileOutputStream out = new FileOutputStream(filename);
            try {
                this.runReport(format, out, updateId, componentName);
            }
            finally {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runReport(String format, OutputStream out, String updateId, String componentName) {
        PrintWriter writer = new PrintWriter(out);
        try {
            this.runReport(format, writer, updateId, componentName);
        }
        finally {
            writer.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runReport(String format, PrintWriter out, String updateId, String componentName) {
        this.setFormatter(format, out);
        this.setUpdateId(updateId);
        this.setComponentName(componentName);
        try {
            if (this.setWASDirectory() && this.setSource()) {
                this.printReport();
            }
        }
        catch (Exception e) {
            this.exceptionThrown = true;
            out.close();
            this.printException(e, System.err, this.getPrintStack());
        }
        finally {
            this.clearSource();
            this.clearComponentName();
            this.clearUpdateId();
            this.clearFormatter();
        }
    }

    protected boolean hasExceptionThrown() {
        return this.exceptionThrown;
    }

    protected void printReport() throws Exception {
        PrintFormatter useFormatter = this.getFormatter();
        String useUpdateId = this.getUpdateId();
        String useComponentName = this.getComponentName();
        String headerText = useUpdateId == null && useComponentName == null ? HistoryInfo.getString("report.header") : (useUpdateId == null ? HistoryInfo.getString("report.header.component", useComponentName) : (useComponentName == null ? HistoryInfo.getString("report.header.update", useUpdateId) : HistoryInfo.getString("report.header.update.component", useUpdateId, useComponentName)));
        useFormatter.printHeader(headerText);
        this.printTimeStamp();
        this.printSource();
        int numOfInterest = this.printHistory(this.wasDirectory.getHistoryMaintenancePackageList());
        if (numOfInterest == 0) {
            useFormatter.println(S_EMPTY_STRING);
            String warningText = useUpdateId == null && useComponentName == null ? HistoryInfo.getString("warning.no.events") : (useUpdateId == null ? HistoryInfo.getString("warning.no.events.for.component", useComponentName) : (useComponentName == null ? HistoryInfo.getString("warning.no.events.for.update", useUpdateId) : HistoryInfo.getString("warning.no.events.for.update.component", useUpdateId, useComponentName)));
            useFormatter.println(warningText, true);
        }
        useFormatter.blankLine();
        useFormatter.printFooter(HistoryInfo.getString("report.footer"));
    }

    protected void printTimeStamp() {
        PrintFormatter useFormatter = this.getFormatter();
        useFormatter.blankLine();
        useFormatter.println(HistoryInfo.getString("info.report.on", this.getTimeStamp()));
    }

    protected String getTimeStamp() {
        Date dateCurrentDate = new Date(System.currentTimeMillis());
        return DateFormat.getDateTimeInstance(1, 1).format(dateCurrentDate);
    }

    protected String unsub(String innerText, String outerText, String subVariable) {
        int subLoc = outerText.indexOf(innerText);
        if (subLoc == -1) {
            return outerText;
        }
        return outerText.substring(0, subLoc) + subVariable + outerText.substring(subLoc + innerText.length());
    }

    protected void printSource() {
        PrintFormatter useFormatter = this.getFormatter();
        useFormatter.blankLine();
        useFormatter.println(HistoryInfo.getString("info.source"), true);
        useFormatter.separator();
        String productDirName = this.wasDirectory.getWasLocation();
        String versionDirName = WASDirectoryHelper.getVersionDirPath(productDirName);
        String historyDirName = WASDirectoryHelper.getHistoryDirPath(productDirName);
        String dtdDirName = WASDirectoryHelper.getDTDDirPath(productDirName);
        String logDirName = WASDirectoryHelper.getLogDirPath(productDirName);
        String backupDirName = WASDirectoryHelper.getBackupDirPath(productDirName);
        String tmpDirName = WASDirectoryHelper.getTmpDirPath();
        Vector<String[]> table = new Vector<String[]>();
        table.add(new String[]{HistoryInfo.getString("label.product.dir"), productDirName});
        table.add(new String[]{HistoryInfo.getString("label.version.dir"), versionDirName});
        table.add(new String[]{HistoryInfo.getString("label.version.dtd.dir"), dtdDirName});
        table.add(new String[]{HistoryInfo.getString("label.version.log.dir"), logDirName});
        File fileBackupFile = new File(backupDirName);
        if (fileBackupFile.exists()) {
            table.add(new String[]{HistoryInfo.getString("label.version.backup.dir"), backupDirName});
        }
        table.add(new String[]{HistoryInfo.getString("label.version.tmp.dir"), tmpDirName});
        table.add(new String[]{HistoryInfo.getString("label.version.history.dir"), historyDirName});
        int[] allocations = new int[]{25, 75};
        useFormatter.printTable(allocations, table, 0);
    }

    protected int printHistory(eventHistory history) {
        int numOfInterest = 0;
        int numEvents = history.getUpdateEventCount();
        for (int eventNo = 0; eventNo < numEvents; ++eventNo) {
            updateEvent nextEvent = history.getUpdateEvent(eventNo);
            if (!this.eventIsOfInterest(nextEvent)) continue;
            this.printEvent(nextEvent);
            ++numOfInterest;
        }
        return numOfInterest;
    }

    protected String consumeNull(String text) {
        return text == null ? S_EMPTY_STRING : text;
    }

    protected void printEvent(updateEvent event2) {
        PrintFormatter useFormatter = this.getFormatter();
        useFormatter.println(S_EMPTY_STRING);
        useFormatter.println(HistoryInfo.getString("info.event"), true);
        useFormatter.separator();
        Vector table = new Vector();
        String eventIdPrefix = this.fillEventFields(event2, table);
        useFormatter.printTable(tableWidths, table, 0);
        this.printComponentEvents(eventIdPrefix, event2);
    }

    protected void printComponentEvents(String eventIdPrefix, updateEvent event2) {
        int numSubEvents = event2.getUpdateEventCount();
        for (int subEventNo = 0; subEventNo < numSubEvents; ++subEventNo) {
            updateEvent nextSubEvent = event2.getUpdateEvent(subEventNo);
            if (!this.componentEventIsOfInterest(nextSubEvent)) continue;
            this.printComponentEvent(eventIdPrefix, nextSubEvent);
        }
    }

    protected void printComponentEvent(String eventIdPrefix, updateEvent event2) {
        PrintFormatter useFormatter = this.getFormatter();
        useFormatter.blankLine();
        useFormatter.println(HistoryInfo.getString("info.component.event"), 1, true);
        useFormatter.separator(1);
        Vector table = new Vector();
        this.fillComponentEventFields(eventIdPrefix, event2, table);
        useFormatter.printTable(tableWidths, table, 1);
    }

    protected String fillEventFields(updateEvent event2, Vector table) {
        String eventIdPrefix = this.getEventIdPrefix(event2);
        table.add(new Object[]{eventIdPrefix, event2.getId()});
        table.add(new String[]{HistoryInfo.getString("label.action"), this.getEventActionText(event2)});
        table.add(new String[]{HistoryInfo.getString("label.primary.content"), event2.getPrimaryContent()});
        if (!event2.getLogName().equalsIgnoreCase(S_EMPTY_STRING)) {
            table.add(new String[]{HistoryInfo.getString("label.log.file.name"), event2.getLogName()});
        }
        if (event2.getBackupName().equalsIgnoreCase(S_BACKUP_FILENAME_NA)) {
            table.add(new String[]{HistoryInfo.getString("label.backup.file.name"), HistoryInfo.getString("label.backup.file.name.notapplicable")});
        } else if (!event2.getBackupName().equalsIgnoreCase(S_EMPTY_STRING)) {
            table.add(new String[]{HistoryInfo.getString("label.backup.file.name"), event2.getBackupName()});
        }
        table.add(new String[]{HistoryInfo.getString("label.start.time.stamp"), event2.getStartTimeStamp()});
        table.add(new String[]{HistoryInfo.getString("label.result"), this.getEventResultText(event2)});
        String message = event2.getResultMessage();
        if (message == null) {
            message = S_EMPTY_STRING;
        }
        return eventIdPrefix;
    }

    protected void fillComponentEventFields(String eventIdPrefix, updateEvent event2, Vector table) {
        table.add(new Object[]{eventIdPrefix, event2.getParentId()});
        table.add(new String[]{HistoryInfo.getString("label.component.name"), event2.getId()});
        table.add(new String[]{HistoryInfo.getString("label.action"), this.getEventActionText(event2)});
        table.add(new Object[]{HistoryInfo.getString("label.update.type"), this.getUpdateTypeText(event2)});
        table.add(new String[]{HistoryInfo.getString("label.start.time.stamp"), event2.getStartTimeStamp()});
        table.add(new String[]{HistoryInfo.getString("label.result"), this.getEventResultText(event2)});
    }

    protected String getEventIdPrefix(updateEvent event2) {
        enumEventType eventType = event2.getEventTypeAsEnum();
        String labelTag = eventType == enumEventType.EFIX_EVENT_TYPE ? "label.efix.id" : (eventType == enumEventType.PTF_EVENT_TYPE ? "label.ptf.id" : "label.unknown.id");
        return HistoryInfo.getString(labelTag);
    }

    protected String booleanText(boolean value) {
        return HistoryInfo.getString(value ? "label.true" : "label.false");
    }

    protected String getEventActionText(updateEvent event2) {
        enumUpdateAction action = event2.getUpdateActionAsEnum();
        String actionTag = action == enumUpdateAction.INSTALL_UPDATE_ACTION ? "label.install.action" : (action == enumUpdateAction.UNINSTALL_UPDATE_ACTION ? "label.uninstall.action" : (action == enumUpdateAction.SELECTIVE_INSTALL_UPDATE_ACTION ? "label.selective.install.action" : (action == enumUpdateAction.SELECTIVE_UNINSTALL_UPDATE_ACTION ? "label.selective.uninstall.action" : "label.unknown.action")));
        String result = HistoryInfo.getString(actionTag);
        return result;
    }

    protected String getUpdateTypeText(updateEvent event2) {
        enumUpdateType updateType = event2.getUpdateTypeAsEnum();
        String updateTypeTag = updateType == enumUpdateType.ADD_UPDATE_TYPE ? "label.update.add.tag" : (updateType == enumUpdateType.REPLACE_UPDATE_TYPE ? "label.update.replace.tag" : (updateType == enumUpdateType.REMOVE_UPDATE_TYPE ? "label.update.remove.tag" : (updateType == enumUpdateType.PATCH_UPDATE_TYPE ? "label.update.patch.tag" : (updateType == enumUpdateType.COMPOSITE_UPDATE_TYPE ? "label.update.composite.tag" : "label.update.unknown.tag"))));
        return HistoryInfo.getString(updateTypeTag);
    }

    protected String getEventResultText(updateEvent event2) {
        enumEventResult eventResult = event2.getResultAsEnum();
        String eventResultTag = eventResult == enumEventResult.SUCCEEDED_EVENT_RESULT ? "label.result.succeeded.tag" : (eventResult == enumEventResult.FAILED_EVENT_RESULT ? "label.result.failed.tag" : (eventResult == enumEventResult.CANCELLED_EVENT_RESULT ? "label.result.cancelled.tag" : (eventResult == enumEventResult.PARTIALSUCCESS_EVENT_RESULT ? "label.result.partialSuccess.tag" : "label.result.unknown.tag")));
        return HistoryInfo.getString(eventResultTag);
    }

    protected String getActionText(String action) {
        String actionTag = "install".equals(action) ? "label.install.action" : ("uninstall".equals(action) ? "label.uninstall.action" : "label.unknown.action");
        return HistoryInfo.getString(actionTag);
    }

    protected String getResultText(String result) {
        String eventResultTag = "success".equals(result) ? "label.result.succeeded.tag" : ("failure".equals(result) ? "label.result.failed.tag" : ("partialSuccess".equals(result) ? "label.result.partialSuccess.tag" : "label.result.unknown.tag"));
        return HistoryInfo.getString(eventResultTag);
    }

    protected String getUpdateEffectText(String updateEffect) {
        String updateTypeTag = "replace".equals(updateEffect) ? "label.update.replace.tag" : "label.update.unknown.tag";
        return HistoryInfo.getString(updateTypeTag);
    }

    protected void printException(Exception e, PrintStream output, boolean printStack) {
        String errorMessage;
        if (!e.getClass().getName().equals(WASDirectoryException.class.getName())) {
            errorMessage = HistoryInfo.getString("WVER0242E");
            output.println(errorMessage);
        }
        errorMessage = e.getMessage();
        output.println(errorMessage);
        if (printStack) {
            e.printStackTrace(output);
        }
    }

    protected int printHistory(WASMaintenancePackage[] historyMaintenancePackages) {
        int numOfInterest = 0;
        String useUpdateId = this.getUpdateId();
        for (int i = 0; i < historyMaintenancePackages.length; ++i) {
            String mpId = historyMaintenancePackages[i].getMaintenancePackageID();
            if (useUpdateId != null && !useUpdateId.equals(mpId)) continue;
            this.printInstallationEvent(historyMaintenancePackages[i]);
            ++numOfInterest;
        }
        return numOfInterest;
    }

    protected void printInstallationEvent(WASMaintenancePackage mp) {
        PrintFormatter useFormatter = this.getFormatter();
        useFormatter.println(S_EMPTY_STRING);
        useFormatter.println(HistoryInfo.getString("info.event"), true);
        useFormatter.separator();
        Vector<Object[]> table = new Vector<Object[]>();
        table.add(new Object[]{HistoryInfo.getString("label.ptf.id"), mp.getMaintenancePackageID()});
        table.add(new String[]{HistoryInfo.getString("label.action"), this.getActionText(mp.getAction())});
        table.add(new String[]{HistoryInfo.getString("label.primary.content"), mp.getPackageFileName()});
        if (!S_EMPTY_STRING.equalsIgnoreCase(mp.getLogFileName())) {
            table.add(new String[]{HistoryInfo.getString("label.log.file.name"), mp.getLogFileName()});
        }
        if (!S_EMPTY_STRING.equalsIgnoreCase(mp.getBackupFileName())) {
            table.add(new String[]{HistoryInfo.getString("label.backup.file.name"), mp.getBackupFileName()});
        }
        table.add(new String[]{HistoryInfo.getString("label.start.time.stamp"), mp.getTimestamp()});
        table.add(new String[]{HistoryInfo.getString("label.result"), this.getResultText(mp.getResult())});
        useFormatter.printTable(tableWidths, table, 0);
        this.printComponentInstallationEvents(mp.getComponentUpdateList());
    }

    protected void printComponentInstallationEvents(WASComponentUpdate[] componentUpdateList) {
        String useComponentName = this.getComponentName();
        for (int i = 0; i < componentUpdateList.length; ++i) {
            String currentComponentName = componentUpdateList[i].getComponentName();
            if (useComponentName != null && !useComponentName.equals(currentComponentName)) continue;
            this.printComponentInstallationEvent(componentUpdateList[i]);
        }
    }

    protected void printComponentInstallationEvent(WASComponentUpdate componentUpdate2) {
        PrintFormatter useFormatter = this.getFormatter();
        useFormatter.blankLine();
        useFormatter.println(HistoryInfo.getString("info.component.event"), 1, true);
        useFormatter.separator(1);
        Vector<Object[]> table = new Vector<Object[]>();
        table.add(new Object[]{HistoryInfo.getString("label.ptf.id"), componentUpdate2.getMaintenancePackageID()});
        table.add(new String[]{HistoryInfo.getString("label.component.name"), componentUpdate2.getComponentName()});
        table.add(new String[]{HistoryInfo.getString("label.action"), this.getActionText(componentUpdate2.getAction())});
        table.add(new Object[]{HistoryInfo.getString("label.update.type"), this.getUpdateEffectText(componentUpdate2.getUpdateEffect())});
        table.add(new String[]{HistoryInfo.getString("label.start.time.stamp"), componentUpdate2.getTimestamp()});
        table.add(new String[]{HistoryInfo.getString("label.result"), this.getResultText(componentUpdate2.getResult())});
        useFormatter.printTable(tableWidths, table, 1);
    }
}

