/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.pmi.stat;

import com.ibm.websphere.management.statistics.TimeStatistic;
import com.ibm.websphere.pmi.stat.Statistic;
import com.ibm.websphere.pmi.stat.StatisticImpl;

public class TimeStatisticImpl
extends StatisticImpl
implements TimeStatistic {
    private static final long serialVersionUID = 7244686523033373244L;
    protected long count = 0L;
    protected long min = 0L;
    protected long max = 0L;
    protected long total = 0L;
    protected long sumOfSquares = 0L;
    private TimeStatisticImpl baseValue = null;

    public TimeStatisticImpl(int dataId) {
        super(dataId);
    }

    public TimeStatisticImpl(int count, int min, int max, int total, int sumOfSquares, int startTime, int lastSampleTime) {
        super(0);
        this.set(count, min, max, total, sumOfSquares, startTime, lastSampleTime);
    }

    public TimeStatisticImpl(int dataId, long count, long min, long max, long total, long sumOfSquares, long startTime, long lastSampleTime) {
        super(dataId);
        this.set(count, min, max, total, sumOfSquares, startTime, lastSampleTime);
    }

    public TimeStatisticImpl(int id, String name, String unit, String description, long startTime, long lastSampleTime) {
        super(id, name, unit, description, startTime, lastSampleTime);
    }

    public void setDataId(int id) {
        this.id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(long val) {
        if (!this.enabled) {
            return;
        }
        if (!this.sync) {
            if (val > this.max) {
                this.max = val;
            }
            if (this.count > 0L) {
                if (val < this.min) {
                    this.min = val;
                }
            } else {
                this.min = val;
            }
            ++this.count;
            this.total += val;
            this.sumOfSquares += val * val;
        } else {
            Object object = this.syncObj;
            synchronized (object) {
                if (val > this.max) {
                    this.max = val;
                }
                if (this.count > 0L) {
                    if (val < this.min) {
                        this.min = val;
                    }
                } else {
                    this.min = val;
                }
                ++this.count;
                this.total += val;
                this.sumOfSquares += val * val;
            }
        }
    }

    public void set(long count, long min, long max, long total, long sumOfSquares, long startTime, long lastSampleTime) {
        this.count = count;
        this.min = min;
        this.max = max;
        this.total = total;
        this.sumOfSquares = sumOfSquares;
        this.startTime = startTime;
        this.lastSampleTime = lastSampleTime;
    }

    public void reset() {
        this.reset(true);
    }

    public void reset(boolean resetAll) {
        if (resetAll) {
            super.reset();
        }
        this.count = 0L;
        this.total = 0L;
        this.sumOfSquares = 0L;
        this.min = 0L;
        this.max = 0L;
    }

    public long getCount() {
        return this.count;
    }

    public long getTotal() {
        return this.total;
    }

    public double getMean() {
        if (this.count == 0L) {
            return 0.0;
        }
        return (double)this.total * 1.0 / (double)this.count;
    }

    public long getMin() {
        return this.min;
    }

    public long getMax() {
        return this.max;
    }

    public long getTotalTime() {
        return this.total;
    }

    public long getMinTime() {
        return this.min;
    }

    public long getMaxTime() {
        return this.max;
    }

    public long getSumOfSquares() {
        return this.sumOfSquares;
    }

    public void combine(Statistic otherStat) {
        if (!this.validate(otherStat)) {
            return;
        }
        TimeStatisticImpl other = (TimeStatisticImpl)otherStat;
        this.count += other.count;
        this.total += other.total;
        this.sumOfSquares += other.sumOfSquares;
        if (this.min > other.min) {
            this.min = other.min;
        }
        if (this.max < other.max) {
            this.max = other.max;
        }
        if (other.lastSampleTime > this.lastSampleTime) {
            this.lastSampleTime = other.lastSampleTime;
        }
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        StringBuffer ret = new StringBuffer();
        ret.append(indent);
        ret.append("TimeStatisticImpl: ");
        ret.append(super.toString(""));
        ret.append(" min=");
        ret.append(this.min);
        ret.append(" max=");
        ret.append(this.max);
        ret.append(" count=");
        ret.append(this.count);
        ret.append(" total=");
        ret.append(this.total);
        ret.append(" sumOfSquares=");
        ret.append(this.sumOfSquares);
        return ret.toString();
    }

    public void update(Statistic otherStat) {
        if (!this.validate(otherStat)) {
            return;
        }
        TimeStatisticImpl other = (TimeStatisticImpl)otherStat;
        if (this.baseValue == null) {
            this.count = other.getCount();
            this.total = other.getTotal();
            this.sumOfSquares = other.sumOfSquares;
            this.startTime = other.getStartTime();
        } else {
            this.count = other.count - this.baseValue.count;
            this.total = other.total - this.baseValue.total;
            this.sumOfSquares = other.sumOfSquares - this.baseValue.sumOfSquares;
            this.startTime = this.baseValue.lastSampleTime;
        }
        this.min = other.getMin();
        this.max = other.getMax();
        this.lastSampleTime = other.getLastSampleTime();
    }

    public Statistic delta(Statistic otherStat) {
        if (!this.validate(otherStat)) {
            return null;
        }
        TimeStatisticImpl other = (TimeStatisticImpl)otherStat;
        TimeStatisticImpl newData = new TimeStatisticImpl(this.id);
        newData.min = this.min;
        newData.max = this.max;
        newData.count = this.count - other.getCount();
        newData.total = this.total - other.getTotal();
        newData.sumOfSquares = this.sumOfSquares - other.sumOfSquares;
        newData.startTime = this.startTime;
        newData.lastSampleTime = this.lastSampleTime;
        return newData;
    }

    public void resetOnClient(Statistic other) {
        if (other == null) {
            if (this.baseValue == null) {
                this.baseValue = new TimeStatisticImpl(this.id);
            }
            this.baseValue.set(this.count, this.min, this.max, this.total, this.sumOfSquares, this.startTime, this.lastSampleTime);
            this.update(this.baseValue);
        } else if (!this.validate(other)) {
            this.baseValue = (TimeStatisticImpl)other;
            this.update(this.baseValue);
        }
    }

    private boolean validate(Statistic other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof TimeStatisticImpl)) {
            System.out.println("WARNING: wrong data type: must be TimeStatisticImpl");
            return false;
        }
        if (other.getId() != this.id) {
            System.out.println("WARNING: wrong data Id: expect dataId=" + this.id + ", got dataId=" + other.getId());
            return false;
        }
        return true;
    }
}

