/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.models.config.orb.impl;

import com.ibm.websphere.models.config.orb.Interceptor;
import com.ibm.websphere.models.config.orb.LSDConnection;
import com.ibm.websphere.models.config.orb.LSDMode;
import com.ibm.websphere.models.config.orb.ORBPlugin;
import com.ibm.websphere.models.config.orb.ObjectRequestBroker;
import com.ibm.websphere.models.config.orb.OrbFactory;
import com.ibm.websphere.models.config.orb.OrbPackage;
import com.ibm.websphere.models.config.orb.impl.InterceptorImpl;
import com.ibm.websphere.models.config.orb.impl.LSDConnectionImpl;
import com.ibm.websphere.models.config.orb.impl.ORBPluginImpl;
import com.ibm.websphere.models.config.orb.impl.ObjectRequestBrokerImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;

public class OrbFactoryImpl
extends EFactoryImpl
implements OrbFactory {
    public static OrbFactory init() {
        try {
            OrbFactory theOrbFactory = (OrbFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.ibm.com/websphere/appserver/schemas/5.0/orb.xmi");
            if (theOrbFactory != null) {
                return theOrbFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log(exception);
        }
        return new OrbFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createObjectRequestBroker();
            }
            case 1: {
                return this.createORBPlugin();
            }
            case 2: {
                return this.createInterceptor();
            }
            case 3: {
                return this.createLSDConnection();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 4: {
                return this.createLSDModeFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 4: {
                return this.convertLSDModeToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public ObjectRequestBroker createObjectRequestBroker() {
        ObjectRequestBrokerImpl objectRequestBroker = new ObjectRequestBrokerImpl();
        return objectRequestBroker;
    }

    public ORBPlugin createORBPlugin() {
        ORBPluginImpl orbPlugin = new ORBPluginImpl();
        return orbPlugin;
    }

    public Interceptor createInterceptor() {
        InterceptorImpl interceptor = new InterceptorImpl();
        return interceptor;
    }

    public LSDConnection createLSDConnection() {
        LSDConnectionImpl lsdConnection = new LSDConnectionImpl();
        return lsdConnection;
    }

    public LSDMode createLSDModeFromString(EDataType eDataType, String initialValue) {
        LSDMode result = LSDMode.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertLSDModeToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public OrbPackage getOrbPackage() {
        return (OrbPackage)this.getEPackage();
    }

    public static OrbPackage getPackage() {
        return OrbPackage.eINSTANCE;
    }
}

