/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.repository;

import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.RepositoryException;
import com.ibm.websphere.management.repository.ConfigEpoch;
import com.ibm.websphere.management.repository.ConfigRepositoryListener;
import com.ibm.websphere.management.repository.Document;
import com.ibm.websphere.management.repository.DocumentContentSource;
import com.ibm.websphere.management.repository.DocumentDigest;
import com.ibm.websphere.management.repository.ResourceNameFilter;
import java.util.HashMap;
import java.util.Properties;

public interface ConfigRepository {
    public static final int RESOURCE_DOCUMENT = 1;
    public static final int RESOURCE_FOLDER = 2;
    public static final int RESOURCE_ALL = 255;
    public static final int DEPTH_SELF = 0;
    public static final int DEPTH_CURRENT = 1;
    public static final int DEPTH_ONE = 2;
    public static final int DEPTH_FULL = Integer.MAX_VALUE;
    public static final String ROOT_FOLDER = "/";
    public static final String AUDITING_ENABLED_KEY = "auditingEnabled";
    public static final String REPOSITORY_TEMP_DIR_KEY = "was.repository.temp";
    public static final String REPOSITORY_BACKUP_DIR_KEY = "was.repository.backup";
    public static final String REPOSITORY_ROOT_DIR_KEY = "was.repository.root";

    public void initialize(Properties var1) throws AdminException;

    public String[] listResourceNames(String var1, int var2, int var3);

    public String[] listResourceNames(String var1, int var2, int var3, ResourceNameFilter var4);

    public DocumentDigest create(DocumentContentSource var1) throws RepositoryException;

    public DocumentDigest[] create(DocumentContentSource[] var1) throws RepositoryException;

    public void delete(String var1) throws RepositoryException;

    public void delete(Document var1) throws RepositoryException;

    public void delete(String[] var1) throws RepositoryException;

    public void delete(Document[] var1) throws RepositoryException;

    public void rename(String var1, String var2) throws RepositoryException;

    public void rename(Document var1, Document var2) throws RepositoryException;

    public DocumentContentSource extract(String var1) throws RepositoryException;

    public DocumentContentSource extract(Document var1) throws RepositoryException;

    public DocumentContentSource[] extract(String[] var1) throws RepositoryException;

    public DocumentContentSource[] extract(Document[] var1) throws RepositoryException;

    public DocumentDigest modify(DocumentContentSource var1) throws RepositoryException;

    public DocumentDigest[] modify(DocumentContentSource[] var1) throws RepositoryException;

    public HashMap update(DocumentContentSource[] var1, DocumentContentSource[] var2, Document[] var3) throws RepositoryException;

    public DocumentDigest getDigest(String var1) throws RepositoryException;

    public DocumentDigest[] getDigest(String[] var1) throws RepositoryException;

    public Boolean lockRepository(String var1) throws RepositoryException;

    public Boolean unlockRepository(String var1) throws RepositoryException;

    public Properties getConfig();

    public void addListener(ConfigRepositoryListener var1);

    public void removeListener(ConfigRepositoryListener var1);

    public ConfigEpoch getRepositoryEpoch();

    public ConfigEpoch refreshRepositoryEpoch();

    public void createDigestFile(String var1, boolean var2) throws RepositoryException;
}

