/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.cmdframework.provider;

import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commanddata.CommandStepData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandStepMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.AbstractCommandStep;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandProviderHelper;
import java.util.List;
import org.eclipse.emf.common.util.EList;

public abstract class CommandProvider {
    public AbstractAdminCommand createCommand(CommandMetadata metadata2) throws CommandNotFoundException {
        throw new CommandNotFoundException(metadata2.getName());
    }

    public AbstractAdminCommand loadCommand(CommandData cmdData) throws CommandNotFoundException, CommandLoadException {
        throw new CommandNotFoundException(cmdData.getName());
    }

    public List initCommandMetadata(List metadata2) {
        return metadata2;
    }

    public AbstractCommandStep createCommandStep(AbstractTaskCommand taskCmd, String stepName) throws CommandNotFoundException {
        throw new CommandNotFoundException(taskCmd.getName(), stepName);
    }

    public AbstractCommandStep loadCommandStep(AbstractTaskCommand taskCmd, CommandStepData stepData) throws CommandNotFoundException, CommandLoadException {
        throw new CommandNotFoundException(taskCmd.getName(), stepData.getName());
    }

    public int commandStepPosition(AbstractTaskCommand taskCmd, String stepName) {
        return -1;
    }

    protected CommandProviderHelper getCommandProviderHelper() {
        CommandMgr cmdMgr = CommandMgr.getCommandMgr();
        return cmdMgr.getCommandProviderHelper();
    }

    protected CommandStepMetadata getStepMetadata(AbstractTaskCommand taskCmd, String stepName) {
        EList steps = taskCmd.getTaskCommandMetadata().getSteps();
        CommandStepMetadata stepMetadata = null;
        for (CommandStepMetadata thisMetadata : steps) {
            if (!thisMetadata.getName().equals(stepName)) continue;
            stepMetadata = thisMetadata;
        }
        return stepMetadata;
    }
}

