/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.application.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.application.client.AppDeploymentController;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentMessages;
import com.ibm.websphere.management.application.client.AppDeploymentTaskInfo;
import com.ibm.ws.management.application.client.util;
import com.ibm.ws.management.connector.interop.JMXVersionValidation;
import com.ibm.ws.management.util.RasUtils;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AppDeploymentTask
implements Serializable {
    private static final long serialVersionUID = -2021644844665692021L;
    private static final TraceComponent tc = Tr.register(AppDeploymentTask.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String CLASS_NAME;
    public static final int VERSION_HIGHEST = 999999;
    public static final String HIGHEST_VERSION;
    protected transient AppDeploymentController appController;
    protected String name = null;
    protected boolean isTaskEmpty = false;
    protected boolean isSufficientlyDone = true;
    protected boolean isTaskDisabled = false;
    protected boolean isValidationEnabled = true;
    protected String[][] taskData = null;
    protected String[] colNames = null;
    protected String[] taskValidateErrorMessages = null;
    protected boolean[] mutables = null;
    protected boolean[] requiredColumns = null;
    protected boolean[] hiddenColumns = null;
    protected boolean hasHiddenColumns = false;

    public AppDeploymentTask(AppDeploymentController controller) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", "controller=" + controller);
        }
        this.appController = controller;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public AppDeploymentController getAppDeploymentController() {
        return this.appController;
    }

    public void setAppDeploymentController(AppDeploymentController controller) {
        this.appController = controller;
    }

    public String getName() {
        return this.name;
    }

    public String[] getColumnNames() {
        return this.colNames;
    }

    public boolean isTaskEmpty() {
        return this.isTaskEmpty;
    }

    public boolean isTaskDisabled() {
        return this.isTaskDisabled;
    }

    public void setIsTaskDisabled(boolean taskDisabled) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setIsTaskDisabled", "taskDisabled=" + taskDisabled);
        }
        this.isTaskDisabled = taskDisabled;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setIsTaskDisabled");
        }
    }

    public boolean isSufficientlyDone() {
        return this.isSufficientlyDone;
    }

    public void setIsSufficientlyDone(boolean sufficientlyDone) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setIsSufficientlyDone", "sufficientlyDone=" + sufficientlyDone);
        }
        this.isSufficientlyDone = sufficientlyDone;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setIsSufficientlyDone");
        }
    }

    public boolean[] getMutableColumns() {
        return this.mutables;
    }

    public boolean isMutableColumn(int index) {
        boolean result = false;
        if (this.mutables != null && index >= 0 && index < this.mutables.length) {
            result = this.mutables[index];
        }
        return result;
    }

    @Deprecated
    public boolean getMutableColumns(int index) {
        return this.isMutableColumn(index);
    }

    public boolean[] getRequiredColumns() {
        return this.requiredColumns;
    }

    @Deprecated
    public boolean isRequiredColumn(int index) {
        boolean result = false;
        if (this.requiredColumns != null && index >= 0 && index < this.requiredColumns.length) {
            result = this.requiredColumns[index];
        }
        return result;
    }

    @Deprecated
    public boolean getRequiredColumns(int index) {
        return this.isRequiredColumn(index);
    }

    public boolean isHiddenColumn(int index) {
        boolean result = false;
        if (this.hasHiddenColumns && this.hiddenColumns != null && index >= 0 && index < this.hiddenColumns.length) {
            result = this.hiddenColumns[index];
        }
        return result;
    }

    public boolean isValidationEnabled() {
        return this.isValidationEnabled;
    }

    public void setValidationEnabled(boolean status) {
        this.isValidationEnabled = status;
    }

    public String[][] getTaskData() {
        String[][] data = null;
        if (this.taskData != null) {
            data = new String[this.taskData.length][];
            for (int i = 0; i < this.taskData.length; ++i) {
                data[i] = new String[this.taskData[i].length];
                for (int j = 0; j < this.taskData[i].length; ++j) {
                    data[i][j] = this.taskData[i][j];
                }
            }
        }
        return data;
    }

    public void setTaskData(String[][] data) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTaskData", "data=" + data);
        }
        this.verifyTaskData(data);
        if (this.taskData != null && this.appController != null) {
            this.appController.getDependencyTask(this.name);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setTaskData");
        }
    }

    protected void verifyTaskData(String[][] data) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "verifyTaskData", "data=" + data);
        }
        this.taskData = data;
        if (this.taskData == null) {
            this.isTaskEmpty = true;
            this.isSufficientlyDone = true;
        } else {
            this.isTaskEmpty = false;
            this.isSufficientlyDone = true;
            for (int i = 0; i < this.taskData.length; ++i) {
                if (this.taskData[i].length != this.colNames.length) {
                    this.isSufficientlyDone = false;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "verifyTaskData", "wrong task data format; colNames.length=" + this.colNames.length + ", taskData[" + i + "].length=" + this.taskData[i].length);
                    }
                    String pattern = util.getMessage(this, "ADMA0015E");
                    String message = MessageFormat.format(pattern, Integer.toString(this.taskData.length));
                    throw new AppDeploymentException(message, null);
                }
                for (int j = 0; this.isSufficientlyDone && j < this.taskData[i].length; ++j) {
                    if (!this.mutables[j] || !this.requiredColumns[j] || this.taskData[i][j] != null && !this.taskData[i][j].trim().equals("")) continue;
                    this.isSufficientlyDone = false;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "verifyTaskData");
        }
    }

    public String[] validate() {
        return null;
    }

    protected void buildErrorMessages(Vector<String> errors) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "buildErrorMessages", "errors=" + errors);
        }
        this.taskValidateErrorMessages = null;
        if (errors != null && errors.size() > 0) {
            this.taskValidateErrorMessages = new String[errors.size()];
            for (int i = 0; i < errors.size(); ++i) {
                this.taskValidateErrorMessages[i] = errors.elementAt(i);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "buildErrorMessages");
        }
    }

    public AppDeploymentMessages getTaskMessages() {
        AppDeploymentTaskInfo taskInfo;
        AppDeploymentMessages taskMessages = null;
        if (this.appController != null && (taskInfo = this.appController.getTaskInfo(this.name)) != null) {
            taskMessages = taskInfo.appMessages;
        }
        return taskMessages;
    }

    public String getCallerVersion() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCallerVersion");
        }
        String callerVersion = HIGHEST_VERSION;
        if (this.appController != null && (this.appController.getDeploymentMode() & 0x110L) != 0L && AdminServiceFactory.getAdminService() != null) {
            JMXVersionValidation jmxVersionValidation = new JMXVersionValidation();
            String clientVersion = jmxVersionValidation.getClientVersion();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getCallerVersion", "clientVersion=" + clientVersion);
            }
            if (clientVersion != null) {
                String clientMajorVersion = null;
                int index = clientVersion.indexOf(46);
                clientMajorVersion = index < 0 ? clientVersion : clientVersion.substring(0, index);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getCallerVersion", "clientMajorVersion=" + clientMajorVersion);
                }
                callerVersion = clientMajorVersion;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCallerVersion", callerVersion);
        }
        return callerVersion;
    }

    public int getClientMajorVersion() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClientMajorVersion");
        }
        int clientMajorVersion = 999999;
        String callerVersion = this.getCallerVersion();
        try {
            clientMajorVersion = Integer.valueOf(callerVersion);
        }
        catch (NumberFormatException e) {
            RasUtils.logException((Throwable)e, tc, CLASS_NAME, "getClientMajorVersion", "595", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClientMajorVersion", Integer.toString(clientMajorVersion));
        }
        return clientMajorVersion;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append('@');
        stringBuilder.append(Integer.toHexString(this.hashCode()));
        stringBuilder.append("[appController=");
        stringBuilder.append(this.appController);
        stringBuilder.append(", name=");
        stringBuilder.append(this.name);
        stringBuilder.append(", isTaskEmpty=");
        stringBuilder.append(this.isTaskEmpty);
        stringBuilder.append(", isSufficientlyDone=");
        stringBuilder.append(this.isSufficientlyDone);
        stringBuilder.append(", isTaskDisabled=");
        stringBuilder.append(this.isTaskDisabled);
        stringBuilder.append(", isValidationEnabled=");
        stringBuilder.append(this.isValidationEnabled);
        stringBuilder.append(", hasHiddenColumns=");
        stringBuilder.append(this.hasHiddenColumns);
        stringBuilder.append(", colNames=");
        stringBuilder.append(Arrays.toString(this.colNames));
        stringBuilder.append(", mutables=");
        stringBuilder.append(Arrays.toString(this.mutables));
        stringBuilder.append(", requiredColumns=");
        stringBuilder.append(Arrays.toString(this.requiredColumns));
        stringBuilder.append(", hiddenColumns=");
        stringBuilder.append(Arrays.toString(this.hiddenColumns));
        stringBuilder.append(", taskValidateErrorMessages=");
        stringBuilder.append(Arrays.toString(this.taskValidateErrorMessages));
        stringBuilder.append(", taskData=");
        stringBuilder.append(Arrays.toString((Object[])this.taskData));
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/websphere/management/application/client/AppDeploymentTask.java, WAS.admin.installapp.client, WAS70.SERV1, q0834.18, ver. 1.19");
        }
        CLASS_NAME = AppDeploymentTask.class.getName();
        HIGHEST_VERSION = Integer.toString(999999);
    }
}

