/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.application;

import com.ibm.ejs.models.base.extensions.ejbext.ContainerManagedEntityExtension;
import com.ibm.ejs.models.base.extensions.ejbext.EJBJarExtension;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.application.AppManagementExtensions;
import com.ibm.websphere.management.application.EarUtils;
import com.ibm.websphere.management.application.Scheduler;
import com.ibm.websphere.management.application.client.AppDeploymentController;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.management.application.AppAssociation;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.DefaultTaskProvider;
import com.ibm.ws.management.application.EditApplication;
import com.ibm.ws.management.application.ExtensionHelper;
import com.ibm.ws.management.application.client.AppInstallHelper;
import com.ibm.ws.management.application.client.util;
import com.ibm.ws.management.application.j2ee.deploy.spi.TargetModuleIDImpl;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.management.tools.UnmanagedNode;
import com.ibm.ws.management.util.RasUtils;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.wsspi.runtime.config.ConfigObject;
import com.ibm.wsspi.runtime.config.ConfigService;
import com.ibm.wsspi.runtime.config.ConfigServiceFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.client.ApplicationClient;
import org.eclipse.jst.j2ee.common.EnvEntry;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ApplicationClientFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EJBJarFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.RARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.WARFile;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.Entity;
import org.eclipse.jst.j2ee.jca.Connector;
import org.eclipse.jst.j2ee.webapplication.WebApp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppDeploymentUtil {
    private static TraceComponent tc = Tr.register(AppDeploymentUtil.class, null, "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String CLASS_NAME;
    private static int[][] versionTable;
    private static int[][] JCAVersionTable;
    public static final Integer BAD_VERSION;
    public static final String APPDEPL_SYSTEM_APP2_FLAG = "META-INF/ibm-application-sa2.props";
    private static final String[] keys;
    private static final int[] keyI;

    public static Hashtable getNodeVersionForAppTargets(Hashtable servertbl, RepositoryContext cellContext, WorkSpace ws) throws AdminException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getNodeVersionForAppTargets: " + servertbl);
        }
        Hashtable tbl = new Hashtable();
        if (servertbl == null || servertbl.size() == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "appValidation: empty mod2svr table");
            }
            return tbl;
        }
        Enumeration keys = servertbl.keys();
        Session session = new Session(ws.getUserName(), true);
        while (keys.hasMoreElements()) {
            try {
                String key = (String)keys.nextElement();
                String targets = (String)servertbl.get(key);
                Vector v = AppAssociation.getServerNames(targets, key, false, cellContext, ws);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, targets + " = " + v);
                }
                Hashtable svrtbl = AppDeploymentUtil.getNodeVersionForAppTargets(v, cellContext.getName(), ws);
                tbl.putAll(svrtbl);
            }
            catch (AdminException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                throw new AdminException(ex, null);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNodeVersionForAppTargets: " + tbl);
        }
        return tbl;
    }

    public static Hashtable getNodeVersionForAppTargets(Vector v, String cellName, WorkSpace ws) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNodeVersionForAppTargets: v=" + v + ",cellName=" + cellName + ",ws=" + ws);
        }
        Hashtable tbl = new Hashtable();
        if (v == null || v.size() == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getNodeVersionForAppTargets: empty server list");
            }
            return tbl;
        }
        try {
            Session session = new Session(ws.getUserName(), true);
            for (int i = 0; i < v.size(); ++i) {
                RepositoryContext ctx = (RepositoryContext)v.elementAt(i);
                ObjectName on = ConfigRepoHelper.getObjectName(ctx);
                if (tbl.get(on) != null) continue;
                ArrayList<String> l = new ArrayList<String>();
                if (AppUtils.isServer(ctx)) {
                    l.add(ctx.getParent().getName());
                    String nodeMajorVersion = AppUtils.getNodeMajorVersion(session, cellName, ctx.getParent().getName());
                    l.add(nodeMajorVersion);
                    if (Integer.parseInt(nodeMajorVersion) >= 6) {
                        l.add(AppUtils.getNodeMinorVersion(session, cellName, ctx.getParent().getName()));
                        l.add(AppUtils.getNodeEJB3FeaturePackProductShortName(session, cellName, ctx.getParent().getName()));
                    } else {
                        l.add("No Minor Version");
                        l.add("No EJB3 FEP");
                    }
                } else {
                    Vector<RepositoryContext> clTarget = new Vector<RepositoryContext>();
                    clTarget.add(ctx);
                    Hashtable nodeTable = ConfigRepoHelper.getNodeServerRelation(ws, clTarget);
                    Enumeration nodes = nodeTable.keys();
                    while (nodes.hasMoreElements()) {
                        RepositoryContext nodeCtx = (RepositoryContext)nodes.nextElement();
                        l.add(nodeCtx.getName());
                        String nodeMajorVersion = AppUtils.getNodeMajorVersion(session, cellName, nodeCtx.getName());
                        l.add(nodeMajorVersion);
                        if (Integer.parseInt(nodeMajorVersion) >= 6) {
                            l.add(AppUtils.getNodeMinorVersion(session, cellName, nodeCtx.getName()));
                            l.add(AppUtils.getNodeEJB3FeaturePackProductShortName(session, cellName, nodeCtx.getName()));
                            continue;
                        }
                        l.add("No Minor Version");
                        l.add("No EJB3 FEP");
                    }
                }
                tbl.put(on, l);
            }
        }
        catch (Throwable ex) {
            if (ex instanceof AdminException) {
                throw (AdminException)ex;
            }
            throw new AdminException(ex, null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNodeVersionForAppTargets: " + tbl);
        }
        return tbl;
    }

    public static Vector appValidation(AppDeploymentController controller, String cellName, WorkSpace ws) throws AdminException {
        Hashtable servertbl;
        Vector messages;
        block9: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "appValidation ");
            }
            messages = new Vector();
            servertbl = new Hashtable();
            try {
                servertbl = controller.getServerTable();
            }
            catch (AppDeploymentException ex) {
                if (!tc.isDebugEnabled()) break block9;
                Tr.debug(tc, "Exception when calling getServerTable: " + ex);
            }
        }
        if (servertbl == null || servertbl.size() == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "appValidation: empty mod2svr table");
            }
            return messages;
        }
        try {
            int earVersion = controller.getAppVersion();
            int appVersion = controller.getAppVersion(true);
            List options = controller.getSelectedOptions();
            int rarVersion = controller.getRarVersion();
            Tr.debug(tc, "earVersion: " + earVersion + " appversion: " + appVersion + " rarVersion: " + rarVersion);
            RepositoryContext cellContext = AppUtils.findContext("cells", cellName, null, null, ws, true);
            Tr.debug(tc, "cellc " + cellContext);
            Hashtable tbl = AppDeploymentUtil.getNodeVersionForAppTargets(servertbl, cellContext, ws);
            messages = AppDeploymentUtil.appValidation(rarVersion, earVersion, appVersion, options, tbl);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "appValidation");
            }
            return messages;
        }
        catch (AdminException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new AdminException(ex, null);
        }
    }

    public static Vector appValidation(int rarVersion, int earVersion, int appVersion, List options, Hashtable targetnodeVersionTable) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "appValidation ");
        }
        Vector messages = new Vector();
        Tr.debug(tc, "earVersion: " + earVersion + " appVersion: " + appVersion + " rarVersion: " + rarVersion);
        int lowestSupportedNode = AppDeploymentUtil.getLowestSupportedNodeVersion(appVersion);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "lowest node: " + lowestSupportedNode);
        }
        ArrayList<String> failedNodes = new ArrayList<String>();
        String failedNodeVersion = null;
        Enumeration keys = targetnodeVersionTable.keys();
        while (keys.hasMoreElements()) {
            List l = (List)targetnodeVersionTable.get(keys.nextElement());
            for (int i = 0; i < l.size(); i += 4) {
                String nodeName = (String)l.get(i);
                int nodeVersion = Integer.parseInt((String)l.get(i + 1));
                if (nodeVersion >= lowestSupportedNode || failedNodes.contains(nodeName)) continue;
                failedNodes.add(nodeName);
                failedNodeVersion = (String)l.get(i + 1);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "failed nodes: " + failedNodes + " version: " + failedNodeVersion);
        }
        Vector<String> appMessages = new Vector<String>();
        String error = null;
        if (failedNodes.size() > 0) {
            error = earVersion < appVersion && options.size() > 0 ? AppUtils.getMessage(AppUtils.getBundle(null), "ADMA0111E", new String[]{options.toString(), ((Object)failedNodes).toString(), failedNodeVersion}) : AppUtils.getMessage(AppUtils.getBundle(null), "ADMA0110E", new String[]{Integer.toString(appVersion), ((Object)failedNodes).toString(), failedNodeVersion});
            appMessages.addElement(error);
        }
        messages.addAll(appMessages);
        if (tc.isEntryEnabled()) {
            Tr.debug(tc, "messages = " + messages);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "appValidation");
        }
        return messages;
    }

    public static Vector appValidation(int rarVersion, int earVersion, int appVersion, List options, Hashtable targetnodeVersionTable, EARFile earFile, String sessionId) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "appValidation ");
        }
        Vector messages = new Vector();
        Tr.debug(tc, "earVersion: " + earVersion + " appVersion: " + appVersion + " rarVersion: " + rarVersion);
        Tr.debug(tc, "targetnodeVersionTable: " + targetnodeVersionTable);
        int lowestSupportedNode = AppDeploymentUtil.getLowestSupportedNodeVersion(appVersion);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "lowest node: " + lowestSupportedNode);
        }
        boolean allowOnlyLatestNodeVersion = AppDeploymentUtil.allowOnlyLatestNodeVersion(options);
        boolean earHas25WebModules = AppDeploymentUtil.checkWeb25Modules(earFile);
        boolean earHas30EJBModules = AppDeploymentUtil.checkEJB3Modules(earFile);
        boolean autoLink = options.contains("useAutoLink");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "allowOnlyLatestNodeVersion: " + allowOnlyLatestNodeVersion + ",earHasWeb25Modules: " + earHas25WebModules + ",earHasEJB3Modules: " + earHas30EJBModules + ",autoLinkEnable: " + autoLink);
        }
        ArrayList failedNodes = new ArrayList();
        ArrayList failedNodeVersion = new ArrayList();
        AppDeploymentUtil.validateTargetsNode(targetnodeVersionTable, allowOnlyLatestNodeVersion, earHas25WebModules, earHas30EJBModules, autoLink, lowestSupportedNode, failedNodes, failedNodeVersion, sessionId);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "failed nodes: " + failedNodes + " version: " + failedNodeVersion);
        }
        Vector<String> appMessages = new Vector<String>();
        String error = null;
        if (failedNodes.size() > 0) {
            error = earVersion < appVersion && options.size() > 0 ? AppUtils.getMessage(AppUtils.getBundle(null), "ADMA0111E", new String[]{options.toString(), ((Object)failedNodes).toString(), ((Object)failedNodeVersion).toString()}) : (autoLink ? AppUtils.getMessage(AppUtils.getBundle(null), "ADMA0148E", new String[]{Integer.toString(appVersion), ((Object)failedNodes).toString(), ((Object)failedNodeVersion).toString()}) : AppUtils.getMessage(AppUtils.getBundle(null), "ADMA0110E", new String[]{Integer.toString(appVersion), ((Object)failedNodes).toString(), ((Object)failedNodeVersion).toString()}));
            appMessages.addElement(error);
        }
        messages.addAll(appMessages);
        if (tc.isEntryEnabled()) {
            Tr.debug(tc, "messages = " + messages);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "appValidation");
        }
        return messages;
    }

    public static Vector appValidation(int rarVersion, int earVersion, int appVersion, List options, Hashtable targetnodeVersionTable, EARFile earFile, Hashtable currentTargetNodeVersionTable, Archive module, String sessionId) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "appValidation ");
        }
        Vector messages = new Vector();
        Tr.debug(tc, "earVersion: " + earVersion + " appVersion: " + appVersion + " rarVersion: " + rarVersion);
        Tr.debug(tc, "targetnodeVersionTable: " + targetnodeVersionTable);
        Tr.debug(tc, "currentTargetNodeVersionTable: " + currentTargetNodeVersionTable);
        Hashtable allTargetNodeVersionTable = new Hashtable();
        allTargetNodeVersionTable.putAll(targetnodeVersionTable);
        boolean allowOnlyLatestNodeVersion = AppDeploymentUtil.allowOnlyLatestNodeVersion(module, options);
        boolean hasWeb25Modules = AppDeploymentUtil.checkWeb25Modules(earFile) || AppDeploymentUtil.isWeb25Module(module);
        boolean hasEJB3Modules = AppDeploymentUtil.checkEJB3Modules(earFile) || AppDeploymentUtil.isEJB3Module(module);
        boolean autoLink = options.contains("useAutoLink");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "allowOnlyLatestNodeVersion: " + allowOnlyLatestNodeVersion + " ,hasWeb25Modules: " + hasWeb25Modules + " ,hasEJB3Modules: " + hasEJB3Modules + " ,isAutoLink: " + autoLink);
        }
        if (hasWeb25Modules || hasEJB3Modules) {
            allTargetNodeVersionTable.putAll(currentTargetNodeVersionTable);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "reconcile targetnodeVersionTable: " + allTargetNodeVersionTable);
            }
        }
        int latestVersionNode = versionTable[versionTable.length - 1][1];
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "latest node: " + latestVersionNode);
        }
        int lowestSupportedNode = AppDeploymentUtil.getLowestSupportedNodeVersion(appVersion);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "lowest node: " + lowestSupportedNode);
        }
        ArrayList failedNodes = new ArrayList();
        ArrayList failedNodeVersion = new ArrayList();
        AppDeploymentUtil.validateTargetsNode(allTargetNodeVersionTable, allowOnlyLatestNodeVersion, hasWeb25Modules, hasEJB3Modules, autoLink, lowestSupportedNode, failedNodes, failedNodeVersion, sessionId);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "failed nodes: " + failedNodes + " version: " + failedNodeVersion);
        }
        Vector<String> appMessages = new Vector<String>();
        String error = null;
        if (failedNodes.size() > 0) {
            error = allowOnlyLatestNodeVersion && options.size() > 0 ? AppUtils.getMessage(AppUtils.getBundle(null), "ADMA0111E", new String[]{options.toString(), ((Object)failedNodes).toString(), ((Object)failedNodeVersion).toString()}) : AppUtils.getMessage(AppUtils.getBundle(null), "ADMA0110E", new String[]{Integer.toString(appVersion), ((Object)failedNodes).toString(), ((Object)failedNodeVersion).toString()});
            appMessages.addElement(error);
        }
        messages.addAll(appMessages);
        if (tc.isEntryEnabled()) {
            Tr.debug(tc, "messages = " + messages);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "appValidation");
        }
        return messages;
    }

    private static void validateTargetsNode(Hashtable targetnodeVersionTable, boolean allowOnlyLatestNodeVersion, boolean earHas25WebModules, boolean earHas30EJBModules, boolean autoLink, int lowestSupportedNode, List failedNodes, List failedNodeVersion, String sessionId) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateTargetsNode", new Object[]{targetnodeVersionTable, allowOnlyLatestNodeVersion, earHas25WebModules, earHas30EJBModules, autoLink, lowestSupportedNode, failedNodes, failedNodeVersion, sessionId});
        }
        List lstUnNode = new ArrayList();
        lstUnNode = UnmanagedNode.listManagedNodes((Session)new Session(sessionId, true));
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "List of managed nodes: ", lstUnNode);
        }
        Enumeration keys = targetnodeVersionTable.keys();
        while (keys.hasMoreElements()) {
            String target;
            Object key = keys.nextElement();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "key=", key);
            }
            if (!AppUtils.isWebServerType(target = key.toString(), sessionId)) {
                List lstData = (List)targetnodeVersionTable.get(key);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "lstData =", lstData);
                }
                for (int i = 0; i < lstData.size(); i += 4) {
                    String nodeName = (String)lstData.get(i);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "nodeName: " + nodeName);
                    }
                    int nodeVersion = Integer.parseInt((String)lstData.get(i + 1));
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "nodeVersion: " + nodeVersion);
                    }
                    String EJB3FEPNode = (String)lstData.get(i + 3);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "nodeFEPShortName: " + EJB3FEPNode);
                    }
                    if (lstUnNode == null || lstUnNode.contains(nodeName)) {
                        if (allowOnlyLatestNodeVersion) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "app need to be target on latest node");
                            }
                            if (nodeVersion >= lowestSupportedNode || failedNodes.contains(nodeName)) continue;
                            failedNodes.add(nodeName);
                            failedNodeVersion.add(lstData.get(i + 1));
                            continue;
                        }
                        if (earHas25WebModules) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "app or update module has 2.5 Web");
                            }
                            if (nodeVersion >= 7 || failedNodes.contains(nodeName)) continue;
                            failedNodes.add(nodeName);
                            failedNodeVersion.add(lstData.get(i + 1));
                            continue;
                        }
                        if (earHas30EJBModules) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "app or update module has 3.0 Ejb");
                            }
                            if (nodeVersion >= 7 || nodeVersion == 6 && "EJB 3.0".equals(EJB3FEPNode) || failedNodes.contains(nodeName)) continue;
                            failedNodes.add(nodeName);
                            failedNodeVersion.add(lstData.get(i + 1));
                            continue;
                        }
                        if (autoLink) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "auto link enable");
                            }
                            if (nodeVersion >= 7 || nodeVersion == 6 && "EJB 3.0".equals(EJB3FEPNode) || failedNodes.contains(nodeName)) continue;
                            failedNodes.add(nodeName);
                            failedNodeVersion.add(lstData.get(i + 1));
                            continue;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "none of the above condition");
                        }
                        if (nodeVersion >= lowestSupportedNode || failedNodes.contains(nodeName)) continue;
                        failedNodes.add(nodeName);
                        failedNodeVersion.add(lstData.get(i + 1));
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Skipping Unmanaged Node: " + nodeName);
                }
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Skipping validation for web server type: " + key);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateTargetsNode", new Object[]{failedNodes, failedNodeVersion});
        }
    }

    private static void concatException(AdminException ex, StringBuffer b) {
        if (ex == null) {
            return;
        }
        b.append("\n" + ex.getMessage());
        Throwable th = ex.getCause();
        if (th == null) {
            return;
        }
        if (th instanceof AdminException) {
            AppDeploymentUtil.concatException((AdminException)th, b);
        } else {
            b.append("\n" + th.toString());
        }
    }

    private static int getLowestSupportedNodeVersion(int appVersion) {
        for (int i = 0; i < versionTable.length; ++i) {
            if (appVersion != versionTable[i][0]) continue;
            return versionTable[i][1];
        }
        return Integer.MAX_VALUE;
    }

    public static Vector MDBValidation(Hashtable targetVersionTable, Hashtable servertbl, AppDeploymentTask mdbTask) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "MDBValidation ");
        }
        Vector<String> messages = new Vector<String>();
        String[][] taskData = mdbTask.getTaskData();
        String[] colNames = mdbTask.getColumnNames();
        int col = colNames.length;
        int uriCol = -1;
        int listenerPortCol = -1;
        int ejbModuleCol = -1;
        int ejbCol = -1;
        for (int mm = 0; mm < col; ++mm) {
            if ("uri".equals(colNames[mm])) {
                uriCol = mm;
            }
            if ("listenerPort".equals(colNames[mm])) {
                listenerPortCol = mm;
            }
            if ("EJBModule".equals(colNames[mm])) {
                ejbModuleCol = mm;
            }
            if (!"EJB".equals(colNames[mm])) continue;
            ejbCol = mm;
        }
        if (taskData != null) {
            for (int i = 1; i < taskData.length; ++i) {
                String moduleURI = util.getModuleUriFromUriString(taskData[i][uriCol]);
                Enumeration en = servertbl.keys();
                while (en.hasMoreElements()) {
                    String key = (String)en.nextElement();
                    Tr.debug(tc, "key: " + key);
                    String moduleDD = util.getModuleURIFromUniqueName(key);
                    if (!moduleURI.equals(moduleDD)) continue;
                    Enumeration en1 = targetVersionTable.keys();
                    while (en1.hasMoreElements()) {
                        List l = (List)targetVersionTable.get(en1.nextElement());
                        for (int j = 0; j < l.size(); j += 4) {
                            String nodeName = (String)l.get(j);
                            int nodeVersion = Integer.parseInt((String)l.get(j + 1));
                            Tr.debug(tc, "Node: " + nodeName + " version:" + nodeVersion);
                            if (nodeVersion != 5 || taskData[i][listenerPortCol] != null && !taskData[i][listenerPortCol].trim().equals("")) continue;
                            String error = AppUtils.getMessage(AppUtils.getBundle(null), "ADMA0001E", new String[]{mdbTask.getName(), taskData[i][ejbCol], taskData[i][ejbModuleCol]});
                            messages.addElement(error);
                        }
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "MDBValidation ");
        }
        return messages;
    }

    public static Vector validateLightweightEJBs(EARFile earFile, Hashtable targetNodes) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateLightweightEJBs");
        }
        Vector<String> messages = new Vector<String>();
        if (AppDeploymentUtil.isNodeVersionPriorTo61(targetNodes)) {
            EList list = earFile.getDeploymentDescriptor().getModules();
            block0: for (Module module : list) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "module: " + module);
                }
                if (!module.isEjbModule()) continue;
                EJBJarExtension ejbext = (EJBJarExtension)earFile.getExtensions(module);
                EJBJar jar = ejbext.getEjbJar();
                List lst = jar.getContainerManagedBeans();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "list of ContainerManagedBeans: " + lst + ", size: " + lst.size());
                }
                for (int j = 0; j < lst.size(); ++j) {
                    Entity b = (Entity)lst.get(j);
                    ContainerManagedEntityExtension cx = (ContainerManagedEntityExtension)ejbext.getEJBExtension(b);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "ContainerManagedEntityExtension: " + cx);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "isSetLightweightLocal: " + cx.isSetLightweightLocal());
                    }
                    if (!cx.isSetLightweightLocal()) continue;
                    String error = AppUtils.getMessage(AppUtils.getBundle(null), "ADMA9002E", new String[]{module.getUri()});
                    messages.addElement(error);
                    continue block0;
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "messages = " + messages);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateLightweightEJBs");
        }
        return messages;
    }

    private static boolean isNodeVersionPriorTo61(Hashtable targetNodes) throws Exception {
        boolean ret = false;
        Enumeration keys = targetNodes.keys();
        block0: while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            List l = (List)targetNodes.get(key);
            Tr.debug(tc, "targets node version: " + l);
            for (int i = 0; i < l.size(); i += 4) {
                String nodeName = (String)l.get(i);
                int nodeMajorVersion = Integer.parseInt((String)l.get(i + 1));
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Node: " + nodeName + ", major version " + nodeMajorVersion);
                }
                if (nodeMajorVersion > 6) continue;
                if (nodeMajorVersion <= 5) {
                    ret = true;
                    continue block0;
                }
                int nodeMinorVersion = Integer.parseInt((String)l.get(i + 2));
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Node: " + nodeName + ", minor version " + nodeMinorVersion);
                }
                if (nodeMajorVersion != 6 || nodeMinorVersion >= 1) continue;
                ret = true;
                continue block0;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "is node version prior to 6.1: " + ret);
        }
        return ret;
    }

    public static List listSystemApps(Repository repo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listSystemApps");
        }
        ArrayList<String> l = new ArrayList<String>();
        try {
            List lstContentObj;
            ConfigService cfgService = ConfigServiceFactory.createConfigService(repo.getRootURI(), repo.getCellName(), repo.getNodeName(), null);
            try {
                lstContentObj = cfgService.getDocumentObjects(cfgService.getScope(3), "systemapps.xml");
            }
            catch (FileNotFoundException ex) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "no systemapps.xml available");
                }
                return l;
            }
            Vector v = AppUtils.listSystemApps(lstContentObj);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "list of System Apps : ", v);
            }
            if (v != null) {
                l.addAll(v);
            }
            List siDocObj = cfgService.getDocumentObjects(cfgService.getScope(3), "serverindex.xml");
            List entries = ((ConfigObject)siDocObj.get(0)).getObjectList("serverEntries");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "serverindex.xml  entires : " + entries);
            }
            for (int i = 0; i < entries.size(); ++i) {
                ConfigObject entry = (ConfigObject)entries.get(i);
                List depls = entry.getStringList("deployedApplications");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "deployedApplications list : " + depls);
                }
                for (int j = 0; j < depls.size(); ++j) {
                    File f;
                    String depl = (String)depls.get(j);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "depl : " + depl);
                    }
                    if ((f = new File(cfgService.getScope(0).getAbsolutePath("applications/" + depl + "/" + APPDEPL_SYSTEM_APP2_FLAG))).exists()) {
                        l.add(depl.substring(depl.lastIndexOf("/") + 1));
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, depl + " doesn't have ibm-application-sa2.props file.");
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SystemApp List after sa2 search: " + l);
            }
        }
        catch (Throwable th) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "error getting system app xml " + th);
            }
            RasUtils.logException(th, tc, CLASS_NAME, "listSystemApps", "808");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listSystemApps: " + l);
        }
        return l;
    }

    public static String getTargetName(String serverName, String node, String cell, boolean isCluster) {
        if (isCluster) {
            return "WebSphere:cluster=" + serverName + ",j2eeType=" + "J2EEServer" + ",cell=" + cell;
        }
        return "WebSphere:server=" + serverName + ",j2eeType=" + "J2EEServer" + ",node=" + node + ",cell=" + cell;
    }

    public static String getModuleID(String name, String type) {
        StringBuffer id = new StringBuffer();
        id.append("WebSphere:name=");
        id.append(name);
        id.append(",type=");
        id.append(type);
        return id.toString();
    }

    public static TargetModuleIDImpl createTargetMod(String name, String type, Target target, TargetModuleID parent) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTargetMod: " + name + ", " + type + ", " + target);
        }
        TargetModuleIDImpl targetMod = new TargetModuleIDImpl();
        targetMod.setTarget(target);
        targetMod.setWebURL(null);
        String m_id = AppDeploymentUtil.getModuleID(name, type);
        targetMod.setModuleID(m_id);
        targetMod.setObjectName(new ObjectName(m_id + ",*"));
        targetMod.setModuleType(type);
        if (parent != null) {
            targetMod.setParentTargetModuleID(parent);
            targetMod.setChildTargetModuleID(null);
        } else {
            targetMod.setParentTargetModuleID(null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createTargetMod: " + name + ", " + type + ", " + target);
        }
        return targetMod;
    }

    public static String[][] getFilePermissionOptions(Hashtable props) {
        String[][] opts = new String[keys.length][2];
        ResourceBundle bundle = AppUtils.getBundle(props);
        for (int i = 0; i < keys.length; ++i) {
            opts[i][0] = AppUtils.getMessage(bundle, keys[i]);
            opts[i][1] = keys[i];
        }
        return opts;
    }

    public static String getFilePermissionString(List l) {
        String retVal = "";
        int total = 0;
        for (int i = 0; i < keys.length; ++i) {
            if (!l.contains(keys[i])) continue;
            total |= keyI[i];
        }
        switch (total) {
            case 1: {
                retVal = ".*=755";
                break;
            }
            case 16: {
                retVal = ".*\\.dll=755#.*\\.so=755#.*\\.a=755#.*\\.sl=755";
                break;
            }
            case 17: {
                retVal = ".*=755";
                break;
            }
            case 256: {
                retVal = ".*\\.htm=755#.*\\.html=755#.*\\.gif=755#.*\\.jpg=755#.*\\.pdf=755";
                break;
            }
            case 257: {
                retVal = ".*=755";
                break;
            }
            case 272: {
                retVal = ".*\\.dll=755#.*\\.so=755#.*\\.a=755#.*\\.sl=755#.*\\.htm=755#.*\\.html=755#.*\\.gif=755#.*\\.jpg=755#.*\\.pdf=755";
                break;
            }
            case 273: {
                retVal = ".*=755";
            }
        }
        return retVal;
    }

    public static Vector envEntryValidation(EARFile earfile, ResourceBundle res) {
        Vector messages = new Vector();
        EList modules = earfile.getDeploymentDescriptor().getModules();
        for (int i = 0; i < modules.size(); ++i) {
            Module module = (Module)modules.get(i);
            try {
                EObject moduleDD = earfile.getDeploymentDescriptor(module);
                String uri = module.getUri() + "," + moduleDD.eResource().getURI();
                ArrayList envEntries = null;
                if (module.isEjbModule()) {
                    EJBJar ejbjar = (EJBJar)moduleDD;
                    EList ejbs = ejbjar.getEnterpriseBeans();
                    envEntries = new ArrayList();
                    for (EnterpriseBean ejb : ejbs) {
                        ArrayList envProps = new ArrayList(ejb.getEnvironmentProperties());
                        envEntries.addAll(envProps);
                    }
                } else if (module.isWebModule()) {
                    envEntries = new ArrayList(((WebApp)moduleDD).getEnvironmentProperties());
                } else if (module.isJavaModule()) {
                    envEntries = new ArrayList(((ApplicationClient)moduleDD).getEnvironmentProps());
                }
                Vector msgs = AppDeploymentUtil.validateEnvEntry(envEntries, uri, res);
                messages.addAll(msgs);
                continue;
            }
            catch (Throwable th) {
                Tr.info(tc, AppUtils.getMessage(res, "ADMA0196I", new String[]{module.getUri(), th.getMessage()}));
            }
        }
        return messages;
    }

    public static Vector validateEnvEntry(List _envEntries, String uri, ResourceBundle res) {
        Vector<String> messages = new Vector<String>();
        if (_envEntries != null && _envEntries.size() > 0) {
            EnvEntry[] envEntries = _envEntries.toArray(new EnvEntry[_envEntries.size()]);
            for (int i = 0; i < envEntries.length; ++i) {
                String name = envEntries[i].getName();
                String value = envEntries[i].getValue();
                if (value != null) continue;
                String error = AppUtils.getMessage(res, "ADMA0195W", new String[]{uri, name});
                messages.add(error);
            }
        }
        return messages;
    }

    public static List getTargetNodes(Scheduler sch, String moduleURI, String ddURI) {
        Hashtable mod2svr;
        if (tc.isEntryEnabled()) {
            Tr.debug(tc, "getTargetNodess : " + moduleURI + " dd = " + ddURI);
        }
        if ((mod2svr = (Hashtable)sch.getProperties().get("moduleToServer")) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getTargetNodes");
            }
            return new ArrayList();
        }
        String targets = AppDeploymentUtil.getTargets(mod2svr, util.createUniqueModuleName(ddURI, moduleURI), moduleURI);
        if (targets == null || targets.trim().length() == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getTargetNodes: no targets");
            }
            return new ArrayList();
        }
        Hashtable nodeVersionTable = (Hashtable)sch.getProperties().get("nodeVersionTable");
        if (nodeVersionTable == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getTargetNodes: no nodeVerTable");
            }
            return new ArrayList();
        }
        String[] tArray = targets.split("\\+");
        ArrayList retVal = new ArrayList();
        for (int i = 0; i < tArray.length; ++i) {
            try {
                ObjectName on = new ObjectName(tArray[i]);
                List l = (List)nodeVersionTable.get(on);
                if (l == null) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "ERROR:: list in nodeversiontable can not be null for key:" + on);
                    continue;
                }
                for (int j = 0; j < l.size(); j += 4) {
                    retVal.add(l.get(j));
                }
                continue;
            }
            catch (Throwable th) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Malformed object name: " + tArray[i]);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.debug(tc, "getTargetNodes: " + retVal);
        }
        return retVal;
    }

    private static String getTargets(Hashtable tbl, String key, String mURI) {
        String targets = (String)tbl.get(key);
        if (targets != null) {
            return targets;
        }
        int index = mURI.lastIndexOf(46);
        if (index != -1 && (targets = (String)tbl.get("*" + mURI.substring(index))) != null) {
            return targets;
        }
        targets = (String)tbl.get("*");
        if (targets != null) {
            return targets;
        }
        return null;
    }

    public static void isNodeValidForCluster(String cellName, String nodeName, String clusterName, String workspaceID, Locale locale, List errors) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.debug(tc, "isApplicationDeployable: " + nodeName + ", " + clusterName);
        }
        Hashtable<String, Locale> props = new Hashtable<String, Locale>();
        props.put("app.client.locale", locale);
        ResourceBundle bundle = AppUtils.getBundle(props);
        Vector v = EditApplication.listApplications("WebSphere:cell=" + cellName + ",cluster=" + clusterName, props, workspaceID);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "apps are : " + v);
        }
        Vector<DefaultTaskProvider> vHelpers = new Vector<DefaultTaskProvider>();
        try {
            ExtensionHelper.provideValidationExtensions(vHelpers);
        }
        catch (Throwable th) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "error getting validation extensions: " + th);
            }
            RasUtils.logException(th, tc, CLASS_NAME, "isNodeValidForCluster", "1107");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "validation helpers: " + vHelpers);
        }
        WorkSpace ws = null;
        try {
            ws = ConfigRepoHelper.getWorkSpace(workspaceID);
            int nodeVersion = Integer.parseInt(AppUtils.getNodeMajorVersion(cellName, nodeName));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "node version: " + nodeVersion);
            }
            Session session = new Session(ws.getUserName(), true);
            String EJB3FEPNode = AppUtils.getNodeEJB3FeaturePackProductShortName(session, cellName, nodeName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "nodeEJBFEPShortName: " + EJB3FEPNode);
            }
            for (int i = 0; i < v.size(); ++i) {
                vHelpers.add(new DefaultTaskProvider());
                String appName = (String)v.elementAt(i);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Handling app: " + appName);
                }
                RepositoryContext appC = AppUtils.findAppContextFromConfig(appName, ws, props);
                EARFile ear = null;
                try {
                    ear = ConfigRepoHelper.getEarFileForApp(ws, appC, bundle, true);
                }
                catch (Throwable th) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "error getting ear: " + th);
                    }
                    RasUtils.logException(th, tc, CLASS_NAME, "isNodeValidForCluster", "1141");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ear = " + ear);
                }
                if (ear == null) continue;
                int appVersion = EarUtils.getAppVersionForDeployment((EARFile)ear);
                int lowestSupportedNode = AppDeploymentUtil.getLowestSupportedNodeVersion(appVersion);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "appV: " + appVersion + ", lowest node: " + lowestSupportedNode);
                }
                if (AppDeploymentUtil.checkWeb25Modules(ear)) {
                    if (nodeVersion >= 7) {
                        AppDeploymentUtil.checkExtensions(vHelpers, nodeName, clusterName, appName, ear, workspaceID, locale, errors);
                        continue;
                    }
                    errors.add(AppUtils.getMessage(bundle, "ADMA0111E", new String[]{"" + appVersion, nodeName, "" + nodeVersion}));
                } else if (AppDeploymentUtil.checkEJB3Modules(ear)) {
                    if (nodeVersion >= 7 || nodeVersion == 6 && "EJB 3.0".equals(EJB3FEPNode)) {
                        AppDeploymentUtil.checkExtensions(vHelpers, nodeName, clusterName, appName, ear, workspaceID, locale, errors);
                        continue;
                    }
                    errors.add(AppUtils.getMessage(bundle, "ADMA0111E", new String[]{"" + appVersion, nodeName, "" + nodeVersion}));
                } else if (nodeVersion < lowestSupportedNode) {
                    errors.add(AppUtils.getMessage(bundle, "ADMA0111E", new String[]{"" + appVersion, nodeName, "" + nodeVersion}));
                } else {
                    AppDeploymentUtil.checkExtensions(vHelpers, nodeName, clusterName, appName, ear, workspaceID, locale, errors);
                }
                if (ear == null) continue;
                ear.close();
            }
        }
        catch (Throwable th) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "error in isNodeValidForCluster: " + th);
            }
            RasUtils.logException(th, tc, CLASS_NAME, "isNodeValidForCluster", "1183");
            if (th instanceof AdminException) {
                throw (AdminException)th;
            }
            throw new AdminException(th);
        }
    }

    private static void checkExtensions(Vector vHelpers, String nodeName, String clusterName, String appName, EARFile ear, String workspaceID, Locale locale, List errors) throws Exception {
        for (int j = 0; j < vHelpers.size(); ++j) {
            Object o = vHelpers.elementAt(j);
            if (!(o instanceof AppManagementExtensions.AppValidationHelper2)) continue;
            AppManagementExtensions.AppValidationHelper2 vh = (AppManagementExtensions.AppValidationHelper2)o;
            vh.isApplicationDeployable(nodeName, clusterName, appName, ear, workspaceID, locale, errors);
        }
    }

    public static boolean isEE5SchemaDD(Module module, Archive archive) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "module=" + module + ",archive=" + archive);
        }
        EARFile earFile = (EARFile)archive;
        ModuleFile mFile = earFile.getModuleRef(module).getModuleFile();
        return AppDeploymentUtil.isEE5SchemaDD(mFile);
    }

    public static boolean isEE5SchemaDD(ModuleFile moduleFile) {
        boolean ret;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isEE5SchemaDD", new Object[]{moduleFile});
        }
        boolean bl = ret = AppDeploymentUtil.getModuleVersion(moduleFile) == 50;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isEE5SchemaDD", new Object[]{new Boolean(ret)});
        }
        return ret;
    }

    public static int getModuleVersion(ModuleFile moduleFile) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getModuleVersion", new Object[]{moduleFile});
        }
        int version = 14;
        if (moduleFile == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "moduleFile is null, return default version " + version);
            }
            return version;
        }
        if (moduleFile.isEJBJarFile()) {
            EJBJarFile ejbJarFile = (EJBJarFile)moduleFile;
            EJBJar dd = ejbJarFile.getDeploymentDescriptor();
            if (dd != null) {
                version = dd.getJ2EEVersionID();
            } else {
                version = 50;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No dd for ejb module. Assuming it is a ee5 module");
                }
            }
        } else if (moduleFile.isWARFile()) {
            WARFile warFile = (WARFile)moduleFile;
            WebApp dd = warFile.getDeploymentDescriptor();
            if (dd != null) {
                version = dd.getJ2EEVersionID();
            } else {
                version = 50;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No dd for web module. Assuming it is a ee5 module");
                }
            }
        } else if (moduleFile.isApplicationClientFile()) {
            ApplicationClientFile appClientFile = (ApplicationClientFile)moduleFile;
            ApplicationClient dd = appClientFile.getDeploymentDescriptor();
            if (dd != null) {
                version = dd.getJ2EEVersionID();
            } else {
                version = 50;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No dd for client module. Assuming it is a ee5 module");
                }
            }
        } else if (moduleFile.isRARFile()) {
            RARFile rarFile = (RARFile)moduleFile;
            Connector dd = rarFile.getDeploymentDescriptor();
            version = dd.getVersionID();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version " + version);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getModuleVersion");
        }
        return version;
    }

    public Hashtable<String, List<ObjectName>> getActivationPlanForV6SysApp(String binURLExpanded) throws AdminException {
        File propFile;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getActivationPlanForV6SysApp: " + binURLExpanded);
        }
        Hashtable<String, List<ObjectName>> ret = new Hashtable<String, List<ObjectName>>();
        String path = binURLExpanded;
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        path = path + "META-INF/ibm-application-runtime.props";
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "prop file: " + path);
        }
        if (!(propFile = new File(path)).exists()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "prop file does not exist");
            }
        } else {
            FileInputStream fin = null;
            try {
                fin = new FileInputStream(propFile);
                Properties props = new Properties();
                props.load(fin);
                Enumeration<Object> ee = props.keys();
                while (ee.hasMoreElements()) {
                    String key = (String)ee.nextElement();
                    if (!key.startsWith("com.ibm.ws.runtime.components.")) continue;
                    String value = props.getProperty(key);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "key = " + key + ", val = " + value);
                    }
                    String modUri = key.substring("com.ibm.ws.runtime.components.".length());
                    String[] vals = value.split("\\+");
                    ArrayList<ObjectName> list = new ArrayList<ObjectName>();
                    for (String val : vals) {
                        list.add(new ObjectName(val));
                    }
                    ret.put(key, list);
                }
            }
            catch (Throwable th) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "exception processing props file for activation plan: " + th);
                }
                RasUtils.logException(th, tc, CLASS_NAME, "getActivationPlanForV6SysApp", "1333", this);
                if (th instanceof AdminException) {
                    throw (AdminException)th;
                }
                throw new AdminException(th);
            }
            finally {
                block23: {
                    if (fin != null) {
                        try {
                            fin.close();
                        }
                        catch (IOException ioex) {
                            if (!tc.isDebugEnabled()) break block23;
                            Tr.debug(tc, "exception closing props: " + ioex);
                        }
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getActivationPlanForV6SysApp: " + ret);
        }
        return ret;
    }

    public static EObject getDeploymentDescriptorXMLOnly(AppDeploymentInfo appDeployInfo, EObject mergedDeploymentDescriptor) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDeploymentDescriptorXMLOnly", new Object[]{appDeployInfo, mergedDeploymentDescriptor});
        }
        EObject xmlDeploymentDescriptor = mergedDeploymentDescriptor;
        ModuleFile mFile = appDeployInfo.getModuleFileForDD(mergedDeploymentDescriptor);
        if (AppDeploymentUtil.isEE5SchemaDD(mFile)) {
            if (mFile instanceof WARFile) {
                xmlDeploymentDescriptor = ((WARFile)mFile).getDeploymentDescriptor(false);
            } else if (mFile instanceof EJBJarFile) {
                xmlDeploymentDescriptor = ((EJBJarFile)mFile).getDeploymentDescriptor(false);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDeploymentDescriptorXMLOnly", new Object[]{xmlDeploymentDescriptor});
        }
        return xmlDeploymentDescriptor;
    }

    public static boolean checkWeb25Modules(EARFile earFile) throws Exception {
        boolean ret = false;
        if (earFile == null) {
            return ret;
        }
        try {
            AppDeploymentInfo info = AppInstallHelper.getAppDeploymentInfo(earFile);
            return AppDeploymentUtil.checkWeb25Modules(info);
        }
        catch (Exception ex) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception in checkWeb25Modules");
            }
            return ret;
        }
    }

    private static boolean checkWeb25Modules(AppDeploymentInfo info) throws Exception {
        boolean hasWeb25Modules = false;
        if (info == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "AppDeploymentInfo is null");
            }
            return hasWeb25Modules;
        }
        Vector web25Wars = info.getModuleConfig("WEB25WAR_DD");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "web25Wars: " + web25Wars);
        }
        if (web25Wars != null && web25Wars.size() > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ear has web2.5: " + web25Wars.size());
            }
            hasWeb25Modules = true;
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, info.getAppDisplayName() + " doesn't have any WEB 2.5 modules!!!!");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "hasWeb25Modules: " + hasWeb25Modules);
        }
        return hasWeb25Modules;
    }

    public static boolean checkEJB3Modules(EARFile earFile) throws Exception {
        boolean ret;
        block3: {
            ret = false;
            if (earFile == null) {
                return ret;
            }
            try {
                AppDeploymentInfo info = AppInstallHelper.getAppDeploymentInfo(earFile);
                ret = AppDeploymentUtil.checkEJB3Modules(info);
            }
            catch (Exception ex) {
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug(tc, "Exception in checkEJB3Modules");
            }
        }
        return ret;
    }

    private static boolean checkEJB3Modules(AppDeploymentInfo info) throws Exception {
        boolean hasEJB30Modules = false;
        if (info == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "AppDeploymentInfo is null");
            }
            return hasEJB30Modules;
        }
        Vector ejbJars = info.getModuleConfig("EJB3JAR_DD");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ejbJars: " + ejbJars);
        }
        if (ejbJars != null && ejbJars.size() > 0) {
            if (ejbJars != null && ejbJars.size() > 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ear has ejb3: " + ejbJars.size());
                }
                hasEJB30Modules = true;
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, info.getAppDisplayName() + " doesn't have any EJB 3.0 modules!!!!");
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "hasEJB30Modules: " + hasEJB30Modules);
        }
        return hasEJB30Modules;
    }

    private static boolean allowOnlyLatestNodeVersion(List options) {
        boolean ret = false;
        if (options != null && options.size() > 0 && (options.contains("deployejb") || options.contains("preCompileJSPs") || options.contains("enhancedEar") || options.contains("deployws") || options.contains("useMetaDataFromBinary"))) {
            ret = true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "allowOnlyLatestNodeVersion: " + ret);
        }
        return ret;
    }

    private static boolean allowOnlyLatestNodeVersion(Archive archive, List options) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "archive: " + archive + ",option: " + options);
        }
        boolean ret = false;
        if (options != null && options.size() > 0) {
            if (archive instanceof EJBJarFile) {
                if (options.contains("deployejb")) {
                    ret = true;
                }
            } else if (archive instanceof WARFile && (options.contains("preCompileJSPs") || options.contains("deployws"))) {
                ret = true;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "allowOnlyLatestNodeVersion: " + ret);
        }
        return ret;
    }

    private static boolean isEJB3Module(Archive archive) throws Exception {
        boolean isEJB3Mod = false;
        if (archive instanceof EJBJarFile) {
            EJBJarFile ejar = (EJBJarFile)archive;
            isEJB3Mod = AppDeploymentUtil.isEE5SchemaDD(ejar);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "isEJB3Mod " + isEJB3Mod);
        }
        return isEJB3Mod;
    }

    private static boolean isWeb25Module(Archive archive) throws Exception {
        boolean isWeb25Mod = false;
        if (archive instanceof WARFile) {
            WARFile war = (WARFile)archive;
            isWeb25Mod = AppDeploymentUtil.isEE5SchemaDD(war);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "isWeb25Mod " + isWeb25Mod);
        }
        return isWeb25Mod;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/websphere/management/application/AppDeploymentUtil.java, WAS.admin.installapp, WAS70.SERV1, q0834.18, ver. 1.21.1.15");
        }
        CLASS_NAME = AppDeploymentUtil.class.getName();
        versionTable = new int[][]{{12, 5}, {13, 5}, {14, 6}, {50, 7}};
        JCAVersionTable = new int[][]{{12, 10, 0}, {13, 10, 0}, {14, 10, 15}, {50, 10, 15}};
        BAD_VERSION = new Integer(0);
        keys = new String[]{"filepermission.option.allr", "filepermission.option.dlle", "filepermission.option.weba"};
        keyI = new int[]{1, 16, 256};
    }
}

