/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management;

import com.ibm.ISecurityUtilityImpl.RealmSecurityName;
import com.ibm.ISecurityUtilityImpl.StringBytesConversion;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.exception.InvalidAdminClientTypeException;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.auth.callback.NonPromptCallbackHandler;
import com.ibm.websphere.security.auth.callback.WSCcacheCallBackHandlerImpl;
import com.ibm.websphere.security.auth.callback.WSGUICallbackHandlerImpl;
import com.ibm.websphere.security.auth.callback.WSStdinCallbackHandlerImpl;
import com.ibm.ws.management.AdminDataHolder;
import com.ibm.ws.management.connector.NullConnector;
import com.ibm.ws.management.util.DebugUtils;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SecurityContext;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.SSLConfig;
import java.awt.GraphicsEnvironment;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationHandler;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.swing.JFrame;

public abstract class AdminClientFactory {
    private static final String bundleName = "com.ibm.ws.management.resources.connector";
    private static TraceComponent tc = Tr.register(AdminClientFactory.class, "Admin", "com.ibm.ws.management.resources.connector");
    private static final TraceNLS connectorNLS = TraceNLS.getTraceNLS("com.ibm.ws.management.resources.connector");
    private static final String SOAP_PROXY_CLASS = "com.ibm.ws.management.connector.soap.SOAPConnectorClient";
    private static final String RMI_PROXY_CLASS = "com.ibm.ws.management.connector.rmi.RMIConnectorClient";
    private static final String JSR160RMI_PROXY_CLASS = "com.ibm.ws.management.connector.jsr160rmi.JSR160RMIConnectorClient";
    private static final String IPC_PROXY_CLASS = "com.ibm.ws.management.connector.ipc.IPCConnectorClient";
    private static final String ADMIN_CLIENT_IMPL_CLASS = "com.ibm.ws.management.AdminClientImpl";
    private static final String ADMIN_SERVICE_PROXY_CLASS = "com.ibm.ws.management.connector.AdminServiceProxy";
    private static WebSphereRuntimePermission adminPermission = new WebSphereRuntimePermission("AdminPermission");
    private static Class thisClass = AdminClientFactory.class;
    private static Hashtable cachedClients = new Hashtable();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static AdminClient createAdminClient(Properties props) throws ConnectorException {
        if (AdminClientFactory.tc.isEntryEnabled()) {
            Tr.entry(AdminClientFactory.tc, "createAdminClient");
        }
        if (AdminClientFactory.tc.isDebugEnabled()) {
            Tr.debug(AdminClientFactory.tc, "Properties passed to createAdminClient");
        }
        AdminClientFactory.showDebugInfo(props);
        client = null;
        if (SecurityContext.isServerProcess() && (sm = System.getSecurityManager()) != null) {
            sm.checkPermission(AdminClientFactory.adminPermission);
        }
        if ((type = (String)props.get("type")) == null) {
            if (AdminClientFactory.tc.isEntryEnabled()) {
                Tr.exit(AdminClientFactory.tc, "createAdminClient");
            }
            throw new InvalidAdminClientTypeException();
        }
        originalException = null;
        cacheKey = AdminClientFactory.getCacheKey(type, props);
        var5_5 = AdminClientFactory.cachedClients;
        synchronized (var5_5) {
            client = (AdminClient)AdminClientFactory.cachedClients.get(cacheKey);
        }
        if (client != null) {
            if (AdminClientFactory.tc.isDebugEnabled()) {
                Tr.debug(AdminClientFactory.tc, "Cached admin client found");
            }
            try {
                userid = (String)props.get("username");
                password = (String)props.get("password");
                if (!SecurityContext.isServerProcess() && ("RMI".equalsIgnoreCase(type) || "JSR160RMI".equalsIgnoreCase(type)) && userid != null && userid.trim().length() > 0 && password != null && password.trim().length() > 0) {
                    subject = SubjectHelper.createBasicAuthSubject(null, userid, password);
                    SecurityContext.getContextManager().setInvocationSubject(subject);
                    client.getConnectorProperties().put("username", userid);
                    client.getConnectorProperties().put("password", password);
                }
                client.isAlive();
                if (AdminClientFactory.tc.isEntryEnabled()) {
                    Tr.exit(AdminClientFactory.tc, "createAdminClient - in cache");
                }
                return client;
            }
            catch (Exception ex) {
                if (AdminClientFactory.tc.isDebugEnabled()) {
                    Tr.debug(AdminClientFactory.tc, "invalid cached client, try to recreate", ex);
                }
                password = AdminClientFactory.cachedClients;
                synchronized (password) {
                    AdminClientFactory.cachedClients.remove(cacheKey);
                }
                client = null;
            }
        }
        secEnabled = false;
        if (type.equalsIgnoreCase("NULL")) {
            client = AdminClientFactory.createNullConnectorClient(props);
        } else if (type.equalsIgnoreCase("SOAP")) {
            propsFromFile = null;
            if (!new Boolean(props.getProperty("isInternal")).booleanValue()) {
                soapURL = props.getProperty("com.ibm.SOAP.ConfigURL");
                if (soapURL == null) {
                    soapURL = System.getProperty("com.ibm.SOAP.ConfigURL");
                }
                if (soapURL == null) {
                    installRoot = System.getProperty("user.install.root");
                    if (installRoot == null) {
                        installRoot = System.getProperty("was.install.root");
                    }
                    soapURL = "file:" + installRoot + "/properties/soap.client.props";
                }
                if (soapURL != null) {
                    url = soapURL;
                    propsFromFile = (Properties)com.ibm.ws.security.util.AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            Properties props = AdminClientFactory.loadPropertiesFromFile(url);
                            return props;
                        }
                    });
                }
            }
            if ((secEnabledStr = props.getProperty("securityEnabled")) == null && propsFromFile != null) {
                secEnabledStr = propsFromFile.getProperty("securityEnabled");
                soapSslAlias = propsFromFile.getProperty("com.ibm.ssl.alias");
                if (soapSslAlias != null) {
                    propsFromFile.setProperty("sslConfig", soapSslAlias);
                }
                if (soapSslAlias == null) {
                    propsFromFile.setProperty("sslConfig", "ADMIN_SOAP");
                }
                if (AdminClientFactory.tc.isDebugEnabled()) {
                    Tr.debug(AdminClientFactory.tc, "soap ssl alias: " + soapSslAlias);
                }
            }
            if (propsFromFile != null) {
                propsFromFile.putAll((Map<?, ?>)props);
                props = propsFromFile;
            }
            alternative = (Properties)props.clone();
            secEnabled = new Boolean(secEnabledStr);
            if (secEnabled) {
                alternative.remove("securityEnabled");
            } else {
                alternative.setProperty("securityEnabled", "true");
            }
            try {
                soapProxyClass = Class.forName("com.ibm.ws.management.connector.soap.SOAPConnectorClient");
                adminClientImplClass = Class.forName("com.ibm.ws.management.AdminClientImpl");
                args = new Class[]{Properties.class};
                propsCtor = soapProxyClass.getConstructor(args);
                try {
                    if (AdminClientFactory.tc.isDebugEnabled()) {
                        Tr.debug(AdminClientFactory.tc, "Before 1st attempt to new up com.ibm.ws.management.connector.soap.SOAPConnectorClient");
                    }
                    AdminClientFactory.showDebugInfo(props);
                    handler = (InvocationHandler)propsCtor.newInstance(new Object[]{props});
                }
                catch (Exception ex) {
                    block176: {
                        altCacheKey = AdminClientFactory.getAltCacheKey(cacheKey);
                        var16_63 = AdminClientFactory.cachedClients;
                        synchronized (var16_63) {
                            client = (AdminClient)AdminClientFactory.cachedClients.get(altCacheKey);
                        }
                        if (client != null) {
                            if (AdminClientFactory.tc.isDebugEnabled()) {
                                Tr.debug(AdminClientFactory.tc, "Alternate cached admin client found");
                            }
                            try {
                                client.isAlive();
                                if (AdminClientFactory.tc.isEntryEnabled()) {
                                    Tr.exit(AdminClientFactory.tc, "createAdminClient - alternate in cache");
                                }
                                return client;
                            }
                            catch (Throwable t) {
                                if (!AdminClientFactory.tc.isDebugEnabled()) break block176;
                                Tr.debug(AdminClientFactory.tc, "Alternate cached admin client is not available", t);
                            }
                        }
                    }
                    if (AdminClientFactory.tc.isDebugEnabled()) {
                        Tr.debug(AdminClientFactory.tc, "Try to new up the com.ibm.ws.management.connector.soap.SOAPConnectorClient instance again using alternative Properties after the 1st attempt failed with", ex);
                    }
                    originalException = ex;
                    AdminClientFactory.showDebugInfo(alternative);
                    handler = (InvocationHandler)propsCtor.newInstance(new Object[]{alternative});
                    v0 = secEnabled = secEnabled == false;
                }
                if (!SecurityContext.isServerProcess() && secEnabled) {
                    user = (String)props.get("username");
                    pw = (String)props.get("password");
                    loginSource = (String)props.get("loginsource");
                    authTarget = (String)props.get("authTarget");
                    krb5Ccache = (String)props.get("krb5Ccache");
                    krb5Config = (String)props.get("krb5Config");
                    krb5Service = (String)props.get("krb5Service");
                    krb5RefreshingTicket = (String)props.get("krb5RefreshingTicket");
                    if (AdminClientFactory.tc.isDebugEnabled()) {
                        Tr.debug(AdminClientFactory.tc, "authTarget: " + authTarget);
                        Tr.debug(AdminClientFactory.tc, "User: " + user);
                        Tr.debug(AdminClientFactory.tc, "krb5Ccache: " + krb5Ccache);
                        Tr.debug(AdminClientFactory.tc, "krb5Config: " + krb5Config);
                        Tr.debug(AdminClientFactory.tc, "krb5Config: " + krb5Service);
                        Tr.debug(AdminClientFactory.tc, "krb5RefreshingTicket: " + krb5RefreshingTicket);
                    }
                    if (authTarget == null || authTarget.length() == 0 || authTarget.equalsIgnoreCase("BasicAuth")) {
                        if (user != null && user.length() > 0 && pw != null && pw.length() > 0) {
                            subject = SubjectHelper.createBasicAuthSubject(null, user, pw);
                            AdminDataHolder.setData("wsSubject", subject);
                            if (AdminClientFactory.tc.isDebugEnabled()) {
                                Tr.debug(AdminClientFactory.tc, "Saving the Subject for Soap connector. ValueNull:" + (subject == null));
                            }
                        } else if (loginSource != null && (loginSource.equals("stdin") || loginSource.equals("prompt"))) {
                            block177: {
                                if (AdminClientFactory.tc.isDebugEnabled()) {
                                    Tr.debug(AdminClientFactory.tc, "About to login using JAAS");
                                }
                                subject = null;
                                cred = null;
                                realm = ContextManagerFactory.getInstance().getDefaultRealm();
                                try {
                                    subject = AdminClientFactory.jaas_login(authTarget, loginSource, user, pw, realm, krb5Ccache, krb5Config);
                                    if (subject == null) break block177;
                                    AdminDataHolder.setData("wsSubject", subject);
                                    cred = SubjectHelper.getWSCredentialFromSubject(subject);
                                    user = cred.getSecurityName();
                                    if (user.startsWith(ContextManagerFactory.getInstance().getDefaultRealm())) {
                                        user = RealmSecurityName.getSecurityName(user);
                                        if (AdminClientFactory.tc.isDebugEnabled()) {
                                            Tr.debug(AdminClientFactory.tc, "New username: " + user);
                                        }
                                    }
                                    pw = StringBytesConversion.getConvertedString(cred.getCredentialToken());
                                    props.put("username", user);
                                    props.put("password", pw);
                                    alternative.put("username", user);
                                    alternative.put("password", pw);
                                    mtd = soapProxyClass.getDeclaredMethod("setUserAndPwd", new Class[]{String.class, String.class});
                                    mtd.invoke((Object)handler, new Object[]{user, pw});
                                }
                                catch (WSLoginFailedException e) {
                                    if (AdminClientFactory.tc.isDebugEnabled()) {
                                        Tr.debug(AdminClientFactory.tc, "WSLoginFailedException occurred: ", new Object[]{e});
                                    }
                                    Manager.Ffdc.log(e, AdminClientFactory.thisClass, "com.ibm.websphere.management.AdminClientFactory.createAdminClient", "469");
                                }
                                catch (Exception e) {
                                    if (AdminClientFactory.tc.isDebugEnabled()) {
                                        Tr.debug(AdminClientFactory.tc, "Exception occurred during JAAS login: ", new Object[]{e});
                                    }
                                    Manager.Ffdc.log(e, AdminClientFactory.thisClass, "com.ibm.websphere.management.AdminClientFactory.createAdminClient", "473");
                                }
                            }
                            if (AdminClientFactory.tc.isDebugEnabled()) {
                                Tr.debug(AdminClientFactory.tc, "Saving the wscredential for Soap connector. ValueNull:" + (cred == null));
                            }
                        }
                    }
                }
                args[0] = InvocationHandler.class;
                clientImplCtor = adminClientImplClass.getConstructor(args);
                client = (AdminClient)clientImplCtor.newInstance(new Object[]{handler});
                if (props.getProperty("username") != null && props.getProperty("password") != null) {
                    client.getConnectorProperties().setProperty("username", props.getProperty("username"));
                    client.getConnectorProperties().setProperty("password", props.getProperty("password"));
                }
                if (AdminClientFactory.tc.isDebugEnabled()) {
                    Tr.debug(AdminClientFactory.tc, "soap client props now = " + DebugUtils.createPropertiesMaskPlainTextPassword(client.getConnectorProperties()));
                }
                if (!AdminClientFactory.tc.isDebugEnabled()) ** GOTO lbl513
                Tr.debug(AdminClientFactory.tc, "SOAPConnectorClient is created");
            }
            catch (Exception exc) {
                if (AdminClientFactory.tc.isEntryEnabled()) {
                    Tr.exit(AdminClientFactory.tc, "createAdminClient - failed", exc);
                }
                if (originalException != null) {
                    exc = originalException;
                }
                throw new ConnectorException(AdminClientFactory.connectorNLS.getFormattedMessage("ADMC0016E", new Object[]{props.getProperty("host"), props.getProperty("port")}, "Could not create SOAP Connector to connect to host {0} at port {1}"), exc);
            }
        } else if (type.equalsIgnoreCase("RMI")) {
            secEnabled = new Boolean(props.getProperty("securityEnabled"));
            alternative = (Properties)props.clone();
            if (secEnabled) {
                alternative.remove("securityEnabled");
            } else {
                alternative.setProperty("securityEnabled", "true");
            }
            try {
                block178: {
                    rmiProxyClass = Class.forName("com.ibm.ws.management.connector.rmi.RMIConnectorClient");
                    adminClientImplClass = Class.forName("com.ibm.ws.management.AdminClientImpl");
                    args = new Class[]{Properties.class};
                    propsCtor = rmiProxyClass.getConstructor(args);
                    try {
                        if (AdminClientFactory.tc.isDebugEnabled()) {
                            Tr.debug(AdminClientFactory.tc, "Before 1st attempt to create connector instance...");
                        }
                        AdminClientFactory.showDebugInfo(props);
                        handler = propsCtor.newInstance(new Object[]{props});
                    }
                    catch (Exception ex) {
                        if (AdminClientFactory.tc.isDebugEnabled()) {
                            Tr.debug(AdminClientFactory.tc, "try alternative connector properties after receiving the following exception", ex);
                        }
                        originalException = ex;
                        AdminClientFactory.showDebugInfo(alternative);
                        handler = propsCtor.newInstance(new Object[]{alternative});
                        secEnabled = secEnabled == false;
                    }
                    args[0] = Class.forName("com.ibm.ws.management.connector.AdminServiceProxy");
                    clientImplCtor = adminClientImplClass.getConstructor(args);
                    client = (AdminClient)clientImplCtor.newInstance(new Object[]{handler});
                    try {
                        if (!SecurityContext.isServerProcess() && ContextManagerFactory.getInstance().isCellSecurityEnabled()) {
                            if (AdminClientFactory.tc.isDebugEnabled()) {
                                Tr.debug(AdminClientFactory.tc, "trying to get security user/pw info from rmi connector if security is enabled");
                            }
                            if ((subject = ContextManagerFactory.getInstance().getInvocationSubject()) == null) {
                                subject = ContextManagerFactory.getInstance().getOwnSubject();
                            }
                            if (subject != null) {
                                if (AdminClientFactory.tc.isDebugEnabled()) {
                                    Tr.debug(AdminClientFactory.tc, "subject is not null");
                                }
                                cred = null;
                                cred = SubjectHelper.getWSCredentialFromSubject(subject);
                                if (cred != null) {
                                    user = cred.getSecurityName();
                                    if (user.startsWith(ContextManagerFactory.getInstance().getDefaultRealm())) {
                                        user = RealmSecurityName.getSecurityName(user);
                                        if (AdminClientFactory.tc.isDebugEnabled()) {
                                            Tr.debug(AdminClientFactory.tc, "RMI New username: " + user);
                                        }
                                    }
                                    pw = StringBytesConversion.getConvertedString(cred.getCredentialToken());
                                    client.getConnectorProperties().setProperty("username", user);
                                    client.getConnectorProperties().setProperty("password", pw);
                                }
                            }
                        }
                        if (AdminClientFactory.tc.isDebugEnabled()) {
                            Tr.debug(AdminClientFactory.tc, "rmi client props now = " + DebugUtils.createPropertiesMaskPlainTextPassword(client.getConnectorProperties()));
                        }
                    }
                    catch (Exception ex) {
                        if (!AdminClientFactory.tc.isDebugEnabled()) break block178;
                        Tr.debug(AdminClientFactory.tc, "exception while trying to get security user/pw info from rmi connector", ex);
                    }
                }
                if (!AdminClientFactory.tc.isDebugEnabled()) ** GOTO lbl513
                Tr.debug(AdminClientFactory.tc, "RMIConnectorClient is created");
            }
            catch (Exception exc) {
                Manager.Ffdc.log(exc, AdminClientFactory.thisClass, "com.ibm.websphere.management.AdminClientFactory.createAdminClient", "267");
                if (AdminClientFactory.tc.isEntryEnabled()) {
                    Tr.exit(AdminClientFactory.tc, "createAdminClient - failed", exc);
                }
                if (originalException != null) {
                    exc = originalException;
                }
                throw new ConnectorException(AdminClientFactory.connectorNLS.getFormattedMessage("ADMC0017E", new Object[]{props.getProperty("host"), props.getProperty("port")}, "Could not create RMI Connector to connect to host {0} at port {1}"), exc);
            }
        } else if (type.equalsIgnoreCase("JSR160RMI")) {
            secEnabled = new Boolean(props.getProperty("securityEnabled"));
            if (type.equalsIgnoreCase("RMI")) {
                props.setProperty("JNDI", "/jndi/RMIConnector");
                props.setProperty("type", "RMI");
            }
            alternative = (Properties)props.clone();
            if (secEnabled) {
                alternative.remove("securityEnabled");
            } else {
                alternative.setProperty("securityEnabled", "true");
            }
            try {
                block179: {
                    jsr160rmiProxyClass = Class.forName("com.ibm.ws.management.connector.jsr160rmi.JSR160RMIConnectorClient");
                    adminClientImplClass = Class.forName("com.ibm.ws.management.AdminClientImpl");
                    args = new Class[]{Properties.class};
                    propsCtor = jsr160rmiProxyClass.getConstructor(args);
                    try {
                        if (AdminClientFactory.tc.isDebugEnabled()) {
                            Tr.debug(AdminClientFactory.tc, "Before 1st attempt to create connector instance...");
                        }
                        AdminClientFactory.showDebugInfo(props);
                        handler = propsCtor.newInstance(new Object[]{props});
                    }
                    catch (Exception ex) {
                        if (AdminClientFactory.tc.isDebugEnabled()) {
                            Tr.debug(AdminClientFactory.tc, "try alternative connector properties after receiving the exception", ex);
                            ps = new PrintStream(new ByteArrayOutputStream());
                            ex.printStackTrace(ps);
                            Tr.debug(AdminClientFactory.tc, ps.toString());
                        }
                        originalException = ex;
                        AdminClientFactory.showDebugInfo(alternative);
                        handler = propsCtor.newInstance(new Object[]{alternative});
                        secEnabled = secEnabled == false;
                    }
                    args[0] = Class.forName("com.ibm.ws.management.connector.AdminServiceProxy");
                    clientImplCtor = adminClientImplClass.getConstructor(args);
                    client = (AdminClient)clientImplCtor.newInstance(new Object[]{handler});
                    try {
                        if (!SecurityContext.isServerProcess() && ContextManagerFactory.getInstance().isCellSecurityEnabled()) {
                            if (AdminClientFactory.tc.isDebugEnabled()) {
                                Tr.debug(AdminClientFactory.tc, "trying to get security user/pw info from JSR160RMI connector if security is enabled");
                            }
                            if ((subject = ContextManagerFactory.getInstance().getInvocationSubject()) == null) {
                                subject = ContextManagerFactory.getInstance().getOwnSubject();
                            }
                            if (subject != null) {
                                if (AdminClientFactory.tc.isDebugEnabled()) {
                                    Tr.debug(AdminClientFactory.tc, "subject is not null");
                                }
                                cred = null;
                                cred = SubjectHelper.getWSCredentialFromSubject(subject);
                                if (cred != null) {
                                    user = cred.getSecurityName();
                                    if (user.startsWith(ContextManagerFactory.getInstance().getDefaultRealm())) {
                                        user = RealmSecurityName.getSecurityName(user);
                                        if (AdminClientFactory.tc.isDebugEnabled()) {
                                            Tr.debug(AdminClientFactory.tc, "JSR160RMI New username: " + user);
                                        }
                                    }
                                    pw = StringBytesConversion.getConvertedString(cred.getCredentialToken());
                                    client.getConnectorProperties().setProperty("username", user);
                                    client.getConnectorProperties().setProperty("password", pw);
                                }
                            }
                        }
                        if (AdminClientFactory.tc.isDebugEnabled()) {
                            Tr.debug(AdminClientFactory.tc, "JSR160RMI client props now = " + DebugUtils.createPropertiesMaskPlainTextPassword(client.getConnectorProperties()));
                        }
                    }
                    catch (Exception ex) {
                        if (!AdminClientFactory.tc.isDebugEnabled()) break block179;
                        Tr.debug(AdminClientFactory.tc, "exception while trying to get security user/pw info from JSR160RMI connector", ex);
                    }
                }
                if (!AdminClientFactory.tc.isDebugEnabled()) ** GOTO lbl513
                Tr.debug(AdminClientFactory.tc, "JSR160RMIConnectorClient is created");
            }
            catch (Exception exc) {
                Manager.Ffdc.log(exc, AdminClientFactory.thisClass, "com.ibm.websphere.management.AdminClientFactory.createAdminClient", "275");
                if (AdminClientFactory.tc.isEntryEnabled()) {
                    Tr.exit(AdminClientFactory.tc, "createAdminClient - failed", exc);
                }
                if (originalException != null) {
                    exc = originalException;
                }
                throw new ConnectorException(AdminClientFactory.connectorNLS.getFormattedMessage("ADMC0017E", new Object[]{props.getProperty("host"), props.getProperty("port")}, "Could not create RMI Connector to connect to host {0} at port {1}"), exc);
            }
        } else if (type.equalsIgnoreCase("IPC")) {
            propsFromFile = null;
            isInternal = SecurityContext.isServerProcess();
            if (!isInternal) {
                ipcUrl = props.getProperty("com.ibm.IPC.ConfigURL");
                if (ipcUrl == null) {
                    ipcUrl = System.getProperty("com.ibm.IPC.ConfigURL");
                }
                if (ipcUrl == null) {
                    installRoot = System.getProperty("user.install.root");
                    if (installRoot == null) {
                        installRoot = System.getProperty("was.install.root");
                    }
                    ipcUrl = "file:" + installRoot + "/properties/ipc.client.props";
                }
                if (ipcUrl != null) {
                    url = ipcUrl;
                    propsFromFile = (Properties)com.ibm.ws.security.util.AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            Properties props = AdminClientFactory.loadPropertiesFromFile(url);
                            return props;
                        }
                    });
                }
            }
            if (propsFromFile != null) {
                propsFromFile.putAll((Map<?, ?>)props);
                props = propsFromFile;
            }
            secEnabled = new Boolean(props.getProperty("securityEnabled"));
            authTarget = (String)props.get("authTarget");
            krb5Ccache = (String)props.get("krb5Ccache");
            krb5Config = (String)props.get("krb5Config");
            krb5Service = (String)props.get("krb5Service");
            krb5RefreshingTicket = (String)props.get("krb5RefreshingTicket");
            user = props.getProperty("username");
            password = props.getProperty("password");
            if (!isInternal) {
                if (user != null && user.length() > 0 && password != null && password.length() > 0) {
                    if (!secEnabled) {
                        secEnabled = true;
                        props.setProperty("securityEnabled", String.valueOf(secEnabled));
                    }
                } else if (secEnabled) {
                    secEnabled = false;
                    props.setProperty("securityEnabled", String.valueOf(secEnabled));
                }
            }
            try {
                block181: {
                    ipcProxyClass = Class.forName("com.ibm.ws.management.connector.ipc.IPCConnectorClient");
                    adminClientImplClass = Class.forName("com.ibm.ws.management.AdminClientImpl");
                    args = new Class[]{Properties.class};
                    propsCtor = ipcProxyClass.getConstructor(args);
                    try {
                        if (AdminClientFactory.tc.isDebugEnabled()) {
                            Tr.debug(AdminClientFactory.tc, "Before 1st attempt to new up com.ibm.ws.management.connector.ipc.IPCConnectorClient");
                        }
                        AdminClientFactory.showDebugInfo(props);
                        handler = propsCtor.newInstance(new Object[]{props});
                        if (AdminClientFactory.tc.isDebugEnabled()) {
                            Tr.debug(AdminClientFactory.tc, "IPCConnectorClient instance constructed: " + handler);
                        }
                    }
                    catch (Exception ex) {
                        block180: {
                            altCacheKey = AdminClientFactory.getAltCacheKey(cacheKey);
                            subject = AdminClientFactory.cachedClients;
                            synchronized (subject) {
                                client = (AdminClient)AdminClientFactory.cachedClients.get(altCacheKey);
                            }
                            if (client != null) {
                                if (AdminClientFactory.tc.isDebugEnabled()) {
                                    Tr.debug(AdminClientFactory.tc, "Alternate cached admin client found");
                                }
                                try {
                                    client.isAlive();
                                    if (AdminClientFactory.tc.isEntryEnabled()) {
                                        Tr.exit(AdminClientFactory.tc, "createAdminClient - alternate in cache");
                                    }
                                    return client;
                                }
                                catch (Throwable t) {
                                    if (!AdminClientFactory.tc.isDebugEnabled()) break block180;
                                    Tr.debug(AdminClientFactory.tc, "Alternate cached admin client is not available", t);
                                }
                            }
                        }
                        originalException = ex;
                        if (AdminClientFactory.tc.isDebugEnabled()) {
                            Tr.debug(AdminClientFactory.tc, "Try to new up the com.ibm.ws.management.connector.ipc.IPCConnectorClient again, now with reversed secEnabled, after the 1st attempt failed with", ex);
                        }
                        secEnabled = secEnabled == false;
                        props.setProperty("securityEnabled", String.valueOf(secEnabled));
                        AdminClientFactory.showDebugInfo(props);
                        handler = propsCtor.newInstance(new Object[]{props});
                        if (!AdminClientFactory.tc.isDebugEnabled()) break block181;
                        Tr.debug(AdminClientFactory.tc, "IPCConnectorClient instance constructed (attempt 2): " + handler);
                    }
                }
                if (!SecurityContext.isServerProcess() && secEnabled) {
                    loginSource = (String)props.get("loginsource");
                    if (authTarget == null || authTarget.length() == 0 || authTarget.equalsIgnoreCase("BasicAuth")) {
                        if (user != null && user.length() > 0 && password != null && password.length() > 0) {
                            subject = SubjectHelper.createBasicAuthSubject(null, user, password);
                            AdminDataHolder.setData("wsSubject", subject);
                            if (AdminClientFactory.tc.isDebugEnabled()) {
                                Tr.debug(AdminClientFactory.tc, "Subject from uid/pw null? " + (subject == null));
                            }
                        } else if (loginSource != null && (loginSource.equals("stdin") || loginSource.equals("prompt"))) {
                            block182: {
                                if (AdminClientFactory.tc.isDebugEnabled()) {
                                    Tr.debug(AdminClientFactory.tc, "About to login using JAAS");
                                }
                                subject = null;
                                cred = null;
                                realm = ContextManagerFactory.getInstance().getDefaultRealm();
                                try {
                                    subject = AdminClientFactory.jaas_login(authTarget, loginSource, user, password, realm, krb5Ccache, krb5Config);
                                    if (AdminClientFactory.tc.isDebugEnabled()) {
                                        Tr.debug(AdminClientFactory.tc, "IPC: calling setInvocationSubject: " + subject);
                                    }
                                    SecurityContext.getContextManager().setInvocationSubject(subject);
                                    if (subject == null) break block182;
                                    AdminDataHolder.setData("wsSubject", subject);
                                    cred = SubjectHelper.getWSCredentialFromSubject(subject);
                                    user = cred.getSecurityName();
                                    if (user.startsWith(ContextManagerFactory.getInstance().getDefaultRealm())) {
                                        user = RealmSecurityName.getSecurityName(user);
                                        if (AdminClientFactory.tc.isDebugEnabled()) {
                                            Tr.debug(AdminClientFactory.tc, "New username: " + user);
                                        }
                                    }
                                    password = StringBytesConversion.getConvertedString(cred.getCredentialToken());
                                    props.put("username", user);
                                    props.put("password", password);
                                    mtd = ipcProxyClass.getDeclaredMethod("setUserAndPwd", new Class[]{String.class, String.class});
                                    mtd.invoke(handler, new Object[]{user, password});
                                }
                                catch (WSLoginFailedException e) {
                                    if (AdminClientFactory.tc.isDebugEnabled()) {
                                        Tr.debug(AdminClientFactory.tc, "WSLoginFailedException occurred: ", e);
                                    }
                                    Manager.Ffdc.log(e, AdminClientFactory.thisClass, "com.ibm.websphere.management.AdminClientFactory.createAdminClient", "1330");
                                }
                                catch (Exception e) {
                                    if (AdminClientFactory.tc.isDebugEnabled()) {
                                        Tr.debug(AdminClientFactory.tc, "Exception occurred during JAAS login: ", new Object[]{e});
                                    }
                                    Manager.Ffdc.log(e, AdminClientFactory.thisClass, "com.ibm.websphere.management.AdminClientFactory.createAdminClient", "1336");
                                }
                            }
                            if (AdminClientFactory.tc.isDebugEnabled()) {
                                Tr.debug(AdminClientFactory.tc, "Subject from jaas_login null? " + (subject == null));
                            }
                        }
                    }
                }
                args[0] = Class.forName("com.ibm.ws.management.connector.AdminServiceProxy");
                clientImplCtor = adminClientImplClass.getConstructor(args);
                if (AdminClientFactory.tc.isDebugEnabled()) {
                    Tr.debug(AdminClientFactory.tc, "AdminClientImpl constructor: " + clientImplCtor);
                }
                client = (AdminClient)clientImplCtor.newInstance(new Object[]{handler});
                if (!AdminClientFactory.tc.isDebugEnabled()) ** GOTO lbl513
                Tr.debug(AdminClientFactory.tc, "IPCConnectorClient is created");
            }
            catch (Exception exc) {
                if (originalException != null) {
                    // empty if block
                }
                throw new ConnectorException("Could not create IPC Connector to connect to port " + props.getProperty("port") + ", due to " + exc);
            }
        } else {
            if (AdminClientFactory.tc.isEntryEnabled()) {
                Tr.exit(AdminClientFactory.tc, "createAdminClient");
            }
            throw new InvalidAdminClientTypeException();
        }
lbl513:
        // 9 sources

        cacheDisabled = new Boolean(props.getProperty("cacheDisabled"));
        if (AdminClientFactory.tc.isDebugEnabled()) {
            Tr.debug(AdminClientFactory.tc, "cacheDisabled is set to " + cacheDisabled);
        }
        if (client != null) {
            if (cacheDisabled) {
                if (AdminClientFactory.tc.isDebugEnabled()) {
                    Tr.debug(AdminClientFactory.tc, "Caching disabled for this admin client");
                }
            } else {
                cacheKey.setProperty("securityEnabled", secEnabled != false ? "true" : "false");
                var7_21 = AdminClientFactory.cachedClients;
                synchronized (var7_21) {
                    if (AdminClientFactory.tc.isDebugEnabled()) {
                        Tr.debug(AdminClientFactory.tc, "Client is being cached, and the properties is");
                    }
                    AdminClientFactory.showDebugInfo(cacheKey);
                    AdminClientFactory.cachedClients.put(cacheKey, client);
                }
            }
        }
        if (AdminClientFactory.tc.isEntryEnabled()) {
            Tr.exit(AdminClientFactory.tc, "createAdminClient");
        }
        return client;
    }

    private static AdminClient createNullConnectorClient(Properties p) throws ConnectorException {
        p.setProperty("cacheDisabled", "true");
        NullConnector client = new NullConnector(p);
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadPropertiesFromFile(String soapURL) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadPropertiesFromFile", soapURL);
        }
        if (!soapURL.startsWith("file:")) {
            soapURL = "file:".concat(soapURL);
        }
        InputStream is = null;
        Properties temp = new Properties();
        try {
            URL propURL = new URL(soapURL);
            is = propURL.openStream();
            temp.load(is);
            temp = AdminClientFactory.decodePasswordsAndExpandVariables(temp);
        }
        catch (IOException ioe) {
            Manager.Ffdc.log(ioe, thisClass, "com.ibm.websphere.management.AdminClientFactory.loadPropertiesFromFile", "313");
            Tr.warning(tc, "ADMC0046W", new Object[]{soapURL});
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    Manager.Ffdc.log(ex, thisClass, "com.ibm.websphere.management.AdminClientFactory.loadPropertiesFromFile", "322");
                }
            }
        }
        if (!temp.isEmpty()) {
            String krb5RefreshingTicket;
            String krb5Service;
            String krb5Config;
            String krb5Ccache;
            String authTarget;
            String secEnabled;
            String loginSource;
            String pw;
            String user;
            if (temp.keySet().contains("com.ibm.SOAP.loginUserid")) {
                user = (String)temp.remove("com.ibm.SOAP.loginUserid");
                pw = (String)temp.remove("com.ibm.SOAP.loginPassword");
                loginSource = (String)temp.remove("com.ibm.SOAP.loginSource");
                secEnabled = (String)temp.remove("com.ibm.SOAP.securityEnabled");
                authTarget = (String)temp.remove("com.ibm.SOAP.authenticationTarget");
                krb5Ccache = (String)temp.remove("com.ibm.SOAP.krb5CcacheFile");
                krb5Config = (String)temp.remove("com.ibm.SOAP.krb5ConfigFile");
                krb5Service = (String)temp.remove("com.ibm.SOAP.krb5Service");
                krb5RefreshingTicket = (String)temp.remove("com.ibm.SOAP.krb5RefreshingTicket");
            } else if (temp.keySet().contains("com.ibm.IPC.loginUserid")) {
                user = (String)temp.remove("com.ibm.IPC.loginUserid");
                pw = (String)temp.remove("com.ibm.IPC.loginPassword");
                loginSource = (String)temp.remove("com.ibm.IPC.loginSource");
                secEnabled = (String)temp.remove("com.ibm.IPC.securityEnabled");
                authTarget = (String)temp.remove("com.ibm.IPC.authenticationTarget");
                krb5Ccache = (String)temp.remove("com.ibm.IPC.krb5CcacheFile");
                krb5Config = (String)temp.remove("com.ibm.IPC.krb5ConfigFile");
                krb5Service = (String)temp.remove("com.ibm.IPC.krb5Service");
                krb5RefreshingTicket = (String)temp.remove("com.ibm.IPC.krb5RefreshingTicket");
            } else {
                user = "";
                pw = "";
                loginSource = "";
                secEnabled = "";
                authTarget = "";
                krb5Ccache = "";
                krb5Config = "";
                krb5Service = "";
                krb5RefreshingTicket = "";
            }
            if (loginSource != null && loginSource.length() > 0) {
                temp.setProperty("loginsource", loginSource);
            }
            if (user != null) {
                temp.setProperty("username", user);
            }
            if (pw != null) {
                temp.setProperty("password", pw);
            }
            if (secEnabled != null) {
                temp.setProperty("securityEnabled", secEnabled);
            }
            if (authTarget != null) {
                temp.setProperty("authTarget", authTarget);
            } else {
                temp.setProperty("authTarget", "BasicAuth");
            }
            if (krb5Ccache != null) {
                temp.setProperty("krb5Ccache", krb5Ccache);
            }
            if (krb5Config != null) {
                temp.setProperty("krb5Config", krb5Config);
            }
            if (krb5Service != null) {
                temp.setProperty("krb5Service", krb5Service);
            }
            if (krb5RefreshingTicket != null) {
                temp.setProperty("krb5RefreshingTicket", krb5RefreshingTicket);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadPropertisFromFile");
        }
        return temp;
    }

    private static Properties decodePasswordsAndExpandVariables(Properties props) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "decodePasswords");
        }
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = props.getProperty(name);
            if (value != null && value.indexOf("${USER_INSTALL_ROOT}") != -1) {
                value = KeyStoreManager.getInstance().expand(value);
            }
            if (name.toLowerCase().indexOf("password") == -1 || value == null) continue;
            String new_value = SSLConfig.decodePassword(value);
            props.setProperty(name, new_value);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "decodePasswords");
        }
        return props;
    }

    private static void showDebugInfo(Properties props) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Client properties: ");
            for (String string : props.keySet()) {
                if (string.equals("password") || string.endsWith("Password")) {
                    String pwd = props.getProperty(string);
                    if (pwd != null && pwd.length() > 0) {
                        Tr.debug(tc, "> " + string + "=*****");
                        continue;
                    }
                    Tr.debug(tc, "> " + string + "=");
                    continue;
                }
                Tr.debug(tc, "> " + string + "=" + props.getProperty(string));
            }
        }
    }

    private static Properties getCacheKey(String connectorType, Properties props) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCacheKey");
        }
        Properties cacheKey = new Properties();
        String authTarget = props.getProperty("authTarget");
        String krb5Ccache = props.getProperty("krb5Ccache");
        String krb5Config = props.getProperty("krb5Config");
        String krb5Service = props.getProperty("krb5Service");
        String krb5RefreshingTicket = props.getProperty("krb5RefreshingTicket");
        String host = props.getProperty("host");
        String port = props.getProperty("port");
        String loginSource = props.getProperty("loginsource");
        String secEnabled = props.getProperty("securityEnabled");
        String autoAcceptSigner = props.getProperty("autoAcceptSignerForThisConnectionOnly");
        String user = props.getProperty("username");
        if (user != null && user.startsWith(ContextManagerFactory.getInstance().getDefaultRealm())) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "In getCacheKey, stripping realm from username.");
            }
            user = RealmSecurityName.getSecurityName(user);
            props.setProperty("username", user);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "In getCacheKey, new username: " + user);
            }
        }
        String password = props.getProperty("password");
        if (host == null) {
            throw new ConnectorException(connectorNLS.getString("ADMC0041E"));
        }
        String tmp = host;
        try {
            host = InetAddress.getByName(host).getHostAddress();
        }
        catch (UnknownHostException ex) {
            Manager.Ffdc.log(ex, thisClass, "com.ibm.websphere.management.AdminClientFactory.getCacheKey", "432");
            host = tmp;
        }
        if (port == null) {
            throw new ConnectorException(connectorNLS.getString("ADMC0042E"));
        }
        port = port.trim();
        cacheKey.setProperty("type", connectorType.toUpperCase());
        cacheKey.setProperty("host", host);
        cacheKey.setProperty("port", port);
        if (secEnabled != null) {
            cacheKey.setProperty("securityEnabled", secEnabled);
        } else {
            cacheKey.setProperty("securityEnabled", "false");
        }
        if (user != null && password != null) {
            cacheKey.setProperty("username", user);
            cacheKey.setProperty("password", password);
        }
        if (user != null) {
            cacheKey.setProperty("username", user);
        }
        if (loginSource != null) {
            cacheKey.setProperty("loginsource", loginSource);
        }
        if (authTarget != null) {
            cacheKey.setProperty("authTarget", authTarget);
        }
        if (krb5Ccache != null) {
            cacheKey.setProperty("krb5Ccache", krb5Ccache);
        }
        if (krb5Config != null) {
            cacheKey.setProperty("krb5Config", krb5Config);
        }
        if (krb5Service != null) {
            cacheKey.setProperty("krb5Service", krb5Service);
        }
        if (krb5RefreshingTicket != null) {
            cacheKey.setProperty("krb5RefreshingTicket", krb5RefreshingTicket);
        }
        if (autoAcceptSigner != null) {
            cacheKey.setProperty("autoAcceptSignerForThisConnectionOnly", autoAcceptSigner);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCacheKey", DebugUtils.createPropertiesMaskPlainTextPassword(cacheKey));
        }
        return cacheKey;
    }

    public static Subject jaas_login(String authTarget, String loginSource, String user, String password, String realm, String krb5Ccache, String krb5Config) throws WSLoginFailedException {
        LoginContext lc;
        block27: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "jaas_login(" + authTarget + ", " + loginSource + " ..." + ")");
            }
            String loginModule = "WSAdminClientLogin";
            if (authTarget.equalsIgnoreCase("KRB5") || authTarget.equalsIgnoreCase("Kerberos")) {
                loginModule = "WSKRB5Login";
                AdminClientFactory.setKrbConfigProp(krb5Config);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "authTarget: " + authTarget);
                Tr.debug(tc, "loginSource: " + loginSource);
                Tr.debug(tc, "user: " + user);
                Tr.debug(tc, "realm: " + realm);
                Tr.debug(tc, "krb5Ccache: " + krb5Ccache);
                Tr.debug(tc, "krb5Config: " + krb5Config);
                Tr.debug(tc, "loginModule: " + loginModule);
            }
            lc = null;
            CallbackHandler callbackhandler = null;
            try {
                if (user != null && user.length() > 0 && password != null && password.length() > 0) {
                    lc = new LoginContext(loginModule, new NonPromptCallbackHandler(realm, user, password));
                    lc.login();
                    break block27;
                }
                if (loginSource != null && loginSource.equalsIgnoreCase("krb5Ccache")) {
                    try {
                        String defaultCcache = "false";
                        if (krb5Ccache == null || krb5Ccache.length() == 0) {
                            defaultCcache = "true";
                        }
                        lc = new LoginContext(loginModule, new WSCcacheCallBackHandlerImpl(user, realm, krb5Ccache, defaultCcache));
                        lc.login();
                        break block27;
                    }
                    catch (WSLoginFailedException wlfe) {
                        throw wlfe;
                    }
                    catch (LoginException le) {
                        Manager.Ffdc.log(le, thisClass, "com.ibm.websphere.management.AdminClientFactory.jaas_login", "173");
                        if (le instanceof WSLoginFailedException) {
                            throw (WSLoginFailedException)le;
                        }
                        throw new WSLoginFailedException(le.getMessage(), le);
                    }
                }
                if (loginSource != null && loginSource.equalsIgnoreCase("prompt")) {
                    try {
                        if (tc.isEntryEnabled()) {
                            Tr.entry(tc, "creating GraphicsEnvironment");
                        }
                        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                        JFrame tmpFrame = new JFrame();
                        if (!ge.isHeadlessInstance()) {
                            callbackhandler = new WSGUICallbackHandlerImpl();
                        } else {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "GraphicsEnvironment is headless; go with stdin");
                            }
                            callbackhandler = new WSStdinCallbackHandlerImpl();
                        }
                    }
                    catch (Throwable e) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Failed to create GraphicsEnvironment; go with stdin");
                        }
                        callbackhandler = new WSStdinCallbackHandlerImpl();
                    }
                    lc = new LoginContext(loginModule, callbackhandler);
                    lc.login();
                    break block27;
                }
                if (loginSource != null && loginSource.equalsIgnoreCase("stdin")) {
                    lc = new LoginContext(loginModule, new WSStdinCallbackHandlerImpl(realm));
                    lc.login();
                }
            }
            catch (WSLoginFailedException wlfe) {
                throw wlfe;
            }
            catch (LoginException le) {
                Manager.Ffdc.log(le, thisClass, "com.ibm.websphere.management.AdminClientFactory.jaas_login", "152");
                if (le instanceof WSLoginFailedException) {
                    throw (WSLoginFailedException)le;
                }
                throw new WSLoginFailedException(le.getMessage(), le);
            }
            catch (SecurityException se) {
                Manager.Ffdc.log(se, thisClass, "com.ibm.websphere.management.AdminClientFactory.jaas_login", "162");
                throw new WSLoginFailedException(se.getMessage(), se);
            }
        }
        Subject subject = lc.getSubject();
        if (subject == null) {
            Tr.debug(tc, "Subject is null.", new Object[]{authTarget, loginSource});
        } else {
            AdminDataHolder.setData("wsSubject", subject);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "jaas_login(authTarget, loginSource, ...)");
        }
        return subject;
    }

    private static Properties getAltCacheKey(Properties cacheKey) {
        Properties altCacheKey = (Properties)cacheKey.clone();
        if (cacheKey.getProperty("securityEnabled").equals("true")) {
            altCacheKey.setProperty("securityEnabled", "false");
        } else {
            altCacheKey.setProperty("securityEnabled", "true");
        }
        return altCacheKey;
    }

    public static void setKrbConfigProp(String krb5Config) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setKrbConfigProp");
        }
        if (krb5Config != null && krb5Config.length() != 0) {
            final String inKrb5Config = krb5Config;
            String cf = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    String property = "java.security.krb5.conf";
                    String c = System.getProperty("java.security.krb5.conf");
                    System.setProperty("java.security.krb5.conf", inKrb5Config);
                    return c;
                }
            });
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "java.security.krb5.conf property previous: " + (cf != null ? cf : "<null>") + " and now: " + krb5Config);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setKrbConfigProp");
        }
    }
}

