/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.trl.util.xml;

import com.ibm.trl.util.Logger;
import com.ibm.trl.util.xml.QName;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class DOMHandler {
    private static final String XMLNS_ = "xmlns:";

    private DOMHandler() {
    }

    public static Document createDocument() {
        Document doc = null;
        try {
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            doc = null;
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            Logger.fatal(sw.toString());
        }
        return doc;
    }

    public static String getNodeValue(Element elem) {
        StringBuffer buf = new StringBuffer();
        NodeList list = elem.getChildNodes();
        int length = list.getLength();
        for (int i = 0; i < length; ++i) {
            if (list.item(i).getNodeType() != 3) continue;
            buf.append(list.item(i).getNodeValue());
        }
        return buf.toString();
    }

    public static String getPrefixForNamespaceURI(Node node, String namespaceURI) {
        Node parent;
        if (node.getNodeType() == 1) {
            NamedNodeMap map = ((Element)node).getAttributes();
            int length = map.getLength();
            for (int i = 0; i < length; ++i) {
                Attr attr = (Attr)map.item(i);
                String name = attr.getName();
                if (!name.startsWith(XMLNS_) || !attr.getValue().equals(namespaceURI)) continue;
                if (name.length() <= XMLNS_.length()) {
                    throw new DOMException(4, "xmlns: attribute does not have prefix part");
                }
                return attr.getName().substring(XMLNS_.length());
            }
        }
        if ((parent = node.getParentNode()) != null) {
            return DOMHandler.getPrefixForNamespaceURI(parent, namespaceURI);
        }
        throw new DOMException(14, "There is no namespace prefix for the namespace URI: " + namespaceURI);
    }

    public static boolean isNodeNamedNS(Node node, QName qname) {
        if (node == null || qname == null) {
            return false;
        }
        return qname.getNamespaceURI().equals(node.getNamespaceURI()) && qname.getLocalName().equals(node.getLocalName());
    }
}

