/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.toad.utils;

import com.ibm.toad.utils.D;
import com.ibm.toad.utils.Parser;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public final class ParserTypeChecker {
    private ParserTypeChecker() {
    }

    public static void check(Object object, DBSpec dBSpec) throws Parser.ParseError {
        Object object2;
        int n;
        if (!(object instanceof Hashtable)) {
            throw new Parser.ParseError("Illegal type of DB");
        }
        Hashtable hashtable = (Hashtable)object;
        ParserTypeChecker.chkDbRecordTypes(hashtable, dBSpec.legal);
        for (n = 0; n < dBSpec.mandatory.length; ++n) {
            object2 = hashtable.get(dBSpec.mandatory[n]);
            if (object2 != null) continue;
            throw new Parser.ParseError("Config doesnt contain mandatory entry: '" + dBSpec.mandatory[n] + "'");
        }
        for (n = 0; n < dBSpec.legal.length; ++n) {
            object2 = (Vector)hashtable.get(dBSpec.legal[n]);
            if (object2 == null) continue;
            for (int i = 0; i < ((Vector)object2).size(); ++i) {
                Hashtable hashtable2 = (Hashtable)((Vector)object2).elementAt(i);
                int n2 = (Integer)hashtable2.get("@LINE");
                int n3 = (Integer)hashtable2.get("@COL");
                RecordValueSpec recordValueSpec = ParserTypeChecker.findSpec((Hashtable)((Vector)object2).elementAt(i), dBSpec);
                if (recordValueSpec == null) {
                    throw new Parser.ParseError("config file containing an illegal record at line: " + n2);
                }
                recordValueSpec.check((Hashtable)((Vector)object2).elementAt(i), dBSpec, n2, n3, "");
            }
        }
    }

    static RecordValueSpec findSpec(Hashtable hashtable, DBSpec dBSpec) {
        String string = (String)hashtable.get("@RECTYPE");
        for (int i = 0; i < dBSpec.specs.length; ++i) {
            RecordValueSpec recordValueSpec = dBSpec.specs[i];
            if (!string.equals(recordValueSpec.name)) continue;
            return recordValueSpec;
        }
        return null;
    }

    public static void chkDbRecordTypes(Hashtable hashtable, String[] stringArray) throws Parser.ParseError {
        if (hashtable == null) {
            return;
        }
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            Vector vector = (Vector)enumeration.nextElement();
            Hashtable hashtable2 = (Hashtable)vector.elementAt(0);
            String string = (String)hashtable2.get("@RECTYPE");
            boolean bl = false;
            for (int i = 0; i < stringArray.length && !bl; ++i) {
                if (!string.equals(stringArray[i])) continue;
                bl = true;
            }
            if (bl) continue;
            String string2 = "Error: config file record \"" + string + "\" is invalid.";
            string2 = string2 + "\nLegal records are: ";
            for (int i = 0; i < stringArray.length; ++i) {
                string2 = string2 + stringArray[i] + ", ";
            }
            string2 = string2 + "\n";
            throw new Parser.ParseError(string2);
        }
    }

    public static class DBSpec {
        public final String[] legal;
        public final String[] mandatory;
        public final RecordValueSpec[] specs;

        public DBSpec(String[] stringArray, String[] stringArray2, RecordValueSpec[] recordValueSpecArray) {
            this.legal = stringArray;
            this.mandatory = stringArray2;
            this.specs = recordValueSpecArray;
        }
    }

    public static class FieldSpec {
        public final String name;
        public final boolean isMandatory;
        public final ValueSpec valueSpec;

        public FieldSpec(String string, boolean bl, ValueSpec valueSpec) {
            this.name = string;
            this.isMandatory = bl;
            this.valueSpec = valueSpec;
        }
    }

    public static final class RecordValueSpec
    extends ValueSpec {
        public final String name;
        public final FieldSpec[] fieldSpecs;

        public RecordValueSpec(String string, FieldSpec[] fieldSpecArray) {
            this.name = string;
            this.fieldSpecs = fieldSpecArray;
        }

        String javaType() {
            return "java.util.Hashtable";
        }

        void check(Object object, DBSpec dBSpec, int n, int n2, String string) throws Parser.ParseError {
            Object object2;
            Object object3;
            if (!(object instanceof Hashtable)) {
                throw new Parser.ParseError("\nConfig file error: Expected Record but encountered different type, \nin record starting on line: " + n + " field: " + string);
            }
            Hashtable hashtable = (Hashtable)object;
            String string2 = (String)hashtable.get("@RECTYPE");
            if (!this.name.equals(string2)) {
                throw new Parser.ParseError("Illegal record: " + string2 + ". Expected: " + this.name);
            }
            for (int i = 0; i < this.fieldSpecs.length; ++i) {
                object3 = this.fieldSpecs[i];
                if (!((FieldSpec)object3).isMandatory || (object2 = hashtable.get(((FieldSpec)object3).name)) != null) continue;
                throw new Parser.ParseError("Mandatory field: " + ((FieldSpec)object3).name + " in record: " + this.name + " is missing from config file.");
            }
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                object3 = (String)enumeration.nextElement();
                if (((String)object3).equals("@RECTYPE") || ((String)object3).equals("@LINE") || ((String)object3).equals("@COL")) continue;
                object2 = null;
                for (int i = 0; i < this.fieldSpecs.length; ++i) {
                    FieldSpec fieldSpec = this.fieldSpecs[i];
                    if (!fieldSpec.name.equals(object3)) continue;
                    object2 = fieldSpec;
                    break;
                }
                if (object2 == null) {
                    throw new Parser.ParseError("Illegal field: " + (String)object3 + " found in record: " + this.name);
                }
                ((FieldSpec)object2).valueSpec.check(hashtable.get(object3), dBSpec, (Integer)hashtable.get("@LINE"), (Integer)hashtable.get("@COL"), ((FieldSpec)object2).name);
            }
        }
    }

    public static final class AltValueSpec
    extends ValueSpec {
        public ValueSpec alt;
        public AltValueSpec next;

        public AltValueSpec(ValueSpec valueSpec, AltValueSpec altValueSpec) {
            this.alt = valueSpec;
            this.next = altValueSpec;
        }

        String javaType() {
            return "@@";
        }

        void check(Object object, DBSpec dBSpec, int n, int n2, String string) throws Parser.ParseError {
            AltValueSpec altValueSpec = this;
            while (altValueSpec != null) {
                try {
                    altValueSpec.alt.check(object, dBSpec, n, n2, string);
                    return;
                }
                catch (Parser.ParseError parseError) {
                    altValueSpec = altValueSpec.next;
                }
            }
            throw new Parser.ParseError("\nConfig file error: Illegal alternative, \nin record starting on line: " + n + " field: " + string);
        }
    }

    public static final class ListValueSpec
    extends ValueSpec {
        public final ValueSpec itemSpec;
        public final int minLen;

        public ListValueSpec(ValueSpec valueSpec, int n) {
            this.itemSpec = valueSpec;
            this.minLen = n;
        }

        public ListValueSpec(ValueSpec valueSpec) {
            D.pre(valueSpec != null);
            this.itemSpec = valueSpec;
            this.minLen = 0;
        }

        String javaType() {
            return "java.util.Vector";
        }

        void check(Object object, DBSpec dBSpec, int n, int n2, String string) throws Parser.ParseError {
            if (!(object instanceof Vector)) {
                throw new Parser.ParseError("\nConfig file error: Expected List but encountered different type, \nin record starting on line: " + n + " field: " + string);
            }
            Vector vector = (Vector)object;
            for (int i = 0; i < vector.size(); ++i) {
                this.itemSpec.check(vector.elementAt(i), dBSpec, n, n2, string);
            }
        }
    }

    public static final class IntValueSpec
    extends ValueSpec {
        String javaType() {
            return "java.lang.Integer";
        }

        void check(Object object, DBSpec dBSpec, int n, int n2, String string) throws Parser.ParseError {
            if (!(object instanceof Integer)) {
                throw new Parser.ParseError("\nConfig file error: Expected Integer but encountered different type, \nin record starting on line: " + n + " field: " + string);
            }
        }
    }

    public static final class StringValueSpec
    extends ValueSpec {
        String javaType() {
            return "java.lang.String";
        }

        void check(Object object, DBSpec dBSpec, int n, int n2, String string) throws Parser.ParseError {
            if (!(object instanceof String)) {
                throw new Parser.ParseError("\nConfig file error: Expected String but encountered different type, \nin record starting on line: " + n + ", field: " + string);
            }
        }
    }

    public static abstract class ValueSpec {
        abstract String javaType();

        abstract void check(Object var1, DBSpec var2, int var3, int var4, String var5) throws Parser.ParseError;
    }
}

