/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.toad.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class HexDiff {
    public static void main(String[] stringArray) {
        try {
            HexDiff.toDiff(stringArray[0], stringArray[1]);
        }
        catch (Exception exception) {
            System.out.println("Could not open " + stringArray[0]);
        }
    }

    public static void toDiff(String string, String string2) throws IOException {
        int n;
        int n2;
        FileInputStream fileInputStream = new FileInputStream(new File(string));
        FileInputStream fileInputStream2 = new FileInputStream(new File(string2));
        byte[] byArray = new byte[fileInputStream.available()];
        fileInputStream.read(byArray);
        byte[] byArray2 = new byte[fileInputStream2.available()];
        fileInputStream2.read(byArray2);
        byte[] byArray3 = null;
        if (byArray.length != byArray2.length) {
            System.out.println("Lengths differ " + byArray.length + " " + byArray2.length);
        }
        int n3 = byArray.length < byArray2.length ? byArray.length : byArray2.length;
        int n4 = n2 = byArray.length > byArray2.length ? byArray.length : byArray2.length;
        if (n2 > n3) {
            byArray3 = n2 == byArray.length ? byArray : byArray2;
        }
        for (n = 0; n < n3; ++n) {
            if ((0xFF & byArray[n]) == (0xFF & byArray2[n])) continue;
            System.out.println("files differ at byte 0x" + Integer.toHexString(0xFF & n) + " 0x" + (0xFF & byArray[n]) + " 0x" + (0xFF & byArray2[n]));
        }
        if (n2 > n3) {
            System.out.println("Extra bytes from " + (n2 == byArray.length ? string : string2));
            System.out.println(HexDiff.toBytes(byArray3, n));
        }
    }

    public static String toBytes(byte[] byArray, int n) {
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer(n + " " + byArray.length + " bytes. \n00: ");
        StringBuffer stringBuffer2 = new StringBuffer();
        while (n < byArray.length) {
            String string = Integer.toHexString(byArray[n] & 0xFF) + " ";
            if ((byArray[n] & 0xFF) < 16) {
                string = "0" + string;
            }
            stringBuffer.append(string);
            stringBuffer2.append(HexDiff.AlNum(byArray[n] & 0xFF));
            if ((n + 1) % 16 == 0) {
                stringBuffer.append("\t " + stringBuffer2.toString() + "\n");
                if (++n2 < 16) {
                    stringBuffer.append(Integer.toHexString(n2) + "0: ");
                } else {
                    stringBuffer.append(Integer.toHexString(n2) + ": ");
                }
                stringBuffer2.setLength(0);
            }
            ++n;
        }
        stringBuffer.append("\t " + stringBuffer2.toString() + "\n\n");
        return stringBuffer.toString();
    }

    private static char AlNum(int n) {
        if (n >= 32 && n <= 126) {
            return (char)n;
        }
        return '.';
    }
}

