/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.toad.cfparse.instruction;

import com.ibm.toad.cfparse.ConstantPool;
import com.ibm.toad.cfparse.attributes.CodeAttrInfo;
import com.ibm.toad.cfparse.instruction.BaseInstruction;
import com.ibm.toad.cfparse.instruction.InstructionEvent;
import com.ibm.toad.cfparse.instruction.InstructionEventListener;
import com.ibm.toad.cfparse.instruction.MutableCodeSegment;
import java.util.Enumeration;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Vector;

public class MutableCodeIterator
implements Enumeration,
ListIterator {
    private int d_curInst;
    private int d_lastInst;
    private Vector d_listeners;
    private MutableCodeSegment d_mc;
    private Vector d_instructions;

    public void addInstructionListener(InstructionEventListener instructionEventListener) {
        this.d_listeners.add(instructionEventListener);
    }

    public MutableCodeIterator(ConstantPool constantPool, CodeAttrInfo codeAttrInfo, boolean bl) {
        this(new MutableCodeSegment(constantPool, codeAttrInfo, bl));
    }

    public MutableCodeIterator(MutableCodeSegment mutableCodeSegment) {
        this.d_mc = mutableCodeSegment;
        this.d_instructions = this.d_mc.getInstructions();
        this.d_curInst = 0;
        this.d_lastInst = -1;
        this.d_listeners = new Vector();
    }

    private void fireInstructionEvent(String string, BaseInstruction baseInstruction) {
        InstructionEvent instructionEvent = new InstructionEvent(string, baseInstruction);
        for (int i = 0; i < this.d_listeners.size(); ++i) {
            ((InstructionEventListener)this.d_listeners.get(i)).handleInstruction(instructionEvent);
        }
    }

    public void rewind() {
        this.d_curInst = 0;
    }

    public int length() {
        return this.d_instructions.size();
    }

    public Object next() throws NoSuchElementException {
        if (this.d_curInst == this.d_instructions.size()) {
            throw new NoSuchElementException("No instruction number " + this.d_curInst);
        }
        BaseInstruction baseInstruction = (BaseInstruction)this.d_instructions.elementAt(this.d_curInst);
        this.fireInstructionEvent("next", baseInstruction);
        this.d_lastInst = this.d_curInst++;
        return baseInstruction;
    }

    public Object previous() throws NoSuchElementException {
        if (this.d_curInst == 0) {
            throw new NoSuchElementException("No instruction number -1");
        }
        BaseInstruction baseInstruction = (BaseInstruction)this.d_instructions.elementAt(this.d_curInst);
        this.fireInstructionEvent("previous", baseInstruction);
        this.d_lastInst = this.d_curInst--;
        return baseInstruction;
    }

    public void remove() throws UnsupportedOperationException, IllegalStateException {
        if (this.d_lastInst == -1) {
            throw new IllegalStateException("Cannot call remove now");
        }
        this.fireInstructionEvent("remove", (BaseInstruction)this.d_instructions.elementAt(this.d_lastInst));
        this.d_instructions.removeElementAt(this.d_lastInst);
        this.d_lastInst = -1;
    }

    public void step(int n) {
        int n2 = this.d_curInst + n;
        if (n2 < 0 || n2 >= this.d_instructions.size()) {
            throw new NoSuchElementException("No instruction number " + n2);
        }
        this.d_curInst = n2;
    }

    public boolean hasNext() {
        return this.d_curInst != this.d_instructions.size();
    }

    public boolean hasPrevious() {
        return this.d_curInst != 0;
    }

    public boolean hasMoreElements() {
        return this.hasNext();
    }

    public Object nextElement() throws NoSuchElementException {
        return this.next();
    }

    public void add(Object object) throws UnsupportedOperationException {
        this.d_lastInst = -1;
        if (!(object instanceof BaseInstruction)) {
            throw new ClassCastException("argument is not a BaseInstruction");
        }
        this.fireInstructionEvent("add", (BaseInstruction)object);
        this.d_instructions.insertElementAt(object, this.d_curInst);
        ++this.d_curInst;
    }

    public int nextIndex() {
        return this.d_curInst + 1;
    }

    public int previousIndex() {
        return this.d_curInst - 1;
    }

    public void set(Object object) throws UnsupportedOperationException {
        this.d_lastInst = -1;
        if (!(object instanceof BaseInstruction)) {
            throw new ClassCastException("argument is not a BaseInstruction");
        }
        this.fireInstructionEvent("set", (BaseInstruction)object);
        this.d_instructions.setElementAt(object, this.d_curInst);
    }
}

