/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ffdc.util.formatting;

import com.ibm.ffdc.FFDC_OMIT;
import com.ibm.ffdc.Manager;
import com.ibm.ffdc.config.Formatter;
import com.ibm.ffdc.config.IncidentStream;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Introspector
implements Formatter {
    private final Formatter formatter;
    private final List<Class<?>> topDownHierarchyTail;

    public Introspector(Class<?> bottom, Class<?> top, Formatter formatter) {
        this.formatter = formatter;
        this.topDownHierarchyTail = this.getTopDownHierarchyTail(bottom, top);
    }

    private List<Class<?>> getTopDownHierarchyTail(Class<?> bottom, Class<?> top) {
        List<Class<?>> ht = this.getBottomUpHierarchyTail(bottom, top);
        Collections.reverse(ht);
        return ht;
    }

    private List<Class<?>> getBottomUpHierarchyTail(Class<?> bottom, Class<?> top) {
        ArrayList hierarchy = new ArrayList();
        do {
            hierarchy.add(bottom);
        } while ((bottom = bottom.equals(top) ? null : bottom.getSuperclass()) != null);
        return hierarchy;
    }

    @Override
    public void formatTo(Object objectToFormat, IncidentStream is) throws IllegalArgumentException {
        if (this.formatter != null) {
            this.formatter.formatTo(objectToFormat, is);
        }
        for (Class<?> cl : this.topDownHierarchyTail) {
            Field[] fields;
            try {
                fields = this.getDeclaredFields(cl);
            }
            catch (PrivilegedActionException e) {
                Manager.Ffdc.log(e, this, this.getClass().getName(), "95");
                return;
            }
            for (Field field : fields) {
                String name = cl.getName() + "::" + field.getName();
                try {
                    Object value = field.getAnnotation(FFDC_OMIT.class) != null ? "OMITTED BY FFDC" : this.getValue(field, objectToFormat);
                    is.write(name, value);
                }
                catch (PrivilegedActionException e) {
                    Manager.Ffdc.log(e, this, this.getClass().getName(), "104");
                }
            }
        }
    }

    @Override
    public String[] getSupportedTypeNames() {
        return new String[]{this.getSupportedClass().getName()};
    }

    @Override
    public boolean isSupported(Class<?> clazz) {
        return this.getSupportedClass().equals(clazz);
    }

    public Class<?> getSupportedClass() {
        return this.topDownHierarchyTail.get(this.topDownHierarchyTail.size() - 1);
    }

    private Field[] getDeclaredFields(final Class<?> cl) throws PrivilegedActionException {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<Field[]>(){

            @Override
            public Field[] run() {
                return cl.getDeclaredFields();
            }
        });
    }

    private Object getValue(final Field field, final Object objectToFormat) throws PrivilegedActionException {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                field.setAccessible(true);
                return field.get(objectToFormat);
            }
        });
    }
}

