/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ffdc.impl;

import com.ibm.ffdc.Manager;
import com.ibm.ffdc.impl.EmptyProvider;
import com.ibm.ffdc.provider.FfdcProvider;
import com.ibm.ffdc.util.provider.FfdcOnFileProvider;
import com.ibm.ffdc.util.provider.FfdcOnPrintStreamProvider;
import com.ibm.ffdc.util.provider.Incident;
import java.io.File;
import java.io.FileOutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ffdc
implements Manager {
    private static FfdcProvider provider;
    static final String SYSTEM_ERR = "System.err";
    static final String SYSTEM_OUT = "System.out";
    private static final String thisClass;
    public static final String resourceBundleName = "com.ibm.ffdc.FFDCBundleMessages";
    private static Logger tracer;
    static final String FFDC_LOG = "com.ibm.ffdc.log";

    public Ffdc() {
        Ffdc.setup();
    }

    public String toString() {
        return Ffdc.asString();
    }

    private static String asString() {
        return Ffdc.class.getName() + "<" + provider + ">";
    }

    public static synchronized void set(FfdcProvider anFfdcProvider) {
        assert (anFfdcProvider != null);
        FfdcProvider oldProvider = provider;
        provider = anFfdcProvider;
        if (oldProvider != null) {
            if (tracer.isLoggable(Level.FINER)) {
                tracer.logp(Level.FINER, thisClass, "set", "FfdcProvider uninstalled:" + Ffdc.toString(oldProvider));
            }
            Ffdc.release(oldProvider);
        }
        if (tracer.isLoggable(Level.FINER)) {
            tracer.logp(Level.FINER, thisClass, "set", "FfdcProvider installed:" + Ffdc.toString(provider));
        }
    }

    private static void release(FfdcProvider oldProvider) {
        try {
            oldProvider.release();
        }
        catch (Throwable th) {
            tracer.logp(Level.FINER, thisClass, "set", "FFDC provider error", th);
        }
    }

    public static synchronized void unset() {
        FfdcProvider oldProvider = provider;
        if (oldProvider == null || oldProvider instanceof EmptyProvider) {
            return;
        }
        Ffdc.set(new EmptyProvider());
    }

    private static synchronized FfdcProvider setFailsafeProvider(Throwable th) {
        FfdcProvider oldProvider = provider;
        if (oldProvider != null && oldProvider instanceof EmptyProvider) {
            return oldProvider;
        }
        if (tracer.isLoggable(Level.INFO)) {
            tracer.logp(Level.INFO, thisClass, "setFailsafeProvider", "FFDCProviderAborted", Ffdc.toString(oldProvider));
            tracer.logp(Level.INFO, thisClass, "setFailsafeProvider", "FFDCProviderAbortedE", th);
        }
        EmptyProvider p = new EmptyProvider();
        Ffdc.set(p);
        return p;
    }

    public static synchronized void abort(FfdcProvider failedProvider, Throwable th) {
        if (provider == failedProvider) {
            Ffdc.setFailsafeProvider(th);
        }
    }

    static String toString(FfdcProvider provider) {
        try {
            return String.valueOf(provider);
        }
        catch (Throwable th) {
            if (tracer.isLoggable(Level.FINER)) {
                tracer.logp(Level.FINER, thisClass, "toString", "FFDC detects failure", th);
            }
            return provider.getClass().getName();
        }
    }

    @Override
    public com.ibm.ffdc.Ffdc getFfdc(Throwable exception, Object reporter, String sourceId, String probeId) {
        try {
            return provider.getFfdc(exception, reporter, sourceId, probeId);
        }
        catch (Throwable th) {
            return Ffdc.setFailsafeProvider(th).getFfdc(exception, reporter, sourceId, probeId);
        }
    }

    @Override
    public com.ibm.ffdc.Ffdc getFfdc(Throwable exception, Object reporter, String sourceId) {
        try {
            return provider.getFfdc(exception, reporter, sourceId);
        }
        catch (Throwable th) {
            return Ffdc.setFailsafeProvider(th).getFfdc(exception, reporter, sourceId);
        }
    }

    @Override
    public void log(Throwable exception, Object reporter, String sourceId, String probeId, Object ... args) {
        try {
            provider.log(exception, reporter, sourceId, probeId, args);
        }
        catch (Throwable th) {
            Ffdc.setFailsafeProvider(th);
        }
    }

    @Override
    public void log(Throwable exception, Object reporter, String sourceId, String probeId) {
        try {
            provider.log(exception, reporter, sourceId, probeId);
        }
        catch (Throwable th) {
            Ffdc.setFailsafeProvider(th);
        }
    }

    @Override
    public List<Incident> getIncidents() {
        return provider.getIncidents();
    }

    @Override
    public boolean unblockLogging(Incident incident) {
        return provider.unblockLogging(incident);
    }

    private static synchronized void setup() {
        FfdcProvider provider;
        if (Ffdc.provider != null) {
            return;
        }
        try {
            provider = Ffdc.makeDefaultProvider();
        }
        catch (Throwable th) {
            provider = new EmptyProvider();
            tracer.logp(Level.WARNING, thisClass, "setup", "FFDCFailSafeErrChk", th);
        }
        Ffdc.set(provider);
    }

    private static FfdcProvider makeDefaultProvider() throws Exception {
        File logfile;
        String ffdclog = Ffdc.getFfdcLog();
        if (ffdclog == null || String.valueOf((Object)null).equalsIgnoreCase(ffdclog)) {
            return new EmptyProvider();
        }
        if (SYSTEM_ERR.equalsIgnoreCase(ffdclog)) {
            return new FfdcOnPrintStreamProvider(System.err, SYSTEM_ERR);
        }
        if (SYSTEM_OUT.equalsIgnoreCase(ffdclog)) {
            return new FfdcOnPrintStreamProvider(System.out, SYSTEM_OUT);
        }
        final File log = logfile = new File(ffdclog);
        FileOutputStream out = AccessController.doPrivileged(new PrivilegedExceptionAction<FileOutputStream>(){

            @Override
            public FileOutputStream run() throws Exception {
                File dir = log.getParentFile();
                if (dir != null) {
                    dir.mkdirs();
                }
                return new FileOutputStream(log);
            }
        });
        return new FfdcOnFileProvider(logfile, out);
    }

    private static String getFfdcLog() throws PrivilegedActionException {
        String log = AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

            @Override
            public String run() throws Exception {
                return System.getProperty(Ffdc.FFDC_LOG);
            }
        });
        tracer.logp(Level.FINER, thisClass, "getFfdcLog", "FFDC installation uses system property -Dcom.ibm.ffdc.log=" + log);
        return log;
    }

    public static FfdcProvider getProvider() {
        return provider;
    }

    static {
        thisClass = Ffdc.class.getName();
        try {
            tracer = Logger.getLogger(thisClass, resourceBundleName);
        }
        catch (Throwable t) {
            tracer = Logger.getLogger(thisClass);
            tracer.logp(Level.WARNING, "com.ibm.ffdc.impl.Ffdc", "<clinit>", "Unable to find FFDC message bundle.");
        }
    }
}

