/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util.deployment.utilities;

import com.ibm.ejs.util.deployment.utilities.JarEntry;
import com.ibm.ejs.util.deployment.utilities.UtilsTrace;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Vector;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class JarUtils {
    private static String copyright = "Licensed Material - Property of IBMIBM(R) VisualAge(R) for Java(TM), Version 2.0 - Professional/Enterprise Update(C) Copyright IBM Corp. 1998 - All Rights Reserved.US Government Users Restricted Rights - Use, duplication or disclosurerestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final char[] radix64Digits = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};

    public static final void createJar(String fileName, Vector jarEntries, String workingDir, boolean noCompress) throws Exception {
        JarEntry je;
        int i;
        PrintWriter mfWriter = null;
        File jarFile = null;
        File jarPath = null;
        String jarFileParent = null;
        FileOutputStream jarStream = null;
        ZipOutputStream zipStream = null;
        CRC32 crc32 = new CRC32();
        jarFile = new File(fileName);
        jarFileParent = jarFile.getParent();
        if (jarFileParent != null && !(jarPath = new File(jarFileParent)).exists()) {
            jarPath.mkdirs();
        }
        if (jarFile.isDirectory()) {
            throw new Exception();
        }
        String mfName = workingDir + File.separator + "META-INF" + File.separator + "MANIFEST.MF";
        UtilsTrace.trace("\nJarUtils: createJar(): Creating manifest file " + mfName);
        File mf = new File(mfName);
        if (mf.exists()) {
            mf.delete();
        }
        mfWriter = new PrintWriter(new FileOutputStream(mf));
        mfWriter.println("Manifest-Version: 1.0");
        for (i = 0; i < jarEntries.size(); ++i) {
            je = (JarEntry)jarEntries.elementAt(i);
            String entryName = je.getZipEntry().getName();
            String specialHeader = je.getManifestHeader();
            String[] digestInfo = JarUtils.getDigestManifestHeaders(je.getByteArray());
            mfWriter.println();
            mfWriter.println("Name: " + entryName);
            if (specialHeader != null) {
                mfWriter.println(specialHeader);
            }
            for (int j = 0; j < digestInfo.length; ++j) {
                mfWriter.println(digestInfo[j]);
            }
        }
        if (mfWriter != null) {
            mfWriter.close();
        }
        je = new JarEntry("META-INF/MANIFEST.MF", mfName);
        ZipEntry ze = je.getZipEntry();
        UtilsTrace.trace("\nJarUtils: createJar(): Creating jar file " + fileName);
        jarStream = new FileOutputStream(jarFile);
        zipStream = new ZipOutputStream(jarStream);
        if (noCompress) {
            zipStream.setMethod(0);
            ze.setMethod(0);
            ze.setSize(je.getByteArray().length);
            crc32.reset();
            crc32.update(je.getByteArray());
            ze.setCrc(crc32.getValue());
        }
        UtilsTrace.trace("     adding META-INF/MANIFEST.MF");
        zipStream.putNextEntry(ze);
        byte[] buf = je.getByteArray();
        zipStream.write(buf, 0, buf.length);
        zipStream.closeEntry();
        for (i = 0; i < jarEntries.size(); ++i) {
            je = (JarEntry)jarEntries.elementAt(i);
            ze = je.getZipEntry();
            if (noCompress) {
                ze.setMethod(0);
                ze.setSize(je.getByteArray().length);
                crc32.reset();
                crc32.update(je.getByteArray());
                ze.setCrc(crc32.getValue());
            }
            UtilsTrace.trace("     adding " + ze.getName());
            zipStream.putNextEntry(ze);
            if (!ze.isDirectory()) {
                buf = je.getByteArray();
                zipStream.write(buf, 0, buf.length);
            }
            zipStream.closeEntry();
        }
        if (zipStream != null) {
            zipStream.close();
        }
    }

    private static final String encode64(byte[] data) {
        StringBuffer result = new StringBuffer("");
        int length = data.length;
        for (int i = 0; i < length; i += 3) {
            byte b3;
            byte b2;
            byte b1;
            if (length - i == 1) {
                b1 = data[i];
                b2 = 0;
                b3 = 0;
                result.append(radix64Digits[b1 >>> 2 & 0x3F]);
                result.append(radix64Digits[(b1 << 4 & 0x30) + (b2 >>> 4 & 0xF)]);
                result.append("==");
                continue;
            }
            if (length - i == 2) {
                b1 = data[i];
                b2 = data[i + 1];
                b3 = 0;
                result.append(radix64Digits[b1 >>> 2 & 0x3F]).toString();
                result.append(radix64Digits[(b1 << 4 & 0x30) + (b2 >>> 4 & 0xF)]);
                result.append(radix64Digits[(b2 << 2 & 0x3C) + (b3 >>> 6 & 3)]);
                result.append('=');
                continue;
            }
            b1 = data[i];
            b2 = data[i + 1];
            b3 = data[i + 2];
            result.append(radix64Digits[b1 >>> 2 & 0x3F]);
            result.append(radix64Digits[(b1 << 4 & 0x30) + (b2 >>> 4 & 0xF)]);
            result.append(radix64Digits[(b2 << 2 & 0x3C) + (b3 >>> 6 & 3)]);
            result.append(radix64Digits[b3 & 0x3F]);
        }
        return new String(result);
    }

    public static final Vector extractJar(String srcJarFile, String dstDir, String excludeFilter) throws FileNotFoundException, IOException {
        FileInputStream srcStream = null;
        ZipInputStream zipStream = null;
        FileOutputStream outStream = null;
        byte[] ba = null;
        Vector<JarEntry> jarEntries = new Vector<JarEntry>();
        boolean extractFiles = true;
        File memberFile = null;
        File memberParentDir = null;
        if (dstDir == null) {
            extractFiles = false;
        }
        try {
            ZipEntry zipEntry;
            srcStream = new FileInputStream(srcJarFile);
            zipStream = new ZipInputStream(srcStream);
            while ((zipEntry = zipStream.getNextEntry()) != null) {
                String zeName = zipEntry.getName();
                boolean excludeFile = false;
                if (excludeFilter != null && zeName.endsWith(excludeFilter)) {
                    excludeFile = true;
                }
                String memberFilePath = zeName;
                memberFilePath = dstDir + File.separator + memberFilePath.replace('/', File.separatorChar);
                if (extractFiles && !excludeFile && !(memberParentDir = new File((memberFile = new File(memberFilePath)).getParent())).exists()) {
                    memberParentDir.mkdirs();
                }
                if (!zipEntry.isDirectory()) {
                    if (extractFiles && !excludeFile) {
                        outStream = new FileOutputStream(memberFile);
                    }
                    BufferedInputStream inStream = new BufferedInputStream(zipStream);
                    ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
                    int bytesRead = inStream.read();
                    while (bytesRead != -1) {
                        if (extractFiles && !excludeFile) {
                            outStream.write(bytesRead);
                        }
                        byteStream.write(bytesRead);
                        bytesRead = inStream.read();
                    }
                    if (outStream != null && extractFiles && !excludeFile) {
                        outStream.close();
                    }
                    if (byteStream != null) {
                        ba = byteStream.toByteArray();
                        byteStream.close();
                    }
                }
                if (zeName.startsWith("META-INF/MANIFEST.MF") || zipEntry.isDirectory()) continue;
                jarEntries.addElement(new JarEntry(zeName, memberFilePath, ba));
            }
            return jarEntries;
        }
        catch (IOException e) {
            if (srcStream != null) {
                srcStream.close();
            }
            if (zipStream != null) {
                zipStream.close();
            }
            if (outStream != null) {
                outStream.close();
            }
            throw e;
        }
    }

    private static final String[] getDigestManifestHeaders(byte[] ba) throws NoSuchAlgorithmException {
        String[] hdrs = new String[3];
        MessageDigest mdSHA = MessageDigest.getInstance("SHA");
        MessageDigest mdMD5 = MessageDigest.getInstance("MD5");
        if (ba != null) {
            mdSHA.reset();
            mdSHA.update(ba);
            byte[] hashSHA = mdSHA.digest();
            mdMD5.reset();
            mdMD5.update(ba);
            byte[] hashMD5 = mdMD5.digest();
            hdrs[0] = "Digest-Algorithms: SHA MD5";
            hdrs[1] = "SHA-Digest: " + JarUtils.encode64(hashSHA);
            hdrs[2] = "MD5-Digest: " + JarUtils.encode64(hashMD5);
        }
        return hdrs;
    }

    public static final DataInputStream locateInJar(String jarFileName, String zipEntryName) throws FileNotFoundException, IOException, ZipException {
        FileInputStream fin = new FileInputStream(jarFileName);
        ZipInputStream in = new ZipInputStream(fin);
        ZipEntry entry = in.getNextEntry();
        while (entry != null && !entry.getName().equals(zipEntryName)) {
            entry = in.getNextEntry();
        }
        if (!entry.getName().equals(zipEntryName)) {
            in.close();
            return null;
        }
        return new DataInputStream(in);
    }
}

