/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util.deployment.deploywrapper;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;

public class DeployOptions
implements Serializable {
    private static final long serialVersionUID = 1088003601992747626L;
    private String workingDirectory;
    private ArrayList classPath = new ArrayList();
    private String clientJarName = null;
    private String deployedModuleName = null;
    private String inputModuleName = null;
    private String RMICOptions = null;
    private boolean isCodegenOnly = false;
    private boolean isValidation = false;
    private boolean isSQLJDeploy = false;
    private String dbType = "";
    private String schemaName = null;
    private String databaseName = null;
    private String complianceLevel = "";
    private static final String[] databaseTypes = new String[]{"DB2UDB_V81", "DB2UDB_V82", "DB2UDB_V91", "DB2UDB_V95", "DB2UDBOS390_V8", "DB2UDBOS390_NEWFN_V8", "DB2UDBOS390_V9", "DB2UDBISERIES_V53", "DB2UDBISERIES_V54", "DERBY_V10", "DERBY_V101", "INFORMIX_V100", "INFORMIX_V110", "MSSQLSERVER_2005", "ORACLE_V10G", "ORACLE_V11G", "SYBASE_V1250", "SYBASE_V15"};
    private static final String[] deployEJBOptions = new String[]{"JDBC", "SQLj"};
    private static final String[] jdkComplianceLevels = new String[]{"1.4", "5.0", "6.0"};

    public static String[] getDatabaseTypes() {
        return databaseTypes;
    }

    public static String[] getDeployEJBOptions() {
        return deployEJBOptions;
    }

    public static String[] getJdkComplianceLevels() {
        return jdkComplianceLevels;
    }

    public String[] getClasspath() {
        Object[] ob = this.classPath.toArray();
        String[] str = new String[ob.length];
        for (int i = 0; i < ob.length; ++i) {
            str[i] = (String)ob[i];
        }
        return str;
    }

    public String getClientJarName() {
        return this.clientJarName;
    }

    public String getDeployedModuleName() {
        return this.deployedModuleName;
    }

    public String getInputModuleName() {
        return this.inputModuleName;
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public String getDependentClasspath() {
        StringBuffer out = new StringBuffer();
        String[] classPath = this.getClasspath();
        for (int i = 0; i < classPath.length; ++i) {
            out.append(classPath[i]).append(File.pathSeparatorChar);
        }
        return out.toString();
    }

    public String getRMICOptions() {
        return this.RMICOptions;
    }

    public String getDatabaseType() {
        return this.dbType;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getComplianceLevel() {
        return this.complianceLevel;
    }

    public boolean isCodegenOnly() {
        return this.isCodegenOnly;
    }

    public boolean isValidation() {
        return this.isValidation;
    }

    public boolean isSQLJDeploy() {
        return this.isSQLJDeploy;
    }

    public void setClasspath(String cp) {
        this.classPath.clear();
        if (cp != null) {
            this.classPath.add(cp);
        }
    }

    public void setClasspath(String[] cp) {
        this.classPath.clear();
        for (int i = 0; i < cp.length; ++i) {
            if (cp[i] == null) continue;
            this.classPath.add(cp[i]);
        }
    }

    public void setClientJarName(String name) {
        this.clientJarName = name;
    }

    public void setDeployedModuleName(String name) {
        this.deployedModuleName = name;
    }

    public void setInputModuleName(String name) {
        this.inputModuleName = name;
    }

    public void setCodegenOnly(boolean only) {
        this.isCodegenOnly = only;
    }

    public void setWorkingDirectory(String workingDir) {
        this.workingDirectory = workingDir;
    }

    public void setDependentClasspath(String classpath) {
        this.setClasspath(classpath);
    }

    public void setRMICOptions(String options) {
        this.RMICOptions = options;
    }

    public void setValidation(boolean validation) {
        this.isValidation = validation;
    }

    public void setSQLJDeploy(boolean sqljDeploy) {
        this.isSQLJDeploy = sqljDeploy;
    }

    public void setDatabaseType(String type) {
        this.dbType = type;
    }

    public void setSchemaName(String name) {
        this.schemaName = name;
    }

    public void setDatabaseName(String name) {
        this.databaseName = name;
    }

    public void setComplianceLevel(String complianceLevel) {
        this.complianceLevel = complianceLevel;
    }

    public String toString() {
        StringBuffer out = new StringBuffer();
        out.append("inputModuleName: ").append(this.getInputModuleName());
        out.append(", workingDirectory: ").append(this.getWorkingDirectory());
        out.append(", deployedModuleName: ").append(this.getDeployedModuleName());
        out.append(", clientJarName: ").append(this.getClientJarName());
        out.append(", isCodegenOnly: ").append(this.isCodegenOnly());
        out.append(", classpath: ");
        String[] classPath = this.getClasspath();
        for (int i = 0; i < classPath.length; ++i) {
            out.append(classPath[i]).append(' ');
        }
        out.append(", isValidation: ").append(this.isValidation);
        out.append(", RMICOptions: ").append(this.RMICOptions);
        out.append(", dbType: ").append(this.dbType);
        out.append(", schemaName: ").append(this.schemaName);
        out.append(", databaseName: ").append(this.databaseName);
        out.append(", complianceLevel: ").append(this.complianceLevel);
        return out.toString();
    }
}

