/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.RasHelper;
import com.ibm.websphere.logging.WsLevel;
import com.ibm.ws.logging.LoggerHelper;
import com.ibm.ws.logging.TraceLogFormatter;
import com.ibm.ws.logging.WsHandler;
import com.ibm.ws.logging.ZRasHelper;
import com.ibm.ws.logging.object.WsLogRecord;
import com.ibm.ws.logging.object.WsLogRecordFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.util.EventFormatter;

public class CB390TraceEventListener
implements WsHandler {
    static final int LEVELVALUE_SEVERE = Level.SEVERE.intValue();
    static final int LEVELVALUE_WARNING = Level.WARNING.intValue();
    static final int RECORD_VERSION = 1;
    private static final int MAX_LOGSTREAM_HEADER_SIZE = 256;
    private static final String CLASSNAME = CB390TraceEventListener.class.getName();
    private static final String svLoggerName = "com.ibm.ejs.ras.CB390TraceEventListener";
    private static final String BUNDLENAME = "com.ibm.ejs.resources.RasMessages";
    private static Logger svLogger = null;
    private static boolean sbUseCBEFormat;
    private String serverName = nativeMethodsLoaded ? this.getServerName() : "";
    private static String ibm;
    private static String websphere;
    private static boolean nativeMethodsLoaded;

    private native String getServerName();

    private native void writeTrace(int var1, byte[] var2, int var3, String var4, String var5, String var6, String var7, String var8, String var9, String var10, String var11, int var12, String var13, String var14, String var15, byte[] var16, boolean var17);

    public void processEvent(LogRecord event2) {
        if (!nativeMethodsLoaded) {
            return;
        }
        int levelInt = 0;
        String component2 = null;
        String threadId = null;
        String methodName = null;
        String eventSource = null;
        String organization = null;
        String product2 = null;
        String version = null;
        String category = null;
        String stackTrace = null;
        byte[] rawData = null;
        String primaryMessage = null;
        String handlerPreference = null;
        WsLogRecord wsLogRecord = WsLogRecordFactory.getWsLogRecordIfConvertible(event2);
        levelInt = event2.getLevel().intValue();
        eventSource = event2.getLoggerName();
        category = event2.getLevel().getName();
        if (wsLogRecord != null) {
            stackTrace = wsLogRecord.getStackTrace();
            rawData = wsLogRecord.getRawData();
            component2 = wsLogRecord.getComponent();
            organization = wsLogRecord.getOrganization();
            product2 = wsLogRecord.getProduct();
            if (organization == ibm && product2 == websphere) {
                version = wsLogRecord.getVersion();
            }
            handlerPreference = wsLogRecord.getExtension("handler_preference");
        }
        threadId = RasHelper.getThreadId(event2);
        primaryMessage = TraceLogFormatter.formatMessage(event2, Locale.getDefault(), 4);
        if (stackTrace == null) {
            stackTrace = TraceLogFormatter.getStackTrace(event2);
        }
        if (component2 == null) {
            component2 = "";
        }
        if (threadId == null) {
            threadId = "";
        }
        if (methodName == null) {
            methodName = "";
        }
        if (eventSource == null) {
            eventSource = "";
        }
        if (organization == null) {
            organization = "";
        }
        if (product2 == null) {
            product2 = "";
        }
        if (version == null) {
            version = "";
        }
        if (category == null) {
            category = "";
        }
        if (stackTrace == null) {
            stackTrace = "";
        }
        if (rawData == null) {
            rawData = new byte[]{};
        }
        if (primaryMessage == null) {
            primaryMessage = "";
        }
        if (handlerPreference == null) {
            handlerPreference = "";
        }
        int severity = 0;
        severity = levelInt >= LEVELVALUE_SEVERE ? 1 : (levelInt >= LEVELVALUE_WARNING ? 2 : 3);
        if (event2.getSourceClassName() == null) {
            event2.setSourceClassName("");
        }
        if (event2.getSourceMethodName() == null) {
            event2.setSourceMethodName("");
        }
        if ((methodName = "".equals(event2.getSourceClassName()) ? event2.getSourceMethodName() : ("".equals(event2.getSourceMethodName()) ? event2.getSourceClassName() : event2.getSourceClassName() + "." + event2.getSourceMethodName())).length() == 0 && eventSource.length() > 0) {
            methodName = eventSource;
        }
        boolean isWTO = false;
        if (handlerPreference != null && handlerPreference.equals("operator")) {
            isWTO = true;
        }
        CommonBaseEvent cbe = null;
        byte[] recordDataBytes = null;
        if (sbUseCBEFormat && (cbe = WsLogRecordFactory.getCommonBaseEvent(event2)) != null) {
            recordDataBytes = CB390TraceEventListener.convertToZippedCBEXML(cbe);
        }
        if (nativeMethodsLoaded) {
            this.writeTrace(1, recordDataBytes, levelInt, component2, threadId, methodName, eventSource, organization, product2, version, this.serverName, severity, category, primaryMessage, stackTrace, rawData, isWTO);
        }
    }

    private static byte[] convertToZippedCBEXML(CommonBaseEvent cbe) {
        byte[] recordDataBytes;
        block10: {
            recordDataBytes = null;
            String recordData = EventFormatter.toCanonicalXMLString(cbe, false);
            if (recordData != null) {
                try {
                    recordDataBytes = CB390TraceEventListener.zip(recordData);
                    if (recordDataBytes == null) {
                        if (svLogger.isLoggable(Level.FINE)) {
                            svLogger.logp(Level.FINE, CLASSNAME, "processEvent", "No data returned from zip method -- CommonBaseEvent will not be logged.  CommonBaseEvent:" + recordData);
                        }
                    } else {
                        int maxSize = ZRasHelper.ProcessInfo.getLogRecordSize();
                        int dataSize = recordDataBytes.length + 256;
                        if (maxSize > 0 && dataSize > maxSize) {
                            if (svLogger.isLoggable(Level.FINE)) {
                                svLogger.logp(Level.FINE, CLASSNAME, "processEvent", "Log entry is of size " + dataSize + " bytes which is too large to be added to log stream which is configured for " + maxSize + " byte records.  This CommonBaseEvent will not be logged to log stream.  CommonBaseEvent:" + recordData);
                            }
                            recordDataBytes = CB390TraceEventListener.createZippedMessage_MessageTooLong(recordDataBytes.length, maxSize);
                        }
                    }
                    break block10;
                }
                catch (IOException e) {
                    if (svLogger.isLoggable(Level.FINE)) {
                        svLogger.logp(Level.FINE, CLASSNAME, "processEvent", "IOException encountered during zip of CommonBaseEvent.  CommonBaseEvent will not be logged to log stream.  CommonBaseEvent:" + recordData);
                    }
                    break block10;
                }
            }
            if (svLogger.isLoggable(Level.FINE)) {
                svLogger.logp(Level.FINE, CLASSNAME, "processEvent", "Unable to convert cbe into an XML string.  CommonBaseEvent will not be logged to log stream.");
            }
        }
        return recordDataBytes;
    }

    private static byte[] zip(String s) throws IOException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DeflaterOutputStream os2 = new DeflaterOutputStream(baos);
            os2.write(s.getBytes("UTF-8"));
            os2.flush();
            os2.close();
            return baos.toByteArray();
        }
        catch (IOException e) {
            svLogger.throwing(CLASSNAME, "zip", e);
            throw e;
        }
    }

    private static String unzip(byte[] b) throws IOException {
        int BUFFER_SIZE = 1024;
        ByteArrayInputStream bais = new ByteArrayInputStream(b);
        InflaterInputStream is = new InflaterInputStream(bais);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int totalbytesread = 0;
        int bufferspace = 1024;
        int bytesread = 0;
        byte[] tempBytes = new byte[1024];
        while (bytesread >= 0) {
            bytesread = is.read(tempBytes, 0, 1024);
            if (bytesread <= 0) continue;
            baos.write(tempBytes, 0, bytesread);
            totalbytesread += bytesread;
            bufferspace -= bytesread;
        }
        baos.flush();
        return new String(baos.toByteArray(), "UTF-8");
    }

    private static byte[] createZippedMessage_MessageTooLong(int size, int maxSize) {
        Object[] parms = new Object[]{new Integer(size), new Integer(maxSize)};
        byte[] recordDataBytes = CB390TraceEventListener.createZippedMessage("MSG_TOO_LARGE_FOR_LOGSTREAM", parms);
        if (recordDataBytes == null || recordDataBytes.length + 256 > maxSize) {
            return null;
        }
        return recordDataBytes;
    }

    private static byte[] createZippedMessage(String msgKey, Object[] parms) {
        WsLogRecord errorWsLogRecord = WsLogRecordFactory.createWsLogRecord(null, Level.SEVERE, msgKey, parms, CLASSNAME, "processEvent", BUNDLENAME, null, null, null, null, null, null, Level.ALL.intValue(), svLoggerName);
        CommonBaseEvent errorCBE = WsLogRecordFactory.getCommonBaseEvent(errorWsLogRecord.getImpl());
        String recordData = EventFormatter.toCanonicalXMLString(errorCBE, false);
        byte[] recordDataBytes = null;
        try {
            recordDataBytes = CB390TraceEventListener.zip(recordData);
        }
        catch (IOException e) {
            // empty catch block
        }
        return recordDataBytes;
    }

    static {
        try {
            svLogger = Logger.getLogger(svLoggerName, BUNDLENAME);
        }
        catch (MissingResourceException e) {
            svLogger = Logger.getLogger(svLoggerName);
            svLogger.throwing(CLASSNAME, "static init", e);
        }
        LoggerHelper.setAttributes(svLogger, "IBM", "WebSphere", "RAS", WsLevel.DETAIL);
        String errorLogFormat = RasHelper.getSystemProperty("com.ibm.ws.logging.zOS.errorLog.format");
        sbUseCBEFormat = errorLogFormat != null && errorLogFormat.equals("CBE-XML-1.0.1");
        ibm = "IBM";
        websphere = "WebSphere";
        nativeMethodsLoaded = false;
        if (System.getProperty("com.ibm.ws390.trace.nolib") == null) {
            String CurrentBitmode = System.getProperty("com.ibm.vm.bitmode");
            int bitmode = Integer.parseInt(CurrentBitmode);
            if (bitmode == 64) {
                System.loadLibrary("bbgrjras");
            } else {
                System.loadLibrary("bborjras");
            }
            nativeMethodsLoaded = true;
        } else {
            nativeMethodsLoaded = false;
        }
    }
}

