/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.models.base.extensions.ejbext;

import com.ibm.ejs.models.base.extensions.ejbext.MofCrawlerListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.wst.common.internal.emf.utilities.Revisit;

public abstract class MofCrawler
extends AdapterImpl {
    private HashMap containmentMap = new HashMap();
    private HashSet listeningHashSet = new HashSet();
    private Vector listeners = new Vector();
    private EClass target;
    private boolean fireEvents;
    private EObject startPoint;
    private Notification currentNotification;

    public MofCrawler() {
    }

    public MofCrawler(EClass target) {
        this.setTarget(target);
    }

    protected void setTarget(EClass target) {
        this.target = target;
    }

    protected void addMap(EClass eClass, EReference reference) {
        this.containmentMap.put(eClass, reference);
    }

    private EObject findRoot(EObject refObject) {
        EObject base = refObject.eContainer();
        while (null != base) {
            refObject = base;
            base = refObject.eContainer();
        }
        return refObject;
    }

    protected void setStartPoint(EObject refObject) {
        this.startPoint = refObject;
        this.fireEvents = false;
        this.addRefObject(refObject, 3);
        this.fireEvents = true;
    }

    protected Notification getCurrentNotification() {
        return this.currentNotification;
    }

    public void notifyChanged(Notification msg) {
        this.currentNotification = msg;
        Revisit.toDo();
        this.notifyChangedRevist((Notifier)msg.getNotifier(), msg.getEventType(), (EObject)msg.getFeature(), msg.getOldValue(), msg.getNewValue(), msg.getPosition());
    }

    private void notifyChangedRevist(Notifier notifier, int eventType, EObject feature, Object oldValue, Object newValue, int index) {
        block15: {
            try {
                if (!(notifier instanceof EObject)) break block15;
                EObject refObject = (EObject)notifier;
                switch (eventType) {
                    case 1: 
                    case 3: {
                        if (newValue instanceof EObject) {
                            this.addRefObject((EObject)newValue, 3);
                        }
                        if (refObject.eClass() != this.target) break;
                        this.addRefObject(refObject, 3);
                        break;
                    }
                    case 4: {
                        if (index != -1 && oldValue instanceof EObject) {
                            this.removeRefObject((EObject)oldValue, 4);
                        }
                        if (refObject.eClass() != this.target) break;
                        this.removeRefObject(refObject, 4);
                        break;
                    }
                    case 2: {
                        if (this.containmentMap.containsValue(feature) && oldValue instanceof EObject) {
                            this.removeRefObject((EObject)oldValue, 4);
                        }
                        if (refObject.eClass() != this.target) break;
                        this.notifyTarget(refObject, 3);
                        break;
                    }
                    case 8: {
                        if (oldValue != this) break;
                        this.removeAdapter(refObject, eventType, false);
                        break;
                    }
                    case 5: {
                        for (Object object : (Collection)newValue) {
                            if (!(object instanceof EObject)) continue;
                            this.addRefObject((EObject)object, 3);
                        }
                        break;
                    }
                    case 6: {
                        for (Object object : (Collection)oldValue) {
                            if (!(object instanceof EObject)) continue;
                            this.removeRefObject((EObject)object, 4);
                        }
                        break;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void removeRefObject(EObject refObject, int eventType) {
        try {
            if (null != refObject) {
                TreeIterator i = EcoreUtil.getAllContents(refObject.eContents());
                while (i.hasNext()) {
                    this.removeAdapter((EObject)i.next(), eventType);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void removeAdapter(EObject deleteRefObject, int eventType) {
        this.removeAdapter(deleteRefObject, eventType, true);
    }

    private void removeAdapter(EObject deleteRefObject, int eventType, boolean shouldRemoveCrawler) {
        try {
            if (this.listeningHashSet.contains(deleteRefObject)) {
                this.listeningHashSet.remove(deleteRefObject);
                if (shouldRemoveCrawler) {
                    deleteRefObject.eAdapters().remove(this);
                }
                if (this.fireEvents && this.target == deleteRefObject.eClass()) {
                    this.notifyTarget(deleteRefObject, eventType);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addRefObject(EObject refObject, int eventType) {
        try {
            if (null != refObject && (this.target == refObject.eClass() || this.containmentMap.containsKey(refObject.eClass()))) {
                EReference reference;
                if (!this.listeningHashSet.contains(refObject)) {
                    this.listeningHashSet.add(refObject);
                    refObject.eAdapters().add(this);
                }
                if (this.fireEvents && this.target == refObject.eClass()) {
                    this.notifyTarget(refObject, eventType);
                }
                if (null != (reference = (EReference)this.containmentMap.get(refObject.eClass()))) {
                    Object refValue = refObject.eGet(reference);
                    if (reference.isMany()) {
                        Iterator iterator = ((List)refValue).iterator();
                        while (iterator.hasNext()) {
                            this.addRefObject((EObject)iterator.next(), eventType);
                        }
                    } else {
                        this.addRefObject((EObject)refValue, eventType);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final void addMofCrawlerListener(MofCrawlerListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public final void removeMofCrawlerListener(MofCrawlerListener listener) {
        this.listeners.remove(listener);
        if (this.listeners.size() == 0) {
            HashSet clone = (HashSet)this.listeningHashSet.clone();
            this.listeningHashSet.clear();
            for (EObject refObject : clone) {
                refObject.eAdapters().remove(this);
            }
            MofCrawler.removeInstance(this.startPoint);
        }
    }

    protected static void removeInstance(EObject refObject) {
    }

    protected void notifyTarget(EObject refObject, int eventType) {
        Notification[] notifications = this.createNotification(refObject, eventType);
        if (null != notifications) {
            for (MofCrawlerListener listener : this.listeners) {
                for (int i = 0; i < notifications.length; ++i) {
                    if (notifications[i] == null) continue;
                    listener.notifyCrawlerChangedEvent(notifications[i]);
                }
            }
        }
    }

    protected abstract Notification[] createNotification(EObject var1, int var2);
}

