/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container.util;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;

public final class DeploymentUtil {
    public static String methodKey(Method m) {
        StringBuffer result = new StringBuffer(m.getName());
        result.append("(");
        Class<?>[] argTypes = m.getParameterTypes();
        for (int i = 0; i < argTypes.length; ++i) {
            result.append(argTypes[i].getName());
            result.append(",");
        }
        result.append(")");
        return result.toString();
    }

    public static Method[] getAllMethods(Class intf) {
        Method[] allMethods = intf.getMethods();
        ArrayList<Method> result = new ArrayList<Method>(allMethods.length);
        HashMap<String, Method> methodNameTable = new HashMap<String, Method>();
        for (int i = 0; i < allMethods.length; ++i) {
            Method m = allMethods[i];
            if (Modifier.isStatic(m.getModifiers())) continue;
            String mKey = DeploymentUtil.methodKey(m);
            String interfaceName = m.getDeclaringClass().getName();
            if ((interfaceName.equals("javax.ejb.EJBObject") || interfaceName.equals("javax.ejb.EJBLocalObject")) && !m.getName().equals("remove")) continue;
            Method synonym = (Method)methodNameTable.get(mKey);
            if (synonym == null) {
                methodNameTable.put(mKey, m);
                result.add(m);
                continue;
            }
            Class<?> mClass = m.getDeclaringClass();
            Class<?> sClass = synonym.getDeclaringClass();
            if (!sClass.isAssignableFrom(mClass)) continue;
            methodNameTable.put(mKey, m);
            result.set(result.indexOf(synonym), m);
        }
        return DeploymentUtil.sortMethods(result);
    }

    public static Method[] getMethods(Class intf) {
        return DeploymentUtil.getMethods(intf, null);
    }

    public static Method[] getMethods(Class componentInterface, Class[] businessInterfaces) {
        Class<?> sClass;
        Class<?> mClass;
        Method synonym;
        int i;
        int numMethods = 0;
        Method[] methods = null;
        int numBusinessInterfaces = 0;
        HashMap<String, Method> methodNameTable = new HashMap<String, Method>();
        if (componentInterface != null) {
            methods = componentInterface.getMethods();
            numMethods = methods.length;
        }
        if (businessInterfaces != null) {
            numBusinessInterfaces = businessInterfaces.length;
        }
        ArrayList<Method> result = new ArrayList<Method>(numMethods + numBusinessInterfaces * 10);
        for (i = 0; i < numMethods; ++i) {
            Method m = methods[i];
            if (Modifier.isStatic(m.getModifiers())) continue;
            String mKey = DeploymentUtil.methodKey(m);
            String interfaceName = m.getDeclaringClass().getName();
            if (interfaceName.equals("javax.ejb.EJBObject") || interfaceName.equals("javax.ejb.EJBLocalObject")) continue;
            synonym = (Method)methodNameTable.get(mKey);
            if (synonym == null) {
                methodNameTable.put(mKey, m);
                result.add(m);
                continue;
            }
            mClass = m.getDeclaringClass();
            sClass = synonym.getDeclaringClass();
            if (!sClass.isAssignableFrom(mClass)) continue;
            methodNameTable.put(mKey, m);
            result.set(result.indexOf(synonym), m);
        }
        for (i = 0; i < numBusinessInterfaces; ++i) {
            methods = businessInterfaces[i].getMethods();
            numMethods = methods.length;
            result.ensureCapacity(result.size() + numMethods);
            for (int j = 0; j < numMethods; ++j) {
                Method m = methods[j];
                if (Modifier.isStatic(m.getModifiers())) continue;
                String mKey = DeploymentUtil.methodKey(m);
                synonym = (Method)methodNameTable.get(mKey);
                if (synonym == null) {
                    methodNameTable.put(mKey, m);
                    result.add(m);
                    continue;
                }
                mClass = m.getDeclaringClass();
                sClass = synonym.getDeclaringClass();
                if (!sClass.isAssignableFrom(mClass)) continue;
                methodNameTable.put(mKey, m);
                result.set(result.indexOf(synonym), m);
            }
        }
        return DeploymentUtil.sortMethods(result);
    }

    private static Method[] sortMethods(ArrayList methods) {
        int numMethods = methods.size();
        Method[] result = new Method[numMethods];
        for (int i = 0; i < numMethods; ++i) {
            Method currMethod = (Method)methods.get(i);
            String currMethodName = currMethod.toString();
            for (int insertIndex = 0; insertIndex < i && currMethodName.compareTo(result[insertIndex].toString()) > 0; ++insertIndex) {
            }
            for (int j = insertIndex; j <= i; ++j) {
                Method tmpMethod = result[j];
                result[j] = currMethod;
                currMethod = tmpMethod;
            }
        }
        return result;
    }
}

