/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ISecurityLocalObjectCSIv2UtilityImpl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.security.auth.Subject;

public final class SecurityExecutionEnvironment
implements Serializable {
    private static final TraceComponent tc = Tr.register(SecurityExecutionEnvironment.class, "SASRas", "com.ibm.ISecurityL13SupportImpl.sec");
    private static final long serialVersionUID = 8804343014975817029L;
    private static final int VERSION_1 = 1;
    private int _version = 1;
    private boolean _isServerCredential;
    private boolean _isUnauthenticatedCredential;
    private boolean _isBasicAuthCredential;
    private boolean _isForwardableCredential;
    private String _realm;
    private String _securityName;
    private String _accessId;
    private String _uniqueSecurityName;
    private ArrayList _groupIds;
    private String _oid;
    private byte[] _credentialToken;
    private long _expiration;
    private String _clientUniqueId;
    private String _managedNodeUUID;
    private static Class adminContextClz = null;
    private static Method peekMethod = null;
    private static final Class thisClass = SecurityExecutionEnvironment.class;

    public SecurityExecutionEnvironment() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        this.initializeManagedNodeUUID();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public SecurityExecutionEnvironment(Subject subject) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", subject);
        }
        WSCredential cred = SubjectHelper.getWSCredentialFromSubject(subject);
        ContextManager contextManager = ContextManagerFactory.getInstance();
        String clientUniqueId = contextManager.getClientUniqueIDForOutboundRequests(subject);
        this.initialize(cred, clientUniqueId);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public SecurityExecutionEnvironment(WSCredential cred, String clientUniqueId) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{cred, clientUniqueId});
        }
        this.initialize(cred, clientUniqueId);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    private void initialize(WSCredential cred, String clientUniqueId) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize", new Object[]{cred, clientUniqueId});
        }
        try {
            ContextManager contextManager = ContextManagerFactory.getInstance();
            this._isServerCredential = contextManager.isServerCred(cred);
            this._isUnauthenticatedCredential = cred.isUnauthenticated();
            this._isBasicAuthCredential = cred.isBasicAuth();
            this._isForwardableCredential = cred.isForwardable();
            this._realm = cred.getRealmName();
            this._securityName = cred.getSecurityName();
            this._accessId = cred.getAccessId();
            this._uniqueSecurityName = cred.getUniqueSecurityName();
            this._clientUniqueId = clientUniqueId;
            this._groupIds = cred.getGroupIds();
            this._oid = cred.getOID();
            this._credentialToken = cred.getCredentialToken();
            this._expiration = cred.getExpiration();
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, this, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.SecurityExecutionEnvironment", "225", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unable to build SecurityExecutionEnvrionment", e);
            }
            this._isUnauthenticatedCredential = true;
            this._credentialToken = null;
            this._expiration = 1L;
        }
        this.initializeManagedNodeUUID();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public Hashtable getLoginHashtable() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLoginHashtable");
        }
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        if (this._isBasicAuthCredential) {
            if (this._realm != null) {
                ht.put("com.ibm.wsspi.security.cred.realm", this._realm);
            }
            if (this._securityName != null) {
                ht.put("com.ibm.wsspi.security.cred.userId", this._securityName);
            }
            if (this._credentialToken != null) {
                ht.put("com.ibm.wsspi.security.cred.password", new String(this._credentialToken));
            }
        } else if (!this._isUnauthenticatedCredential && !this._isServerCredential) {
            if (this._uniqueSecurityName != null) {
                ht.put("com.ibm.wsspi.security.cred.uniqueId", this._accessId);
            }
            if (this._realm != null) {
                ht.put("com.ibm.wsspi.security.cred.realm", this._realm);
            }
            if (this._securityName != null) {
                ht.put("com.ibm.wsspi.security.cred.securityName", this._securityName);
            }
            if (this._groupIds != null) {
                ht.put("com.ibm.wsspi.security.cred.groups", this._groupIds);
            }
            if (this._oid != null) {
                ht.put("com.ibm.wsspi.security.cred.oid", this._oid);
            }
            ht.put("com.ibm.wsspi.security.cred.forwardable", this._isForwardableCredential ? "true" : "false");
        } else if (this._isUnauthenticatedCredential || this._isServerCredential) {
            ht = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLoginHashtable", ht);
        }
        return ht;
    }

    public boolean isServerCredential() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isServerCredential");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isServerCredential", new Boolean(this._isServerCredential));
        }
        return this._isServerCredential;
    }

    public boolean isUnauthenticatedCredential() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isUnauthenticatedCredential");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isUnauthenticatedCredential");
        }
        return this._isUnauthenticatedCredential;
    }

    public boolean isBasicAuthCredential() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isBasicAuthCredential");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isBasicAuthCredential", new Boolean(this._isBasicAuthCredential));
        }
        return this._isBasicAuthCredential;
    }

    public boolean isForwardableCredential() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isForwardableCredential");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isForwardableCredential", new Boolean(this._isForwardableCredential));
        }
        return this._isForwardableCredential;
    }

    public String getRealm() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRealm");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRealm", this._realm);
        }
        return this._realm;
    }

    public String getSecurityName() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSecurityName");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSecurityName", this._securityName);
        }
        return this._securityName;
    }

    public String getAccessId() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAccessId");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAccessId", this._accessId);
        }
        return this._accessId;
    }

    public String getUniqueId() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUniqueId");
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUniqueId", this._uniqueSecurityName);
        }
        return this._uniqueSecurityName;
    }

    public String getClientUniqueId() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClientUniqueId");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClientUniqueId", this._clientUniqueId);
        }
        return this._clientUniqueId;
    }

    public ArrayList getGroupIds() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGroupIds");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGroupIds", this._groupIds);
        }
        return this._groupIds;
    }

    public String getOID() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOID");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOID", this._oid);
        }
        return this._oid;
    }

    public byte[] getCredentialToken() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCredentialToken");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCredentialToken", this._isBasicAuthCredential ? "secret".getBytes() : this._credentialToken);
        }
        return this._credentialToken;
    }

    public long getCredentialExpiration() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCredentialExpiration");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCredentialExpiration", new Long(this._expiration));
        }
        return this._expiration;
    }

    public byte[] getBytes() {
        ByteArrayOutputStream baos;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getBytes");
            }
            baos = new ByteArrayOutputStream(1024);
            try {
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(this);
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, this, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.getBytes", "424", this);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Unable to serialize execution environment", e);
            }
        }
        byte[] bytes = baos.toByteArray();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getBytes", this._isBasicAuthCredential ? "secret".getBytes() : bytes);
        }
        return bytes;
    }

    public static SecurityExecutionEnvironment createFromBytes(byte[] bytes) {
        SecurityExecutionEnvironment see;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "createFromBytes", bytes);
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            see = null;
            try {
                ObjectInputStream ois = new ObjectInputStream(bais);
                see = (SecurityExecutionEnvironment)ois.readObject();
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, SecurityExecutionEnvironment.class, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.createFromBytes", "451");
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Unable to deserialize the execution environment", e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createFromBytes", see);
        }
        return see;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "writeObject", s);
        }
        ObjectOutputStream.PutField fields = s.putFields();
        fields.put("_version", this._version);
        fields.put("_isServerCredential", this._isServerCredential);
        fields.put("_isUnauthenticatedCredential", this._isUnauthenticatedCredential);
        fields.put("_isBasicAuthCredential", this._isBasicAuthCredential);
        fields.put("_isForwardableCredential", this._isForwardableCredential);
        fields.put("_realm", this._realm);
        fields.put("_securityName", this._securityName);
        fields.put("_accessId", this._accessId);
        fields.put("_uniqueSecurityName", this._uniqueSecurityName);
        fields.put("_groupIds", this._groupIds);
        fields.put("_oid", this._oid);
        fields.put("_credentialToken", this._credentialToken);
        fields.put("_expiration", this._expiration);
        fields.put("_clientUniqueId", this._clientUniqueId);
        fields.put("_managedNodeUUID", this._managedNodeUUID);
        s.writeFields();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "writeObject");
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readObject", s);
        }
        ObjectInputStream.GetField fields = s.readFields();
        this._version = fields.get("_version", 1);
        this._isServerCredential = fields.get("_isServerCredential", false);
        this._isUnauthenticatedCredential = fields.get("_isUnauthenticatedCredential", true);
        this._isBasicAuthCredential = fields.get("_isBasicAuthCredential", false);
        this._isForwardableCredential = fields.get("_isForwardableCredential", false);
        this._realm = (String)fields.get("_realm", null);
        this._securityName = (String)fields.get("_securityName", null);
        this._accessId = (String)fields.get("_accessId", null);
        this._uniqueSecurityName = (String)fields.get("_uniqueSecurityName", null);
        this._groupIds = (ArrayList)fields.get("_groupIds", null);
        this._oid = (String)fields.get("_oid", null);
        this._credentialToken = (byte[])fields.get("_credentialToken", null);
        this._expiration = fields.get("_expiration", 0L);
        this._clientUniqueId = (String)fields.get("_clientUniqueId", null);
        this._managedNodeUUID = (String)fields.get("_managedNodeUUID", null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readObject");
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        sb.append(";_isServerCredential=").append(this._isServerCredential);
        sb.append(";_isUnauthenticatedCredential=").append(this._isUnauthenticatedCredential);
        sb.append(";_isBasicAuthCredential=").append(this._isBasicAuthCredential);
        sb.append(";_isForwardableCredential=").append(this._isForwardableCredential);
        sb.append(":_realm=").append(this._realm);
        sb.append(";_accessId=").append(this._accessId);
        sb.append(";_clientUniqueId=").append(this._clientUniqueId);
        sb.append(";_groupIds=").append(this._groupIds);
        sb.append(";_oid=").append(this._oid);
        sb.append(";_expiration=").append(this._expiration);
        sb.append(";_managedNodeUUID=").append(this._managedNodeUUID);
        return sb.toString();
    }

    public String getManagedNodeUUID() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getManagedNodeUUID");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getManagedNodeUUID", this._managedNodeUUID);
        }
        return this._managedNodeUUID;
    }

    private void initializeManagedNodeUUID() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeManagedNodeUUID");
        }
        this._managedNodeUUID = SecurityExecutionEnvironment.peekAdminContext();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeManagedNodeUUID", this._managedNodeUUID);
        }
    }

    public static String peekAdminContext() {
        String ret = null;
        try {
            ret = (String)peekMethod.invoke(null, new Object[0]);
        }
        catch (Throwable ex) {
            Manager.Ffdc.log(ex, thisClass, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.peekAdminContext", "%C");
        }
        return ret;
    }

    static {
        try {
            adminContextClz = Class.forName("com.ibm.websphere.management.AdminContext");
            peekMethod = adminContextClz.getMethod("peek", new Class[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

