/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ISecurityLocalObjectBaseL13Impl;

import com.ibm.CORBA.iiop.ORB;
import com.ibm.ISecurityL13SupportImpl.LoginPanel;
import com.ibm.ISecurityL13SupportImpl.SecurityMessages;
import com.ibm.ISecurityLocalObjectBaseL13Impl.VaultImpl;
import com.ibm.ISecurityUtilityImpl.KeyFile;
import com.ibm.ISecurityUtilityImpl.KeyFileEntry;
import com.ibm.ISecurityUtilityImpl.RealmSecurityName;
import com.ibm.ISecurityUtilityImpl.SourceLocation;
import com.ibm.ISecurityUtilityImpl.StdinLoginPrompt;
import com.ibm.ISecurityUtilityImpl.StringBytesConversion;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.auth.callback.NonPromptCallbackHandler;
import com.ibm.websphere.security.auth.callback.WSCcacheCallBackHandlerImpl;
import com.ibm.websphere.security.auth.callback.WSGUICallbackHandlerImpl;
import com.ibm.websphere.security.auth.callback.WSStdinCallbackHandlerImpl;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.config.CSIv2Config;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.ws.util.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.swing.JFrame;
import org.omg.CORBA.NO_MEMORY;

public class LoginHelperImpl {
    private VaultImpl _vault = null;
    private ORB _orb = null;
    private static KeyFile _keyFile = null;
    private int _loginSource;
    private int _loginTimeout;
    private int _authenticationTarget = 0;
    private String _loginModule = null;
    private static int stdinRetry = 0;
    private String r_name = null;
    private String s_name = null;
    private String p_name = null;
    private String p_word = null;
    private byte[] a_data = null;
    private boolean isBasicAuth = false;
    private int result = 0;
    private static final WebSphereRuntimePermission perm = new WebSphereRuntimePermission("SecOwnCredentials");
    private static final TraceComponent tc = Tr.register(LoginHelperImpl.class, "SASRas", "com.ibm.ISecurityL13SupportImpl.sec");

    protected LoginHelperImpl() {
    }

    public LoginHelperImpl(ORB theORB) {
        CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
        if (theORB != null) {
            this._vault = VaultImpl.getInstance();
            this._orb = theORB;
            this._loginSource = csiv2.getInteger("com.ibm.CORBA.loginSource");
            this._loginTimeout = csiv2.getInteger("com.ibm.CORBA.loginTimeout");
            this._authenticationTarget = csiv2.getInteger("com.ibm.CORBA.authenticationTarget");
            try {
                if (this._authenticationTarget == 6) {
                    LoginHelperImpl.setKrbConfigProp(csiv2.getString("com.ibm.CORBA.krb5ConfigFile"));
                    this._loginModule = "WSKRB5Login";
                    this.isBasicAuth = false;
                } else if (this._authenticationTarget == 4) {
                    this._loginModule = "WSLogin";
                    this.isBasicAuth = true;
                } else {
                    throw new Exception("The value of com.ibm.CORBA.authenticationTarget porperty in sas.client.prop file is either null or no supported");
                }
                _keyFile = this.getKeyFileObject();
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, this, "com.ibm.ISecurityLocalObjectBaseL13Impl.LoginHelperImpl.LoginHelperImpl", "194", this);
                Tr.debug(tc, e.getMessage(), new Object[]{e});
            }
        } else {
            this._loginSource = csiv2.getInteger("DefaultLoginSource");
            this._loginTimeout = csiv2.getInteger("DefaultLoginTimeout");
        }
    }

    private void getEnvironmentLogin() {
    }

    private String getHostName() {
        String hostName = null;
        try {
            hostName = this._orb.getLocalHost();
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, this, "com.ibm.ISecurityLocalObjectBaseL13Impl.LoginHelperImpl.getHostName", "238", this);
            hostName = null;
        }
        if (hostName == null || hostName.length() == 0) {
            hostName = "localHost";
        }
        return hostName;
    }

    private void getKeyFileLogin() {
        KeyFileEntry keyFileEntry;
        CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
        if (this.p_name == null) {
            this.p_name = csiv2.getString("com.ibm.CORBA.principalName");
            this.p_name = RealmSecurityName.getRealmSecurityName(this.p_name);
            this.s_name = RealmSecurityName.getSecurityName(this.p_name);
            this.r_name = RealmSecurityName.getRealm(this.p_name);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Getting login information from key-file for " + this.p_name);
        }
        if (_keyFile == null) {
            _keyFile = new KeyFile(csiv2.getString("com.ibm.CORBA.keyFileName"));
        }
        if ((keyFileEntry = _keyFile.find(this.r_name, this.s_name)) != null) {
            this.p_name = keyFileEntry.getUserid();
            this.p_word = keyFileEntry.getPassword();
            this.p_name = RealmSecurityName.getRealmSecurityName(this.r_name, this.p_name);
            this.s_name = RealmSecurityName.getSecurityName(this.p_name);
            this.r_name = RealmSecurityName.getRealm(this.p_name);
        } else {
            this.p_word = null;
            Tr.audit(tc, SecurityMessages.getMsgOrUseDefault("JSAS0454A", "JSAS0454A: The indicated entry was not found in the key file."));
        }
    }

    public KeyFile getKeyFileObject() {
        CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
        String _kFile = csiv2.getString("com.ibm.CORBA.keyFileName");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Getting an authentication key file object.");
        }
        if (_keyFile == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Authentication key file is: " + _kFile);
            }
            _keyFile = new KeyFile(_kFile);
        }
        if (!_keyFile.isEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Returning authentication key file object is initialized.");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Returning authentication key file object is empty.");
        }
        return _keyFile;
    }

    private void getPropertiesLogin() {
        CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
        if (this.r_name != null && this.r_name.length() > 0 && csiv2.getBoolean("multiLoginEnabled")) {
            this.p_name = csiv2.getloginUserid(this.r_name);
            this.p_word = csiv2.getloginPassword(this.r_name);
        } else {
            this.p_name = csiv2.getString("com.ibm.CORBA.loginUserid");
            this.p_word = csiv2.getString("com.ibm.CORBA.loginPassword");
        }
        this.p_name = RealmSecurityName.getRealmSecurityName(this.p_name);
        this.s_name = RealmSecurityName.getSecurityName(this.p_name);
    }

    private void getStdInLogin() {
        String[] usernameAndPassword = null;
        try {
            if (stdinRetry < 1) {
                if (this.r_name.length() > 0) {
                    String realmString = SecurityMessages.getMsgOrUseDefault("RealmName", "Realm (Cell) Name");
                    System.out.println(realmString + ": " + this.r_name);
                }
                if ((usernameAndPassword = new StdinLoginPrompt().getUidAndPassword()) != null) {
                    this.p_word = usernameAndPassword[1];
                    this.p_name = RealmSecurityName.getRealmSecurityName(usernameAndPassword[0]);
                    this.s_name = RealmSecurityName.getSecurityName(usernameAndPassword[0]);
                    if (this.r_name.length() == 0) {
                        BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
                        String realmString = SecurityMessages.getMsgOrUseDefault("RealmName", "Realm (Cell) Name");
                        System.out.print(realmString + ": ");
                        this.r_name = stdin.readLine().trim();
                        if (this.r_name.length() == 0) {
                            this.r_name = this.getHostName();
                        }
                        this.p_name = RealmSecurityName.getRealmSecurityName(this.r_name, this.s_name);
                    }
                    stdinRetry = 0;
                } else {
                    ++stdinRetry;
                    this.r_name = null;
                    this.s_name = null;
                    this.p_name = null;
                    this.p_word = null;
                }
            } else {
                stdinRetry = 0;
                this.r_name = null;
                this.s_name = null;
                this.p_name = null;
                this.p_word = null;
            }
        }
        catch (IOException e) {
            Manager.Ffdc.log(e, this, "com.ibm.ISecurityLocalObjectBaseL13Impl.LoginHelperImpl.getStdInLogin", "413", this);
            System.out.println("unable to get system input stream");
        }
    }

    private synchronized boolean getPromptLogin() {
        boolean done = false;
        boolean cancel_hit = false;
        LoginPanel lgpanel = null;
        JFrame tmpFrame = null;
        while (!done) {
            tmpFrame = new JFrame();
            lgpanel = new LoginPanel(this.s_name, this.r_name, this.p_word, this._loginTimeout, tmpFrame);
            this.result = lgpanel.showPanel();
            if (this.result == 2) {
                String sn = lgpanel.getId();
                if (sn != null && sn.length() > 0) {
                    this.s_name = new String(sn.trim());
                    if (this.s_name != null && this.s_name.length() > 0) {
                        String rn = lgpanel.getCell();
                        this.r_name = rn != null && rn.length() > 0 ? new String(rn.trim()) : "";
                        this.p_name = RealmSecurityName.getRealmSecurityName(this.r_name, this.s_name);
                        String pw = lgpanel.getPassword();
                        this.p_word = pw != null && pw.length() > 0 ? new String(pw) : "";
                        lgpanel.dispose();
                        lgpanel = null;
                        done = true;
                    } else {
                        this.r_name = "";
                        this.p_name = "";
                        this.p_word = "";
                    }
                } else {
                    this.s_name = "";
                    this.r_name = "";
                    this.p_name = "";
                    this.p_word = "";
                }
                if (!done) {
                    lgpanel.dispose();
                    lgpanel = null;
                    done = true;
                }
            } else {
                cancel_hit = true;
                lgpanel.dispose();
                lgpanel = null;
                this.r_name = null;
                this.s_name = null;
                this.p_name = null;
                this.p_word = null;
                done = true;
            }
            if (tmpFrame == null) continue;
            tmpFrame.dispose();
            tmpFrame = null;
        }
        return !cancel_hit;
    }

    public synchronized Subject request_login_controlled(String security_name, String realm_name, String password, byte[] credential_token, boolean set_invocation_creds) throws WSLoginFailedException {
        SecurityManager sm;
        if (security_name != null) {
            security_name = security_name.trim();
        }
        if (password != null && !PlatformHelperFactory.getPlatformHelper().isZOS()) {
            password = password.trim();
        }
        if ((security_name == null || security_name.equals("") || password == null || password.equals("")) && (sm = System.getSecurityManager()) != null) {
            Tr.debug(tc, "Performing Java 2 Security Permission Check ...Expecting : " + perm.toString());
            sm.checkPermission(perm);
        }
        boolean callLoginContext = false;
        Subject subject = null;
        ContextManager contextMgr = ContextManagerFactory.getInstance();
        this.r_name = null;
        this.s_name = null;
        this.p_name = null;
        this.p_word = null;
        this.a_data = null;
        LoginContext lc = null;
        if (credential_token == null) {
            if (security_name != null) {
                this.s_name = new String(security_name.trim());
                if (this.s_name == null) {
                    throw new NO_MEMORY();
                }
            }
            if (realm_name != null) {
                this.r_name = new String(realm_name.trim());
                if (this.r_name == null) {
                    throw new NO_MEMORY();
                }
            }
            if (password != null) {
                this.p_word = new String(password);
                if (this.p_word == null) {
                    throw new NO_MEMORY();
                }
            }
            if (this.s_name == null && this.p_word == null) {
                String bvt_pwd;
                String bvt_uid = this._orb.getProperty("com.ibm.CORBA.BVTestPrincipalName");
                if (bvt_uid != null && bvt_uid.length() > 0) {
                    this.s_name = new String(RealmSecurityName.getSecurityName(bvt_uid));
                    if (this.s_name == null) {
                        throw new NO_MEMORY();
                    }
                    this.r_name = new String(RealmSecurityName.getRealm(bvt_uid));
                    if (this.r_name == null) {
                        throw new NO_MEMORY();
                    }
                }
                if ((bvt_pwd = this._orb.getProperty("com.ibm.CORBA.BVTestPassword")) != null && bvt_pwd.length() > 0) {
                    this.p_word = new String(bvt_pwd);
                    if (this.p_word == null) {
                        throw new NO_MEMORY();
                    }
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "s_name: " + this.s_name + ", p_word: " + StringUtils.mask(this.p_word) + ", r_name: " + this.r_name);
            }
            if (this.s_name == null || this.s_name.length() == 0 || this.p_word == null || this.p_word.length() == 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Login source is " + SourceLocation.strings.get(new Integer(this._loginSource)) + ".");
                }
                switch (this._loginSource) {
                    case 4: {
                        this.getEnvironmentLogin();
                        break;
                    }
                    case 3: {
                        this.getKeyFileLogin();
                        break;
                    }
                    case 1: {
                        if (this.isBasicAuth) {
                            try {
                                boolean ok_hit = this.getPromptLogin();
                                if (ok_hit && (this.s_name == null || this.s_name.length() == 0 || this.p_word == null || this.p_word.length() == 0)) {
                                    throw new WSLoginFailedException("username and/or password is null");
                                }
                                break;
                            }
                            catch (WSLoginFailedException e) {
                                throw e;
                            }
                            catch (Throwable e) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Error occurred with GUI prompt, logging in with console prompt.");
                                }
                                this.getStdInLogin();
                                break;
                            }
                        }
                        this._vault.getCurrent().setAllowUnauthCredForAuthenticate(true);
                        try {
                            callLoginContext = true;
                            try {
                                JFrame tmpFrame = new JFrame();
                                lc = new LoginContext(this._loginModule, new WSGUICallbackHandlerImpl(this.r_name));
                                lc.login();
                                subject = lc.getSubject();
                                break;
                            }
                            catch (WSLoginFailedException wlfe) {
                                Manager.Ffdc.log(wlfe, this, "com.ibm.ISecurityLocalObjectBaseL13Impl.loginHelper.request_login_controlled", "701", this);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, wlfe.getMessage(), new Object[]{wlfe});
                                }
                                throw wlfe;
                            }
                            catch (LoginException le) {
                                Manager.Ffdc.log(le, this, "com.ibm.ISecurityLocalObjectBaseL13Impl.loginHelper.request_login_controlled", "706", this);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, le.getMessage(), new Object[]{le});
                                }
                                if (le instanceof WSLoginFailedException) {
                                    throw (WSLoginFailedException)le;
                                }
                                throw new WSLoginFailedException(le.getMessage(), le);
                            }
                            catch (Throwable e) {
                                lc = new LoginContext(this._loginModule, new WSStdinCallbackHandlerImpl(this.r_name));
                                lc.login();
                                subject = lc.getSubject();
                                break;
                            }
                        }
                        catch (LoginException le) {
                            Manager.Ffdc.log(le, this, "com.ibm.ISecurityLocalObjectBaseL13Impl.loginHelper.request_login_controlled", "722", this);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, le.getMessage(), new Object[]{le});
                            }
                            if (le instanceof WSLoginFailedException) {
                                throw (WSLoginFailedException)le;
                            }
                            throw new WSLoginFailedException(le.getMessage(), le);
                        }
                        catch (SecurityException se) {
                            Manager.Ffdc.log(se, this, "com.ibm.ISecurityLocalObjectBaseL13Impl.loginHelper.request_login_controlled", "730", this);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, se.getMessage(), new Object[]{se});
                            }
                            throw new WSLoginFailedException(se.getMessage(), se);
                        }
                        finally {
                            this._vault.getCurrent().setAllowUnauthCredForAuthenticate(false);
                        }
                    }
                    case 5: {
                        this.getPropertiesLogin();
                        break;
                    }
                    case 6: {
                        if (this.isBasicAuth) {
                            this.getStdInLogin();
                            break;
                        }
                        try {
                            callLoginContext = true;
                            lc = new LoginContext(this._loginModule, new WSStdinCallbackHandlerImpl(this.r_name));
                            lc.login();
                            subject = lc.getSubject();
                            break;
                        }
                        catch (WSLoginFailedException wlfe) {
                            Manager.Ffdc.log(wlfe, this, "com.ibm.ISecurityLocalObjectBaseL13Impl.loginHelper.request_login_controlled", "760", this);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, wlfe.getMessage(), new Object[]{wlfe});
                            }
                            throw wlfe;
                        }
                        catch (LoginException le) {
                            Manager.Ffdc.log(le, this, "com.ibm.ISecurityLocalObjectBaseL13Impl.loginHelper.request_login_controlled", "765", this);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, le.getMessage(), new Object[]{le});
                            }
                            if (le instanceof WSLoginFailedException) {
                                throw (WSLoginFailedException)le;
                            }
                            throw new WSLoginFailedException(le.getMessage(), le);
                        }
                    }
                    case 7: {
                        callLoginContext = true;
                        subject = this.krb5CcacheLogin();
                        break;
                    }
                    case 8: {
                        callLoginContext = true;
                        try {
                            try {
                                subject = this.krb5CcacheLogin();
                            }
                            catch (WSLoginFailedException wlfe) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Fall back to Prompt login");
                                }
                                try {
                                    JFrame tmpFrame = new JFrame();
                                    lc = new LoginContext(this._loginModule, new WSGUICallbackHandlerImpl(this.r_name));
                                    lc.login();
                                    subject = lc.getSubject();
                                }
                                catch (WSLoginFailedException wlfe2) {
                                    Manager.Ffdc.log(wlfe2, this, "com.ibm.ISecurityLocalObjectBaseL13Impl.loginHelper.request_login_controlled", "799", this);
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, wlfe2.getMessage(), new Object[]{wlfe2});
                                    }
                                    throw wlfe2;
                                }
                                catch (LoginException le) {
                                    Manager.Ffdc.log(le, this, "com.ibm.ISecurityLocalObjectBaseL13Impl.loginHelper.request_login_controlled", "804", this);
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, le.getMessage(), new Object[]{le});
                                    }
                                    if (le instanceof WSLoginFailedException) {
                                        throw (WSLoginFailedException)le;
                                    }
                                    throw new WSLoginFailedException(le.getMessage(), le);
                                }
                                catch (Throwable e) {
                                    lc = new LoginContext(this._loginModule, new WSStdinCallbackHandlerImpl(this.r_name));
                                    lc.login();
                                    subject = lc.getSubject();
                                }
                            }
                            break;
                        }
                        catch (LoginException le) {
                            Manager.Ffdc.log(le, this, "com.ibm.ISecurityLocalObjectBaseL13Impl.loginHelper.request_login_controlled", "821", this);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, le.getMessage(), new Object[]{le});
                            }
                            if (le instanceof WSLoginFailedException) {
                                throw (WSLoginFailedException)le;
                            }
                            throw new WSLoginFailedException(le.getMessage(), le);
                        }
                        catch (SecurityException se) {
                            Manager.Ffdc.log(se, this, "com.ibm.ISecurityLocalObjectBaseL13Impl.loginHelper.request_login_controlled", "829", this);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, se.getMessage(), new Object[]{se});
                            }
                            throw new WSLoginFailedException(se.getMessage(), se);
                        }
                    }
                    case 9: {
                        callLoginContext = true;
                        try {
                            try {
                                subject = this.krb5CcacheLogin();
                            }
                            catch (WSLoginFailedException wlfe) {
                                lc = new LoginContext(this._loginModule, new WSStdinCallbackHandlerImpl(this.r_name));
                                lc.login();
                                subject = lc.getSubject();
                            }
                            break;
                        }
                        catch (LoginException le) {
                            Manager.Ffdc.log(le, this, "com.ibm.websphere.management.AdminClientFactory.jaas_login", "846", this);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, le.getMessage(), new Object[]{le});
                            }
                            if (le instanceof WSLoginFailedException) {
                                throw (WSLoginFailedException)le;
                            }
                            throw new WSLoginFailedException(le.getMessage(), le);
                        }
                        catch (SecurityException se) {
                            Manager.Ffdc.log(se, this, "com.ibm.ISecurityLocalObjectBaseL13Impl.loginHelper.request_login_controlled", "853", this);
                            if (!tc.isDebugEnabled()) break;
                            Tr.debug(tc, se.getMessage(), new Object[]{se});
                            break;
                        }
                    }
                    case 10: {
                        callLoginContext = true;
                        try {
                            try {
                                subject = this.krb5CcacheLogin();
                            }
                            catch (WSLoginFailedException wlfe) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Fall back to Properties login");
                                }
                                this.getPropertiesLogin();
                                lc = new LoginContext(this._loginModule, new NonPromptCallbackHandler(this.r_name, this.s_name, this.p_word));
                                lc.login();
                                subject = lc.getSubject();
                            }
                            break;
                        }
                        catch (LoginException le) {
                            Manager.Ffdc.log(le, this, "com.ibm.ISecurityLocalObjectBaseL13Impl.loginHelper.request_login_controlled", "871", this);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, le.getMessage(), new Object[]{le});
                            }
                            if (le instanceof WSLoginFailedException) {
                                throw (WSLoginFailedException)le;
                            }
                            throw new WSLoginFailedException(le.getMessage(), le);
                        }
                        catch (SecurityException se) {
                            Manager.Ffdc.log(se, this, "com.ibm.ISecurityLocalObjectBaseL13Impl.loginHelper.request_login_controlled", "879", this);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, se.getMessage(), new Object[]{se});
                            }
                            throw new WSLoginFailedException(se.getMessage(), se);
                        }
                    }
                    case 11: {
                        if (this.s_name != null && this.s_name.length() != 0 && this.p_word != null && this.p_word.length() != 0) break;
                        return SubjectHelper.createUnauthenticatedSubject();
                    }
                }
            }
            this.p_name = RealmSecurityName.getRealmSecurityName(this.r_name, this.s_name);
            this.a_data = StringBytesConversion.getConvertedBytes(this.p_word);
        } else {
            this.a_data = credential_token;
        }
        if (this.result == 3) {
            return SubjectHelper.createUnauthenticatedSubject();
        }
        if (!(this.a_data != null && this.a_data.length != 0 || callLoginContext)) {
            Tr.audit(tc, SecurityMessages.getMsgOrUseDefault("JSAS0455A", "JSAS0455A: Unable to login principal, invalid authentication information."));
            throw new WSLoginFailedException(SecurityMessages.getMsgOrUseDefault("JSAS0455A", "JSAS0455A: Unable to login principal, invalid authentication information."));
        }
        this._vault.getCurrent().setAllowUnauthCredForAuthenticate(true);
        if (!callLoginContext) {
            try {
                if (credential_token == null) {
                    if (this.isBasicAuth) {
                        subject = contextMgr.login(this.r_name, this.s_name, this.p_word);
                    } else {
                        lc = new LoginContext(this._loginModule, new NonPromptCallbackHandler(this.r_name, this.s_name, this.p_word));
                        lc.login();
                        subject = lc.getSubject();
                    }
                } else {
                    subject = contextMgr.login(this.r_name, this.a_data);
                }
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, this, "com.ibm.ISecurityLocalObjectBaseL13Impl.LoginHelperImpl.request_login_controlled", "946", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, e.getMessage(), new Object[]{e});
                }
                subject = null;
                if (e instanceof WSLoginFailedException) {
                    throw (WSLoginFailedException)e;
                }
                throw new WSLoginFailedException(e.getMessage(), e);
            }
            finally {
                this._vault.getCurrent().setAllowUnauthCredForAuthenticate(false);
            }
        }
        if (subject == null) {
            Tr.error(tc, "security.JSAS0240E");
            throw new WSLoginFailedException(SecurityMessages.getMsgOrUseDefault("JSAS0240E", "JSAS0240E: Login failed.  Verify the userid/password is correct.  Check the properties file to ensure the login source is valid.  If this error occurs on the server, check the server properties to ensure the principalName has a valid realm and userid."));
        }
        if (set_invocation_creds) {
            try {
                contextMgr.setInvocationSubject(subject);
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, this, "com.ibm.ISecurityLocalObjectBaseL13Impl.LoginHelperImpl.request_login_controlled", "980", this);
                Tr.error(tc, "security.JSAS0054E", new Object[]{e});
                if (e instanceof WSLoginFailedException) {
                    throw (WSLoginFailedException)e;
                }
                throw new WSLoginFailedException(e.getMessage(), e);
            }
        }
        if (!SecurityObjectLocator.getAdminData().getBoolean("isServerProcess")) {
            this._vault.set_default_subject(subject);
        }
        return subject;
    }

    public synchronized Subject krb5CcacheLogin() throws WSLoginFailedException {
        LoginContext lc = null;
        String _defaultCcache = "true";
        String _krb5Ccache = null;
        Subject tmpSubject = new Subject();
        try {
            CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
            _krb5Ccache = csiv2.getString("com.ibm.CORBA.krb5CcacheFile");
            if (_krb5Ccache != null && _krb5Ccache.length() > 0) {
                _defaultCcache = "false";
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "_krb5Ccache: " + _krb5Ccache);
            }
            this.p_name = csiv2.getString("com.ibm.CORBA.loginUserid");
            lc = new LoginContext(this._loginModule, new WSCcacheCallBackHandlerImpl(this.p_name, this.r_name, _krb5Ccache, _defaultCcache));
            lc.login();
            tmpSubject = lc.getSubject();
        }
        catch (WSLoginFailedException wlfe) {
            throw wlfe;
        }
        catch (LoginException le) {
            Manager.Ffdc.log(le, this, "com.ibm.ISecurityLocalObjectBaseL13Impl.loginHelper.krb5CcacheLogin", "1026", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, le.getMessage(), new Object[]{le});
            }
            if (le instanceof WSLoginFailedException) {
                throw (WSLoginFailedException)le;
            }
            throw new WSLoginFailedException(le.getMessage(), le);
        }
        return tmpSubject;
    }

    public static void setKrbConfigProp(String krb5Config) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setKrbConfigProp");
        }
        if (krb5Config != null && krb5Config.length() != 0) {
            final String inKrb5Config = krb5Config;
            String cf = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    String property = "java.security.krb5.conf";
                    String c = System.getProperty("java.security.krb5.conf");
                    System.setProperty("java.security.krb5.conf", inKrb5Config);
                    return c;
                }
            });
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "java.security.krb5.conf property previous: " + (cf != null ? cf : "<null>") + " and now: " + krb5Config);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setKrbConfigProp");
        }
    }
}

