/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ISecurityLocalObjectBaseL13Impl;

import com.ibm.CORBA.iiop.ExtendedClientRequestInfo;
import com.ibm.CORBA.iiop.ExtendedORBInitInfo;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.ISecurityLocalObjectBaseL13Impl.CSIClientRIBase;
import com.ibm.ISecurityLocalObjectBaseL13Impl.CSICredentialsManager;
import com.ibm.ISecurityLocalObjectBaseL13Impl.CurrentImpl;
import com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityConnectionInterceptor;
import com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityContextImpl;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2EffectivePerformPolicy;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.ClientSessionKey;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.SessionEntry;
import com.ibm.ISecurityUtilityImpl.RealmSecurityName;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.ws.connmgmt.ConnectionHandle;
import com.ibm.ws.orb.transport.ConnectionData;
import com.ibm.ws.orbimpl.transport.ConnectionInformationImpl;
import com.ibm.ws.security.config.CSIv2Config;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.orbssl.ExtendedSSLConnectionData;
import com.ibm.ws.util.PlatformHelperFactory;
import javax.security.auth.Subject;
import org.omg.CORBA.Object;
import org.omg.CSI.IdentityToken;
import org.omg.CSI.SASContextBody;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.RequestInfo;

public class CSIClientRI
extends CSIClientRIBase {
    private static final TraceComponent tc = Tr.register(CSIClientRI.class, "SASRas", "com.ibm.ISecurityL13SupportImpl.sec");

    public void pre_init(ORBInitInfo info) {
        CSIv2Config csiv2;
        super.pre_init(info);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "pre_init", new java.lang.Object[]{info, this});
        }
        if ((csiv2 = SecurityObjectLocator.getCSIv2Config()).getBoolean("com.ibm.CORBA.securityEnabled")) {
            Tr.audit(tc, "security.ClientCSI");
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Registering client request interceptor.");
                }
                this.slotid = info.allocate_slot_id();
                ((ExtendedORBInitInfo)info).add_client_request_interceptor((ClientRequestInterceptor)this, false);
            }
            catch (Exception ex) {
                Manager.Ffdc.log(ex, (java.lang.Object)this, "com.ibm.ISecurityLocalObjectBaseL13Impl.CSIClientRI.pre_init", "%C", new java.lang.Object[]{this});
                Tr.debug(tc, "An exception has been thrown registering the interceptor.", new java.lang.Object[]{ex});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "pre_init");
        }
    }

    public void post_init(ORBInitInfo info) {
        super.post_init(info);
    }

    public void send_request(ClientRequestInfo info) throws ForwardRequest {
        if (tc.isDebugEnabled()) {
            this.entry(info, "send_request");
        }
        CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
        CurrentImpl curr = this.csiUtil.getCurrent();
        CSIv2EffectivePerformPolicy csiv2EffectivePolicy = null;
        if (PlatformHelperFactory.getPlatformHelper().isZOS()) {
            try {
                csiv2EffectivePolicy = this.getEffectivePolicyFromClientRequestInfo(info);
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, (java.lang.Object)this, "com.ibm.ISecurityLocalObjectBaseL13Impl.CSIClientRI.send_request", "%C", new java.lang.Object[]{this});
                Tr.debug(tc, "An exception has been thrown getting the effective policy from the ior.", new java.lang.Object[]{e});
            }
        } else {
            csiv2EffectivePolicy = curr.getEffectivePolicy();
        }
        curr.setEffectivePolicy(null);
        String connectionKey = "";
        ConnectionData cdata = null;
        ConnectionInformationImpl connectionInfo = (ConnectionInformationImpl)((ExtendedClientRequestInfo)info).getConnectionData();
        if (connectionInfo != null) {
            cdata = (ConnectionData)connectionInfo.getConnectionData();
        }
        boolean isLocalcomm = false;
        if (cdata != null) {
            ConnectionHandle ch;
            if (!(cdata instanceof ExtendedSSLConnectionData)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Invalid cdata class: " + cdata);
                }
                return;
            }
            connectionKey = cdata.getConnectionKey();
            if (connectionKey == null && (ch = (ConnectionHandle)cdata.getConnectionHandle()) != null && ch.getIsLocalComm()) {
                connectionKey = ch.toString();
                cdata.setConnectionKey(connectionKey);
                isLocalcomm = true;
            }
            if (csiv2EffectivePolicy == null) {
                csiv2EffectivePolicy = ((ExtendedSSLConnectionData)cdata).getEffectivePolicy();
            }
        }
        this.myVault.put_effective_policy(info.request_id(), csiv2EffectivePolicy);
        boolean continueAuthenticating = this.qualifyClientRequest(info, csiv2EffectivePolicy);
        if (!continueAuthenticating) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Returning from send_request without authenticating.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "send_request");
            }
            return;
        }
        CSICredentialsManager credsMgr = new CSICredentialsManager();
        boolean clientAuthentication = csiv2EffectivePolicy.performClientAuthentication();
        boolean identityAssertion = csiv2EffectivePolicy.performIdentityAssertion();
        SessionEntry sessionEntry = null;
        ClientSessionKey clientSessionKey = null;
        long stateful_context_id = 0L;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Identity assertion: " + identityAssertion + ",  client authentication: " + clientAuthentication + ",  authorization token: " + csiv2EffectivePolicy.performAuthorizationToken());
        }
        if (clientAuthentication || identityAssertion) {
            String targetRealmName = RealmSecurityName.getRealmOrReturnSecurityName(csiv2EffectivePolicy.getTargetSecurityName());
            if (targetRealmName == null || targetRealmName.equals("")) {
                targetRealmName = csiv2EffectivePolicy.getTargetSecurityName();
            }
            Subject subject = null;
            boolean isUnprotectedNamingMethod = false;
            if (csiv2EffectivePolicy.isNamingReadUnprotected()) {
                isUnprotectedNamingMethod = this.namingReadUnprotected(info, csiv2EffectivePolicy);
            }
            if (isUnprotectedNamingMethod) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Naming call unprotected, returning from send_request.");
                }
                return;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Retrieving Subject from thread or login.");
            }
            if ((subject = this.retrieveSubject(targetRealmName, csiv2EffectivePolicy, credsMgr)) == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Subject is null, sending unauthenticated request.");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "send_request");
                }
                return;
            }
            if (csiv2.getBoolean("com.ibm.CSI.rmiOutboundMappingEnabled")) {
                subject = this.unwrapSubject(subject);
            }
            if (csiv2EffectivePolicy.isStateful()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Starting session evaluation.");
                }
                String localHost = null;
                int localPort = 0;
                if (cdata == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Null connection data");
                    }
                    if (PlatformHelperFactory.getPlatformHelper().isZOS()) {
                        Exception e = new Exception("No connection data, probable broken connection");
                        Manager.Ffdc.log(e, (java.lang.Object)this, "com.ibm.ISecurityLocalObjectBaseL13Impl.CSIClientRI.send_request", "%C", new java.lang.Object[]{this});
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "No connection data, probable broken connection, returning with no security");
                        }
                        return;
                    }
                }
                if (isLocalcomm) {
                    localHost = "";
                } else {
                    localHost = cdata.getLocalHost();
                    localPort = cdata.getLocalPort();
                }
                sessionEntry = this.determineStatefulContextID(targetRealmName, csiv2EffectivePolicy, this.sessionMgr, info, subject, cdata.getConnectionKey(), localHost, localPort);
                if (sessionEntry == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "EstablishContext message has been set in the request.");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "send_request");
                    }
                    return;
                }
                clientSessionKey = sessionEntry.get_client_session_key();
                stateful_context_id = sessionEntry.get_client_context_id();
                if (sessionEntry.get_renegotiate_to_stateless()) {
                    stateful_context_id = 0L;
                    sessionEntry.reset_renegotiate_to_stateless();
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "This is a stateless request.");
            }
            csiv2EffectivePolicy.setStatefulContextID(stateful_context_id);
            csiv2EffectivePolicy.setClientSessionKey(clientSessionKey);
            if (csiv2EffectivePolicy.performAuthorizationToken() || csiv2.getBoolean("com.ibm.CSI.rmiOutboundLoginEnabled")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Calling JAAS login to map or create opaque authorization token.");
                }
                subject = this.mapOutboundOrCreateOAT(subject, csiv2EffectivePolicy);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Determining which SecurityContext to use (GSSUP, LTPA or KRB5).");
            }
            SecurityContextImpl secCtx = this.determineSecurityContextType(subject, csiv2EffectivePolicy, connectionKey, this.sessionMgr, sessionEntry);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting the contents of the identity token.");
            }
            IdentityToken it = new IdentityToken();
            this.setIdentityToken(it, subject, csiv2EffectivePolicy, this.sessionMgr, sessionEntry);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting the contents of the client authentication token and EstablishContext message.");
            }
            this.setSecurityContext(info, secCtx, it, subject, csiv2EffectivePolicy, this.sessionMgr, sessionEntry, targetRealmName);
        } else if (csiv2EffectivePolicy.performTLClientAuth() && cdata.getConnectionType() == 1L) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "TLSClientAuth over SSL only, No security service returned.");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "No security is required at csiv2 message and attribute layers.  No security context will be sent.");
        }
        if (csiv2EffectivePolicy.isStateful() && sessionEntry != null && stateful_context_id != 0L) {
            this.sessionMgr.csi_client_session_status_update(stateful_context_id, clientSessionKey, 6);
        }
        this.csiUtil.setUnauthenticatedToNullIfNeeded();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "*** SENDING REQUEST ***");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "send_request");
        }
    }

    public void receive_reply(ClientRequestInfo info) {
        if (tc.isDebugEnabled()) {
            this.entry(info, "receive_reply");
        }
        if (this.is_local_client_request(info)) {
            this.receive_reply_local(info);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "receive_reply");
            }
            return;
        }
        CSIv2EffectivePerformPolicy csiv2EffectivePolicy = this.myVault.get_effective_policy(info.request_id());
        this.myVault.clear_effective_policy(info.request_id());
        String class_name = "<unknown>";
        if (info.effective_target() != null) {
            class_name = info.effective_target().getClass().getName();
        }
        if (SecurityConnectionInterceptor.isSpecialNamingMethod(info.operation(), class_name) || SecurityConnectionInterceptor.isSpecialSSLRequiredNamingMethod(info.operation(), class_name) || ORB.isSpecialMethod((String)info.operation()) && !this.csiUtil.isCORBAAuthRequired()) {
            Tr.debug(tc, "Special naming method or other corba special method. Return from interceptor.");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "recieve_reply");
            }
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "*** RECEIVING REPLY ***");
        }
        if (csiv2EffectivePolicy != null) {
            ServiceContext sc = null;
            SASContextBody msg = null;
            sc = this.csiUtil.get_sc_from_reply((RequestInfo)info);
            if (sc != null) {
                msg = this.csiUtil.get_message_from_sc(sc);
            }
            this.sessionMgr.csi_client_session_complete(msg, csiv2EffectivePolicy.isStateful(), csiv2EffectivePolicy.getStatefulContextID(), csiv2EffectivePolicy.getClientSessionKey());
            if (sc != null && (csiv2EffectivePolicy.performClientAuthentication() || csiv2EffectivePolicy.performIdentityAssertion())) {
                com.ibm.ISecurityLocalObjectGSSUPImpl.SecurityContextImpl secCtx = null;
                secCtx = new com.ibm.ISecurityLocalObjectGSSUPImpl.SecurityContextImpl(this.myVault, "");
                ((SecurityContextImpl)secCtx).csi_continue_security_context(info, secCtx);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Effective policy is null.");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "*** MESSAGE COMPLETED ***");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "receive_reply");
        }
    }

    public void receive_reply_local(ClientRequestInfo info) {
    }

    public void receive_exception(ClientRequestInfo info) throws ForwardRequest {
        if (tc.isDebugEnabled()) {
            this.entry(info, "receive_exception");
        }
        if (this.is_local_client_request(info)) {
            this.receive_exception_local(info);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "receive_exception");
            }
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "*** RECEIVING EXCEPTION ***");
            String detailed_message = this.csiUtil.read_detailed_message((RequestInfo)info);
            if (!detailed_message.equals("")) {
                Tr.debug(tc, "The following exception was received from the server: " + detailed_message);
            }
        }
        CSIv2EffectivePerformPolicy csiv2EffectivePolicy = this.myVault.get_effective_policy(info.request_id());
        this.myVault.clear_effective_policy(info.request_id());
        if (csiv2EffectivePolicy != null) {
            ServiceContext sc = null;
            SASContextBody msg = null;
            sc = this.csiUtil.get_sc_from_reply((RequestInfo)info);
            if (sc != null) {
                msg = this.csiUtil.get_message_from_sc(sc);
            }
            this.sessionMgr.csi_client_session_complete_exception(msg, csiv2EffectivePolicy.isStateful(), csiv2EffectivePolicy.getClientSessionKey());
            if (info.reply_status() == 1) {
                this.sessionMgr.retry(info);
            }
            if (sc != null && (csiv2EffectivePolicy.performClientAuthentication() || csiv2EffectivePolicy.performIdentityAssertion())) {
                com.ibm.ISecurityLocalObjectGSSUPImpl.SecurityContextImpl secCtx = null;
                secCtx = new com.ibm.ISecurityLocalObjectGSSUPImpl.SecurityContextImpl(this.myVault, "");
                ((SecurityContextImpl)secCtx).csi_continue_security_context(info, secCtx);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "*** MESSAGE COMPLETED ***");
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Effective policy is null.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "receive_exception");
        }
    }

    public void receive_exception_local(ClientRequestInfo info) throws ForwardRequest {
    }

    public void receive_other(ClientRequestInfo info) throws ForwardRequest {
        if (tc.isDebugEnabled()) {
            this.entry(info, "receive_other");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "*** RECEIVE OTHER ***");
        }
        if (this.is_local_client_request(info)) {
            this.receive_other_local(info);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "receive_other");
            }
            return;
        }
        String class_name = "<unknown>";
        if (info.effective_target() != null) {
            class_name = info.effective_target().getClass().getName();
        }
        if (SecurityConnectionInterceptor.isSpecialNamingMethod(info.operation(), class_name) || SecurityConnectionInterceptor.isSpecialSSLRequiredNamingMethod(info.operation(), class_name) || ORB.isSpecialMethod((String)info.operation()) && !this.csiUtil.isCORBAAuthRequired()) {
            Tr.debug(tc, "Special naming method or other corba special method. Return from interceptor.");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "receive_other");
            }
            return;
        }
        CSIv2EffectivePerformPolicy csiv2EffectivePolicy = this.myVault.get_effective_policy(info.request_id());
        switch (info.reply_status()) {
            case 0: {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "receive_other status: SUCCESSFUL.");
                }
                this.receive_reply(info);
                break;
            }
            case 3: {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "receive_other status: LOCATION_FORWARD.");
                }
                if (this.sessionMgr == null || csiv2EffectivePolicy == null) break;
                this.sessionMgr.csi_client_session_status_update(csiv2EffectivePolicy.getStatefulContextID(), csiv2EffectivePolicy.getClientSessionKey(), 7);
                break;
            }
            default: {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "receive_other status: " + info.reply_status());
                }
                if (this.sessionMgr == null || csiv2EffectivePolicy == null) break;
                this.sessionMgr.csi_client_session_status_update(csiv2EffectivePolicy.getStatefulContextID(), csiv2EffectivePolicy.getClientSessionKey(), 7);
            }
        }
        this.myVault.clear_effective_policy(info.request_id());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "receive_other");
        }
    }

    public void receive_other_local(ClientRequestInfo info) throws ForwardRequest {
    }

    public void entry(ClientRequestInfo info, String logMethod) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "entry", new java.lang.Object[]{info, logMethod, this});
        }
        if (tc.isDebugEnabled()) {
            StringBuffer logMsg = new StringBuffer(100);
            logMsg.append("Request_id: ").append(info.request_id()).append(", ");
            Object effectiveTarget = info.effective_target();
            if (effectiveTarget != null) {
                logMsg.append("class: ").append(effectiveTarget.getClass().getName()).append(", ");
            }
            logMsg.append("operation: ").append(info.operation());
            Tr.debug(tc, logMsg.toString());
            java.lang.Object var3_3 = null;
        }
    }
}

