/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ISecurityL13SupportImpl;

import com.ibm.ffdc.Manager;
import com.ibm.ws.security.util.AccessController;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Random;

public final class SecurityUIDGenerator {
    private static Random randomGen = new Random();
    private static short processId = 0;
    private static short sequence = 1;
    private static long previousTime = 0L;
    private static final int sessionIDMax = 45;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createUID() {
        boolean vmidFound = true;
        String sessionID = new String();
        try {
            Object vmid = Class.forName("java.rmi.dgc.VMID").newInstance();
            sessionID = vmid.toString();
        }
        catch (ClassNotFoundException e) {
            Manager.Ffdc.log(e, SecurityUIDGenerator.class, "com.ibm.ISecurityL13SupportImpl.SecurityUIDGenerator.createUID", "90");
            vmidFound = false;
        }
        catch (InstantiationException e) {
            Manager.Ffdc.log(e, SecurityUIDGenerator.class, "com.ibm.ISecurityL13SupportImpl.SecurityUIDGenerator.createUID", "96");
            vmidFound = false;
        }
        catch (IllegalAccessException e) {
            Manager.Ffdc.log(e, SecurityUIDGenerator.class, "com.ibm.ISecurityL13SupportImpl.SecurityUIDGenerator.createUID", "102");
            vmidFound = false;
        }
        catch (Throwable e) {
            Manager.Ffdc.log(e, SecurityUIDGenerator.class, "com.ibm.ISecurityL13SupportImpl.SecurityUIDGenerator.createUID", "108");
            vmidFound = false;
        }
        finally {
            if (!vmidFound) {
                sessionID = SecurityUIDGenerator.generate();
            }
        }
        return sessionID;
    }

    private static short currentProcessId() {
        while (processId == 0) {
            processId = (short)(SecurityUIDGenerator.randomInt(900) + 100);
        }
        return processId;
    }

    public static synchronized String generate() {
        long time2 = System.currentTimeMillis();
        short seq = SecurityUIDGenerator.getSequence(time2);
        short milli = (short)(time2 % 1000L);
        short pid = SecurityUIDGenerator.currentProcessId();
        String hostAddress = SecurityUIDGenerator.getLocalAddress();
        int rand = SecurityUIDGenerator.randomInt(0x3FFFFF);
        int index = hostAddress.indexOf("/");
        String ipMinusName = hostAddress.substring(index + 1);
        String uid = new String(ipMinusName + ":" + Integer.toHexString(pid) + Integer.toHexString(seq) + Long.toHexString(time2 /= 1000L) + Integer.toHexString(rand) + Integer.toHexString(milli));
        if (uid.length() > 45) {
            return uid.substring(0, 44);
        }
        return uid;
    }

    private static String getLocalAddress() {
        String defaultHost = "localhost";
        try {
            return (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws UnknownHostException {
                    InetAddress host = InetAddress.getLocalHost();
                    return host.toString();
                }
            });
        }
        catch (PrivilegedActionException e) {
            Manager.Ffdc.log(e, SecurityUIDGenerator.class, "com.ibm.ISecurityL13SupportImpl.SecurityUIDGenerator.getLocalAddress", "220");
            return defaultHost;
        }
    }

    private static synchronized short getSequence(long time2) {
        if (time2 <= previousTime) {
            sequence = (short)(sequence + 1);
        }
        previousTime = time2;
        return sequence;
    }

    private static int randomInt(int max) {
        int result = randomGen.nextInt();
        if (result < 0) {
            result = -result;
        }
        if (max > 0) {
            return result % max;
        }
        return result;
    }
}

