/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.persistence.pdqstatic.gen;

import com.ibm.ws.persistence.EntityManagerFactoryImpl;
import com.ibm.ws.persistence.pdqstatic.conf.StaticJDBCConfigurationImpl;
import com.ibm.ws.persistence.pdqstatic.gen.StaticDeleteStmt;
import com.ibm.ws.persistence.pdqstatic.gen.StaticInsertStmt;
import com.ibm.ws.persistence.pdqstatic.gen.StaticSelectStmt;
import com.ibm.ws.persistence.pdqstatic.gen.StaticUpdateStmt;
import com.ibm.ws.persistence.pdqstatic.jdbc.kernel.StaticJDBCBrokerFactory;
import com.ibm.ws.persistence.pdqstatic.jdbc.meta.StaticMappingRepository;
import com.ibm.ws.persistence.pdqstatic.kernel.StaticBrokerImpl;
import com.ibm.ws.persistence.pdqstatic.meta.PDQMetas;
import java.util.Collection;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.persistence.EntityManager;
import javax.persistence.Persistence;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.persistence.EntityManagerImpl;

public class StaticSQLGenerator {
    private EntityManagerFactoryImpl emf = null;
    private EntityManager em = null;
    private StaticJDBCConfigurationImpl conf = null;
    private Log _logs = null;
    private String url = null;
    private String userName = null;
    private String pwd = null;
    private BindInfo bindInfo = new BindInfo();

    public StaticSQLGenerator(String puName, String collectionId, String url, String userName, String pwd, boolean singlePackage, String packageName) {
        this.bindInfo.puName = puName;
        this.bindInfo.collectionId = collectionId;
        this.bindInfo.singlePackage = singlePackage;
        this.bindInfo.packageName = packageName;
        this.url = url;
        this.userName = userName;
        this.pwd = pwd;
        this.init(puName);
    }

    private void init(String puName) {
        String connProperties;
        HashMap<Object, Object> props = new HashMap<Object, Object>(System.getProperties());
        props.put("openjpa.BrokerFactory", StaticJDBCBrokerFactory.class.getName());
        props.put("openjpa.BrokerImpl", StaticBrokerImpl.class.getName());
        this.emf = (EntityManagerFactoryImpl)Persistence.createEntityManagerFactory((String)puName, props);
        if (this.emf == null) {
            System.out.println("puName " + puName + " is invalid.");
            System.exit(1);
        }
        this.conf = (StaticJDBCConfigurationImpl)this.emf.getBrokerFactory().getConfiguration();
        this.conf.setConnectionDriverName("com.ibm.db2.jcc.DB2Driver");
        if (this.url != null) {
            this.conf.setConnectionURL(this.url);
            this.conf.setConnectionUserName(this.userName);
            this.conf.setConnectionPassword(this.pwd);
        } else if (this.conf.getConnectionURL() == null && (connProperties = this.conf.getConnectionProperties()) != null) {
            StringTokenizer st = new StringTokenizer(connProperties, ",");
            while (st.hasMoreTokens()) {
                String prop = st.nextToken();
                int idx = prop.indexOf("=");
                String name = prop.substring(0, idx).trim();
                String value = prop.substring(idx + 1).trim();
                if (name.equalsIgnoreCase("Url") && value.startsWith("jdbc:db2")) {
                    this.conf.setConnectionURL(value);
                    continue;
                }
                if (name.equalsIgnoreCase("Username")) {
                    this.conf.setConnectionUserName(value);
                    continue;
                }
                if (!name.equalsIgnoreCase("Password")) continue;
                this.conf.setConnectionPassword(value);
            }
        }
        this._logs = this.conf.getLog("wsjpa.Sqlgen");
    }

    public void generateSQL() {
        this.em = this.emf.createEntityManager();
        this.loadPersistenceEntities();
        StaticInsertStmt insertStmt = new StaticInsertStmt(this.em, this.bindInfo, this._logs);
        insertStmt.generate();
        StaticDeleteStmt deleteStmt = new StaticDeleteStmt(this.em, this.bindInfo, this._logs);
        deleteStmt.generate();
        StaticUpdateStmt updateStmt = new StaticUpdateStmt(this.em, this.bindInfo, this._logs);
        updateStmt.generate();
        StaticSelectStmt selectStmt = new StaticSelectStmt(this.em, this.bindInfo, this._logs);
        selectStmt.generate();
        this.em.close();
    }

    private void loadPersistenceEntities() {
        StaticMappingRepository metaRepo = (StaticMappingRepository)this.conf.getMetaDataRepositoryInstance();
        Collection persistentTypes = metaRepo.loadPersistentTypes(false, null);
        for (Class cls : persistentTypes) {
            if (cls == null) continue;
            metaRepo.getMetaDataFactory().load(cls, 5, null);
        }
        metaRepo.setPU(this.bindInfo.puName);
        metaRepo.setSinglePackage(this.bindInfo.singlePackage);
        if (this.bindInfo.packageName != null) {
            metaRepo.setPkgName(this.bindInfo.packageName);
        }
        if (this.bindInfo.collectionId != null) {
            metaRepo.setCollection(this.bindInfo.collectionId);
        }
    }

    public PDQMetas getPDQMetas() {
        StaticMappingRepository metaRepo = (StaticMappingRepository)((EntityManagerImpl)this.em).getConfiguration().getMetaDataRepositoryInstance();
        return metaRepo.getPDQMetas();
    }

    public Log getLog() {
        return this._logs;
    }

    class BindInfo {
        public String puName = null;
        public String collectionId = null;
        public boolean singlePackage = false;
        public String packageName = null;

        BindInfo() {
        }
    }
}

