/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.persistence.pdqstatic.gen;

import com.ibm.ws.persistence.pdqstatic.gen.StaticAbstractSQLStmt;
import com.ibm.ws.persistence.pdqstatic.gen.StaticSQLGenUtil;
import com.ibm.ws.persistence.pdqstatic.gen.StaticSQLGenerator;
import com.ibm.ws.persistence.pdqstatic.gen.StaticSelectStmt;
import java.util.Collection;
import javax.persistence.EntityManager;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.Localizer;

public class StaticDeleteStmt
extends StaticAbstractSQLStmt {
    private static final Localizer _loc = Localizer.forPackage(StaticDeleteStmt.class);

    public StaticDeleteStmt(EntityManager em, StaticSQLGenerator.BindInfo bindInfo, Log _logs) {
        super(em, bindInfo, _logs);
    }

    public void generate() {
        this.em.getTransaction().begin();
        StaticSelectStmt selectStmt = new StaticSelectStmt(this.em, this.bindInfo, this._logs);
        Collection entities = selectStmt.getEntities();
        for (Object entity : entities) {
            String entityClassName = entity.getClass().getName();
            if (!this.bindInfo.singlePackage) {
                this.metaRepo.setPkgName(entityClassName);
            }
            this.metaRepo.setRuntimeSignature(entityClassName + ":Remove");
            if (this._logs.isTraceEnabled()) {
                this._logs.trace(_loc.get("remove-entity", entityClassName));
            }
            this.em.remove(entity);
            if (StaticSQLGenUtil.removeFlush(this.em, entity, this._logs)) continue;
        }
        StaticSQLGenUtil.commit(this.em, this._logs);
    }
}

