/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.fortress;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Provider;

public class BootstrapHelper {
    private static final String BOOTSTRAP_PROVIDER_NAME = "com.ibm.security.bootstrap.BootstrapProvider";
    private static Provider bootstrapProvider = null;
    private static ThreadLocal<Integer> inJarVerifer = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 0;
        }
    };
    private static ThreadLocal<Integer> inFIPSLoading = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 0;
        }
    };

    public static Provider getBootstrapProvider() {
        if (null != bootstrapProvider) {
            return bootstrapProvider;
        }
        bootstrapProvider = AccessController.doPrivileged(new PrivilegedAction<Provider>(){

            @Override
            public Provider run() {
                try {
                    Class<?> clazz = Class.forName(BootstrapHelper.BOOTSTRAP_PROVIDER_NAME);
                    return (Provider)clazz.newInstance();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    return null;
                }
            }
        });
        return bootstrapProvider;
    }

    public static void beginJarVerify() {
        int n = inJarVerifer.get();
        inJarVerifer.set(++n);
    }

    public static void endJarVerify() {
        int n = inJarVerifer.get();
        inJarVerifer.set(--n);
    }

    public static boolean isInJarVerify() {
        return inJarVerifer.get() > 0;
    }

    static void beginFIPSLoading() {
        int n = inFIPSLoading.get();
        inFIPSLoading.set(++n);
    }

    static void endFIPSLoading() {
        int n = inFIPSLoading.get();
        inFIPSLoading.set(--n);
    }

    static boolean isInFIPSLoading() {
        return inFIPSLoading.get() > 0;
    }
}

