/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.asn1;

import org.apache.harmony.security.asn1.ASN1Choice;
import org.apache.harmony.security.asn1.ASN1Explicit;
import org.apache.harmony.security.asn1.ASN1Sequence;
import org.apache.harmony.security.asn1.ASN1SequenceOf;
import org.apache.harmony.security.asn1.ASN1Set;
import org.apache.harmony.security.asn1.ASN1SetOf;
import org.apache.harmony.security.asn1.BitString;

public class BerOutputStream {
    public byte[] encoded;
    protected int offset;
    public int length;
    public Object content;

    public final void encodeTag(int n) {
        this.encoded[this.offset++] = (byte)n;
        if (this.length > 127) {
            int n2;
            int n3 = 1;
            for (n2 = this.length >> 8; n2 > 0; n2 >>= 8) {
                n3 = (byte)(n3 + 1);
            }
            this.encoded[this.offset] = (byte)(n3 | 0x80);
            ++this.offset;
            n2 = this.length;
            int n4 = this.offset + n3 - 1;
            int n5 = 0;
            while (n5 < n3) {
                this.encoded[n4 - n5] = (byte)n2;
                ++n5;
                n2 >>= 8;
            }
            this.offset += n3;
        } else {
            this.encoded[this.offset++] = (byte)this.length;
        }
    }

    public void encodeANY() {
        System.arraycopy(this.content, 0, this.encoded, this.offset, this.length);
        this.offset += this.length;
    }

    public void encodeBitString() {
        BitString bitString = (BitString)this.content;
        this.encoded[this.offset] = (byte)bitString.unusedBits;
        System.arraycopy(bitString.bytes, 0, this.encoded, this.offset + 1, this.length - 1);
        this.offset += this.length;
    }

    public void encodeBoolean() {
        this.encoded[this.offset] = (Boolean)this.content != false ? -1 : 0;
        ++this.offset;
    }

    public void encodeChoice(ASN1Choice aSN1Choice) {
        throw new RuntimeException("Is not implemented yet");
    }

    public void encodeExplicit(ASN1Explicit aSN1Explicit) {
        throw new RuntimeException("Is not implemented yet");
    }

    public void encodeGeneralizedTime() {
        System.arraycopy(this.content, 0, this.encoded, this.offset, this.length);
        this.offset += this.length;
    }

    public void encodeUTCTime() {
        System.arraycopy(this.content, 0, this.encoded, this.offset, this.length);
        this.offset += this.length;
    }

    public void encodeInteger() {
        System.arraycopy(this.content, 0, this.encoded, this.offset, this.length);
        this.offset += this.length;
    }

    public void encodeOctetString() {
        System.arraycopy(this.content, 0, this.encoded, this.offset, this.length);
        this.offset += this.length;
    }

    public void encodeOID() {
        int n;
        int[] nArray = (int[])this.content;
        int n2 = this.length;
        int n3 = nArray.length - 1;
        while (n3 > 1) {
            n = nArray[n3];
            if (n > 127) {
                this.encoded[this.offset + n2 - 1] = (byte)(n & 0x7F);
                n >>= 7;
                while (n > 0) {
                    this.encoded[this.offset + --n2 - 1] = (byte)(n | 0x80);
                    n >>= 7;
                }
            } else {
                this.encoded[this.offset + n2 - 1] = (byte)n;
            }
            --n3;
            --n2;
        }
        n = nArray[0] * 40 + nArray[1];
        if (n > 127) {
            this.encoded[this.offset + n2 - 1] = (byte)(n & 0x7F);
            n >>= 7;
            while (n > 0) {
                this.encoded[this.offset + --n2 - 1] = (byte)(n | 0x80);
                n >>= 7;
            }
        } else {
            this.encoded[this.offset + n2 - 1] = (byte)n;
        }
        this.offset += this.length;
    }

    public void encodeSequence(ASN1Sequence aSN1Sequence) {
        throw new RuntimeException("Is not implemented yet");
    }

    public void encodeSequenceOf(ASN1SequenceOf aSN1SequenceOf) {
        throw new RuntimeException("Is not implemented yet");
    }

    public void encodeSet(ASN1Set aSN1Set) {
        throw new RuntimeException("Is not implemented yet");
    }

    public void encodeSetOf(ASN1SetOf aSN1SetOf) {
        throw new RuntimeException("Is not implemented yet");
    }

    public void encodeString() {
        System.arraycopy(this.content, 0, this.encoded, this.offset, this.length);
        this.offset += this.length;
    }

    public void getChoiceLength(ASN1Choice aSN1Choice) {
        throw new RuntimeException("Is not implemented yet");
    }

    public void getExplicitLength(ASN1Explicit aSN1Explicit) {
        throw new RuntimeException("Is not implemented yet");
    }

    public void getSequenceLength(ASN1Sequence aSN1Sequence) {
        throw new RuntimeException("Is not implemented yet");
    }

    public void getSequenceOfLength(ASN1SequenceOf aSN1SequenceOf) {
        throw new RuntimeException("Is not implemented yet");
    }

    public void getSetLength(ASN1Set aSN1Set) {
        throw new RuntimeException("Is not implemented yet");
    }

    public void getSetOfLength(ASN1SetOf aSN1SetOf) {
        throw new RuntimeException("Is not implemented yet");
    }

    public int getStringLength(Object object) {
        throw new RuntimeException("Is not implemented yet");
    }
}

