/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.asn1;

import java.io.IOException;
import java.io.InputStream;
import org.apache.harmony.security.asn1.ASN1Constants;
import org.apache.harmony.security.asn1.BerInputStream;
import org.apache.harmony.security.asn1.BerOutputStream;
import org.apache.harmony.security.asn1.DerInputStream;
import org.apache.harmony.security.asn1.DerOutputStream;
import org.apache.harmony.security.internal.nls.Messages;

public abstract class ASN1Type
implements ASN1Constants {
    public final int id;
    public final int constrId;

    public ASN1Type(int n) {
        this(0, n);
    }

    public ASN1Type(int n, int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException(Messages.getString("security.102"));
        }
        if (n != 0 && n != 64 && n != 128 && n != 192) {
            throw new IllegalArgumentException(Messages.getString("security.103"));
        }
        if (n2 >= 31) {
            throw new IllegalArgumentException(Messages.getString("security.104"));
        }
        this.id = n + n2;
        this.constrId = this.id + 32;
    }

    public final Object decode(byte[] byArray) throws IOException {
        return this.decode(new DerInputStream(byArray));
    }

    public final Object decode(byte[] byArray, int n, int n2) throws IOException {
        return this.decode(new DerInputStream(byArray, n, n2));
    }

    public final Object decode(InputStream inputStream) throws IOException {
        return this.decode(new DerInputStream(inputStream));
    }

    public final void verify(byte[] byArray) throws IOException {
        DerInputStream derInputStream = new DerInputStream(byArray);
        derInputStream.setVerify();
        this.decode(derInputStream);
    }

    public final void verify(InputStream inputStream) throws IOException {
        DerInputStream derInputStream = new DerInputStream(inputStream);
        derInputStream.setVerify();
        this.decode(derInputStream);
    }

    public final byte[] encode(Object object) {
        DerOutputStream derOutputStream = new DerOutputStream(this, object);
        return derOutputStream.encoded;
    }

    public abstract Object decode(BerInputStream var1) throws IOException;

    public abstract boolean checkTag(int var1);

    protected Object getDecodedObject(BerInputStream berInputStream) throws IOException {
        return berInputStream.content;
    }

    public abstract void encodeASN(BerOutputStream var1);

    public abstract void encodeContent(BerOutputStream var1);

    public abstract void setEncodingContent(BerOutputStream var1);

    public int getEncodedLength(BerOutputStream berOutputStream) {
        int n = 1;
        ++n;
        if (berOutputStream.length > 127) {
            ++n;
            int n2 = berOutputStream.length >> 8;
            while (n2 > 0) {
                n2 >>= 8;
                ++n;
            }
        }
        return n += berOutputStream.length;
    }

    public String toString() {
        return this.getClass().getName() + "(tag: 0x" + Integer.toHexString(0xFF & this.id) + ")";
    }
}

